/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.contour;

import org.jfree.data.Range;
import org.jfree.data.contour.DefaultContourDataset;

public class NonGridContourDataset
extends DefaultContourDataset {
    static final int DEFAULT_NUM_X = 50;
    static final int DEFAULT_NUM_Y = 50;
    static final int DEFAULT_POWER = 4;

    public NonGridContourDataset() {
    }

    public NonGridContourDataset(String seriesName, Object[] xData, Object[] yData, Object[] zData) {
        super(seriesName, xData, yData, zData);
        this.buildGrid(50, 50, 4);
    }

    public NonGridContourDataset(String seriesName, Object[] xData, Object[] yData, Object[] zData, int numX, int numY, int power) {
        super(seriesName, xData, yData, zData);
        this.buildGrid(numX, numY, power);
    }

    protected void buildGrid(int numX, int numY, int power) {
        int k;
        int numValues = numX * numY;
        double[] xGrid = new double[numValues];
        double[] yGrid = new double[numValues];
        double[] zGrid = new double[numValues];
        double xMin = 1.0E20;
        int k2 = 0;
        while (k2 < this.xValues.length) {
            xMin = Math.min(xMin, this.xValues[k2].doubleValue());
            ++k2;
        }
        double xMax = -1.0E20;
        int k3 = 0;
        while (k3 < this.xValues.length) {
            xMax = Math.max(xMax, this.xValues[k3].doubleValue());
            ++k3;
        }
        double yMin = 1.0E20;
        int k4 = 0;
        while (k4 < this.yValues.length) {
            yMin = Math.min(yMin, this.yValues[k4].doubleValue());
            ++k4;
        }
        double yMax = -1.0E20;
        int k5 = 0;
        while (k5 < this.yValues.length) {
            yMax = Math.max(yMax, this.yValues[k5].doubleValue());
            ++k5;
        }
        Range xRange = new Range(xMin, xMax);
        Range yRange = new Range(yMin, yMax);
        xRange.getLength();
        yRange.getLength();
        double dxGrid = xRange.getLength() / (double)(numX - 1);
        double dyGrid = yRange.getLength() / (double)(numY - 1);
        double x = 0.0;
        int i = 0;
        while (i < numX) {
            x = i == 0 ? xMin : (x += dxGrid);
            double y = 0.0;
            int j = 0;
            while (j < numY) {
                k = numY * i + j;
                xGrid[k] = x;
                y = j == 0 ? yMin : (y += dyGrid);
                yGrid[k] = y;
                ++j;
            }
            ++i;
        }
        int kGrid = 0;
        while (kGrid < xGrid.length) {
            double dTotal = 0.0;
            zGrid[kGrid] = 0.0;
            k = 0;
            while (k < this.xValues.length) {
                double xPt = this.xValues[k].doubleValue();
                double yPt = this.yValues[k].doubleValue();
                double d = this.distance(xPt, yPt, xGrid[kGrid], yGrid[kGrid]);
                if (power != 1) {
                    d = Math.pow(d, power);
                }
                d = (d = Math.sqrt(d)) > 0.0 ? 1.0 / d : 1.0E20;
                if (this.zValues[k] != null) {
                    int n = kGrid;
                    zGrid[n] = zGrid[n] + this.zValues[k].doubleValue() * d;
                }
                dTotal += d;
                ++k;
            }
            zGrid[kGrid] = zGrid[kGrid] / dTotal;
            ++kGrid;
        }
        this.initialize(DefaultContourDataset.formObjectArray(xGrid), DefaultContourDataset.formObjectArray(yGrid), DefaultContourDataset.formObjectArray(zGrid));
    }

    protected double distance(double xDataPt, double yDataPt, double xGrdPt, double yGrdPt) {
        double dx = xDataPt - xGrdPt;
        double dy = yDataPt - yGrdPt;
        return Math.sqrt(dx * dx + dy * dy);
    }

    static {
        DEFAULT_NUM_X = 50;
        DEFAULT_NUM_Y = 50;
        DEFAULT_POWER = 4;
    }
}

