/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class XYAreaRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private boolean showOutline;

    public XYAreaRenderer() {
        this(4);
    }

    public XYAreaRenderer(int type) {
        this(type, null, null);
    }

    public XYAreaRenderer(int type, XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        this.setToolTipGenerator(toolTipGenerator);
        this.setURLGenerator(urlGenerator);
        if (type == 1) {
            this.plotShapes = true;
        }
        if (type == 2) {
            this.plotLines = true;
        }
        if (type == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (type == 4) {
            this.plotArea = true;
        }
        if (type == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean show) {
        this.showOutline = show;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYAreaRendererState state = new XYAreaRendererState(info);
        return state;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        XYAreaRendererState areaState = (XYAreaRendererState)state;
        Number x1n = dataset.getX(series, item);
        Number y1n = dataset.getY(series, item);
        if (y1n == null) {
            y1n = AbstractRenderer.ZERO;
        }
        double x1 = x1n.doubleValue();
        double y1 = y1n.doubleValue();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, plot.getDomainAxisEdge());
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
        int itemCount = dataset.getItemCount(series);
        Number x0 = dataset.getX(series, Math.max(item - 1, 0));
        Number y0 = dataset.getY(series, Math.max(item - 1, 0));
        if (y0 == null) {
            y0 = AbstractRenderer.ZERO;
        }
        double transX0 = domainAxis.valueToJava2D(x0.doubleValue(), dataArea, plot.getDomainAxisEdge());
        double transY0 = rangeAxis.valueToJava2D(y0.doubleValue(), dataArea, plot.getRangeAxisEdge());
        Number x2 = dataset.getX(series, Math.min(item + 1, itemCount - 1));
        Number y2 = dataset.getY(series, Math.min(item + 1, itemCount - 1));
        if (y2 == null) {
            y2 = AbstractRenderer.ZERO;
        }
        double transX2 = domainAxis.valueToJava2D(x2.doubleValue(), dataArea, plot.getDomainAxisEdge());
        double transY2 = rangeAxis.valueToJava2D(y2.doubleValue(), dataArea, plot.getRangeAxisEdge());
        double transZero = rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
        Polygon hotspot = null;
        if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
            hotspot = new Polygon();
            hotspot.addPoint((int)transZero, (int)((transX0 + transX1) / 2.0));
            hotspot.addPoint((int)((transY0 + transY1) / 2.0), (int)((transX0 + transX1) / 2.0));
            hotspot.addPoint((int)transY1, (int)transX1);
            hotspot.addPoint((int)((transY1 + transY2) / 2.0), (int)((transX1 + transX2) / 2.0));
            hotspot.addPoint((int)transZero, (int)((transX1 + transX2) / 2.0));
        } else {
            hotspot = new Polygon();
            hotspot.addPoint((int)((transX0 + transX1) / 2.0), (int)transZero);
            hotspot.addPoint((int)((transX0 + transX1) / 2.0), (int)((transY0 + transY1) / 2.0));
            hotspot.addPoint((int)transX1, (int)transY1);
            hotspot.addPoint((int)((transX1 + transX2) / 2.0), (int)((transY1 + transY2) / 2.0));
            hotspot.addPoint((int)((transX1 + transX2) / 2.0), (int)transZero);
        }
        if (item == 0) {
            areaState.area = new Polygon();
            double zero = rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                areaState.area.addPoint((int)transX1, (int)zero);
            } else if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                areaState.area.addPoint((int)zero, (int)transX1);
            }
        }
        if (plot.getOrientation() == PlotOrientation.VERTICAL) {
            areaState.area.addPoint((int)transX1, (int)transY1);
        } else if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
            areaState.area.addPoint((int)transY1, (int)transX1);
        }
        PlotOrientation orientation = plot.getOrientation();
        Paint paint = this.getItemPaint(series, item);
        Stroke stroke = this.getItemStroke(series, item);
        g2.setPaint(paint);
        g2.setStroke(stroke);
        Shape shape = null;
        if (this.getPlotShapes()) {
            shape = this.getItemShape(series, item);
            if (orientation == PlotOrientation.VERTICAL) {
                shape = this.createTransformedShape(shape, transX1, transY1);
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                shape = this.createTransformedShape(shape, transY1, transX1);
            }
            g2.draw(shape);
        }
        if (this.getPlotLines() && item > 0) {
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                areaState.line.setLine(transX0, transY0, transX1, transY1);
            } else if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                areaState.line.setLine(transY0, transX0, transY1, transX1);
            }
            g2.draw(areaState.line);
        }
        if (this.getPlotArea() && item > 0 && item == itemCount - 1) {
            if (orientation == PlotOrientation.VERTICAL) {
                areaState.area.addPoint((int)transX1, (int)transZero);
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                areaState.area.addPoint((int)transZero, (int)transX1);
            }
            g2.fill(areaState.area);
            if (this.isOutline()) {
                g2.setStroke(this.getItemOutlineStroke(series, item));
                g2.setPaint(this.getItemOutlinePaint(series, item));
                g2.draw(areaState.area);
            }
        }
        this.updateCrosshairValues(crosshairState, x1, y1, transX1, transY1, orientation);
        if (state.getInfo() != null && (entities = state.getInfo().getOwner().getEntityCollection()) != null && hotspot != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(hotspot, dataset, series, item, tip, url);
            entities.addEntity(entity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        SHAPES = 1;
        LINES = 2;
        SHAPES_AND_LINES = 3;
        AREA = 4;
        AREA_AND_SHAPES = 5;
    }

    static class XYAreaRendererState
    extends XYItemRendererState {
        public Polygon area = new Polygon();
        public Line2D line = new Line2D.Double();

        public XYAreaRendererState(PlotRenderingInfo info) {
            super(info);
        }
    }
}

