/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class StackedXYBarRenderer
extends XYBarRenderer {
    static /* synthetic */ Class class$org$jfree$data$xy$IntervalXYDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$TableXYDataset;

    public StackedXYBarRenderer() {
    }

    public StackedXYBarRenderer(double margin) {
        super(margin);
    }

    public Range getRangeExtent(XYDataset dataset) {
        return DatasetUtilities.findStackedRangeExtent((TableXYDataset)dataset, this.getBase());
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        return new StackedXYBarRendererState(info);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        if (!(dataset instanceof IntervalXYDataset) || !(dataset instanceof TableXYDataset)) {
            String message = "dataset (type " + dataset.getClass().getName() + ") has wrong type:";
            boolean and = false;
            if (!(class$org$jfree$data$xy$IntervalXYDataset == null ? (class$org$jfree$data$xy$IntervalXYDataset = StackedXYBarRenderer.class$("org.jfree.data.xy.IntervalXYDataset")) : class$org$jfree$data$xy$IntervalXYDataset).isAssignableFrom(dataset.getClass())) {
                message = message + " it is no IntervalXYDataset";
                and = true;
            }
            if (!(class$org$jfree$data$xy$TableXYDataset == null ? (class$org$jfree$data$xy$TableXYDataset = StackedXYBarRenderer.class$("org.jfree.data.xy.TableXYDataset")) : class$org$jfree$data$xy$TableXYDataset).isAssignableFrom(dataset.getClass())) {
                if (and) {
                    message = message + " and";
                }
                message = message + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(message);
        }
        IntervalXYDataset intervalData = (IntervalXYDataset)dataset;
        Paint seriesPaint = this.getItemPaint(series, item);
        Paint seriesOutlinePaint = this.getItemOutlinePaint(series, item);
        double ph = this.getPreviousHeight(dataset, series, item);
        double value = intervalData.getYValue(series, item);
        if (Double.isNaN(value)) {
            return;
        }
        double translatedStartY = rangeAxis.valueToJava2D(ph, dataArea, plot.getRangeAxisEdge());
        double translatedEndY = rangeAxis.valueToJava2D(value + ph, dataArea, plot.getRangeAxisEdge());
        RectangleEdge location = plot.getDomainAxisEdge();
        double startX = intervalData.getStartXValue(series, item);
        if (Double.isNaN(startX)) {
            return;
        }
        double translatedStartX = domainAxis.valueToJava2D(startX, dataArea, location);
        double endX = intervalData.getEndXValue(series, item);
        if (Double.isNaN(endX)) {
            return;
        }
        double translatedEndX = domainAxis.valueToJava2D(endX, dataArea, location);
        double translatedWidth = Math.max(1.0, Math.abs(translatedEndX - translatedStartX));
        double translatedHeight = Math.abs(translatedEndY - translatedStartY);
        if (this.getMargin() > 0.0) {
            double cut = translatedWidth * this.getMargin();
            translatedWidth -= cut;
            translatedStartX += cut / 2.0;
        }
        Rectangle2D.Double bar = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bar = new Rectangle2D.Double(Math.min(translatedStartY, translatedEndY), translatedEndX, translatedHeight, translatedWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bar = new Rectangle2D.Double(translatedStartX, Math.min(translatedStartY, translatedEndY), translatedWidth, translatedHeight);
        }
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (this.isDrawBarOutline() && Math.abs(translatedEndX - translatedStartX) > 3.0) {
            g2.setStroke(this.getItemStroke(series, item));
            g2.setPaint(seriesOutlinePaint);
            g2.draw(bar);
        }
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(bar, dataset, series, item, tip, url);
            entities.addEntity(entity);
        }
    }

    protected double getPreviousHeight(XYDataset data, int series, int index) {
        double result = this.getBase();
        int i = 0;
        while (i < series) {
            double tmp = data.getYValue(i, index);
            if (!Double.isNaN(tmp)) {
                result += tmp;
            }
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class StackedXYBarRendererState
    extends XYItemRendererState {
        public StackedXYBarRendererState(PlotRenderingInfo info) {
            super(info);
        }
    }
}

