/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.renderer.WaferMapRenderer;
import org.jfree.data.general.WaferMapDataset;

public class WaferMapPlot
extends Plot
implements RendererChangeListener,
Cloneable,
Serializable {
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT;
    protected static ResourceBundle localizationResources;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private WaferMapDataset dataset;
    private WaferMapRenderer renderer;

    public WaferMapPlot(WaferMapDataset dataset) {
        this(dataset, null);
    }

    public WaferMapPlot(WaferMapDataset dataset, WaferMapRenderer renderer) {
        this.dataset = dataset;
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.renderer = renderer;
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
    }

    public String getPlotType() {
        return "WMAP_Plot";
    }

    public void setRenderer(WaferMapRenderer renderer) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = renderer;
        if (renderer != null) {
            renderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState state, PlotRenderingInfo info) {
        Insets insets;
        boolean b2;
        boolean b1 = plotArea.getWidth() <= 10.0;
        boolean bl = b2 = plotArea.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if ((insets = this.getInsets()) != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        this.drawChipGrid(g2, plotArea);
        this.drawWaferEdge(g2, plotArea);
    }

    private void drawChipGrid(Graphics2D g2, Rectangle2D plotArea) {
        Shape savedClip = g2.getClip();
        g2.setClip(this.getWaferEdge(plotArea));
        Rectangle2D.Double chip = new Rectangle2D.Double();
        int xchips = 35;
        int ychips = 20;
        double space = 1.0;
        if (this.dataset != null) {
            xchips = this.dataset.getMaxChipX() + 2;
            ychips = this.dataset.getMaxChipY() + 2;
            space = this.dataset.getChipSpace();
        }
        double startX = plotArea.getX();
        double startY = plotArea.getY();
        double chipWidth = 1.0;
        double chipHeight = 1.0;
        if (plotArea.getWidth() != plotArea.getHeight()) {
            double major = 0.0;
            double minor = 0.0;
            if (plotArea.getWidth() > plotArea.getHeight()) {
                major = plotArea.getWidth();
                minor = plotArea.getHeight();
            } else {
                major = plotArea.getHeight();
                minor = plotArea.getWidth();
            }
            if (plotArea.getWidth() == minor) {
                startY += (major - minor) / 2.0;
                chipWidth = (plotArea.getWidth() - (space * (double)xchips - 1.0)) / (double)xchips;
                chipHeight = (plotArea.getWidth() - (space * (double)ychips - 1.0)) / (double)ychips;
            } else {
                startX += (major - minor) / 2.0;
                chipWidth = (plotArea.getHeight() - (space * (double)xchips - 1.0)) / (double)xchips;
                chipHeight = (plotArea.getHeight() - (space * (double)ychips - 1.0)) / (double)ychips;
            }
        }
        int x = 1;
        while (x <= xchips) {
            double upperLeftX = startX - chipWidth + chipWidth * (double)x + space * (double)(x - 1);
            int y = 1;
            while (y <= ychips) {
                double upperLeftY = startY - chipHeight + chipHeight * (double)y + space * (double)(y - 1);
                chip.setFrame(upperLeftX, upperLeftY, chipWidth, chipHeight);
                g2.setColor(Color.white);
                if (this.dataset.getChipValue(x - 1, ychips - y - 1) != null) {
                    g2.setPaint(this.renderer.getChipColor(this.dataset.getChipValue(x - 1, ychips - y - 1)));
                }
                g2.fill(chip);
                g2.setColor(Color.lightGray);
                g2.draw(chip);
                ++y;
            }
            ++x;
        }
        g2.setClip(savedClip);
    }

    private Ellipse2D getWaferEdge(Rectangle2D plotArea) {
        Ellipse2D.Double edge = new Ellipse2D.Double();
        double diameter = plotArea.getWidth();
        double upperLeftX = plotArea.getX();
        double upperLeftY = plotArea.getY();
        if (plotArea.getWidth() != plotArea.getHeight()) {
            double major = 0.0;
            double minor = 0.0;
            if (plotArea.getWidth() > plotArea.getHeight()) {
                major = plotArea.getWidth();
                minor = plotArea.getHeight();
            } else {
                major = plotArea.getHeight();
                minor = plotArea.getWidth();
            }
            diameter = minor;
            if (plotArea.getWidth() == minor) {
                upperLeftY = plotArea.getY() + (major - minor) / 2.0;
            } else {
                upperLeftX = plotArea.getX() + (major - minor) / 2.0;
            }
        }
        ((RectangularShape)edge).setFrame(upperLeftX, upperLeftY, diameter, diameter);
        return edge;
    }

    private void drawWaferEdge(Graphics2D g2, Rectangle2D plotArea) {
        Ellipse2D waferEdge = this.getWaferEdge(plotArea);
        g2.setColor(Color.black);
        g2.draw(waferEdge);
        Arc2D.Double notch = null;
        Rectangle2D waferFrame = waferEdge.getFrame();
        double notchDiameter = waferFrame.getWidth() * 0.04;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D.Double notchFrame = new Rectangle2D.Double(waferFrame.getX() + waferFrame.getWidth() - notchDiameter / 2.0, waferFrame.getY() + waferFrame.getHeight() / 2.0 - notchDiameter / 2.0, notchDiameter, notchDiameter);
            notch = new Arc2D.Double(notchFrame, 90.0, 180.0, 0);
        } else {
            Rectangle2D.Double notchFrame = new Rectangle2D.Double(waferFrame.getX() + waferFrame.getWidth() / 2.0 - notchDiameter / 2.0, waferFrame.getY() + waferFrame.getHeight() - notchDiameter / 2.0, notchDiameter, notchDiameter);
            notch = new Arc2D.Double(notchFrame, 0.0, 180.0, 0);
        }
        g2.setColor(Color.white);
        g2.fill(notch);
        g2.setColor(Color.black);
        g2.draw(notch);
    }

    public WaferMapDataset getDataset() {
        return this.dataset;
    }

    public LegendItemCollection getLegendItems() {
        return this.renderer.getLegendCollection();
    }

    public void rendererChanged(RendererChangeEvent event) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    static {
        DEFAULT_CROSSHAIR_VISIBLE = false;
        DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
        DEFAULT_CROSSHAIR_PAINT = Color.blue;
        localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    }
}

