/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart.ChartColor;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PublicCloneable;

public class DefaultDrawingSupplier
implements DrawingSupplier,
Cloneable,
PublicCloneable,
Serializable {
    public static final Paint[] DEFAULT_PAINT_SEQUENCE = ChartColor.createDefaultPaintArray();
    public static final Paint[] DEFAULT_OUTLINE_PAINT_SEQUENCE = new Paint[]{Color.lightGray};
    public static final Stroke[] DEFAULT_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Stroke[] DEFAULT_OUTLINE_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.createStandardSeriesShapes();
    private transient Paint[] paintSequence;
    private int paintIndex;
    private transient Paint[] outlinePaintSequence;
    private int outlinePaintIndex;
    private transient Stroke[] strokeSequence;
    private int strokeIndex;
    private transient Stroke[] outlineStrokeSequence;
    private int outlineStrokeIndex;
    private transient Shape[] shapeSequence;
    private int shapeIndex;

    public DefaultDrawingSupplier() {
        this(DEFAULT_PAINT_SEQUENCE, DEFAULT_OUTLINE_PAINT_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    public DefaultDrawingSupplier(Paint[] paintSequence, Paint[] outlinePaintSequence, Stroke[] strokeSequence, Stroke[] outlineStrokeSequence, Shape[] shapeSequence) {
        this.paintSequence = paintSequence;
        this.outlinePaintSequence = outlinePaintSequence;
        this.strokeSequence = strokeSequence;
        this.outlineStrokeSequence = outlineStrokeSequence;
        this.shapeSequence = shapeSequence;
    }

    public Paint getNextPaint() {
        Paint result = this.paintSequence[this.paintIndex % this.paintSequence.length];
        ++this.paintIndex;
        return result;
    }

    public Paint getNextOutlinePaint() {
        Paint result = this.outlinePaintSequence[this.outlinePaintIndex % this.outlinePaintSequence.length];
        ++this.outlinePaintIndex;
        return result;
    }

    public Stroke getNextStroke() {
        Stroke result = this.strokeSequence[this.strokeIndex % this.strokeSequence.length];
        ++this.strokeIndex;
        return result;
    }

    public Stroke getNextOutlineStroke() {
        Stroke result = this.outlineStrokeSequence[this.outlineStrokeIndex % this.outlineStrokeSequence.length];
        ++this.outlineStrokeIndex;
        return result;
    }

    public Shape getNextShape() {
        Shape result = this.shapeSequence[this.shapeIndex % this.shapeSequence.length];
        ++this.shapeIndex;
        return result;
    }

    public static Shape[] createStandardSeriesShapes() {
        Shape[] result = new Shape[10];
        double size = 6.0;
        double delta = size / 2.0;
        int[] xpoints = null;
        int[] ypoints = null;
        result[0] = new Rectangle2D.Double(-delta, -delta, size, size);
        result[1] = new Ellipse2D.Double(-delta, -delta, size, size);
        xpoints = DefaultDrawingSupplier.intArray(0.0, delta, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, delta, delta);
        result[2] = new Polygon(xpoints, ypoints, 3);
        xpoints = DefaultDrawingSupplier.intArray(0.0, delta, 0.0, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, 0.0, delta, 0.0);
        result[3] = new Polygon(xpoints, ypoints, 4);
        result[4] = new Rectangle2D.Double(-delta, -delta / 2.0, size, size / 2.0);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, 0.0);
        ypoints = DefaultDrawingSupplier.intArray(-delta, -delta, delta);
        result[5] = new Polygon(xpoints, ypoints, 3);
        result[6] = new Ellipse2D.Double(-delta, -delta / 2.0, size, size / 2.0);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, 0.0, delta);
        result[7] = new Polygon(xpoints, ypoints, 3);
        result[8] = new Rectangle2D.Double(-delta / 2.0, -delta, size / 2.0, size);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, delta);
        ypoints = DefaultDrawingSupplier.intArray(0.0, -delta, delta);
        result[9] = new Polygon(xpoints, ypoints, 3);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultDrawingSupplier) {
            DefaultDrawingSupplier supplier = (DefaultDrawingSupplier)obj;
            boolean b0 = Arrays.equals(this.paintSequence, supplier.paintSequence);
            boolean b1 = this.paintIndex == supplier.paintIndex;
            boolean b2 = Arrays.equals(this.outlinePaintSequence, supplier.outlinePaintSequence);
            boolean b3 = this.outlinePaintIndex == supplier.outlinePaintIndex;
            boolean b4 = Arrays.equals(this.strokeSequence, supplier.strokeSequence);
            boolean b5 = this.strokeIndex == supplier.strokeIndex;
            boolean b6 = Arrays.equals(this.outlineStrokeSequence, supplier.outlineStrokeSequence);
            boolean b7 = this.outlineStrokeIndex == supplier.outlineStrokeIndex;
            boolean b8 = true;
            boolean b9 = this.shapeIndex == supplier.shapeIndex;
            return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8 && b9;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int paintCount = this.paintSequence.length;
        stream.writeInt(paintCount);
        int i = 0;
        while (i < paintCount) {
            SerialUtilities.writePaint((Paint)this.paintSequence[i], (ObjectOutputStream)stream);
            ++i;
        }
        int outlinePaintCount = this.outlinePaintSequence.length;
        stream.writeInt(outlinePaintCount);
        int i2 = 0;
        while (i2 < outlinePaintCount) {
            SerialUtilities.writePaint((Paint)this.outlinePaintSequence[i2], (ObjectOutputStream)stream);
            ++i2;
        }
        int strokeCount = this.strokeSequence.length;
        stream.writeInt(strokeCount);
        int i3 = 0;
        while (i3 < strokeCount) {
            SerialUtilities.writeStroke((Stroke)this.strokeSequence[i3], (ObjectOutputStream)stream);
            ++i3;
        }
        int outlineStrokeCount = this.outlineStrokeSequence.length;
        stream.writeInt(outlineStrokeCount);
        int i4 = 0;
        while (i4 < outlineStrokeCount) {
            SerialUtilities.writeStroke((Stroke)this.outlineStrokeSequence[i4], (ObjectOutputStream)stream);
            ++i4;
        }
        int shapeCount = this.shapeSequence.length;
        stream.writeInt(shapeCount);
        int i5 = 0;
        while (i5 < shapeCount) {
            SerialUtilities.writeShape((Shape)this.shapeSequence[i5], (ObjectOutputStream)stream);
            ++i5;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int paintCount = stream.readInt();
        this.paintSequence = new Paint[paintCount];
        int i = 0;
        while (i < paintCount) {
            this.paintSequence[i] = SerialUtilities.readPaint((ObjectInputStream)stream);
            ++i;
        }
        int outlinePaintCount = stream.readInt();
        this.outlinePaintSequence = new Paint[outlinePaintCount];
        int i2 = 0;
        while (i2 < outlinePaintCount) {
            this.outlinePaintSequence[i2] = SerialUtilities.readPaint((ObjectInputStream)stream);
            ++i2;
        }
        int strokeCount = stream.readInt();
        this.strokeSequence = new Stroke[strokeCount];
        int i3 = 0;
        while (i3 < strokeCount) {
            this.strokeSequence[i3] = SerialUtilities.readStroke((ObjectInputStream)stream);
            ++i3;
        }
        int outlineStrokeCount = stream.readInt();
        this.outlineStrokeSequence = new Stroke[outlineStrokeCount];
        int i4 = 0;
        while (i4 < outlineStrokeCount) {
            this.outlineStrokeSequence[i4] = SerialUtilities.readStroke((ObjectInputStream)stream);
            ++i4;
        }
        int shapeCount = stream.readInt();
        this.shapeSequence = new Shape[shapeCount];
        int i5 = 0;
        while (i5 < shapeCount) {
            this.shapeSequence[i5] = SerialUtilities.readShape((ObjectInputStream)stream);
            ++i5;
        }
    }

    private static int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDrawingSupplier clone = (DefaultDrawingSupplier)super.clone();
        return clone;
    }
}

