/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.wbem.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class WBEMClient {
    private Exception error;
    private CIMClient cc;
    private String namespace;
    private String host;
    private String user;
    private String pass;
    private boolean useXML = true;
    private boolean debug = true;
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public WBEMClient() {
        this.namespace = "\\root\\cimv2";
        this.host = "localhost";
    }

    public WBEMClient(String namespace) {
        this.namespace = namespace;
        this.host = "localhost";
    }

    public WBEMClient(String host, String namespace, String user, String pass) {
        this.host = host;
        this.namespace = namespace;
        this.user = user;
        this.pass = pass;
    }

    public void connect() throws Exception {
        if (this.user == null && this.pass == null && "localhost".equals(this.host)) {
            this.localConnect();
            return;
        }
        UserPrincipal principal = new UserPrincipal(this.user);
        PasswordCredential credential = new PasswordCredential(this.pass);
        CIMNameSpace cns = new CIMNameSpace(this.host, this.namespace);
        String protocol = this.useXML ? "cim-xml" : "cim-rmi";
        this.cc = new CIMClient(cns, (Principal)principal, (Object)credential, protocol);
    }

    public void close() {
        try {
            if (this.cc != null) {
                this.cc.close();
            }
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public Properties[] enumInstances(String className) {
        try {
            CIMObjectPath cop = new CIMObjectPath(className);
            Enumeration e = this.cc.enumerateInstances(cop, true, false, false, false, null);
            LinkedList<Properties> list = new LinkedList<Properties>();
            while (e.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)e.nextElement();
                Vector props = ci.getProperties();
                if (props == null) continue;
                Properties p = new Properties();
                Iterator iter = props.iterator();
                while (iter.hasNext()) {
                    CIMProperty cp = (CIMProperty)iter.next();
                    String name = cp.getName();
                    String value = this.getStringValue(cp);
                    if (name == null || value == null) continue;
                    p.setProperty(name, value);
                }
                list.add(p);
            }
            Properties[] inst = new Properties[list.size()];
            list.toArray(inst);
            return inst;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = e;
            return null;
        }
    }

    public Properties getError() {
        if (this.error == null) {
            return null;
        }
        Properties p = new Properties();
        p.setProperty("error", this.error.toString());
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.error.printStackTrace(out);
        p.setProperty("trace", sw.toString());
        return p;
    }

    public void clearError() {
        this.error = null;
    }

    public void setUseXML(boolean use) {
        this.useXML = use;
    }

    public String[] getNameSpaces() {
        return this.getNameSpaces("/root");
    }

    public String[] getNameSpaces(String rootNS) {
        LinkedList<String> list;
        block11: {
            CIMObjectPath cop;
            block10: {
                list = new LinkedList<String>();
                try {
                    cop = new CIMObjectPath("CIM_Namespace");
                    Enumeration e = this.cc.enumerateInstances(cop, true, false, false, false, null);
                    while (e.hasMoreElements()) {
                        CIMInstance ci = (CIMInstance)e.nextElement();
                        list.add(this.getStringValue(ci, "Name"));
                    }
                }
                catch (Exception e) {
                    if (!this.debug) break block10;
                    e.printStackTrace();
                }
            }
            if (list.size() == 0) {
                if (this.debug) {
                    System.out.println("No CIM_Namespace instances found, using enumNameSpace.");
                }
                cop = new CIMObjectPath(rootNS);
                try {
                    Enumeration ns = this.cc.enumNameSpace(cop, true);
                    if (ns.hasMoreElements()) {
                        while (ns.hasMoreElements()) {
                            CIMObjectPath path = (CIMObjectPath)ns.nextElement();
                            list.add(path.getNameSpace());
                            if (!this.debug) continue;
                            System.out.println("Add namespace " + path.getNameSpace());
                        }
                    } else {
                        list.add(rootNS);
                    }
                }
                catch (Exception nse) {
                    list.add(rootNS);
                    if (!this.debug) break block11;
                    nse.printStackTrace();
                }
            }
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    private String getStringValue(CIMInstance ci, String var) {
        return this.getStringValue(ci.getProperty(var));
    }

    private String getStringValue(CIMProperty cp) {
        Object value;
        CIMValue cv;
        if (cp != null && (cv = cp.getValue()) != null && (value = cv.getValue()) != null) {
            if (cv.isArrayValue()) {
                return cv.toString();
            }
            CIMDataType type = cv.getType();
            switch (type.getType()) {
                case 8: 
                case 9: {
                    return "" + value;
                }
            }
            return cv.toString();
        }
        return null;
    }

    private static Object load(String name) {
        try {
            Class<?> cls = Class.forName(name);
            return cls.newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void localConnect() throws Exception {
        Object up = WBEMClient.load("org.wbemservices.wbem.client.security.LocalUserPrincipal");
        Object pc = WBEMClient.load("org.wbemservices.wbem.client.security.LocalPasswordCredential");
        CIMNameSpace cns = new CIMNameSpace();
        cns.setNameSpace(this.namespace);
        boolean useXML = false;
        if (up == null || pc == null) {
            up = new UserPrincipal(this.user);
            pc = new PasswordCredential(this.pass);
            useXML = this.useXML;
        }
        String protocol = useXML ? "cim-xml" : "cim-rmi";
        String altproto = useXML ? "cim-rmi" : "cim-xml";
        this.cc = new CIMClient(cns, (Principal)up, pc, protocol);
    }

    public static void main(String[] args) {
        try {
            WBEMClient wc = new WBEMClient(args[1], args[2], args[3], args[4]);
            wc.connect();
            Properties[] insts = wc.enumInstances(args[0]);
            if (insts == null) {
                if (wc.error != null) {
                    wc.error.printStackTrace();
                }
                System.exit(1);
            }
            System.out.println("Found " + insts.length + " " + args[0]);
            int i = 0;
            while (i < insts.length) {
                if (insts[i] != null) {
                    insts[i].list(System.out);
                }
                ++i;
            }
            wc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }
}

