/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.wbem.client;

import com.sun.netstorage.fm.util.Options;
import com.sun.netstorage.fm.wbem.client.SystemProperties;
import java.security.Principal;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class Discover {
    private String host;
    private String nameSpace;
    private String user;
    private String pass;
    private CIMClient client;
    public static boolean debug;
    public static boolean verbose;
    public static boolean useXML;
    public static final String DEFAULT_NAMESPACE = "\\root\\cimv2";

    public void setHost(String host) {
        this.host = host;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setAuthentication(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNameSpaces() throws CIMException {
        LinkedList<String> list = new LinkedList<String>();
        try {
            this.connect(DEFAULT_NAMESPACE);
            CIMObjectPath cop = new CIMObjectPath("\root");
            Enumeration ns = this.client.enumNameSpace(cop, true);
            while (ns.hasMoreElements()) {
                CIMObjectPath path = (CIMObjectPath)ns.nextElement();
                list.add(path.getNameSpace());
            }
            Object var6_5 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanUp();
            throw throwable;
        }
        if (list.size() == 0) {
            return new String[]{DEFAULT_NAMESPACE};
        }
        String[] nss = new String[list.size()];
        list.toArray(nss);
        return nss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemProperties[] findSystems(String nameSpace) {
        LinkedList<SystemProperties> list = new LinkedList<SystemProperties>();
        try {
            try {
                this.connect(nameSpace);
                CIMObjectPath cop = new CIMObjectPath("CIM_System");
                Enumeration systems = this.client.enumerateInstances(cop, false, false, verbose, false, null);
                while (systems.hasMoreElements()) {
                    Vector deds;
                    int i;
                    Vector roles;
                    CIMValue val;
                    SystemProperties sysProps = new SystemProperties();
                    sysProps.setNameSpace(nameSpace);
                    CIMInstance systemCI = (CIMInstance)systems.nextElement();
                    String ccn = systemCI.getClassName();
                    CIMProperty cp = systemCI.getProperty("CreationClassName");
                    if (cp != null && (val = cp.getValue()) != null) {
                        ccn = val.getValue().toString();
                    }
                    sysProps.setClassName(ccn);
                    String name = "null";
                    cp = systemCI.getProperty("Name");
                    if (cp != null && (val = cp.getValue()) != null) {
                        name = val.getValue().toString();
                    }
                    sysProps.setName(name);
                    sysProps.setType("system");
                    cp = systemCI.getProperty("Roles");
                    if (cp != null && (val = cp.getValue()) != null && (roles = (Vector)val.getValue()) != null) {
                        i = 0;
                        while (i < roles.size()) {
                            if ("BlockServer".equalsIgnoreCase(roles.get(i).toString())) {
                                sysProps.setType("storage");
                            }
                            if ("Storage".equalsIgnoreCase(roles.get(i).toString())) {
                                sysProps.setType("storage");
                            }
                            ++i;
                        }
                    }
                    if ("system".equals(sysProps.getType()) && (cp = systemCI.getProperty("Dedicated")) != null && (val = cp.getValue()) != null && (deds = (Vector)val.getValue()) != null) {
                        i = 0;
                        while (i < deds.size()) {
                            Number ded = (Number)deds.get(i);
                            if (5 == ded.intValue()) {
                                sysProps.setType("fcswitch");
                            }
                            ++i;
                        }
                    }
                    try {
                        CIMObjectPath sysCop = systemCI.getObjectPath();
                        Enumeration subsystems = this.client.associators(sysCop, "CIM_ComponentCS", null, "PartComponent", "GroupComponent", true, true, null);
                        if (subsystems.hasMoreElements()) {
                            sysProps.setType("unit");
                        }
                    }
                    catch (Exception se) {
                        // empty catch block
                    }
                    if ("storage".equals(sysProps.getType())) {
                        this.addStorageProperties(systemCI, sysProps);
                    }
                    list.add(sysProps);
                }
            }
            catch (Exception e) {
                Object var15_18 = null;
                this.cleanUp();
            }
            Object var15_17 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            this.cleanUp();
            throw throwable;
        }
        SystemProperties[] spArray = new SystemProperties[list.size()];
        list.toArray(spArray);
        return spArray;
    }

    private synchronized void connect() {
        this.cleanUp();
        this.client = Discover.getCIMClient(this.host, this.nameSpace, this.user, this.pass);
    }

    private synchronized void connect(String nameSpace) {
        this.cleanUp();
        this.client = Discover.getCIMClient(this.host, nameSpace, this.user, this.pass);
    }

    private synchronized void cleanUp() {
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    public static CIMClient getCIMClient(String host, String nameSpace, String user, String pass) {
        CIMClient cc;
        block8: {
            cc = null;
            if (nameSpace == null || "".equals(nameSpace)) {
                nameSpace = DEFAULT_NAMESPACE;
            }
            if (debug) {
                System.out.println("getCIMClient:host=" + host + ", nameSpace=" + nameSpace + ", user=" + user + ", pass=" + pass);
            }
            try {
                UserPrincipal principal = new UserPrincipal(user);
                PasswordCredential credential = new PasswordCredential(pass);
                CIMNameSpace cns = new CIMNameSpace(host, nameSpace);
                String protocol = useXML ? "cim-xml" : "cim-rmi";
                String altproto = useXML ? "cim-rmi" : "cim-xml";
                try {
                    cc = new CIMClient(cns, (Principal)principal, (Object)credential, protocol);
                }
                catch (Exception e) {
                    if (debug) {
                        System.out.println(protocol + " failed.  Trying " + altproto);
                    }
                    cc = new CIMClient(cns, (Principal)principal, (Object)credential, altproto);
                }
            }
            catch (Exception e) {
                if (!debug) break block8;
                e.printStackTrace();
            }
        }
        if (debug) {
            System.out.println("CIM_Client open: " + host + ":" + nameSpace + "&" + user + "@" + pass);
        }
        return cc;
    }

    public static void printClasses(CIMClient cc, String className, boolean verbose) throws CIMException {
        CIMObjectPath cop = new CIMObjectPath(className);
        if (verbose) {
            Enumeration systems = cc.enumerateInstances(cop, true, false, true, true, null);
            while (systems.hasMoreElements()) {
                CIMInstance systemCI = (CIMInstance)systems.nextElement();
                System.out.println("" + systemCI);
            }
        } else {
            Enumeration e = cc.enumerateInstanceNames(cop);
            while (e.hasMoreElements()) {
                CIMObjectPath instPath = (CIMObjectPath)e.nextElement();
                System.out.println("" + instPath);
            }
        }
    }

    public void addStorageProperties(CIMInstance sys, SystemProperties props) {
        String wwn = "";
        String label = Discover.getStringValue(sys, "Caption");
        String ip = "";
        int diskCount = 0;
        int portCount = 0;
        CIMObjectPath sysCop = sys.getObjectPath();
        try {
            Enumeration disks = this.client.associators(sysCop, "CIM_SystemDevice", "CIM_DiskDrive", "GroupComponent", "PartComponent", false, false, null);
            while (disks.hasMoreElements()) {
                Object disk = disks.nextElement();
                ++diskCount;
            }
        }
        catch (CIMException ce) {
            // empty catch block
        }
        try {
            Enumeration ports = this.client.associators(sysCop, "CIM_SystemDevice", "CIM_FCPort", "GroupComponent", "PartComponent", true, true, null);
            while (ports.hasMoreElements()) {
                CIMInstance portCI = (CIMInstance)ports.nextElement();
                wwn = wwn + "|" + Discover.getStringValue(portCI, "PermanentAddress");
                ++portCount;
            }
        }
        catch (CIMException ce) {
            // empty catch block
        }
        props.setDiskCount(diskCount);
        props.setUserLabel(label);
        props.setWwn(wwn);
    }

    public static void discoverStorage(CIMClient cc, CIMInstance sys, String nameSpace, String ccn, String name) throws CIMException {
        if ("/interop".equals(nameSpace)) {
            return;
        }
        String wwn = "";
        String label = Discover.getStringValue(sys, "Caption");
        String ip = "";
        int diskCount = 0;
        int portCount = 0;
        CIMObjectPath sysCop = sys.getObjectPath();
        try {
            Enumeration disks = cc.associators(sysCop, "CIM_SystemDevice", "CIM_DiskDrive", "GroupComponent", "PartComponent", true, true, null);
            while (disks.hasMoreElements()) {
                Object disk = disks.nextElement();
                ++diskCount;
            }
        }
        catch (CIMException ce) {
            // empty catch block
        }
        try {
            Enumeration ports = cc.associators(sysCop, "CIM_SystemDevice", "CIM_FCPort", "GroupComponent", "PartComponent", true, true, null);
            while (ports.hasMoreElements()) {
                CIMInstance portCI = (CIMInstance)ports.nextElement();
                wwn = wwn + "|" + Discover.getStringValue(portCI, "PermanentAddress");
                ++portCount;
            }
        }
        catch (CIMException ce) {
            // empty catch block
        }
        System.out.println("storage|" + nameSpace + "|" + ccn + "|" + name + "|" + label + "|" + diskCount + "|" + ip + "|" + wwn);
    }

    public static String getStringValue(CIMInstance ci, String var) {
        return Discover.getStringValue(ci.getProperty(var));
    }

    public static String getStringValue(CIMProperty cp) {
        Object value;
        CIMValue cv;
        if (cp != null && (cv = cp.getValue()) != null && (value = cv.getValue()) != null) {
            if (cv.isArrayValue()) {
                return cv.toString();
            }
            CIMDataType type = cv.getType();
            switch (type.getType()) {
                case 8: 
                case 9: {
                    return "" + value;
                }
            }
            return cv.toString();
        }
        return null;
    }

    public static void disco(CIMClient cc, String discoType, String nameSpace) {
        block17: {
            try {
                CIMObjectPath cop = new CIMObjectPath("CIM_System");
                Enumeration systems = cc.enumerateInstances(cop, true, false, false, true, null);
                while (systems.hasMoreElements()) {
                    Vector deds;
                    int i;
                    Vector roles;
                    CIMValue val;
                    CIMInstance systemCI = (CIMInstance)systems.nextElement();
                    if (debug) {
                        System.out.println("" + systemCI);
                    }
                    String ccn = systemCI.getClassName();
                    CIMProperty cp = systemCI.getProperty("CreationClassName");
                    if (cp != null && (val = cp.getValue()) != null) {
                        ccn = val.getValue().toString();
                    }
                    String name = "null";
                    cp = systemCI.getProperty("Name");
                    if (cp != null && (val = cp.getValue()) != null) {
                        name = val.getValue().toString();
                    }
                    String type = "system";
                    cp = systemCI.getProperty("Roles");
                    if (cp != null && (val = cp.getValue()) != null && (roles = (Vector)val.getValue()) != null) {
                        i = 0;
                        while (i < roles.size()) {
                            if ("BlockServer".equalsIgnoreCase(roles.get(i).toString())) {
                                type = "storage";
                            }
                            if ("Storage".equalsIgnoreCase(roles.get(i).toString())) {
                                type = "storage";
                            }
                            ++i;
                        }
                    }
                    if ("system".equals(type) && (cp = systemCI.getProperty("Dedicated")) != null && (val = cp.getValue()) != null && (deds = (Vector)val.getValue()) != null) {
                        i = 0;
                        while (i < deds.size()) {
                            Number ded = (Number)deds.get(i);
                            if (5 == ded.intValue()) {
                                type = "fcswitch";
                            }
                            ++i;
                        }
                    }
                    try {
                        CIMObjectPath sysCop = systemCI.getObjectPath();
                        Enumeration subsystems = cc.associators(sysCop, "CIM_ComponentCS", null, "PartComponent", "GroupComponent", true, true, null);
                        if (subsystems.hasMoreElements()) {
                            type = type + ".unit";
                        }
                    }
                    catch (Exception se) {
                        // empty catch block
                    }
                    if (discoType == null) {
                        System.out.println(type + " " + nameSpace + " " + ccn + " " + name);
                        continue;
                    }
                    if (!discoType.equals(type) || !discoType.equals("storage")) continue;
                    Discover.discoverStorage(cc, systemCI, nameSpace, ccn, name);
                }
            }
            catch (Exception e) {
                if (!debug) break block17;
                e.printStackTrace();
            }
        }
    }

    public static String[] getNameSpaces(CIMClient cc, String rootNS) {
        LinkedList<String> list;
        block11: {
            CIMObjectPath cop;
            block10: {
                list = new LinkedList<String>();
                try {
                    cop = new CIMObjectPath("CIM_Namespace");
                    Enumeration e = cc.enumerateInstances(cop, true, false, false, false, null);
                    while (e.hasMoreElements()) {
                        CIMInstance ci = (CIMInstance)e.nextElement();
                        list.add(Discover.getStringValue(ci, "Name"));
                    }
                }
                catch (Exception e) {
                    if (!debug) break block10;
                    e.printStackTrace();
                }
            }
            if (list.size() == 0) {
                if (debug) {
                    System.out.println("No CIM_Namespace instances found, using enumNameSpace.");
                }
                cop = new CIMObjectPath(rootNS);
                try {
                    Enumeration ns = cc.enumNameSpace(cop, true);
                    if (ns.hasMoreElements()) {
                        while (ns.hasMoreElements()) {
                            CIMObjectPath path = (CIMObjectPath)ns.nextElement();
                            list.add(path.getNameSpace());
                            if (!debug) continue;
                            System.out.println("Add namespace " + path.getNameSpace());
                        }
                    } else {
                        list.add(rootNS);
                    }
                }
                catch (Exception nse) {
                    list.add(rootNS);
                    if (!debug) break block11;
                    nse.printStackTrace();
                }
            }
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    public static void main(String[] args) {
        try {
            int i;
            CIMClient cc;
            Options opts = new Options("Dvu:p:r:n:h:xt:");
            args = opts.parseOptions(args);
            String userName = opts.getOption("u", "administrator");
            String password = opts.getOption("p", "password");
            String nameSpace = opts.getOption("n", null);
            String cimomHost = opts.getOption("h", "localhost");
            String discoType = opts.getOption("t");
            String rootNS = opts.getOption("r", "/root");
            useXML = opts.getFlagOption("x");
            verbose = opts.getFlagOption("v");
            debug = opts.getFlagOption("D");
            if (nameSpace != null) {
                cc = Discover.getCIMClient(cimomHost, nameSpace, userName, password);
                Discover.disco(cc, discoType, nameSpace);
                System.exit(0);
            }
            nameSpace = DEFAULT_NAMESPACE;
            cc = Discover.getCIMClient(cimomHost, nameSpace, userName, password);
            String[] ns = Discover.getNameSpaces(cc, rootNS);
            if (debug) {
                System.out.println("Namespaces:");
                i = 0;
                while (i < ns.length) {
                    System.out.println("\t" + ns[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < ns.length) {
                cc.close();
                nameSpace = ns[i];
                cc = Discover.getCIMClient(cimomHost, ns[i], userName, password);
                Discover.disco(cc, discoType, nameSpace);
                ++i;
            }
            cc.close();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static {
        DEFAULT_NAMESPACE = DEFAULT_NAMESPACE;
    }
}

