/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.util.PropertyList;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.BatteryParamsUpdateDescriptor;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveChannelState;
import devmgr.versioned.symbol.DriveChannelStateDescriptor;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.TrayRef;
import devmgr.versioned.symbol.TrayRefList;
import java.util.Map;
import java.util.Properties;

public class Controls {
    private static final int DISABLE = 0;
    private static final int ENABLE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void blinkDriveLED(Map propMap, String deviceID) throws StoradeException {
        String status;
        block6: {
            PropertyList props = new PropertyList(propMap);
            SYMbolAPIClientV1 client = null;
            status = null;
            try {
                block5: {
                    try {
                        client = SYMbolConnection.getOpenConnection((Properties)props);
                        DriveRef ref = Controls.convertToDriveRef(client, deviceID);
                        DriveRef[] driveRefs = new DriveRef[]{ref};
                        DriveRefList refList = new DriveRefList();
                        refList.setDriveRef(driveRefs);
                        client.setTimeout(new ProcedureTimeout().getProcTimeout(33));
                        ReturnCode rc = client.startDriveIdentification(refList);
                        if (rc.getValue() == 1) break block5;
                        status = Translator.translateReturnCode(rc);
                    }
                    catch (Exception e) {
                        Object var10_11 = null;
                        SYMbolConnection.closeClient(client);
                        break block6;
                    }
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                SYMbolConnection.closeClient(client);
                throw throwable;
            }
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void blinkTrayLEDs(Map propMap, String deviceID) throws StoradeException {
        String status;
        block6: {
            PropertyList props = new PropertyList(propMap);
            SYMbolAPIClientV1 client = null;
            status = null;
            try {
                block5: {
                    try {
                        client = SYMbolConnection.getOpenConnection((Properties)props);
                        TrayRef ref = Controls.convertToTrayRef(client, deviceID);
                        TrayRef[] trayRefs = new TrayRef[]{ref};
                        TrayRefList refList = new TrayRefList();
                        refList.setTrayRef(trayRefs);
                        client.setTimeout(new ProcedureTimeout().getProcTimeout(115));
                        ReturnCode rc = client.startTrayIdentification(refList);
                        if (rc.getValue() == 1) break block5;
                        status = Translator.translateReturnCode(rc);
                    }
                    catch (Exception e) {
                        Object var10_11 = null;
                        SYMbolConnection.closeClient(client);
                        break block6;
                    }
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                SYMbolConnection.closeClient(client);
                throw throwable;
            }
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void blinkArrayLEDs(Map propMap) throws StoradeException {
        String status;
        block6: {
            PropertyList props = new PropertyList(propMap);
            SYMbolAPIClientV1 client = null;
            status = null;
            try {
                block5: {
                    try {
                        client = SYMbolConnection.getOpenConnection((Properties)props);
                        client.setTimeout(new ProcedureTimeout().getProcTimeout(32));
                        ReturnCode rc = client.startSAIdentification();
                        if (rc.getValue() == 1) break block5;
                        status = Translator.translateReturnCode(rc);
                    }
                    catch (Exception e) {
                        Object var6_7 = null;
                        SYMbolConnection.closeClient(client);
                        break block6;
                    }
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                SYMbolConnection.closeClient(client);
                throw throwable;
            }
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void turnOffLEDs(Map propMap) throws StoradeException {
        String status;
        block6: {
            PropertyList props = new PropertyList(propMap);
            SYMbolAPIClientV1 client = null;
            status = null;
            try {
                block5: {
                    try {
                        client = SYMbolConnection.getOpenConnection((Properties)props);
                        client.setTimeout(new ProcedureTimeout().getProcTimeout(34));
                        ReturnCode rc = client.stopIdentification();
                        if (rc.getValue() == 1) break block5;
                        status = Translator.translateReturnCode(rc);
                    }
                    catch (Exception e) {
                        Object var6_7 = null;
                        SYMbolConnection.closeClient(client);
                        break block6;
                    }
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                SYMbolConnection.closeClient(client);
                throw throwable;
            }
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resetBattery(Map propMap, String deviceID, String password) throws Exception {
        String status;
        SYMbolAPIClientV1 client;
        block10: {
            String string;
            block9: {
                String string2;
                block8: {
                    PropertyList props = new PropertyList(propMap);
                    client = null;
                    status = null;
                    try {
                        try {
                            String ip = props.getProperty("ipno");
                            String altip = props.getProperty("altipno");
                            String targetip = ip;
                            client = SYMbolConnection.getOpenConnection(targetip);
                            if (client == null && (client = SYMbolConnection.getOpenConnection(targetip = altip)) == null) {
                                string2 = "Could not open a connection to the array";
                                Object var16_12 = null;
                                break block8;
                            }
                            int bindex = deviceID.indexOf("bat");
                            String controllerID = deviceID.substring(0, bindex);
                            ControllerRef cref = Controls.convertToControllerRef(client, controllerID);
                            if (cref == null) {
                                string = "Could not create a controller ref using battery id " + deviceID;
                                break block9;
                            }
                            if (!DiagUtility.bindToController(client, cref)) {
                                SYMbolConnection.closeClient(client);
                                targetip = targetip.equals(ip) ? altip : ip;
                                client = SYMbolConnection.getOpenConnection(targetip);
                            }
                            ComponentRef ref = Controls.convertToBatteryRef(client, deviceID);
                            BatteryParamsUpdateDescriptor descr = new BatteryParamsUpdateDescriptor();
                            descr.setComponent(ref);
                            descr.setResetBatteryAge(true);
                            Utility.setClientPassword(password, client);
                            client.setTimeout(new ProcedureTimeout().getProcTimeout(89));
                            ReturnCode rc = client.setBatteryParams(descr);
                            status = rc.getValue() == 1 ? "OK" : Translator.translateReturnCode(rc);
                            break block10;
                        }
                        catch (Exception e) {
                            status = e.toString();
                            Object var16_15 = null;
                            SYMbolConnection.closeClient(client);
                            return status;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_16 = null;
                        SYMbolConnection.closeClient(client);
                        throw throwable;
                    }
                }
                SYMbolConnection.closeClient(client);
                return string2;
            }
            Object var16_13 = null;
            SYMbolConnection.closeClient(client);
            return string;
        }
        Object var16_14 = null;
        SYMbolConnection.closeClient(client);
        return status;
    }

    public static String activateController(Map propMap, String deviceID, String password) throws Exception {
        String status = Controls.changeControllerState(propMap, deviceID, password, 1);
        return status;
    }

    public static String deactivateController(Map propMap, String deviceID, String password) throws Exception {
        String status = Controls.changeControllerState(propMap, deviceID, password, 0);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String changeControllerState(Map propMap, String deviceID, String password, int targetState) throws Exception {
        String status;
        SYMbolAPIClientV1 client;
        block13: {
            String string;
            block12: {
                PropertyList props = new PropertyList(propMap);
                client = null;
                status = null;
                try {
                    try {
                        String ip = props.getProperty("ipno");
                        String altip = props.getProperty("altipno");
                        String targetip = ip;
                        client = SYMbolConnection.getOpenConnection(targetip);
                        if (client == null && (client = SYMbolConnection.getOpenConnection(targetip = altip)) == null) {
                            string = "Could not open a connection to the array";
                            Object var13_13 = null;
                            break block12;
                        }
                        ControllerRef ref = Controls.convertToControllerRef(client, deviceID);
                        if (ref != null) {
                            if (DiagUtility.bindToController(client, ref)) {
                                SYMbolConnection.closeClient(client);
                                targetip = targetip.equals(ip) ? altip : ip;
                                client = SYMbolConnection.getOpenConnection(targetip);
                            }
                            if (client != null) {
                                Utility.setClientPassword(password, client);
                                ReturnCode rc = null;
                                if (targetState == 0) {
                                    client.setTimeout(new ProcedureTimeout().getProcTimeout(10));
                                    rc = client.setControllerToFailed(ref);
                                } else {
                                    client.setTimeout(new ProcedureTimeout().getProcTimeout(36));
                                    rc = client.setControllerToOptimal(ref);
                                }
                                status = rc.getValue() == 1 ? "OK" : Translator.translateReturnCode(rc);
                                break block13;
                            } else {
                                status = "Could not open a connection to the alternate controller";
                            }
                            break block13;
                        }
                        status = "Error creating a reference using " + deviceID;
                        break block13;
                    }
                    catch (Exception e) {
                        status = "An error was received from the RPC call: " + e.toString();
                        Object var13_15 = null;
                        SYMbolConnection.closeClient(client);
                        return status;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    SYMbolConnection.closeClient(client);
                    throw throwable;
                }
            }
            SYMbolConnection.closeClient(client);
            return string;
        }
        Object var13_14 = null;
        SYMbolConnection.closeClient(client);
        return status;
    }

    public static String failDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    public static String reviveDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    public static String initializeDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    public static String reconstructDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resetMEL(String deviceKey, String password) throws Exception {
        Properties props = Utility.getDeviceProperties(deviceKey);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        try {
            try {
                client = SYMbolConnection.getOpenConnection(props);
                Utility.setClientPassword(password, client);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(16));
                ReturnCode rc = client.resetMel();
                rval = Translator.translateReturnCode(rc);
            }
            catch (Exception e) {
                Object var7_8 = null;
                SYMbolConnection.closeClient(client);
                return rval;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SYMbolConnection.closeClient(client);
            throw throwable;
        }
        SYMbolConnection.closeClient(client);
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String setDriveChannelOptimal(Map propMap, String chan, String password) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        int channel = 0;
        try {
            channel = Integer.parseInt(chan);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (channel != 1 && channel != 2) {
            return "Invalid channel specified: " + channel;
        }
        try {
            try {
                client = SYMbolConnection.getOpenConnection((Properties)props);
                Utility.setClientPassword(password, client);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(154));
                ReturnCode rc = client.clearDriveChannelStatistics();
                if (rc.getValue() == 1) {
                    DriveChannelState dcs = new DriveChannelState();
                    dcs.setValue(0);
                    DriveChannelStateDescriptor dcsd = new DriveChannelStateDescriptor();
                    dcsd.setChannel(channel);
                    dcsd.setState(dcs);
                    client.setTimeout(new ProcedureTimeout().getProcTimeout(152));
                    rc = client.setDriveChannelState(dcsd);
                    rval = Translator.translateReturnCode(rc);
                }
                rval = Translator.translateReturnCode(rc);
            }
            catch (Exception e) {
                Object var11_13 = null;
                SYMbolConnection.closeClient(client);
                return rval;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            SYMbolConnection.closeClient(client);
            throw throwable;
        }
        SYMbolConnection.closeClient(client);
        return rval;
    }

    private static DriveRef convertToDriveRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        DriveRef driveRef = null;
        if (id == null) {
            throw new StoradeException("Drive identifier is null");
        }
        int tindex = id.indexOf("t");
        int dindex = id.indexOf("drive");
        String tstr = id.substring(tindex + 1, dindex);
        String dstr = id.substring(dindex + 5);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(tstr);
            targetSlot = Integer.parseInt(dstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid drive identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Drive[] drives = objectBundle.getDrive();
            Tray[] trays = objectBundle.getTray();
            int x = 0;
            while (x < drives.length) {
                Location loc = drives[x].getPhysicalLocation();
                int currSlot = loc.getSlot();
                if (currSlot == targetSlot) {
                    byte[] driveTray = loc.getTrayRef().getRefToken();
                    int trayID = -1;
                    int i = 0;
                    while (i < trays.length) {
                        byte[] currTray = trays[i].getTrayRef().getRefToken();
                        if (Utility.rawCompare(driveTray, currTray)) {
                            trayID = trays[i].getTrayId();
                            break;
                        }
                        ++i;
                    }
                    if (trayID == targetTray) {
                        driveRef = drives[x].getDriveRef();
                        break;
                    }
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (driveRef == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return driveRef;
    }

    private static TrayRef convertToTrayRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        TrayRef trayRef = null;
        if (id == null) {
            throw new StoradeException("Tray identifier is null");
        }
        int tindex = id.indexOf("t");
        int mindex = id.indexOf("mpn");
        String tstr = id.substring(tindex + 1, mindex);
        int targetTray = -1;
        try {
            targetTray = Integer.parseInt(tstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid tray identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Tray[] trays = objectBundle.getTray();
            int i = 0;
            while (i < trays.length) {
                if (targetTray == trays[i].getTrayId()) {
                    trayRef = trays[i].getTrayRef();
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (trayRef == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return trayRef;
    }

    private static ComponentRef convertToBatteryRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        ComponentRef ref = null;
        if (id == null) {
            throw new StoradeException("Battery identifier is null");
        }
        int tindex = id.indexOf("t");
        int cindex = id.indexOf("ctrl");
        int bindex = id.indexOf("bat");
        String traystr = id.substring(tindex + 1, cindex);
        String slotstr = id.substring(cindex + 4, bindex);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(traystr);
            targetSlot = Integer.parseInt(slotstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid battery identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Controller[] controllers = objectBundle.getController();
            Tray[] trays = objectBundle.getTray();
            ComponentBundle compBundle = objectBundle.getComponentBundle();
            Battery[] batteries = compBundle.getBattery();
            int x = 0;
            while (x < batteries.length) {
                ControllerRef parentRef = batteries[x].getBatteryTypeData().getParentController();
                int i = 0;
                while (i < controllers.length) {
                    Location cloc;
                    int currSlot;
                    ControllerRef cref = controllers[i].getControllerRef();
                    if (Utility.rawCompare(parentRef.getRefToken(), cref.getRefToken()) && (currSlot = (cloc = controllers[i].getPhysicalLocation()).getSlot()) == targetSlot) {
                        byte[] controllerTray = cloc.getTrayRef().getRefToken();
                        int trayID = -1;
                        int y = 0;
                        while (y < trays.length) {
                            byte[] currTray = trays[y].getTrayRef().getRefToken();
                            if (Utility.rawCompare(controllerTray, currTray)) {
                                trayID = trays[y].getTrayId();
                                break;
                            }
                            ++y;
                        }
                        if (trayID == targetTray) {
                            ref = batteries[x].getBatteryRef();
                            break;
                        }
                    }
                    ++i;
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ref == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return ref;
    }

    private static ControllerRef convertToControllerRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        ControllerRef controllerRef = null;
        if (id == null) {
            throw new StoradeException("Controller identifier is null");
        }
        int tindex = id.indexOf("t");
        int cindex = id.indexOf("ctrl");
        String tstr = id.substring(tindex + 1, cindex);
        String cstr = id.substring(cindex + 4);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(tstr);
            targetSlot = Integer.parseInt(cstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid controller identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Controller[] controllers = objectBundle.getController();
            Tray[] trays = objectBundle.getTray();
            int x = 0;
            while (x < controllers.length) {
                Location loc = controllers[x].getPhysicalLocation();
                int currSlot = loc.getSlot();
                if (currSlot == targetSlot) {
                    byte[] controllerTray = loc.getTrayRef().getRefToken();
                    int trayID = -1;
                    int i = 0;
                    while (i < trays.length) {
                        byte[] currTray = trays[i].getTrayRef().getRefToken();
                        if (Utility.rawCompare(controllerTray, currTray)) {
                            trayID = trays[i].getTrayId();
                            break;
                        }
                        ++i;
                    }
                    if (trayID == targetTray) {
                        controllerRef = controllers[x].getControllerRef();
                        break;
                    }
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return controllerRef;
    }

    static {
        DISABLE = 0;
        ENABLE = 1;
    }
}

