/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ComponentLocation;
import devmgr.versioned.symbol.EventComponentType;
import java.util.HashMap;

public class DecodeMEL {
    private static final long MB = 0x100000L;
    public static final int ALL_EVENTS = 0;
    public static final int CRITICAL_EVENTS = 1;

    public static String getTypeName(EventComponentType type) {
        String rval = "Unknown";
        if (type != null) {
            rval = DecodeMEL.getTypeName(type.getValue());
        }
        return rval;
    }

    public static String getTypeName(int type) {
        String name = "Unknown";
        switch (type) {
            case 9: {
                name = "Battery";
                break;
            }
            case 6: {
                name = "Channel";
                break;
            }
            case 12: {
                name = "Chip";
                break;
            }
            case 8: {
                name = "Controller";
                break;
            }
            case 1: {
                name = "Drive";
                break;
            }
            case 10: {
                name = "Enclosure";
                break;
            }
            case 7: {
                name = "IOM";
                break;
            }
            case 3: {
                name = "Fan";
                break;
            }
            case 4: {
                name = "Minihub";
                break;
            }
            case 15: {
                name = "PortCRU";
                break;
            }
            case 2: {
                name = "PowerSupply";
                break;
            }
            case 5: {
                name = "TempSensor";
                break;
            }
            case 0: {
                name = "Unknown";
                break;
            }
            case 11: {
                name = "UPS";
                break;
            }
            case 13: {
                name = "Volume";
                break;
            }
            case 14: {
                name = "Vdisk";
            }
        }
        return name;
    }

    public static String getComponentLocation(int type, ComponentLocation loc) {
        String location = "Unknown";
        if (loc == null) {
            return location;
        }
        switch (type) {
            case 9: {
                int tray = loc.getBatteryTray();
                if (tray >= 0) {
                    location = "tray" + loc.getBatteryTray();
                    break;
                }
                location = "tray undefined";
                break;
            }
            case 6: {
                int cslot = loc.getChannelLoc().getControllerSlot();
                location = "Controller." + Translator.getSlotName(cslot) + ".channel." + loc.getChannelLoc().getIndex();
                break;
            }
            case 12: {
                location = "t" + loc.getChipLoc().getTray() + "s" + loc.getChipLoc().getSlot();
                break;
            }
            case 8: {
                int slot = loc.getControllerLoc().getSlot();
                location = "Controller in slot " + Translator.getSlotName(++slot);
                break;
            }
            case 1: {
                location = "Tray." + loc.getDriveLoc().getTray() + ".Drive." + loc.getDriveLoc().getSlot();
                break;
            }
            case 10: {
                location = "Tray." + loc.getEnclosureTray();
                break;
            }
            case 7: {
                location = "Tray." + loc.getEsmTray();
                break;
            }
            case 3: {
                location = "Tray." + loc.getFanTray();
                break;
            }
            case 4: {
                location = "Unknown";
                break;
            }
            case 15: {
                location = "Tray." + loc.getPortCruTray();
                break;
            }
            case 2: {
                location = "Tray." + loc.getPowerSupplyTray();
                break;
            }
            case 5: {
                location = "Tray." + loc.getTempSensorTray();
                break;
            }
            case 0: {
                location = "Unknown";
                break;
            }
            case 11: {
                location = "Unknown";
                break;
            }
            case 13: {
                location = Utility.userLabelString(loc.getLabel());
                break;
            }
            case 14: {
                location = "Vdisk index " + loc.getGroupNumber();
            }
        }
        return location;
    }

    public static String decodePriority(int priority) {
        String description = "Unknown";
        switch (priority) {
            case 0: {
                description = "Critical";
                break;
            }
            case 1: {
                description = "Info";
            }
        }
        return description;
    }

    public static HashMap getTargetMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(new Integer(4097), "Channel failed");
        map.put(new Integer(4112), "Impending drive failure (PFA) detected");
        map.put(new Integer(4615), "Fibre channel link errors - threshold exceeded");
        map.put(new Integer(4616), "Data rate negotiation failed");
        map.put(new Integer(5390), "Controller loop-back diagnostics failed");
        map.put(new Integer(5391), "Channel miswire");
        map.put(new Integer(5392), "IOM miswire");
        map.put(new Integer(5395), "Individual drive - degraded path");
        map.put(new Integer(5632), "Uncertified drive detected");
        map.put(new Integer(5633), "Reserved blocks on SATA drives cannot be discovered");
        map.put(new Integer(8202), "Data/parity mismatch on volume ");
        map.put(new Integer(8238), "Read drive error during interrupted write");
        map.put(new Integer(8457), "Controller cache not enabled - cache sizes do not match");
        map.put(new Integer(8460), "Controller cache battery failed");
        map.put(new Integer(8462), "Controller cache memory recovery failed after power cycle or reset");
        map.put(new Integer(8464), "Controller cache memory initialization failed");
        map.put(new Integer(8467), "Controller cache battery nearing expiration");
        map.put(new Integer(8475), "Batteries present but NVSRAM file configured for no batteries");
        map.put(new Integer(8745), "Drive failed by controller");
        map.put(new Integer(8749), "Drive manually failed");
        map.put(new Integer(8775), "Data lost on volume during unrecovered interrupted write");
        map.put(new Integer(8776), "Drive failed - write failure");
        map.put(new Integer(8777), "Drive capacity less than minimum");
        map.put(new Integer(8778), "Drive has wrong block size");
        map.put(new Integer(8779), "Drive failed - initialization failure");
        map.put(new Integer(8781), "Drive failed - no response at start of day");
        map.put(new Integer(8782), "Drive failed - initialization/reconstruction failure");
        map.put(new Integer(8784), "Volume failure");
        map.put(new Integer(8785), "Drive failed - reconstruction failure");
        map.put(new Integer(8786), "Drive marked offline during interrupted write");
        map.put(new Integer(8789), "Volume definition incompatible with ALT mode - ALT disabled");
        map.put(new Integer(9730), "Automatic controller firmware synchronization failed");
        map.put(new Integer(10241), "Storage Array running on UPS battery");
        map.put(new Integer(10243), "UPS battery - two minutes to failure");
        map.put(new Integer(10248), "Tray ID not unique");
        map.put(new Integer(10254), "Standby power source not fully charged");
        map.put(new Integer(10255), "IOM - loss of communication");
        map.put(new Integer(10259), "Mini-hub canister failed");
        map.put(new Integer(10261), "GBIC failed");
        map.put(new Integer(10262), "Tray ID conflict - duplicate IDs across drive trays");
        map.put(new Integer(10264), "Tray ID mismatch - duplicate IDs in same drive tray");
        map.put(new Integer(10267), "Nominal temperature exceeded");
        map.put(new Integer(10268), "Maximum temperature exceeded");
        map.put(new Integer(10269), "Temperature sensor removed");
        map.put(new Integer(10270), "IOM firmware mismatch");
        map.put(new Integer(10273), "Incompatible mini-hub canister");
        map.put(new Integer(10275), "Drive by-passed");
        map.put(new Integer(10279), "Controller inadvertently replaced with an IOM");
        map.put(new Integer(10280), "Unsupported drive tray detected");
        map.put(new Integer(10281), "Controller redundancy lost");
        map.put(new Integer(10283), "Drive tray path redundancy lost");
        map.put(new Integer(10285), "Drive path redundancy lost");
        map.put(new Integer(10288), "Mixed drive types not supported");
        map.put(new Integer(12313), "Volume ownership changed due to failover");
        map.put(new Integer(16401), "Volume not on preferred path due to AVT/RDAC failover");
        map.put(new Integer(20485), "Controller was placed offline");
        map.put(new Integer(20536), "Storage array 10-minute lockout; maximum incorrect passwords attempted");
        map.put(new Integer(22018), "This controller's alternate failed - timeout waiting for results");
        map.put(new Integer(22027), "Diagnostics rejected - CtlrDiag task cannot obtain Mode Select lock");
        map.put(new Integer(22028), "Diagnostics rejected - CtlrDiag task on controller's alternate cannot obtain Mode Select lock");
        map.put(new Integer(22029), "Diagnostics read test failed on controller");
        map.put(new Integer(22030), "This controller's alternate failed diagnostics read test");
        map.put(new Integer(22031), "Diagnostics write test failed on controller");
        map.put(new Integer(22032), "This controller's alternate failed diagnostics write test");
        map.put(new Integer(22038), "Diagnostics rejected - configuration error on controller");
        map.put(new Integer(22039), "Diagnostics rejected - configuration error on this controller's alternate");
        map.put(new Integer(24833), "Internal configuration database full");
        map.put(new Integer(24839), "This controller's alternate is non-functional and is being held in reset");
        map.put(new Integer(25088), "Snapshot repository volume capacity - threshold exceeded");
        map.put(new Integer(25089), "Snapshot repository volume capacity - full");
        map.put(new Integer(25090), "Snapshot volume failed");
        map.put(new Integer(25600), "Dual primary volume conflict");
        map.put(new Integer(25601), "Dual secondary volume conflict");
        map.put(new Integer(25602), "Data on mirrored pair unsynchronized");
        map.put(new Integer(25610), "Mirrored pair unsynchronized - volume failures");
        map.put(new Integer(25859), "Communication to remote volume - down");
        map.put(new Integer(25861), "Failed to communicate storage array's storage array ID");
        map.put(new Integer(26112), "Volume copy operation failed");
        map.put(new Integer(26368), "Unreadable sector(s) detected - data loss occurred");
        map.put(new Integer(26371), "Overflow in unreadable sector database");
        map.put(new Integer(4105), "Controller memory parity error");
        map.put(new Integer(4106), "Drive returned a check condition");
        map.put(new Integer(4109), "Timeout on drive side of controller");
        map.put(new Integer(4110), "Unexpected interrupt on controller");
        map.put(new Integer(4116), "Destination driver successfully issued reassign blocks command");
        map.put(new Integer(4118), "Unrecoverable read error on drive");
        map.put(new Integer(4119), "Fibre channel link down");
        map.put(new Integer(4120), "Fibre channel link up");
        map.put(new Integer(4121), "Channel link down (60 seconds)");
        map.put(new Integer(4617), "Drive channel set to Degraded");
        map.put(new Integer(5396), "Drive channel changed to optimal");
        map.put(new Integer(5401), "Unresponsive drive (bad AL_PA error)");
        map.put(new Integer(8193), "Repair started");
        map.put(new Integer(8194), "Repair completed");
        map.put(new Integer(8197), "Virtual disk failed - interrupted write");
        map.put(new Integer(8205), "I/O aborted on a volume");
        map.put(new Integer(8206), "Virtual disk drive reconfigured");
        map.put(new Integer(8207), "Cache synchronization started");
        map.put(new Integer(8212), "Virtual disk drive logged an error");
        map.put(new Integer(8217), "I/O's elapsed time exceeded threshold");
        map.put(new Integer(8218), "Virtual disk drive restore started");
        map.put(new Integer(8219), "Virtual disk drive restore completed");
        map.put(new Integer(8220), "Virtual disk drive recover started");
        map.put(new Integer(8221), "Virtual disk drive recover completed");
        map.put(new Integer(8222), "Virtual disk drive repair started");
        map.put(new Integer(8223), "Virtual disk drive repair started");
        map.put(new Integer(8225), "Virtual disk failed during interrupted write");
        map.put(new Integer(8226), "Media scan (scrub) started");
        map.put(new Integer(8227), "Media scan (scrub) completed");
        map.put(new Integer(8228), "Media scan (scrub) resumed");
        map.put(new Integer(8229), "Reconstruction started");
        map.put(new Integer(8230), "Reconstruction completed");
        map.put(new Integer(8231), "Reconstruction resumed");
        map.put(new Integer(8232), "Modification (reconfigure) started");
        map.put(new Integer(8233), "Modification (reconfigure) completed");
        map.put(new Integer(8235), "Redundancy (parity) check started");
        map.put(new Integer(8236), "Redundancy (parity) check completed");
        map.put(new Integer(8237), "Redundancy (parity) check resumed");
        map.put(new Integer(8239), "Automatic volume transfer completed");
        map.put(new Integer(8240), "Initialization completed");
        map.put(new Integer(8241), "Initialization started");
        map.put(new Integer(8243), "Parity reconstructed on volume");
        map.put(new Integer(8244), "Data/parity mismatch detected on volume");
        map.put(new Integer(8463), "Controller cache memory parity error detected");
        map.put(new Integer(8466), "Controller cache battery is fully charged");
        map.put(new Integer(8470), "Alternate controller cache battery failed");
        map.put(new Integer(8472), "Memory parity ECC error");
        map.put(new Integer(8473), "Recoverable error in data buffer memory detected/corrected");
        map.put(new Integer(8474), "Cache corrected by using alternate controller's cache");
        map.put(new Integer(8706), "A new volume was created");
        map.put(new Integer(8709), "Source drive failed during copy operation");
        map.put(new Integer(8710), "Reconstruction completed");
        map.put(new Integer(8711), "Device copy complete");
        map.put(new Integer(8714), "Copyback started");
        map.put(new Integer(8715), "Copyback restarted");
        map.put(new Integer(8716), "Device failed during interrupted write processing");
        map.put(new Integer(8721), "Restore completed");
        map.put(new Integer(8722), "Parity repaired");
        map.put(new Integer(8728), "Piece failed duringuncompleted write processing");
        map.put(new Integer(8729), "Piece removed from volume");
        map.put(new Integer(8736), "Hot spare drive added to hot spare list");
        map.put(new Integer(8737), "Hot spare drive removed from hot spare list");
        map.put(new Integer(8740), "Reconstruction started");
        map.put(new Integer(8746), "Hot spare drive assigned");
        map.put(new Integer(8747), "Drive replaced while array was powered off");
        map.put(new Integer(8756), "Reconstruction drive marked as removed");
        map.put(new Integer(8758), "Hot spare drive copy completed");
        map.put(new Integer(8759), "Replaced drive completed reconstruction");
        map.put(new Integer(8761), "Hot spare drive assigned internally");
        map.put(new Integer(8773), "Media scan (scrub) stopped");
        map.put(new Integer(8774), "Media scan (scrub) resumed");
        map.put(new Integer(8790), "Copyback completed on volume");
        map.put(new Integer(8791), "Modification (reconfigure) started on volume");
        map.put(new Integer(8792), "Modification (reconfigure) completed on volume");
        map.put(new Integer(9728), "Automatic controller firmware synchronization started");
        map.put(new Integer(9729), "Automatic controller firmware synchronization completed");
        map.put(new Integer(9732), "Persistent controller memory parity error");
        map.put(new Integer(9733), "Start-of-day routine completed");
        map.put(new Integer(9734), "Start-of-day routine begun");
        map.put(new Integer(9987), "Recoverable error in processor memory detected/corrected");
        map.put(new Integer(10240), "Power supply state changedetected");
        map.put(new Integer(10256), "IOM communication restored");
        map.put(new Integer(10266), "Temperature now optimal");
        map.put(new Integer(10276), "Drive bypass condition resolved");
        map.put(new Integer(10282), "Controller redundancy restored");
        map.put(new Integer(10287), "Incompatible version of IOM firmware detected");
        map.put(new Integer(10296), "Interconnect CRU removed");
        map.put(new Integer(10297), "Interconnect CRU reinserted");
        map.put(new Integer(10300), "Power supply needs attention");
        map.put(new Integer(10303), "Fan needs attention");
        map.put(new Integer(12307), "Download controller firmware issued");
        map.put(new Integer(12308), "Drive firmware download started");
        map.put(new Integer(12314), "Drive firmware download failed");
        map.put(new Integer(12315), "Drive firmware download completed");
        map.put(new Integer(12316), "IOM firmware download started");
        map.put(new Integer(12317), "IOM firmware download failed");
        map.put(new Integer(12318), "IOM firmware download completed");
        map.put(new Integer(16398), "Automatic volume transfer started");
        map.put(new Integer(16400), "Controller reset");
        map.put(new Integer(20481), "Assign hot spare drive");
        map.put(new Integer(20483), "De-Assign hot spare drive");
        map.put(new Integer(20489), "Controller firmware download started");
        map.put(new Integer(20490), "Drive firmware download started");
        map.put(new Integer(20491), "NVSRAM download started");
        map.put(new Integer(20494), "Drive reconstruction started");
        map.put(new Integer(20507), "Place controller online");
        map.put(new Integer(20517), "Controller firmware download failed");
        map.put(new Integer(20518), "Controller firmware download completed");
        map.put(new Integer(20519), "Controller NVSRAM download failed");
        map.put(new Integer(20520), "Controller NVSRAM download completed");
        map.put(new Integer(20522), "Volume ownership modified");
        map.put(new Integer(20544), "Place controller in service mode");
        map.put(new Integer(20545), "Volume recovered");
        map.put(new Integer(25091), "Snapshot volume created");
        map.put(new Integer(25092), "Snapshot volume deleted");
        map.put(new Integer(25603), "Data on mirrored pair synchronizing");
        map.put(new Integer(25604), "Data on mirrored pair synchronized");
        map.put(new Integer(25605), "Associated volume in mirrored pair not present");
        map.put(new Integer(25609), "Mirror relationship suspended");
        map.put(new Integer(25611), "Mirror relationship suspended failed");
        map.put(new Integer(25612), "Mirror write mode set to synchronous");
        map.put(new Integer(25613), "Mirror write mode set to asynchronous");
        map.put(new Integer(25614), "Mirror write mode set to asynchronous, write-consistent");
        map.put(new Integer(25856), "Remote volume created");
        map.put(new Integer(25857), "Remote volume deleted");
        map.put(new Integer(25858), "Communication to remote volume is up");
        map.put(new Integer(26113), "Volume copy pair established");
        map.put(new Integer(26114), "Volume copy pair removed");
        map.put(new Integer(26115), "Volume copy operation in progress");
        map.put(new Integer(26118), "Volume copy operation completed");
        map.put(new Integer(26369), "Unreadable sector repaired");
        map.put(new Integer(26370), "All unreadable sectors on volume repaired - data unrecovered");
        map.put(new Integer(26372), "Unreadable sectors found on volume");
        return map;
    }

    public static HashMap getDescriptions() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(new Integer(256), "Event log cleared");
        map.put(new Integer(4097), "Channel failed");
        map.put(new Integer(4098), "Channel revived");
        map.put(new Integer(4099), "Drive error tally exceeded threshold");
        map.put(new Integer(4100), "Error on drive open");
        map.put(new Integer(4101), "Drive read failure - retries exhausted");
        map.put(new Integer(4102), "Drive write failure - retries exhausted");
        map.put(new Integer(4103), "Controller out of memory");
        map.put(new Integer(4104), "Unsupported SCSI chip");
        map.put(new Integer(4105), "Controller memory parity error");
        map.put(new Integer(4106), "Drive returned CHECK CONDITION");
        map.put(new Integer(4107), "Start-of-day error in destination driver");
        map.put(new Integer(4108), "Hardware error on drive side of controller");
        map.put(new Integer(4109), "Timeout on drive side of controller");
        map.put(new Integer(4110), "Unexpected interrupt on controller");
        map.put(new Integer(4111), "Bus parity error on controller");
        map.put(new Integer(4112), "Impending drive failure (PFA) detected");
        map.put(new Integer(4113), "Chip error");
        map.put(new Integer(4114), "Destination driver event");
        map.put(new Integer(4115), "Destination driver level 0 diagnostic failed");
        map.put(new Integer(4116), "Destination driver successfully issued reassign blocks command");
        map.put(new Integer(4117), "Incorrect mode parameters modified and saved on drive");
        map.put(new Integer(4118), "Hardware error - Unrecoverable read error on drive");
        map.put(new Integer(4119), "Fibre channel link down");
        map.put(new Integer(4120), "Fibre channel link up");
        map.put(new Integer(4121), "Extended fibre channel link down (greater than one minute)");
        map.put(new Integer(4122), "Unresponsive drive - extended I/O timeout");
        map.put(new Integer(4353), "SRC driver detected exception on SCSI chip");
        map.put(new Integer(4354), "Host bus reset asserted");
        map.put(new Integer(4355), "Host bus reset received");
        map.put(new Integer(4356), "Unknown interrupt");
        map.put(new Integer(4609), "Fibre channel - LIP reset received");
        map.put(new Integer(4610), "Fibre channel - TGT reset received");
        map.put(new Integer(4611), "Fibre channel - TPRLO reset received");
        map.put(new Integer(4612), "Fibre channel - driver detected error after initialization");
        map.put(new Integer(4613), "Fibre channel - driver detected error during initialization");
        map.put(new Integer(4614), "Fibre channel link errors continue");
        map.put(new Integer(4615), "Fibre channel link errors - threshold exceeded");
        map.put(new Integer(4616), "Data rate negotiation failed");
        map.put(new Integer(4617), "Drive channel set to degraded");
        map.put(new Integer(5376), "Channel initialization error");
        map.put(new Integer(5377), "Selective LIP reset issued to drive");
        map.put(new Integer(5378), "Selective LIP reset issued to alternate controller");
        map.put(new Integer(5379), "Selective LIP reset issued to IOM");
        map.put(new Integer(5380), "Loop port enable (LPE) issued to drive");
        map.put(new Integer(5381), "Loop port enable (LPE) issued to alternate controller");
        map.put(new Integer(5382), "Loop port enable (LPE) issued to IOM");
        map.put(new Integer(5383), "Loop port bypass (LPB) issued to drive");
        map.put(new Integer(5384), "Loop port bypass (LPB) issued to alternate controller");
        map.put(new Integer(5385), "Loop port bypass (LPB) issued to IOM");
        map.put(new Integer(5386), "Unresponsive drive (bad AL_PA error)");
        map.put(new Integer(5387), "Unresponsive alternate controller (bad AL_PA error)");
        map.put(new Integer(5388), "Unresponsive IOM (bad AL_PA error)");
        map.put(new Integer(5389), "Channel reset occurred");
        map.put(new Integer(5390), "Controller loop-back diagnostics failed");
        map.put(new Integer(5391), "Channel miswire");
        map.put(new Integer(5392), "IOM miswire");
        map.put(new Integer(5393), "Channel miswire resolved");
        map.put(new Integer(5394), "IOM miswire resolved");
        map.put(new Integer(5395), "Individual drive - degraded path");
        map.put(new Integer(5396), "Drive channel changed to optimal");
        map.put(new Integer(5632), "Uncertified drive detected");
        map.put(new Integer(5633), "Reserved blocks on SATA drives cannot be discovered");
        map.put(new Integer(8193), "Repair started");
        map.put(new Integer(8194), "Repair completed");
        map.put(new Integer(8195), "Interrupted write started");
        map.put(new Integer(8196), "Interrupted write completed");
        map.put(new Integer(8197), "Virtual disk failed - interrupted write");
        map.put(new Integer(8198), "Piece failed");
        map.put(new Integer(8199), "Fail piece delayed");
        map.put(new Integer(8200), "Failed volume started reconstruction");
        map.put(new Integer(8201), "RAID 0 write failures");
        map.put(new Integer(8202), "Data/parity mismatch on volume");
        map.put(new Integer(8203), "Unrecovered deferred error on volume");
        map.put(new Integer(8204), "Recovered error on volume");
        map.put(new Integer(8205), "I/O aborted on volume");
        map.put(new Integer(8206), "Virtual disk driver reconfigured");
        map.put(new Integer(8207), "Cache synchronization started");
        map.put(new Integer(8208), "Cache synchronization completed");
        map.put(new Integer(8209), "Cache flush started");
        map.put(new Integer(8210), "Cache flush completed");
        map.put(new Integer(8211), "Unwritten data/parity recovered from cache");
        map.put(new Integer(8212), "VDD logged an error");
        map.put(new Integer(8213), "Uncompleted writes detected in NVSRAM at start-of-day");
        map.put(new Integer(8214), "Interrupted writes processed");
        map.put(new Integer(8215), "Interrupted writes detected from checkpoint logs");
        map.put(new Integer(8216), "I/O suspended due to no pre-allocated resources");
        map.put(new Integer(8217), "Performance monitor: I/O's elapsed time exceeded threshold");
        map.put(new Integer(8218), "VDD restore started");
        map.put(new Integer(8219), "VDD restore completed");
        map.put(new Integer(8220), "VDD recover started");
        map.put(new Integer(8221), "VDD recover completed");
        map.put(new Integer(8222), "VDD repair started");
        map.put(new Integer(8223), "VDD repair completed");
        map.put(new Integer(8224), "Piece failed during interrupted write");
        map.put(new Integer(8225), "Virtual disk failed during interrupted write");
        map.put(new Integer(8226), "Media scan (scrub) started");
        map.put(new Integer(8227), "Media scan (scrub) completed");
        map.put(new Integer(8228), "Media scan (scrub) resumed");
        map.put(new Integer(8229), "Reconstruction started");
        map.put(new Integer(8230), "Reconstruction completed");
        map.put(new Integer(8231), "Reconstruction resumed");
        map.put(new Integer(8232), "Modification (reconfigure) started");
        map.put(new Integer(8233), "Modification (reconfigure) completed");
        map.put(new Integer(8234), "Modification (reconfigure) resumed");
        map.put(new Integer(8235), "Redundancy check started");
        map.put(new Integer(8236), "Redundancy check completed");
        map.put(new Integer(8237), "Redundancy check resumed");
        map.put(new Integer(8238), "Read drive error during interrupted write");
        map.put(new Integer(8239), "Automatic volume transfer completed");
        map.put(new Integer(8240), "Initialization completed on volume");
        map.put(new Integer(8241), "Initialization started on volume");
        map.put(new Integer(8242), "Initialization resumed on volume");
        map.put(new Integer(8243), "Parity reconstructed on volume");
        map.put(new Integer(8244), "Data/parity mismatch detected on volume");
        map.put(new Integer(8288), "Protection information mismatch detected by the channel interface");
        map.put(new Integer(8289), "Protection information mismatch detected for cached volume data");
        map.put(new Integer(8449), "Alternate controller checked in late");
        map.put(new Integer(8450), "Cache mirroring on controllers not synchronized");
        map.put(new Integer(8451), "UPS battery is fully charged");
        map.put(new Integer(8452), "Controller cache synchronization/purge event");
        map.put(new Integer(8453), "Controller cache reconfigure event");
        map.put(new Integer(8454), "Update requested on controller cache manager's DACSTORE");
        map.put(new Integer(8455), "Clear requested on controller cache manager's DACSTORE");
        map.put(new Integer(8456), "Controller cache manager experiencing errors");
        map.put(new Integer(8457), "Controller cache not enabled - cache sizes do not match");
        map.put(new Integer(8458), "Controller cache not enabled or was internally disabled");
        map.put(new Integer(8459), "Cache between controllers not synchronized");
        map.put(new Integer(8460), "Controller cache battery failed");
        map.put(new Integer(8461), "Controller deferred error");
        map.put(new Integer(8462), "Controller cache memory recovery failed after power cycle or reset");
        map.put(new Integer(8463), "Controller cache memory parity error detected");
        map.put(new Integer(8464), "Controller cache memory initialization failed");
        map.put(new Integer(8465), "Controller cache task failed");
        map.put(new Integer(8466), "Controller cache battery is fully charged");
        map.put(new Integer(8467), "Controller cache battery nearing expiration");
        map.put(new Integer(8468), "Alternate controller cache battery is fully charged");
        map.put(new Integer(8469), "Alternate controller cache battery nearing expiration");
        map.put(new Integer(8470), "Alternate controller cache battery failed");
        map.put(new Integer(8471), "Controller cache manager error cleared");
        map.put(new Integer(8472), "Memory parity ECC error");
        map.put(new Integer(8473), "Recoverable error in data buffer memory detected/corrected");
        map.put(new Integer(8474), "Cache corrected by using alternate controller's cache");
        map.put(new Integer(8475), "Batteries present but NVSRAM file configured for no batteries");
        map.put(new Integer(8705), "Volume marked optimal");
        map.put(new Integer(8706), "Volume added");
        map.put(new Integer(8707), "Virtual disk or volume deleted");
        map.put(new Integer(8708), "I/O is resumed");
        map.put(new Integer(8709), "Source drive failed during copy operation");
        map.put(new Integer(8710), "Reconstruction completed");
        map.put(new Integer(8711), "Device copy complete");
        map.put(new Integer(8712), "Modification (reconfigure) started");
        map.put(new Integer(8713), "Modification (reconfigure) completed");
        map.put(new Integer(8714), "Copyback started");
        map.put(new Integer(8715), "Copyback restarted");
        map.put(new Integer(8716), "Device failed during interrupted write processing");
        map.put(new Integer(8717), "Media scan (scrub) enabled");
        map.put(new Integer(8718), "Media scan (scrub) started");
        map.put(new Integer(8719), "Media scan (scrub) completed");
        map.put(new Integer(8720), "Restore started");
        map.put(new Integer(8721), "Restore completed");
        map.put(new Integer(8722), "Parity repaired");
        map.put(new Integer(8723), "Volume initialized with zeros");
        map.put(new Integer(8724), "One or more Sundry regions created");
        map.put(new Integer(8725), "Drive marked failed");
        map.put(new Integer(8726), "Piece taken out of service");
        map.put(new Integer(8727), "Piece failed");
        map.put(new Integer(8728), "Piece failed during uncompleted write processing");
        map.put(new Integer(8729), "Piece removed from volume");
        map.put(new Integer(8730), "Piece replaced");
        map.put(new Integer(8731), "Piece placed in service");
        map.put(new Integer(8732), "Virtual disk placed offline");
        map.put(new Integer(8733), "Virtual disk placed online");
        map.put(new Integer(8734), "Virtual disk or volume initialized");
        map.put(new Integer(8735), "Immediate availability initialization (IAF) completed on volume");
        map.put(new Integer(8736), "Hot spare drive added to hot spare list");
        map.put(new Integer(8737), "Hot spare drive removed from hot spare list");
        map.put(new Integer(8738), "Logical unit number for volume reassigned");
        map.put(new Integer(8739), "Duplicate data structure exists for two devices");
        map.put(new Integer(8740), "Reconstruction started");
        map.put(new Integer(8741), "Reconstruction restarted");
        map.put(new Integer(8742), "Drive spun down");
        map.put(new Integer(8743), "Drive marked optimal");
        map.put(new Integer(8744), "Drive deleted");
        map.put(new Integer(8745), "Drive failed by controller");
        map.put(new Integer(8746), "Hot spare drive assigned");
        map.put(new Integer(8747), "Drive replaced when storage array was turned off");
        map.put(new Integer(8748), "Drive marked unassigned");
        map.put(new Integer(8749), "Drive manually failed");
        map.put(new Integer(8750), "Mark drive removed");
        map.put(new Integer(8751), "Drive marked replaced");
        map.put(new Integer(8752), "Drive failed by device manager");
        map.put(new Integer(8753), "Drive marked removed");
        map.put(new Integer(8754), "Removed drive marked removed");
        map.put(new Integer(8755), "Unassigned drive marked removed");
        map.put(new Integer(8756), "Reconstructing drive marked removed");
        map.put(new Integer(8757), "Optimal/Replaced drive marked removed");
        map.put(new Integer(8758), "Hot spare drive copy completed");
        map.put(new Integer(8759), "Replaced drive completed reconstruction");
        map.put(new Integer(8760), "Drive added in previously unused slot");
        map.put(new Integer(8761), "Hot spare drive assigned internally");
        map.put(new Integer(8762), "Drive marked deleted");
        map.put(new Integer(8763), "Failed/Replaced drive marked replaced");
        map.put(new Integer(8764), "Drive reinserted");
        map.put(new Integer(8765), "Unassigned drive replaced");
        map.put(new Integer(8766), "Drive marked optimal");
        map.put(new Integer(8767), "Partially reconstructed drive marked optimal");
        map.put(new Integer(8768), "DACSTORE created for unassigned or hot spare drive");
        map.put(new Integer(8769), "Unassigned drive with no DACSTORE failed");
        map.put(new Integer(8770), "Unassigned drive with no DACSTORE deleted");
        map.put(new Integer(8771), "Unassigned drive with no DACSTORE removed");
        map.put(new Integer(8772), "Unknown drive marked unassigned");
        map.put(new Integer(8773), "Media scan (scrub) stopped");
        map.put(new Integer(8774), "Media scan (scrub) resumed");
        map.put(new Integer(8775), "Data lost on volume during unrecovered interrupted write");
        map.put(new Integer(8776), "Drive failed - write failure");
        map.put(new Integer(8777), "Drive capacity less than minimum");
        map.put(new Integer(8778), "Drive has wrong block size");
        map.put(new Integer(8779), "Drive failed - initialization failure");
        map.put(new Integer(8780), "Wrong drive removed/replaced");
        map.put(new Integer(8781), "Drive failed - no response at start of day");
        map.put(new Integer(8782), "Drive failed - initialization/reconstruction failure");
        map.put(new Integer(8783), "Hot spare capacity not sufficient for all drives");
        map.put(new Integer(8784), "Volume failure");
        map.put(new Integer(8785), "Drive failed - reconstruction failure");
        map.put(new Integer(8786), "Drive marked offline during interrupted write");
        map.put(new Integer(8787), "Virtual disk or volume modified (created or deleted)");
        map.put(new Integer(8788), "Redundancy (parity) and data mismatch was detected");
        map.put(new Integer(8789), "Volume definition incompatible with ALT mode-ALT disabled");
        map.put(new Integer(8790), "Copyback completed on volume");
        map.put(new Integer(8791), "Modification (reconfigure) started on volume");
        map.put(new Integer(8792), "Modification (reconfigure) completed on volume");
        map.put(new Integer(8793), "Initialization started on volume");
        map.put(new Integer(8794), "Immediate availability initialization (IAF) started on volume");
        map.put(new Integer(8795), "Premium feature not supported - snapshot volumes and mirror relationships deleted");
        map.put(new Integer(8796), "Controller in stopped state");
        map.put(new Integer(8797), "Automatic configuration started");
        map.put(new Integer(8798), "Automatic configuration completed successfully");
        map.put(new Integer(8799), "Automatic configuration failed");
        map.put(new Integer(9216), "Hot swap monitor detected drive removal");
        map.put(new Integer(9217), "Hot swap monitor detected drive insertion");
        map.put(new Integer(9472), "Controller inserted or removed");
        map.put(new Integer(9473), "Controller mode changed to active");
        map.put(new Integer(9474), "Controller icon chip error");
        map.put(new Integer(9475), "Controller mode changed to passive");
        map.put(new Integer(9476), "Controller mode changed to active");
        map.put(new Integer(9477), "Controller mode switch occurred");
        map.put(new Integer(9728), "Automatic controller firmware synchronization started");
        map.put(new Integer(9729), "Automatic controller firmware synchronization completed");
        map.put(new Integer(9730), "Automatic controller firmware synchronization failed");
        map.put(new Integer(9731), "Default volume created");
        map.put(new Integer(9732), "Persistent controller memory parity error");
        map.put(new Integer(9733), "Start-of-day routine completed");
        map.put(new Integer(9734), "Start-of-day routine begun");
        map.put(new Integer(9984), "Controller RPA memory parity error detected");
        map.put(new Integer(9985), "PCI controller parity error");
        map.put(new Integer(9986), "Controller unexpected RPA interrupt detected");
        map.put(new Integer(9987), "Recoverable error in processor memory detected/corrected");
        map.put(new Integer(10240), "Power supply state change detected");
        map.put(new Integer(10241), "Storage array running on UPS battery");
        map.put(new Integer(10242), "UPS battery is fully charged");
        map.put(new Integer(10243), "UPS battery - two minutes to failure");
        map.put(new Integer(10244), "UPS battery failed");
        map.put(new Integer(10245), "Controller tray component change detected");
        map.put(new Integer(10246), "Tray component change ");
        map.put(new Integer(10247), "IOM failed");
        map.put(new Integer(10248), "Tray ID not unique");
        map.put(new Integer(10249), "Controller tray component changed to optimal");
        map.put(new Integer(10250), "Controller tray component removed");
        map.put(new Integer(10251), "Controller tray component failed");
        map.put(new Integer(10252), "Drive tray component changed to optimal");
        map.put(new Integer(10253), "Drive tray component failed or removed");
        map.put(new Integer(10254), "Standby power source not fully charged");
        map.put(new Integer(10255), "IOM - loss of communication");
        map.put(new Integer(10256), "IOM - communication restored");
        map.put(new Integer(10258), "Mini-hub canister changed to optimal");
        map.put(new Integer(10259), "Mini-hub canister failed");
        map.put(new Integer(10260), "GBIC/SFP changed to optimal");
        map.put(new Integer(10261), "GBIC/SFP failed");
        map.put(new Integer(10262), "Tray ID conflict - duplicate IDs across drive trays");
        map.put(new Integer(10263), "Tray ID conflict resolved");
        map.put(new Integer(10264), "Tray ID mismatch - duplicate IDs in same drive tray");
        map.put(new Integer(10265), "Tray ID mismatch resolved");
        map.put(new Integer(10266), "Temperature changed to optimal");
        map.put(new Integer(10267), "Nominal temperature exceeded");
        map.put(new Integer(10268), "Maximum temperature exceeded");
        map.put(new Integer(10269), "Temperature sensor removed");
        map.put(new Integer(10270), "IOM firmware or hardware mismatch");
        map.put(new Integer(10271), "IOM firmware or hardware mismatch resolved");
        map.put(new Integer(10272), "Two controllers present but NVSRAM (offset 0x35, bit 6) set for NOT reporting a missing second controller");
        map.put(new Integer(10273), "Incompatible mini-hub canister");
        map.put(new Integer(10274), "Drive by-passed - data rate (speed) mismatch");
        map.put(new Integer(10275), "Drive by-passed");
        map.put(new Integer(10276), "Drive by-passed condition resolved");
        map.put(new Integer(10277), "Tray ID harness removed");
        map.put(new Integer(10278), "Tray ID harness replaced");
        map.put(new Integer(10279), "Controller inadvertently replaced with an IOM");
        map.put(new Integer(10280), "Unsupported drive tray detected");
        map.put(new Integer(10281), "Controller redundancy lost");
        map.put(new Integer(10282), "Controller redundancy restored");
        map.put(new Integer(10283), "Drive tray path redundancy lost");
        map.put(new Integer(10284), "Drive tray path redundancy restored");
        map.put(new Integer(10285), "Drive path redundancy lost");
        map.put(new Integer(10286), "Drive path redundancy restored");
        map.put(new Integer(10287), "Incompatible version of IOM firmware detected");
        map.put(new Integer(10288), "Mixed drive types not supported");
        map.put(new Integer(10293), "Drive trays not cabled correctly");
        map.put(new Integer(10294), "Discrete lines diagnostic failure");
        map.put(new Integer(10295), "Discrete lines diagnostic failure cleared");
        map.put(new Integer(10296), "Interconnect CRU removed");
        map.put(new Integer(10297), "Interconnect CRU reinserted");
        map.put(new Integer(10298), "Power supply missing or removed");
        map.put(new Integer(10299), "Power supply failed");
        map.put(new Integer(10300), "Power supply needs attention");
        map.put(new Integer(10301), "Fan missing or removed");
        map.put(new Integer(10302), "Fan failed");
        map.put(new Integer(10303), "Fan needs attention");
        map.put(new Integer(12288), "Format unit issued");
        map.put(new Integer(12289), "Quiescence issued");
        map.put(new Integer(12290), "Reassign blocks issued from host");
        map.put(new Integer(12291), "Reserve issued");
        map.put(new Integer(12292), "Release issued");
        map.put(new Integer(12293), "Synchronize controller cache issued");
        map.put(new Integer(12294), "Safe pass-through issued");
        map.put(new Integer(12295), "Mode select for page 1 received");
        map.put(new Integer(12296), "Mode select for page 2 received");
        map.put(new Integer(12297), "Mode for caching page 8 received");
        map.put(new Integer(12298), "Mode select for control mode page A received");
        map.put(new Integer(12299), "Mode select for array physical page 2A received");
        map.put(new Integer(12300), "Mode select for array logical page 2B received");
        map.put(new Integer(12301), "Mode select for redundant controller page 2C received");
        map.put(new Integer(12302), "Mode select for vendor-unique cache page 2E received");
        map.put(new Integer(12303), "Mode select for time page 2F received");
        map.put(new Integer(12304), "Mode select for hot spare page 3A received");
        map.put(new Integer(12305), "Defect list received");
        map.put(new Integer(12306), "Write buffer received");
        map.put(new Integer(12307), "Download controller firmware issued");
        map.put(new Integer(12308), "Drive firmware download started");
        map.put(new Integer(12309), "Drive pass-through issued");
        map.put(new Integer(12310), "Alternate controller transition issued");
        map.put(new Integer(12311), "Set pass-through issued");
        map.put(new Integer(12312), "Set pass command issued");
        map.put(new Integer(12313), "Volume ownership changed due to failover");
        map.put(new Integer(12314), "Drive firmware download failed");
        map.put(new Integer(12315), "Drive firmware download completed");
        map.put(new Integer(12316), "IOM firmware download started");
        map.put(new Integer(12317), "IOM firmware download failed");
        map.put(new Integer(12318), "IOM firmware download completed");
        map.put(new Integer(12319), "Unable to register a volume due to insufficient resources");
        map.put(new Integer(12545), "AEN posted for recently logged event");
        map.put(new Integer(12546), "Deferred error (EEL)");
        map.put(new Integer(12800), "VKI common error");
        map.put(new Integer(12801), "VKI panic");
        map.put(new Integer(16384), "Sys wipe request sent to controller");
        map.put(new Integer(16385), "NVSRAM clear request sent to alternate controller");
        map.put(new Integer(16386), "Sys wipe request received by alternate controller");
        map.put(new Integer(16387), "NVSRAM clear request received by alternate controller");
        map.put(new Integer(16388), "Alternate controller quiescence message received");
        map.put(new Integer(16389), "Controller quiescence started");
        map.put(new Integer(16390), "Alternate controller quiescence started");
        map.put(new Integer(16391), "Subsystem quiescence started");
        map.put(new Integer(16392), "Controller quiescence halted");
        map.put(new Integer(16393), "Controller quiescence released");
        map.put(new Integer(16394), "Alternate controller quiescence released");
        map.put(new Integer(16395), "All channel reset detected");
        map.put(new Integer(16396), "Controller placed offline");
        map.put(new Integer(16397), "Controller placed online");
        map.put(new Integer(16398), "Automatic volume transfer started");
        map.put(new Integer(16399), "Controller reset by its alternate");
        map.put(new Integer(16400), "Controller reset");
        map.put(new Integer(16401), "Volume not on preferred path due to AVT/RDAC failover");
        map.put(new Integer(20480), "Assign virtual disk ownership");
        map.put(new Integer(20481), "Assign hot spare drive");
        map.put(new Integer(20482), "Create volume");
        map.put(new Integer(20483), "De-assign hot spare drive");
        map.put(new Integer(20484), "Delete volume");
        map.put(new Integer(20485), "Place controller offline");
        map.put(new Integer(20486), "Fail drive");
        map.put(new Integer(20487), "Initialize virtual disk or volume");
        map.put(new Integer(20488), "Initialize drive");
        map.put(new Integer(20489), "Controller firmware download started");
        map.put(new Integer(20490), "Download drive firmware issued");
        map.put(new Integer(20491), "Controller NVSRAM download started");
        map.put(new Integer(20492), "Place virtual disk offline");
        map.put(new Integer(20493), "Place virtual disk online");
        map.put(new Integer(20494), "Reconstruct drive/volume");
        map.put(new Integer(20495), "Start virtual disk defragment");
        map.put(new Integer(20496), "Add free capacity to virtual disk");
        map.put(new Integer(20497), "Change RAID level of virtual disk");
        map.put(new Integer(20498), "Change segment size of volume");
        map.put(new Integer(20499), "Change controller to passive mode");
        map.put(new Integer(20500), "Change controller to active mode");
        map.put(new Integer(20501), "Update cache parameters of storage array");
        map.put(new Integer(20502), "Change name of storage array");
        map.put(new Integer(20503), "Synchronize controller clock");
        map.put(new Integer(20504), "Change cache parameters of volume");
        map.put(new Integer(20505), "Change parameters of volume");
        map.put(new Integer(20506), "Change name of volume");
        map.put(new Integer(20507), "Place controller online");
        map.put(new Integer(20508), "Revive drive");
        map.put(new Integer(20509), "Revive volume");
        map.put(new Integer(20510), "Change positions of trays in physical view");
        map.put(new Integer(20511), "Change media scan (scrub) settings of volume");
        map.put(new Integer(20512), "Change media scan (scrub) settings of storage array");
        map.put(new Integer(20513), "Reset configuration of storage array");
        map.put(new Integer(20514), "Automatic configuration on storage array");
        map.put(new Integer(20515), "Controller return status/function call for requested operation");
        map.put(new Integer(20516), "Internal download checkpoint");
        map.put(new Integer(20517), "Controller firmware download failed");
        map.put(new Integer(20518), "Controller firmware download completed");
        map.put(new Integer(20519), "Controller NVSRAM download failed");
        map.put(new Integer(20520), "Controller NVSRAM download completed");
        map.put(new Integer(20521), "Reset controller battery age");
        map.put(new Integer(20522), "Assign volume ownership");
        map.put(new Integer(20523), "Increase volume capacity");
        map.put(new Integer(20524), "Change parameters of snapshot repository volume");
        map.put(new Integer(20525), "Re-create snapshot volume");
        map.put(new Integer(20526), "Disable snapshot volume");
        map.put(new Integer(20527), "Delete missing volume");
        map.put(new Integer(20528), "Activate remote volume mirroring");
        map.put(new Integer(20529), "Deactivate remote volume mirroring");
        map.put(new Integer(20530), "Change synchronization priority");
        map.put(new Integer(20531), "Start mirror synchronization");
        map.put(new Integer(20535), "Incorrect password attempted");
        map.put(new Integer(20536), "Storage array 10-minute lockout; maximum incorrect passwords attempted");
        map.put(new Integer(20537), "Change parameters of volume copy pair");
        map.put(new Integer(20538), "Start volume copy operation ");
        map.put(new Integer(20539), "Stop volume copy operation");
        map.put(new Integer(20540), "Change mirrored pair write mode ");
        map.put(new Integer(20541), "Suspend mirror relationship");
        map.put(new Integer(20542), "Resume mirror relationship");
        map.put(new Integer(20543), "Resynchronization set for automatic ");
        map.put(new Integer(20544), "Place controller in service mode");
        map.put(new Integer(20545), "Recover volume");
        map.put(new Integer(20546), "Mirror relationships for write consistency group suspended");
        map.put(new Integer(20547), "Mirror relationships for write consistency group resumed");
        map.put(new Integer(20548), "Change to single controller mode");
        map.put(new Integer(20549), "Activate controller firmware started");
        map.put(new Integer(20550), "Activate controller firmware completed");
        map.put(new Integer(20551), "Activate controller firmware failed");
        map.put(new Integer(20552), "Clear controller firmware started");
        map.put(new Integer(20553), "Clear controller firmware completed");
        map.put(new Integer(20560), "Clear controller firmware failed");
        map.put(new Integer(20992), "Create host group");
        map.put(new Integer(20993), "Delete host group");
        map.put(new Integer(20994), "Rename host group");
        map.put(new Integer(20995), "Create host");
        map.put(new Integer(20996), "Delete host");
        map.put(new Integer(20997), "Rename host");
        map.put(new Integer(20998), "Move host");
        map.put(new Integer(20999), "Create host port");
        map.put(new Integer(21000), "Delete host port");
        map.put(new Integer(21001), "Rename host port");
        map.put(new Integer(21002), "Move host port");
        map.put(new Integer(21003), "Set host port type");
        map.put(new Integer(21004), "Create storage array port group");
        map.put(new Integer(21005), "Delete storage array port group");
        map.put(new Integer(21006), "Move storage array port");
        map.put(new Integer(21007), "Create volume-to-LUN mapping");
        map.put(new Integer(21008), "Delete volume-to-LUN mapping");
        map.put(new Integer(21009), "Change volume-to-LUN mapping");
        map.put(new Integer(21010), "Error writing configuration");
        map.put(new Integer(21011), "Premium feature not supported - storage partitions deleted");
        map.put(new Integer(21504), "Premium feature enabled");
        map.put(new Integer(21505), "Premium feature disabled");
        map.put(new Integer(21506), "Premium feature out of compliance");
        map.put(new Integer(21507), "Premium feature exceeds limit");
        map.put(new Integer(21508), "Feature Enable Identifier changed");
        map.put(new Integer(22016), "Controller passed diagnostics");
        map.put(new Integer(22017), "This controller's alternate passed diagnostics");
        map.put(new Integer(22018), "This controller's alternate failed - timeout waiting for results");
        map.put(new Integer(22019), "Diagnostics rejected - already in progress");
        map.put(new Integer(22020), "Diagnostics rejected - this controller's alternate is absent or failed");
        map.put(new Integer(22021), "Diagnostics rejected - error occurred when sending the Icon message");
        map.put(new Integer(22022), "Diagnostics rejected - ctlrDiag task unable to queue DIAG_INIT_MSG message");
        map.put(new Integer(22023), "Diagnostics returned unknown ReturnCode");
        map.put(new Integer(22024), "Diagnostics rejected - test ID is incorrect");
        map.put(new Integer(22025), "Diagnostics unable to select a drive for I/O");
        map.put(new Integer(22026), "Diagnostics rejected - access volume (UTM) is not enabled");
        map.put(new Integer(22027), "Diagnostics rejected - ctlrDiag task unable to obtain Mode Select lock");
        map.put(new Integer(22028), "Diagnostics rejected - ctlrDiag task on this controller's alternate unable to obtain Mode Select lock");
        map.put(new Integer(22029), "Diagnostics read test failed on controller");
        map.put(new Integer(22030), "This controller's alternate failed diagnostics read test");
        map.put(new Integer(22031), "Diagnostics write test failed on controller");
        map.put(new Integer(22032), "This controller's alternate failed diagnostics write test");
        map.put(new Integer(22033), "Controller passed diagnostics, but loopback test identified error on loop(s)");
        map.put(new Integer(22034), "This controller's alternate passed diagnostics, but loopback test identified error on loop(s)");
        map.put(new Integer(22035), "Diagnostics loopback test identified bad destination channel(s)");
        map.put(new Integer(22036), "A host-side port (link) has been detected as down");
        map.put(new Integer(22037), "Not Used");
        map.put(new Integer(22038), "Diagnostics rejected - configuration error on controller");
        map.put(new Integer(22039), "Diagnostics rejected - configuration error on this controller's alternate");
        map.put(new Integer(22040), "Diagnostics rejected - no cache memory on controller");
        map.put(new Integer(22041), "Diagnostics rejected - no cache memory on this controller's alternate");
        map.put(new Integer(22042), "Diagnostics rejected - data transfer on controller is not disabled (quiesced)");
        map.put(new Integer(22043), "Diagnostics rejected - data transfer on this controller's alternate is not disabled (quiesced)");
        map.put(new Integer(22044), "Diagnostics rejected - both controllers must be in active mode");
        map.put(new Integer(22045), "Diagnostics initiated from this controller");
        map.put(new Integer(22046), "Running diagnostics on this controller");
        map.put(new Integer(22047), "Diagnostics rejected - download is in progress");
        map.put(new Integer(24576), "Internal configuration database created");
        map.put(new Integer(24577), "Internal configuration database merged");
        map.put(new Integer(24578), "Internal configuration database - mismatch of drives");
        map.put(new Integer(24579), "Internal configuration database - not enough optimal drives available");
        map.put(new Integer(24580), "Internal configuration database is being resynchronized");
        map.put(new Integer(24581), "Internal configuration database - read or write operation failed");
        map.put(new Integer(24582), "Internal configuration database - merge failed");
        map.put(new Integer(24832), "Internal configuration database cleared");
        map.put(new Integer(24833), "Internal configuration database full");
        map.put(new Integer(24834), "Internal configuration database size increased");
        map.put(new Integer(24835), "This controller's alternate was reset");
        map.put(new Integer(24836), "This controller's alternate was failed");
        map.put(new Integer(24837), "Internal configuration database - file system corrupted");
        map.put(new Integer(24838), "Internal configuration database - incorrect file system version");
        map.put(new Integer(24839), "This controller's alternate is non-functional and is being held in reset");
        map.put(new Integer(25088), "Snapshot repository volume capacity - threshold exceeded");
        map.put(new Integer(25089), "Snapshot repository volume capacity - full");
        map.put(new Integer(25090), "Snapshot volume failed");
        map.put(new Integer(25091), "Snapshot volume created");
        map.put(new Integer(25092), "Snapshot volume deleted");
        map.put(new Integer(25344), "Mirror repository volume created");
        map.put(new Integer(25345), "Mirror repository volume deleted");
        map.put(new Integer(25600), "Dual primary volume conflict");
        map.put(new Integer(25601), "Dual secondary volume conflict");
        map.put(new Integer(25602), "Data on mirrored pair unsynchronized");
        map.put(new Integer(25603), "Data on mirrored pair synchronizing");
        map.put(new Integer(25604), "Data on mirrored pair synchronized");
        map.put(new Integer(25605), "Associated volume in mirrored pair not present");
        map.put(new Integer(25606), "Remote volume mirror created");
        map.put(new Integer(25607), "Mirror relationship removed");
        map.put(new Integer(25608), "Mirror volume role change successful");
        map.put(new Integer(25609), "Mirror relationship suspended");
        map.put(new Integer(25610), "Mirrored pair unsynchronized - volume failures");
        map.put(new Integer(25611), "Mirror relationship suspended");
        map.put(new Integer(25612), "Mirror write mode set to synchronous");
        map.put(new Integer(25613), "Mirror write mode set to asynchronous");
        map.put(new Integer(25614), "Mirror write mode set to asynchronous, write-consistent");
        map.put(new Integer(25856), "Remote volume created");
        map.put(new Integer(25857), "Remote volume deleted");
        map.put(new Integer(25858), "Communication to remote volume - up");
        map.put(new Integer(25859), "Communication to remote volume - down");
        map.put(new Integer(25860), "Remote storage array's world-wide name changed");
        map.put(new Integer(25861), "Failed to communicate storage array's world-wide name");
        map.put(new Integer(26112), "Volume copy operation failed");
        map.put(new Integer(26113), "Volume copy pair established");
        map.put(new Integer(26114), "Volume copy pair removed");
        map.put(new Integer(26115), "Volume copy operation in progress");
        map.put(new Integer(26116), "Volume copy operation pending");
        map.put(new Integer(26117), "Volume copy operation stopped");
        map.put(new Integer(26118), "Volume copy operation completed");
        map.put(new Integer(26368), "Unreadable sector(s) detected - data loss occurred");
        map.put(new Integer(26369), "Unreadable sector repaired");
        map.put(new Integer(26370), "All unreadable sectors on the volume repaired - data not recovered");
        map.put(new Integer(26371), "Overflow in unreadable sector database");
        map.put(new Integer(26372), "Unreadable sectors found on volume");
        map.put(new Integer(26373), "Volume import failed - too many unreadable sectors");
        return map;
    }

    static {
        MB = 0x100000L;
        ALL_EVENTS = 0;
        CRITICAL_EVENTS = 1;
    }
}

