/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.diags;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.Properties;

public class DiagSetup {
    private ControllerRef primaryRef = null;
    private SYMbolAPIClientV1 primaryClient;
    private ControllerRef targetRef = null;
    private SYMbolAPIClientV1 targetClient;
    private String reason = "Target controller not found";
    private boolean runnable = false;

    DiagSetup(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2, Properties props) {
        this.initialize(client1, client2, props);
    }

    private void initialize(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2, Properties props) {
        block19: {
            String controller = props.getProperty("controller_choice");
            int target = -1;
            try {
                if (controller != null) {
                    if (controller.trim().equalsIgnoreCase("A")) {
                        target = 1;
                    } else if (controller.trim().equalsIgnoreCase("B")) {
                        target = 2;
                    } else {
                        this.setRunnable(false);
                        this.setStatusReason("Invalid controller id: " + controller);
                    }
                    ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client1);
                    Controller[] controllers = objectBundle.getController();
                    int x = 0;
                    while (x < controllers.length) {
                        int slot = controllers[x].getPhysicalLocation().getSlot();
                        if (slot == target) {
                            int y = (x + 1) % 2;
                            if (controllers[y].getActive()) {
                                this.targetRef = controllers[x].getControllerRef();
                                this.primaryRef = controllers[y].getControllerRef();
                                if (DiagUtility.bindToController(client2, this.primaryRef)) {
                                    this.primaryClient = client2;
                                } else if (DiagUtility.bindToController(client1, this.primaryRef)) {
                                    this.primaryClient = client1;
                                }
                                if (DiagUtility.bindToController(client2, this.targetRef)) {
                                    this.targetClient = client2;
                                } else if (DiagUtility.bindToController(client1, this.targetRef)) {
                                    this.targetClient = client1;
                                }
                                if (this.primaryClient == null || this.targetClient == null) {
                                    this.setRunnable(false);
                                    this.setStatusReason("Could not bind to one of the controllers");
                                } else {
                                    this.setRunnable(true);
                                }
                            } else {
                                this.setStatusReason("Primary controller not active");
                            }
                            break block19;
                        }
                        ++x;
                    }
                    break block19;
                }
                this.setRunnable(false);
                this.setStatusReason("Controller missing from parameters: " + controller);
            }
            catch (Exception e) {
                this.runnable = false;
                this.setStatusReason(e.toString());
            }
        }
    }

    ControllerRef getPrimaryRef() {
        return this.primaryRef;
    }

    SYMbolAPIClientV1 getPrimaryClient() {
        return this.primaryClient;
    }

    ControllerRef getTargetRef() {
        return this.targetRef;
    }

    SYMbolAPIClientV1 getTargetClient() {
        return this.targetClient;
    }

    void setStatusReason(String text) {
        this.reason = text + "\n";
    }

    String getStatusReason() {
        return this.reason;
    }

    void setRunnable(boolean temp) {
        this.runnable = temp;
    }

    boolean isRunnable() {
        return this.runnable;
    }
}

