/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.common;

import com.sun.netstorage.fm.storade.client.SAClient;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import devmgr.versioned.jrpc.RPCAuthGenerator;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.ChangeQueryDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SYMbolAuthGenerator;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.TrayRef;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class Utility {
    public static void setClientPassword(String password, SYMbolAPIClientV1 client) throws RPCError, IOException {
        ChangeQueryDescriptor chgQuery = new ChangeQueryDescriptor();
        chgQuery.getLastKnown().setConfigGeneration(-1L);
        chgQuery.getLastKnown().setLastCriticalMelSeqNumber(-1L);
        chgQuery.setMaxWait(0);
        client.setTimeout(new ProcedureTimeout().getProcTimeout(43));
        SYMbolAuthGenerator authGenerator = new SYMbolAuthGenerator(client.getLocalAddress(), client.getSAData().getSaId());
        client.setTimeout(new ProcedureTimeout().getProcTimeout(48));
        authGenerator.setConfigGeneration(client.getChangeState(chgQuery).getConfigGeneration());
        authGenerator.setPassword(password);
        client.setAuthGenerator((RPCAuthGenerator)authGenerator);
    }

    public static void showInfo(String info) {
        Date now = new Date();
        System.out.println(now.toString() + " *** " + info);
    }

    public static boolean rawCompare(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String wwnString(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            sbuf.append(Utility.toHex(data[i], 2));
            ++i;
        }
        return sbuf.toString().toUpperCase();
    }

    public static String hexString(byte[] data) {
        return Utility.bytesArrayString(data);
    }

    public static String refToString(ControllerRef ref) {
        StringBuffer sbuf = new StringBuffer();
        byte[] data = ref.getRefToken();
        int i = 0;
        while (i < data.length) {
            sbuf.append(Utility.toHex(data[i], 2));
            ++i;
        }
        return sbuf.toString();
    }

    public static String bytesArrayString(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            sbuf.append(Utility.toHex(data[i], 2));
            ++i;
        }
        return sbuf.toString();
    }

    public static String bytesToString(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (i > 0) {
                sbuf.append('.');
            }
            sbuf.append(Utility.toHex(data[i], 2));
            ++i;
        }
        return sbuf.toString();
    }

    public static String hexBytes(byte[] data) {
        return Utility.hexBytes(data, 0, data.length);
    }

    public static String hexBytes(byte[] data, int start, int end) {
        StringBuffer sbuf = new StringBuffer();
        int i = start;
        while (i < end) {
            if (i > start) {
                sbuf.append(' ');
            }
            sbuf.append(Utility.toHex(data[i], 2));
            ++i;
        }
        return sbuf.toString();
    }

    public static String bytesToDecimalString(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        int x = 0;
        while (x < data.length) {
            if (x > 0) {
                sbuf.append('.');
            }
            sbuf.append(Utility.toDecimal(data[x], 2));
            ++x;
        }
        return sbuf.toString();
    }

    private static String toDecimal(int value, int width) {
        StringBuffer buf = new StringBuffer();
        String rep = Integer.toString(value);
        while (buf.length() + rep.length() < width) {
            buf.append('0');
        }
        int i = rep.length() > width ? rep.length() - width : 0;
        while (buf.length() < width) {
            buf.append(rep.charAt(i++));
        }
        return buf.toString();
    }

    public static String userLabelString(UserAssignedLabel label) {
        String name = "unlabeled";
        byte[] labelArray = label.getValue();
        if (label != null) {
            try {
                name = new String(labelArray, 0, labelArray.length, "UTF-16");
            }
            catch (Exception e) {
                name = e.toString();
            }
            if (name.length() == 0) {
                name = "unlabeled";
            }
        }
        return name;
    }

    private static String toHex(int value, int width) {
        StringBuffer buf = new StringBuffer();
        String rep = Integer.toHexString(value);
        while (buf.length() + rep.length() < width) {
            buf.append('0');
        }
        int i = rep.length() > width ? rep.length() - width : 0;
        while (buf.length() < width) {
            buf.append(rep.charAt(i++));
        }
        return buf.toString();
    }

    public static Tray findTray(ObjectBundle bundle, TrayRef trayRef) {
        byte[] refValue = trayRef.getRefToken();
        Tray[] trays = bundle.getTray();
        int t = 0;
        while (t < trays.length) {
            if (Utility.rawCompare(trays[t].getTrayRef().getRefToken(), refValue)) {
                return trays[t];
            }
            ++t;
        }
        return null;
    }

    public static String convertDate(long input) {
        Date date = new Date(input * 1000L);
        return date.toString();
    }

    public static Date getDate(long input) {
        Date date = new Date(input * 1000L);
        return date;
    }

    public static String convertIpAddr(int ip) {
        int[] ipArray = new int[]{(ip & 0xFF000000) >> 24, (ip & 0xFF0000) >> 16, (ip & 0xFF00) >> 8, ip & 0xFF};
        StringBuffer buf = new StringBuffer();
        int x = 0;
        while (x < 4) {
            String hexval = Utility.toHex(ipArray[x], 2);
            buf.append(Integer.valueOf(hexval, 16).toString());
            if (x < 3) {
                buf.append(".");
            }
            ++x;
        }
        return buf.toString();
    }

    public static String convertBoolean(boolean input) {
        String rval = "false";
        if (input) {
            rval = "true";
        }
        return rval;
    }

    public static Properties getDeviceProperties(String deviceKey) {
        Properties devProps = null;
        try {
            SAClient sa = new SAClient();
            DeviceMaintenanceService dms = sa.getDeviceMaintenanceService();
            DeviceProperties dp = dms.getDeviceProperties(deviceKey);
            devProps = dp.getProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return devProps;
    }
}

