/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.common;

import devmgr.versioned.symbol.BatteryStatus;
import devmgr.versioned.symbol.BatteryType;
import devmgr.versioned.symbol.CacheFlushModifier;
import devmgr.versioned.symbol.Capability;
import devmgr.versioned.symbol.DriveType;
import devmgr.versioned.symbol.EventCategory;
import devmgr.versioned.symbol.EventPriority;
import devmgr.versioned.symbol.IOInterfaceType;
import devmgr.versioned.symbol.InterfaceSpeed;
import devmgr.versioned.symbol.NVSRAMRegionId;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.ReservationTypeID;
import devmgr.versioned.symbol.ReservedPortID;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.RuntimeDiagTestID;
import devmgr.versioned.symbol.RuntimeDiagTestLevel;
import devmgr.versioned.symbol.RuntimeDiagTestStatus;
import devmgr.versioned.symbol.SFP_CONNECT_TYPE;
import devmgr.versioned.symbol.SFP_IDENT_TYPE;
import devmgr.versioned.symbol.SFP_LINKL_TYPE;
import devmgr.versioned.symbol.SFP_SPEED;
import devmgr.versioned.symbol.SFP_TRANSMISSION_MEDIA;
import devmgr.versioned.symbol.SFP_TRANSMITTER_TYPE;
import devmgr.versioned.symbol.UsmRecordType;

public class Translator {
    public static final String SLOT_1_NAME = "A";
    public static final String SLOT_2_NAME = "B";

    public static String getSlotName(int slot) {
        String name = "" + slot;
        if (slot == 1) {
            name = SLOT_1_NAME;
        } else if (slot == 2) {
            name = SLOT_2_NAME;
        }
        return name;
    }

    public static String translateDriveStatusCause(int cause) {
        String result = "Unknown";
        switch (cause) {
            case 1: {
                result = "None";
                break;
            }
            case 5: {
                result = "Speed Mismatch";
                break;
            }
            case 4: {
                result = "Uncertified";
                break;
            }
            case 2: {
                result = "User Operation";
                break;
            }
            case 3: {
                result = "Write Operation";
                break;
            }
            case 6: {
                result = "Unknown";
            }
        }
        return result;
    }

    public static String translateTrayType(int type) {
        String result = "Unknown";
        switch (type) {
            case 5: {
                result = "GENERIC";
                break;
            }
            case 4: {
                result = "PCIRAID";
                break;
            }
            case 1: {
                result = "SYM1000";
                break;
            }
            case 7: {
                result = "SYM1200";
                break;
            }
            case 2: {
                result = "SYM2000";
                break;
            }
            case 6: {
                result = "SYM2200";
                break;
            }
            case 3: {
                result = "SYM2772";
                break;
            }
            case 8: {
                result = "SYM2882";
            }
        }
        return result;
    }

    public static String translateRaidLevel(RAIDLevel level) {
        return Translator.translateRaidLevel(level.getValue());
    }

    public static String translateRaidLevel(int level) {
        String result = "Unknown";
        switch (level) {
            case -1: {
                result = "Raid All";
                break;
            }
            case 0: {
                result = "raid0";
                break;
            }
            case 1: {
                result = "raid1";
                break;
            }
            case 3: {
                result = "raid3";
                break;
            }
            case 5: {
                result = "raid5";
            }
        }
        return result;
    }

    public static String translateOrientation(int value) {
        String result = "Unknown";
        switch (value) {
            case 1: {
                result = "horizontal";
                break;
            }
            case 2: {
                result = "vertical";
            }
        }
        return result;
    }

    public static String translateSpeed(InterfaceSpeed speed) {
        return Translator.translateSpeed(speed.getValue());
    }

    public static String translateSpeed(int speed) {
        String result = "Unknown";
        switch (speed) {
            case 5: {
                result = "10 Gb/sec";
                break;
            }
            case 2: {
                result = "1 Gb/sec";
                break;
            }
            case 3: {
                result = "2 Gb/sec";
                break;
            }
            case 4: {
                result = "4 Gb/sec";
            }
        }
        return result;
    }

    public static String translateESMStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 1: {
                rval = "Failed";
                break;
            }
            case 2: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateFanStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateSfpStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateBatteryStatus(BatteryStatus status) {
        String rval = "Unknown";
        int value = status.getValue();
        switch (value) {
            case 2: {
                rval = "Charging";
                break;
            }
            case 4: {
                rval = "Failed";
                break;
            }
            case 3: {
                rval = "Near Expiration";
                break;
            }
            case 7: {
                rval = "Not in Config";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 5: {
                rval = "Removed";
                break;
            }
            case 6: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateBatteryType(BatteryType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "Controller";
                break;
            }
            case 1: {
                rval = "Controller Tray";
            }
        }
        return rval;
    }

    public static String translatePowerSupplyStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateControllerStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
                break;
            }
            case 4: {
                rval = "RPA Parity Error";
                break;
            }
            case 5: {
                rval = "Service";
            }
        }
        return rval;
    }

    public static String translateDriveStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 4: {
                rval = "Bypassed";
                break;
            }
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 6: {
                rval = "Removed";
                break;
            }
            case 3: {
                rval = "Replaced";
                break;
            }
            case 5: {
                rval = "Unresponsive";
            }
        }
        return rval;
    }

    public static String translateDriveType(DriveType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "Fibre";
                break;
            }
            case 1: {
                rval = "SCSI";
                break;
            }
            case 3: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translatePhysicalDriveType(PhysicalDriveType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 0: {
                rval = "All";
                break;
            }
            case 2: {
                rval = "Fibre Channel";
                break;
            }
            case 4: {
                rval = "PATA";
                break;
            }
            case 3: {
                rval = "SATA";
                break;
            }
            case 1: {
                rval = "SCSI";
            }
        }
        return rval;
    }

    public static String translateTempStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 3: {
                rval = "OverMaxTemp";
                break;
            }
            case 2: {
                rval = "OverTemp";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 4: {
                rval = "Removed";
                break;
            }
            case 5: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateLinkStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Down";
                break;
            }
            case 1: {
                rval = "Up";
                break;
            }
            case 3: {
                rval = "Failed";
            }
        }
        return rval;
    }

    public static String translateSpeedControl(int status) {
        String rval = "Unknown";
        switch (status) {
            case 4: {
                rval = "Auto";
                break;
            }
            case 2: {
                rval = "Fixed";
                break;
            }
            case 3: {
                rval = "Switched";
                break;
            }
            case 1: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateTopologyType(int status) {
        String rval = "Unknown";
        switch (status) {
            case 3: {
                rval = "Arb Loop";
                break;
            }
            case 4: {
                rval = "FAB Loop";
                break;
            }
            case 2: {
                rval = "Fabric";
                break;
            }
            case 1: {
                rval = "PTP";
            }
        }
        return rval;
    }

    public static String translateRLSDeviceType(int type) {
        String rval = "Unknown";
        switch (type) {
            case 1: {
                rval = "Controller";
                break;
            }
            case 2: {
                rval = "Drive";
                break;
            }
            case 3: {
                rval = "ESM";
            }
        }
        return rval;
    }

    public static String translateVolumeStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Degraded";
                break;
            }
            case 3: {
                rval = "Failed";
                break;
            }
            case 4: {
                rval = "Impaired";
                break;
            }
            case 1: {
                rval = "Optimal";
            }
        }
        return rval;
    }

    public static String translateVolumeAction(int action) {
        String rval = "Unknown";
        switch (action) {
            case 2: {
                rval = "Copyback";
                break;
            }
            case 13: {
                rval = "Formatting";
                break;
            }
            case 3: {
                rval = "Initializing";
                break;
            }
            case 1: {
                rval = "None";
                break;
            }
            case 4: {
                rval = "Reconstructing";
                break;
            }
            case 5: {
                rval = "Remapping DCE";
                break;
            }
            case 7: {
                rval = "Remapping DCEDRM";
                break;
            }
            case 10: {
                rval = "Remapping DCEDVE";
                break;
            }
            case 12: {
                rval = "Remapping Defrag";
                break;
            }
            case 6: {
                rval = "Remapping DRM";
                break;
            }
            case 8: {
                rval = "Remapping DSEG";
                break;
            }
            case 9: {
                rval = "Remapping DVE";
                break;
            }
            case 11: {
                rval = "Remapping Internal";
                break;
            }
            case 14: {
                rval = "Synchronizing";
            }
        }
        return rval;
    }

    public static String translateCacheFlushModifier(CacheFlushModifier modifier) {
        String rval = "Unknown";
        switch (modifier.getValue()) {
            case 4: {
                rval = "1";
                break;
            }
            case 8: {
                rval = "10";
                break;
            }
            case 11: {
                rval = "20";
                break;
            }
            case 13: {
                rval = "1200";
                break;
            }
            case 5: {
                rval = "1.5";
                break;
            }
            case 6: {
                rval = "2";
                break;
            }
            case 9: {
                rval = "20";
                break;
            }
            case 1: {
                rval = ".25";
                break;
            }
            case 12: {
                rval = "300";
                break;
            }
            case 14: {
                rval = "3600";
                break;
            }
            case 7: {
                rval = "5";
                break;
            }
            case 2: {
                rval = ".5";
                break;
            }
            case 10: {
                rval = "60";
                break;
            }
            case 3: {
                rval = ".75";
                break;
            }
            case 0: {
                rval = "Immediate";
                break;
            }
            case 15: {
                rval = "Infinite";
            }
        }
        return rval;
    }

    public static String translateSfpIdentType(SFP_IDENT_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 1: {
                rval = "GBIC";
                break;
            }
            case 3: {
                rval = "SFP";
                break;
            }
            case 2: {
                rval = "Soldered";
            }
        }
        return rval;
    }

    public static String translateSfpConnectType(SFP_CONNECT_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 4: {
                rval = "BNCorTNC";
                break;
            }
            case 13: {
                rval = "COP_PIGTAIL";
                break;
            }
            case 6: {
                rval = "F_JACK";
                break;
            }
            case 5: {
                rval = "FC_COAX";
                break;
            }
            case 2: {
                rval = "FCS1CC";
                break;
            }
            case 3: {
                rval = "FCS2CC";
                break;
            }
            case 12: {
                rval = "HSSDCII";
                break;
            }
            case 7: {
                rval = "LC";
                break;
            }
            case 8: {
                rval = "MT_RJ";
                break;
            }
            case 9: {
                rval = "MU";
                break;
            }
            case 11: {
                rval = "OPT_PIGTAIL";
                break;
            }
            case 1: {
                rval = "SC";
                break;
            }
            case 10: {
                rval = "SG";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateEsmIFType(IOInterfaceType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "Fibre Channel";
                break;
            }
            case 1: {
                rval = "SCSI";
            }
        }
        return rval;
    }

    public static String translateSfpLinkType(SFP_LINKL_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "Intermediate";
                break;
            }
            case 4: {
                rval = "Long";
                break;
            }
            case 2: {
                rval = "Short";
                break;
            }
            case 1: {
                rval = "Very long";
            }
        }
        return rval;
    }

    public static String translateSfpSpeed(SFP_SPEED type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 1: {
                rval = "1 Gb/sec";
                break;
            }
            case 2: {
                rval = "2 Gb/sec";
                break;
            }
            case 4: {
                rval = "4 Gb/sec";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateSfpXmitMedia(SFP_TRANSMISSION_MEDIA media) {
        String rval = "unknown";
        switch (media.getValue()) {
            case 4: {
                rval = "Miniature Coax";
                break;
            }
            case 32: {
                rval = "Multi Mode M5 (50m)";
                break;
            }
            case 16: {
                rval = "Multi Mode M6 (62.5m)";
                break;
            }
            case 2: {
                rval = "Shielded Twisted Pair";
                break;
            }
            case 64: {
                rval = "Single Mode";
                break;
            }
            case 8: {
                rval = "Video Coax";
                break;
            }
            case 1: {
                rval = "Twin Axial Pair";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateSfpXmitType(SFP_TRANSMITTER_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "Electrical Intra-Enclosure";
                break;
            }
            case 2: {
                rval = "Electrical Inter-Enclosure";
                break;
            }
            case 1: {
                rval = "Long Wave Laser";
                break;
            }
            case 6: {
                rval = "Long Wave Laser";
                break;
            }
            case 5: {
                rval = "Short Wave Laser with OFC";
                break;
            }
            case 4: {
                rval = "Short Wave Laser without OFC";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateTestStatus(RuntimeDiagTestStatus status) {
        String rval = "Unknown";
        switch (status.getValue()) {
            case 1: {
                rval = "Fail";
                break;
            }
            case -1: {
                rval = "None";
                break;
            }
            case 0: {
                rval = "Pass";
            }
        }
        return rval;
    }

    public static String translateTestID(RuntimeDiagTestID id) {
        String rval = "Unknown";
        switch (id.getValue()) {
            case 0: {
                rval = "All";
                break;
            }
            case 2: {
                rval = "Loopback";
                break;
            }
            case 1: {
                rval = "Read";
                break;
            }
            case 3: {
                rval = "Write";
            }
        }
        return rval;
    }

    public static String translateTestLevel(RuntimeDiagTestLevel level) {
        String rval = "Unknown";
        switch (level.getValue()) {
            case 1: {
                rval = "External";
                break;
            }
            case 0: {
                rval = "Internal";
            }
        }
        return rval;
    }

    public static String translateRegionID(NVSRAMRegionId id) {
        String rval = "Unknown";
        switch (id.getValue()) {
            case -1: {
                rval = "REGION_ALL_REGIONS";
                break;
            }
            case 240: {
                rval = "REGION_BOOTP_DATA";
                break;
            }
            case 234: {
                rval = "REGION_DRIVE_FAULT_DATA";
                break;
            }
            case 241: {
                rval = "REGION_EXT_USER_CONFIG_DATA";
                break;
            }
            case 237: {
                rval = "REGION_HOST_INTERFACE_DATA";
                break;
            }
            case 236: {
                rval = "REGION_HOST_MANAGED_DATA";
                break;
            }
            case 242: {
                rval = "REGION_HOST_TYPE_DEPENDENT_DATA";
                break;
            }
            case 233: {
                rval = "REGION_SUBSYSTEM_FAULT_DATA";
                break;
            }
            case 232: {
                rval = "REGION_SUBSYSTEM_ID";
                break;
            }
            case 238: {
                rval = "REGION_USER_CONFIG_DATA";
            }
        }
        return rval;
    }

    public static String translateUsmRecordType(UsmRecordType type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "USM_RECORD_TYPE_INJECTED";
                break;
            }
            case 2: {
                rval = "USM_RECORD_TYPE_LOGICAL";
                break;
            }
            case 1: {
                rval = "USM_RECORD_TYPE_PHYSICAL";
            }
        }
        return rval;
    }

    public static String translateEventCategory(EventCategory type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "EVENT_CATEGORY_COMMAND";
                break;
            }
            case 1: {
                rval = "EVENT_CATEGORY_ERROR";
                break;
            }
            case 2: {
                rval = "EVENT_CATEGORY_FAILURE";
                break;
            }
            case 7: {
                rval = "EVENT_CATEGORY_GENERAL";
                break;
            }
            case 6: {
                rval = "EVENT_CATEGORY_HOST_ENTRY";
                break;
            }
            case 4: {
                rval = "EVENT_CATEGORY_NOTIFICATION";
                break;
            }
            case 5: {
                rval = "EVENT_CATEGORY_STATE_CHANGE";
            }
        }
        return rval;
    }

    public static String niceEventCategory(EventCategory type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "Command";
                break;
            }
            case 1: {
                rval = "Error";
                break;
            }
            case 2: {
                rval = "Failure";
                break;
            }
            case 7: {
                rval = "General";
                break;
            }
            case 6: {
                rval = "Host Entry";
                break;
            }
            case 4: {
                rval = "Notification";
                break;
            }
            case 5: {
                rval = "State Change";
            }
        }
        return rval;
    }

    public static String translateEventPriority(EventPriority type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 0: {
                rval = "Critical";
                break;
            }
            case 1: {
                rval = "Informational";
            }
        }
        return rval;
    }

    public static String translateReservationTypeID(ReservationTypeID type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "RES_TYPE_EXCL_ACCESS";
                break;
            }
            case 6: {
                rval = "RES_TYPE_EXCL_ACCESS_ALL_REG";
                break;
            }
            case 4: {
                rval = "RES_TYPE_EXCL_ACCESS_REG_ONLY";
                break;
            }
            case 0: {
                rval = "RES_TYPE_NO_RESERVATION";
                break;
            }
            case 1: {
                rval = "RES_TYPE_WRITE_EXCL";
                break;
            }
            case 5: {
                rval = "RES_TYPE_WRITE_EXCL_ALL_REG";
                break;
            }
            case 3: {
                rval = "RES_TYPE_WRITE_EXCL_REG_ONLY";
            }
        }
        return rval;
    }

    public static String translateReservedPortID(ReservedPortID type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 0: {
                rval = "RES_PORT_A0";
                break;
            }
            case 1: {
                rval = "RES_PORT_A1";
                break;
            }
            case 2: {
                rval = "RES_PORT_B0";
                break;
            }
            case 3: {
                rval = "RES_PORT_B1";
                break;
            }
            case -1: {
                rval = "RES_PORT_ALL";
                break;
            }
            case -2: {
                rval = "RES_PORT_NONE";
            }
        }
        return rval;
    }

    public static String translateCapability(Capability capability) {
        String rval = "unknown";
        switch (capability.getValue()) {
            case 4: {
                rval = "CAPABILITY_AUTO_CODE_SYNC";
                break;
            }
            case 5: {
                rval = "CAPABILITY_AUTO_LUN_TRANSFER";
                break;
            }
            case 3: {
                rval = "CAPABILITY_MIXED_RAIDLEVEL";
                break;
            }
            case 13: {
                rval = "CAPABILITY_REMOTE_MIRRORING";
                break;
            }
            case 1: {
                rval = "CAPABILITY_SHARED_VOLUME";
                break;
            }
            case 12: {
                rval = "CAPABILITY_SNAPSHOTS";
                break;
            }
            case 15: {
                rval = "CAPABILITY_STAGED_DOWNLOAD";
                break;
            }
            case 11: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_16";
                break;
            }
            case 8: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_2";
                break;
            }
            case 2: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_4";
                break;
            }
            case 10: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_64";
                break;
            }
            case 7: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_8";
                break;
            }
            case 9: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_MAX";
                break;
            }
            case 6: {
                rval = "CAPABILITY_SUB_LUNS_ALLOWED";
                break;
            }
            case 14: {
                rval = "CAPABILITY_VOLUME_COPY";
            }
        }
        return rval;
    }

    public static String translateReturnCode(ReturnCode rcode) {
        return Translator.translateReturnCode(rcode.getValue());
    }

    public static String translateReturnCode(int status) {
        String rval = "Unknown";
        switch (status) {
            case 273: {
                rval = "MAX_RETCODE";
                break;
            }
            case 22: {
                rval = "RETCODE_ALT_REMOVED";
                break;
            }
            case 103: {
                rval = "RETCODE_ATTEMPT_TO_SET_LOCAL";
                break;
            }
            case 218: {
                rval = "RETCODE_AUTH_FAIL_CONT_LOCKOUT";
                break;
            }
            case 29: {
                rval = "RETCODE_AUTH_FAIL_PARAM";
                break;
            }
            case 30: {
                rval = "RETCODE_AUTH_FAIL_PASSWORD";
                break;
            }
            case 101: {
                rval = "RETCODE_AUTH_FAIL_READPASSWORD";
                break;
            }
            case 14: {
                rval = "RETCODE_BACKGROUND";
                break;
            }
            case 150: {
                rval = "RETCODE_BASE_VOLUME_FAILED";
                break;
            }
            case 152: {
                rval = "RETCODE_BASE_VOLUME_FORMATTING";
                break;
            }
            case 151: {
                rval = "RETCODE_BASE_VOLUME_OFFLINE";
                break;
            }
            case 222: {
                rval = "RETCODE_BATTERY_MISSING";
                break;
            }
            case 221: {
                rval = "RETCODE_BATTERY_NOT_IN_CONFIG";
                break;
            }
            case 3: {
                rval = "RETCODE_BUSY";
                break;
            }
            case 23: {
                rval = "RETCODE_CACHE_SYNC_FAILURE";
                break;
            }
            case 76: {
                rval = "RETCODE_CACHECONFIG_ERROR";
                break;
            }
            case 146: {
                rval = "RETCODE_CANNOT_FORMAT_VOLUME";
                break;
            }
            case 145: {
                rval = "RETCODE_CANNOT_MAP_VOLUME";
                break;
            }
            case 217: {
                rval = "RETCODE_CANNOT_RECONFIGURE";
                break;
            }
            case 84: {
                rval = "RETCODE_CAPACITY_CONSTRAINED";
                break;
            }
            case 194: {
                rval = "RETCODE_COPY_ACTIVE";
                break;
            }
            case 193: {
                rval = "RETCODE_COPY_CHANGE_FAILED";
                break;
            }
            case 198: {
                rval = "RETCODE_COPY_GHOST_SOURCE";
                break;
            }
            case 199: {
                rval = "RETCODE_COPY_GHOST_TARGET";
                break;
            }
            case 195: {
                rval = "RETCODE_COPY_INACTIVE";
                break;
            }
            case 196: {
                rval = "RETCODE_COPY_INCOMPATIBLE_SOURCE";
                break;
            }
            case 197: {
                rval = "RETCODE_COPY_INCOMPATIBLE_TARGET";
                break;
            }
            case 200: {
                rval = "RETCODE_COPY_INVALID_SOURCE_REF";
                break;
            }
            case 202: {
                rval = "RETCODE_COPY_INVALID_SOURCE_STATE";
                break;
            }
            case 201: {
                rval = "RETCODE_COPY_INVALID_TARGET_REF";
                break;
            }
            case 203: {
                rval = "RETCODE_COPY_INVALID_TARGET_STATE";
                break;
            }
            case 211: {
                rval = "RETCODE_COPY_SOURCE_FORMAT";
                break;
            }
            case 204: {
                rval = "RETCODE_COPY_SOURCE_RECONFIG";
                break;
            }
            case 209: {
                rval = "RETCODE_COPY_SOURCE_RESERVATION";
                break;
            }
            case 226: {
                rval = "RETCODE_COPY_SOURCE_ZERO_CAPACITY";
                break;
            }
            case 213: {
                rval = "RETCODE_COPY_START_FAILED";
                break;
            }
            case 214: {
                rval = "RETCODE_COPY_STOP_FAILED";
                break;
            }
            case 212: {
                rval = "RETCODE_COPY_TARGET_FORMAT";
                break;
            }
            case 207: {
                rval = "RETCODE_COPY_TARGET_LIMIT";
                break;
            }
            case 205: {
                rval = "RETCODE_COPY_TARGET_RECONFIG";
                break;
            }
            case 210: {
                rval = "RETCODE_COPY_TARGET_RESERVATION";
                break;
            }
            case 206: {
                rval = "RETCODE_COPY_TARGET_TOO_SMALL";
                break;
            }
            case 225: {
                rval = "RETCODE_DATA_REDUNDANCY_REQUIRED";
                break;
            }
            case 190: {
                rval = "RETCODE_DEFAULT_UTM_COLLISION";
                break;
            }
            case 122: {
                rval = "RETCODE_DIAG_CONFIG_ERR";
                break;
            }
            case 120: {
                rval = "RETCODE_DIAG_DRIVE_ERR";
                break;
            }
            case 116: {
                rval = "RETCODE_DIAG_ICON_SEND_ERR";
                break;
            }
            case 114: {
                rval = "RETCODE_DIAG_IN_PROGRESS";
                break;
            }
            case 117: {
                rval = "RETCODE_DIAG_INIT_ERR";
                break;
            }
            case 119: {
                rval = "RETCODE_DIAG_INVALID_TEST_ID";
                break;
            }
            case 121: {
                rval = "RETCODE_DIAG_LOCK_ERR";
                break;
            }
            case 112: {
                rval = "RETCODE_DIAG_LOOPBACK_ERROR";
                break;
            }
            case 118: {
                rval = "RETCODE_DIAG_MODE_ERR";
                break;
            }
            case 115: {
                rval = "RETCODE_DIAG_NO_ALT";
                break;
            }
            case 123: {
                rval = "RETCODE_DIAG_NO_CACHE_MEM";
                break;
            }
            case 124: {
                rval = "RETCODE_DIAG_NOT_QUIESCED";
                break;
            }
            case 109: {
                rval = "RETCODE_DIAG_READ_FAILURE";
                break;
            }
            case 110: {
                rval = "RETCODE_DIAG_SRC_LINK_DOWN";
                break;
            }
            case 113: {
                rval = "RETCODE_DIAG_TIMEOUT";
                break;
            }
            case 125: {
                rval = "RETCODE_DIAG_UTM_NOT_ENABLED";
                break;
            }
            case 111: {
                rval = "RETCODE_DIAG_WRITE_FAILURE";
                break;
            }
            case 77: {
                rval = "RETCODE_DOWNLOAD_IN_PROGRESS";
                break;
            }
            case 72: {
                rval = "RETCODE_DOWNLOAD_NOT_PERMITTED";
                break;
            }
            case 96: {
                rval = "RETCODE_DRIVE_DOWNLOAD_FAILED";
                break;
            }
            case 6: {
                rval = "RETCODE_DRIVE_NOT_EXIST";
                break;
            }
            case 78: {
                rval = "RETCODE_DRIVE_NOT_OPTIMAL";
                break;
            }
            case 7: {
                rval = "RETCODE_DRIVE_NOT_UNASSIGNED";
                break;
            }
            case 79: {
                rval = "RETCODE_DRIVE_REMOVED";
                break;
            }
            case 83: {
                rval = "RETCODE_DRIVE_TOO_SMALL";
                break;
            }
            case 147: {
                rval = "RETCODE_DST_NOT_FIBRE";
                break;
            }
            case 80: {
                rval = "RETCODE_DUPLICATE_DRIVES";
                break;
            }
            case 128: {
                rval = "RETCODE_DUPLICATE_VOL_MAPPING";
                break;
            }
            case 2: {
                rval = "RETCODE_ERROR";
                break;
            }
            case 97: {
                rval = "RETCODE_ESM_DOWNLOAD_FAILED";
                break;
            }
            case 98: {
                rval = "RETCODE_ESM_PARTIAL_UPDATE";
                break;
            }
            case 105: {
                rval = "RETCODE_FAIL_VOLUME_VISIBLE";
                break;
            }
            case 67: {
                rval = "RETCODE_FILE_TOO_LARGE";
                break;
            }
            case 28: {
                rval = "RETCODE_FLASH_ERROR";
                break;
            }
            case 139: {
                rval = "RETCODE_GHOST_VOLUME";
                break;
            }
            case 20: {
                rval = "RETCODE_ICON_FAILURE";
                break;
            }
            case 4: {
                rval = "RETCODE_ILLEGAL_PARAM";
                break;
            }
            case 66: {
                rval = "RETCODE_IMAGE_TRANSFERRED";
                break;
            }
            case 18: {
                rval = "RETCODE_INTERNAL_ERROR";
                break;
            }
            case 229: {
                rval = "RETCODE_INV_HOSTLUN_DEFINE_HOSTTYPE";
                break;
            }
            case 227: {
                rval = "RETCODE_INV_HOSTLUN_DEFINE_MAPPING";
                break;
            }
            case 228: {
                rval = "RETCODE_INV_HOSTLUN_MOVE_MAPPING";
                break;
            }
            case 131: {
                rval = "RETCODE_INVALID_BASEVOL";
                break;
            }
            case 45: {
                rval = "RETCODE_INVALID_CACHE_MODIFIER";
                break;
            }
            case 41: {
                rval = "RETCODE_INVALID_CACHEBLKSIZE";
                break;
            }
            case 70: {
                rval = "RETCODE_INVALID_CHUNKSIZE";
                break;
            }
            case 32: {
                rval = "RETCODE_INVALID_CONTROLLERREF";
                break;
            }
            case 191: {
                rval = "RETCODE_INVALID_COPY_PRIORITY";
                break;
            }
            case 75: {
                rval = "RETCODE_INVALID_DLSTATE";
                break;
            }
            case 35: {
                rval = "RETCODE_INVALID_DRIVEREF";
                break;
            }
            case 52: {
                rval = "RETCODE_INVALID_ENCRYPTION";
                break;
            }
            case 54: {
                rval = "RETCODE_INVALID_EXPANSION_LIST";
                break;
            }
            case 51: {
                rval = "RETCODE_INVALID_FIBREID";
                break;
            }
            case 24: {
                rval = "RETCODE_INVALID_FILE";
                break;
            }
            case 43: {
                rval = "RETCODE_INVALID_FLUSH_AMOUNT";
                break;
            }
            case 42: {
                rval = "RETCODE_INVALID_FLUSH_THRESHOLD";
                break;
            }
            case 36: {
                rval = "RETCODE_INVALID_FREEEXTENTREF";
                break;
            }
            case 104: {
                rval = "RETCODE_INVALID_HOST_TYPE_INDEX";
                break;
            }
            case 44: {
                rval = "RETCODE_INVALID_LABEL";
                break;
            }
            case 107: {
                rval = "RETCODE_INVALID_LUN";
                break;
            }
            case 158: {
                rval = "RETCODE_INVALID_MIRROR_CANDIDATE_VOL";
                break;
            }
            case 159: {
                rval = "RETCODE_INVALID_MIRRORVOL";
                break;
            }
            case 126: {
                rval = "RETCODE_INVALID_MODE_SWITCH";
                break;
            }
            case 68: {
                rval = "RETCODE_INVALID_OFFSET";
                break;
            }
            case 127: {
                rval = "RETCODE_INVALID_PORTNAME";
                break;
            }
            case 53: {
                rval = "RETCODE_INVALID_RAIDLEVEL";
                break;
            }
            case 46: {
                rval = "RETCODE_INVALID_READAHEAD";
                break;
            }
            case 47: {
                rval = "RETCODE_INVALID_RECONPRIORITY";
                break;
            }
            case 50: {
                rval = "RETCODE_INVALID_REGIONID";
                break;
            }
            case 141: {
                rval = "RETCODE_INVALID_REPOSITORY_LABEL";
                break;
            }
            case 19: {
                rval = "RETCODE_INVALID_REQUEST";
                break;
            }
            case 143: {
                rval = "RETCODE_INVALID_ROLLBACK_PRIORITY";
                break;
            }
            case 93: {
                rval = "RETCODE_INVALID_SAFE_CAPABILITY";
                break;
            }
            case 91: {
                rval = "RETCODE_INVALID_SAFE_ID";
                break;
            }
            case 92: {
                rval = "RETCODE_INVALID_SAFE_KEY";
                break;
            }
            case 94: {
                rval = "RETCODE_INVALID_SAFE_VERSION";
                break;
            }
            case 48: {
                rval = "RETCODE_INVALID_SCANPERIOD";
                break;
            }
            case 40: {
                rval = "RETCODE_INVALID_SEGMENTSIZE";
                break;
            }
            case 142: {
                rval = "RETCODE_INVALID_SNAP_LABEL";
                break;
            }
            case 71: {
                rval = "RETCODE_INVALID_TOTALSIZE";
                break;
            }
            case 49: {
                rval = "RETCODE_INVALID_TRAYPOS_LENGTH";
                break;
            }
            case 188: {
                rval = "RETCODE_INVALID_TRAYREF";
                break;
            }
            case 192: {
                rval = "RETCODE_INVALID_VOLUMECOPYREF";
                break;
            }
            case 33: {
                rval = "RETCODE_INVALID_VOLUMEGROUPREF";
                break;
            }
            case 34: {
                rval = "RETCODE_INVALID_VOLUMEREF";
                break;
            }
            case 144: {
                rval = "RETCODE_INVALID_WARN_THRESHOLD";
                break;
            }
            case 164: {
                rval = "RETCODE_LOCAL_ROLE_CHANGE_FAILED";
                break;
            }
            case 166: {
                rval = "RETCODE_LOCAL_ROLE_CHANGE_SUCCESSFUL";
                break;
            }
            case 174: {
                rval = "RETCODE_LOCAL_ROLE_CHANGED_NOT_FORCED";
                break;
            }
            case 157: {
                rval = "RETCODE_MAX_MIRRORS_EXCEEDED";
                break;
            }
            case 130: {
                rval = "RETCODE_MAX_SNAPS_EXCEEDED";
                break;
            }
            case 129: {
                rval = "RETCODE_MAX_SNAPS_PER_BASE_EXCEEDED";
                break;
            }
            case 63: {
                rval = "RETCODE_MAX_VOL_MAPPING_EXCEEDED";
                break;
            }
            case 208: {
                rval = "RETCODE_MAX_VOLUME_COPYS_EXCEEDED";
                break;
            }
            case 85: {
                rval = "RETCODE_MAX_VOLUMES_EXCEEDED";
                break;
            }
            case 31: {
                rval = "RETCODE_MEM_PARITY_ERROR";
                break;
            }
            case 160: {
                rval = "RETCODE_METADATA_ALREADY_EXISTS";
                break;
            }
            case 185: {
                rval = "RETCODE_METADATA_CHILD_DELETION";
                break;
            }
            case 161: {
                rval = "RETCODE_METADATA_MISSING";
                break;
            }
            case 162: {
                rval = "RETCODE_METADATA_OFFLINE";
                break;
            }
            case 163: {
                rval = "RETCODE_METADATA_RECONFIGURING";
                break;
            }
            case 153: {
                rval = "RETCODE_METADATA_VOL_NONEXISTENT";
                break;
            }
            case 182: {
                rval = "RETCODE_MIRROR_VOL_NOT_PRIMARY";
                break;
            }
            case 155: {
                rval = "RETCODE_MIRRORS_PRESENT";
                break;
            }
            case 39: {
                rval = "RETCODE_MODESENSE_ERROR";
                break;
            }
            case 223: {
                rval = "RETCODE_NO_CHANNEL";
                break;
            }
            case 106: {
                rval = "RETCODE_NO_DELETE_UTM_IN_USE";
                break;
            }
            case 5: {
                rval = "RETCODE_NO_HEAP";
                break;
            }
            case 8: {
                rval = "RETCODE_NO_SPARES_ASSIGNED";
                break;
            }
            case 55: {
                rval = "RETCODE_NO_SPARES_DEASSIGNED";
                break;
            }
            case 168: {
                rval = "RETCODE_NO_VALID_MIRROR_CANDIDATE";
                break;
            }
            case 100: {
                rval = "RETCODE_NO_VOLUMES";
                break;
            }
            case 133: {
                rval = "RETCODE_NOT_DISABLED";
                break;
            }
            case 12: {
                rval = "RETCODE_NOT_DUAL_ACTIVE";
                break;
            }
            case 15: {
                rval = "RETCODE_NOT_IMPLEMENTED";
                break;
            }
            case 172: {
                rval = "RETCODE_NOT_REGISTERED";
                break;
            }
            case 138: {
                rval = "RETCODE_NUM_VOLUMES_GROUP";
                break;
            }
            case 81: {
                rval = "RETCODE_NUMDRIVES_ADDITIONAL";
                break;
            }
            case 82: {
                rval = "RETCODE_NUMDRIVES_GROUP";
                break;
            }
            case 27: {
                rval = "RETCODE_NVRAM_ERROR";
                break;
            }
            case 1: {
                rval = "RETCODE_OK";
                break;
            }
            case 167: {
                rval = "RETCODE_ONLY_LOCAL_MIRROR_DELETED";
                break;
            }
            case 69: {
                rval = "RETCODE_OVERRUN";
                break;
            }
            case 90: {
                rval = "RETCODE_PARITY_SCAN_IN_PROGRESS";
                break;
            }
            case 102: {
                rval = "RETCODE_PART_CRTE_FAIL_TBL_FULL";
                break;
            }
            case 57: {
                rval = "RETCODE_PART_DUP_ID";
                break;
            }
            case 86: {
                rval = "RETCODE_PART_IS_UTM_LUN";
                break;
            }
            case 58: {
                rval = "RETCODE_PART_LABEL_INVALID";
                break;
            }
            case 62: {
                rval = "RETCODE_PART_LUN_COLLISION";
                break;
            }
            case 64: {
                rval = "RETCODE_PART_MAPPING_NONEXISTENT";
                break;
            }
            case 65: {
                rval = "RETCODE_PART_NO_HOSTPORTS";
                break;
            }
            case 59: {
                rval = "RETCODE_PART_NODE_NONEXISTENT";
                break;
            }
            case 60: {
                rval = "RETCODE_PART_PORT_ID_INVALID";
                break;
            }
            case 61: {
                rval = "RETCODE_PART_VOLUME_NONEXISTENT";
                break;
            }
            case 189: {
                rval = "RETCODE_PARTIAL_DELETION";
                break;
            }
            case 95: {
                rval = "RETCODE_PARTITIONS_DISABLED";
                break;
            }
            case 219: {
                rval = "RETCODE_PR_RESERVATION_CONFLICT";
                break;
            }
            case 184: {
                rval = "RETCODE_PRI_NOT_DEMOTEABLE";
                break;
            }
            case 26: {
                rval = "RETCODE_RECONFIG_FAILURE";
                break;
            }
            case 25: {
                rval = "RETCODE_RECONFIG_SMALL_DACSTORE";
                break;
            }
            case 220: {
                rval = "RETCODE_REG_DELETE_FAILED";
                break;
            }
            case 177: {
                rval = "RETCODE_REMOTE_AUTH_FAIL_PASSWORD";
                break;
            }
            case 173: {
                rval = "RETCODE_REMOTE_INVALID_CFG_GEN";
                break;
            }
            case 169: {
                rval = "RETCODE_REMOTE_MAX_MIRRORS_EXCEEDED";
                break;
            }
            case 171: {
                rval = "RETCODE_REMOTE_METADATA_VOL_NONEXISTENT";
                break;
            }
            case 165: {
                rval = "RETCODE_REMOTE_ROLE_CHANGE_FAILED";
                break;
            }
            case 175: {
                rval = "RETCODE_REMOTE_ROLE_CHANGED_LOCAL_FAILED";
                break;
            }
            case 170: {
                rval = "RETCODE_REMOTE_RVM_FEATURE_DISABLED";
                break;
            }
            case 149: {
                rval = "RETCODE_REPOSITORY_FAILED";
                break;
            }
            case 140: {
                rval = "RETCODE_REPOSITORY_MISSING";
                break;
            }
            case 135: {
                rval = "RETCODE_REPOSITORY_OFFLINE";
                break;
            }
            case 136: {
                rval = "RETCODE_REPOSITORY_RECONFIGURING";
                break;
            }
            case 148: {
                rval = "RETCODE_REPOSITORY_TOO_SMALL";
                break;
            }
            case 16: {
                rval = "RETCODE_RESERVATION_CONFLICT";
                break;
            }
            case 186: {
                rval = "RETCODE_RMTVOL_ORPHAN_DELETION";
                break;
            }
            case 137: {
                rval = "RETCODE_ROLLBACK_IN_PROGRESS";
                break;
            }
            case 187: {
                rval = "RETCODE_RVM_ACTIVATE_DISALLOWED";
                break;
            }
            case 180: {
                rval = "RETCODE_RVM_COMMUNICATION_ERROR";
                break;
            }
            case 156: {
                rval = "RETCODE_RVM_FEATURE_DEACTIVATED";
                break;
            }
            case 154: {
                rval = "RETCODE_RVM_FEATURE_DISABLED";
                break;
            }
            case 181: {
                rval = "RETCODE_RVM_FIBRE_ERROR";
                break;
            }
            case 179: {
                rval = "RETCODE_RVM_REMOTE_ARRAY_ERROR";
                break;
            }
            case 176: {
                rval = "RETCODE_RVM_SPM_ERROR";
                break;
            }
            case 178: {
                rval = "RETCODE_RVM_VERSION_MISMATCH";
                break;
            }
            case 183: {
                rval = "RETCODE_SEC_NOT_PROMOTEABLE";
                break;
            }
            case 132: {
                rval = "RETCODE_SNAP_NOT_AVAILABLE";
                break;
            }
            case 134: {
                rval = "RETCODE_SNAPSHOT_FEATURE_DISABLED";
                break;
            }
            case 9: {
                rval = "RETCODE_SOME_SPARES_ASSIGNED";
                break;
            }
            case 56: {
                rval = "RETCODE_SOME_SPARES_DEASSIGNED";
                break;
            }
            case 87: {
                rval = "RETCODE_SOME_SPARES_TOO_SMALL";
                break;
            }
            case 88: {
                rval = "RETCODE_SPARES_SMALL_UNASSIGNED";
                break;
            }
            case 73: {
                rval = "RETCODE_SPAWN_ERROR";
                break;
            }
            case 89: {
                rval = "RETCODE_TOO_MANY_PARTITIONS";
                break;
            }
            case 13: {
                rval = "RETCODE_TRY_ALTERNATE";
                break;
            }
            case 99: {
                rval = "RETCODE_UTM_CONFLICT";
                break;
            }
            case 108: {
                rval = "RETCODE_UTM_TOO_MANY_MAPS";
                break;
            }
            case 215: {
                rval = "RETCODE_VOLCOPY_FEATURE_DISABLED";
                break;
            }
            case 74: {
                rval = "RETCODE_VOLTRANSFER_ERROR";
                break;
            }
            case 17: {
                rval = "RETCODE_VOLUME_DEAD";
                break;
            }
            case 21: {
                rval = "RETCODE_VOLUME_FORMATTING";
                break;
            }
            case 10: {
                rval = "RETCODE_VOLUME_NOT_EXIST";
                break;
            }
            case 38: {
                rval = "RETCODE_VOLUME_NOT_OPTIMAL";
                break;
            }
            case 37: {
                rval = "RETCODE_VOLUME_OFFLINE";
                break;
            }
            case 11: {
                rval = "RETCODE_VOLUME_RECONFIGURING";
                break;
            }
            case 216: {
                rval = "RETCODE_WRITE_LOCK";
            }
        }
        return rval;
    }

    static {
        SLOT_1_NAME = SLOT_1_NAME;
        SLOT_2_NAME = SLOT_2_NAME;
    }
}

