/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.UnreadableSectorTableEntry;
import devmgr.versioned.symbol.UnreadableSectorTableInfo;

public class UnreadableSectors {
    static String getData(String ip) {
        String data = "No unreadble sector data collected";
        SYMbolAPIClientV1 client = SYMbolConnection.getOpenConnection(ip);
        try {
            data = UnreadableSectors.collectData(client);
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client);
            client = SYMbolConnection.getOpenConnection(ip);
            try {
                data = UnreadableSectors.collectData(client);
            }
            catch (Exception e2) {
                data = "Error accessing unreadble sector data: " + e2.toString();
            }
        }
        SYMbolConnection.closeClient(client);
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client) throws Exception {
        StringBuffer data = new StringBuffer();
        client.setTimeout(new ProcedureTimeout().getProcTimeout(143));
        UnreadableSectorTableInfo table = client.readUnreadableSectorDatabase();
        UnreadableSectorTableEntry[] entries = table.getDatabase();
        int maxEntries = table.getMaxLimit();
        data.append("Volume  Date/Time  Volume LBA  Drive Location  Drive LBA  Failure Type\n");
        int x = 0;
        while (x < entries.length) {
            data.append(Utility.hexString(entries[x].getVolumeRef().getRefToken()) + "\t");
            data.append(Utility.convertDate(entries[x].getTimeStamp()) + "\t");
            data.append(entries[x].getVolumeLBA() + "\t");
            data.append(entries[x].getTrayNo() + " ");
            data.append(entries[x].getSlotNo() + "\t");
            data.append(entries[x].getDriveLBA() + "\t");
            data.append(Translator.translateUsmRecordType(entries[x].getRecordType()) + "\n");
            ++x;
        }
        return data.toString();
    }
}

