/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.ArrayProfile;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.DriveLogCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.MELLog;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.NVSRAMCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.ObjectBundleCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.PersistentRegistrations;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.ReadLinkStatus;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.StateCapture;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.UnreadableSectors;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.VolumeStatistics;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SupportDataCollector {
    private static final int STORAGE_ARRAY_PROFILE = 0;
    private static final int MAJOR_EVENT_LOG = 1;
    private static final int READ_LINK_STATUS = 2;
    private static final int NVSRAM = 3;
    private static final int PERFORMANCE_STATISTICS = 4;
    private static final int PERSISTENT_REGISTRATIONS = 5;
    private static final int BAD_BLOCKS = 6;
    private static final int STATE_CAPTURE = 7;
    private static final int DRIVE_LOG_DATA = 8;
    private static final int OBJECT_BUNDLE = 9;
    private static final String[] ITEM_FILENAMES;
    private static final int IO_BUFFER_BYTE_SIZE = 1024;
    private static final String NEWLINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectSupportData(Properties props, String path, String zipfileName) {
        String rval;
        SYMbolAPIClientV1 client2;
        SYMbolAPIClientV1 client;
        block16: {
            String string;
            block15: {
                String string2;
                block14: {
                    String string3;
                    block13: {
                        String string4;
                        block12: {
                            client = null;
                            client2 = null;
                            rval = "OK";
                            try {
                                try {
                                    File baseDir;
                                    if (zipfileName.indexOf(".zip") < 0) {
                                        zipfileName = zipfileName + ".zip";
                                    }
                                    if (!(baseDir = new File(path)).exists()) {
                                        string4 = "ERROR: The directory " + baseDir.getPath() + " does not exist";
                                        Object var25_11 = null;
                                        break block12;
                                    }
                                    if (!baseDir.canWrite()) {
                                        string3 = "ERROR: Unable to write to the directory " + baseDir.getPath();
                                        break block13;
                                    }
                                    File zipFile = new File(path, zipfileName);
                                    if (zipFile.exists() && !zipFile.canWrite()) {
                                        string2 = "ERROR: The file " + zipFile.getPath() + " already exists, and cannot be overwritten (check permissions)";
                                        break block14;
                                    }
                                    File tempPath = File.createTempFile("TEMP_DATA", ".tmp", zipFile.getParentFile());
                                    if (tempPath.exists()) {
                                        tempPath.delete();
                                    }
                                    tempPath.mkdir();
                                    String tempPathName = tempPath.getCanonicalPath();
                                    String ip1 = props.getProperty("ipno");
                                    String ip2 = props.getProperty("altipno");
                                    String ipUsed = ip1;
                                    String altIP = ip2;
                                    client = SYMbolConnection.getOpenConnection(ip1);
                                    if (client == null) {
                                        ipUsed = ip2;
                                        altIP = ip1;
                                        client = SYMbolConnection.getOpenConnection(ip2);
                                    }
                                    if (client == null) {
                                        string = rval = "ERROR: Could not connect to " + ip1 + " or " + ip2;
                                        break block15;
                                    }
                                    String profile = ArrayProfile.getData(client);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[0], profile);
                                    SYMbolConnection.closeClient(client);
                                    String melData = MELLog.getData(ipUsed);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[1], melData);
                                    String rlsData = ReadLinkStatus.getData(ipUsed);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[2], rlsData);
                                    String persistentReg = PersistentRegistrations.getData(ipUsed);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[5], persistentReg);
                                    String badBlocks = UnreadableSectors.getData(ipUsed);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[6], badBlocks);
                                    DriveLogCollector.getData(ipUsed, tempPathName, ITEM_FILENAMES[8]);
                                    ObjectBundleCollector.getData(ipUsed, tempPathName, ITEM_FILENAMES[9]);
                                    DeviceProperties devProps = new DeviceProperties(props);
                                    String password = devProps.getPassword();
                                    String stateCapture = StateCapture.getData(ipUsed, altIP, password);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[7], stateCapture);
                                    String nvsramData = NVSRAMCollector.getData(ipUsed, altIP);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[3], nvsramData);
                                    String volumePerformance = VolumeStatistics.getData(ipUsed, altIP);
                                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[4], volumePerformance);
                                    rval = SupportDataCollector.createZipFile(tempPathName, zipFile);
                                    SupportDataCollector.cleanup(tempPathName, tempPath);
                                    break block16;
                                }
                                catch (Exception e) {
                                    rval = "ERROR:\n" + e.toString();
                                    Object var25_16 = null;
                                    SYMbolConnection.closeClient(client);
                                    SYMbolConnection.closeClient(client2);
                                    return rval;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var25_17 = null;
                                SYMbolConnection.closeClient(client);
                                SYMbolConnection.closeClient(client2);
                                throw throwable;
                            }
                        }
                        SYMbolConnection.closeClient(client);
                        SYMbolConnection.closeClient(client2);
                        return string4;
                    }
                    Object var25_12 = null;
                    SYMbolConnection.closeClient(client);
                    SYMbolConnection.closeClient(client2);
                    return string3;
                }
                Object var25_13 = null;
                SYMbolConnection.closeClient(client);
                SYMbolConnection.closeClient(client2);
                return string2;
            }
            Object var25_14 = null;
            SYMbolConnection.closeClient(client);
            SYMbolConnection.closeClient(client2);
            return string;
        }
        Object var25_15 = null;
        SYMbolConnection.closeClient(client);
        SYMbolConnection.closeClient(client2);
        return rval;
    }

    static boolean writeFile(String path, String filename, String data) {
        FileWriter outFileWriter = null;
        PrintWriter printWriter = null;
        File outFile = new File(path, filename);
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            outFileWriter = new FileWriter(outFile.getAbsolutePath(), true);
            printWriter = new PrintWriter((Writer)new BufferedWriter(outFileWriter), true);
            printWriter.println(data);
        }
        catch (Exception e) {
            return false;
        }
        try {
            outFileWriter.close();
        }
        catch (IOException ioException) {
            return false;
        }
        return true;
    }

    private static String createZipFile(String tempPathName, File zipFile) {
        ZipOutputStream zipOutStream = null;
        byte[] buffer = new byte[1024];
        int length = 0;
        String rval = "Success";
        try {
            FileOutputStream outStream = new FileOutputStream(zipFile);
            zipOutStream = new ZipOutputStream(outStream);
        }
        catch (IOException e) {
            rval = "Error\n" + e.toString();
        }
        int i = 0;
        while (i < ITEM_FILENAMES.length) {
            File oneFile = new File(tempPathName, ITEM_FILENAMES[i]);
            if (oneFile.exists() && oneFile.isFile() && oneFile.canRead()) {
                try {
                    FileInputStream fileInStream = new FileInputStream(oneFile);
                    ZipEntry zipEntry = new ZipEntry(ITEM_FILENAMES[i]);
                    zipEntry.setSize(oneFile.length());
                    zipEntry.setTime(oneFile.lastModified());
                    zipOutStream.putNextEntry(zipEntry);
                    while ((length = fileInStream.read(buffer)) > -1) {
                        zipOutStream.write(buffer, 0, length);
                    }
                    zipOutStream.closeEntry();
                    fileInStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (zipOutStream != null) {
            try {
                zipOutStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return rval;
    }

    private static void cleanup(String tempPathName, File tempPath) {
        File oneFile = null;
        int i = 0;
        while (i < ITEM_FILENAMES.length) {
            oneFile = new File(tempPathName, ITEM_FILENAMES[i]);
            oneFile.delete();
            ++i;
        }
        if (tempPath != null) {
            tempPath.delete();
        }
        if (new File(".", tempPathName).exists()) {
            new File(".", tempPath.getName()).delete();
        }
    }

    static {
        STORAGE_ARRAY_PROFILE = 0;
        MAJOR_EVENT_LOG = 1;
        READ_LINK_STATUS = 2;
        NVSRAM = 3;
        PERFORMANCE_STATISTICS = 4;
        PERSISTENT_REGISTRATIONS = 5;
        BAD_BLOCKS = 6;
        STATE_CAPTURE = 7;
        DRIVE_LOG_DATA = 8;
        OBJECT_BUNDLE = 9;
        ITEM_FILENAMES = new String[]{"storageArrayProfile.txt", "majorEventLog.txt", "readLinkStatus.csv", "NVSRAMdata.txt", "performanceStatistics.csv", "persistentReservations.txt", "badBlocksData.txt", "stateCaptureData.dmp", "driveDiagnosticData.bin", "objectBundle"};
        IO_BUFFER_BYTE_SIZE = 1024;
        NEWLINE = System.getProperty("line.separator");
    }
}

