/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithOpaqueData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Volume;
import java.util.ArrayList;

public class StateCapture {
    static String getData(String ip1, String ip2, String password) {
        SYMbolAPIClientV1 client1 = SYMbolConnection.getOpenConnection(ip1);
        SYMbolAPIClientV1 client2 = SYMbolConnection.getOpenConnection(ip2);
        StringBuffer data = new StringBuffer();
        try {
            data.append(StateCapture.performStateCapture(client1, client2, password));
        }
        catch (Exception e) {
            data.append("\nError accessing state capture\n" + e.toString());
        }
        SYMbolConnection.closeClient(client1);
        SYMbolConnection.closeClient(client2);
        return data.toString();
    }

    private static String performStateCapture(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2, String password) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("moduleList,1");
        list.add("arrayPrintSummary");
        list.add("cfgUnitList");
        list.add("ghsList");
        list.add("printBatteryAge");
        list.add("cfgPhyList");
        list.add("spmShowMaps");
        list.add("spmShow");
        list.add("getObjectGraph_MT,1");
        list.add("getObjectGraph_MT,4");
        list.add("getObjectGraph_MT,8");
        list.add("ccmStateAnalyze,8");
        list.add("fcDevs,1");
        list.add("i");
        list.add("dqflush");
        list.add("dqprint,\"fd=1,tail=400\"");
        list.add("dqprint,\"fc=hdd->rde,tail=200\"");
        list.add("fc,111");
        list.add("hdd,5");
        list.add("fcAll,10");
        list.add("showEnclosures");
        list.add("showEnclosuresPage81");
        SYMbolAPIClientV1[] clients = new SYMbolAPIClientV1[]{client1, client2};
        String[] clientNames = new String[2];
        int i = 0;
        while (i < clients.length) {
            int slot = 0;
            try {
                clients[i].setTimeout(new ProcedureTimeout().getProcTimeout(40));
                Controller[] controllers = clients[i].getObjectGraph().getController();
                int x = 0;
                while (x < controllers.length) {
                    if (DiagUtility.bindToController(clients[i], controllers[x].getControllerRef())) {
                        slot = controllers[x].getPhysicalLocation().getSlot();
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            clientNames[i] = "Controller in slot " + Translator.getSlotName(slot);
            ++i;
        }
        try {
            client1.setTimeout(new ProcedureTimeout().getProcTimeout(40));
            Volume[] volumes = client1.getObjectGraph().getVolume();
            int i2 = 0;
            while (i2 < volumes.length) {
                list.add("vdShow," + i2);
                ++i2;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        StringBuffer data = new StringBuffer();
        if (client1 != null) {
            Utility.setClientPassword(password, client1);
        }
        if (client1 != null) {
            Utility.setClientPassword(password, client2);
        }
        int x = 0;
        while (x < list.size()) {
            String command = "";
            int i3 = 0;
            while (i3 < clients.length) {
                try {
                    command = (String)list.get(x);
                    if (clients[i3] != null) {
                        clients[i3].setTimeout(new ProcedureTimeout().getProcTimeout(84));
                        ReturnCodeWithOpaqueData rcwod = clients[i3].stateCapture(command);
                        ReturnCode rc = rcwod.getReturnCode();
                        if (rc.getValue() == 1) {
                            byte[] opaqueData = rcwod.getData();
                            String temp = new String(opaqueData);
                            data.append(clientNames[i3] + "\n");
                            data.append(temp + "\n");
                        } else {
                            data.append("Accessing " + command + " ReturnCode = " + Translator.translateReturnCode(rc) + "\n");
                        }
                    } else {
                        data.append("The client connection is null, no data is available\n");
                    }
                }
                catch (Exception e) {
                    data.append("Exception while accessing " + command);
                }
                ++i3;
            }
            ++x;
        }
        return data.toString();
    }
}

