/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.Util;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.RLSCommand;
import devmgr.versioned.symbol.RLSCommandDescriptor;
import devmgr.versioned.symbol.RLSCount;
import devmgr.versioned.symbol.RLSData;
import devmgr.versioned.symbol.RLSDevice;
import devmgr.versioned.symbol.RLSResults;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.Date;

public class ReadLinkStatus {
    private static final long YEAR_SECONDS = 31536000L;
    private static final long DAY_SECONDS = 86400L;
    private static final long HOUR_SECONDS = 3600L;
    private static final long MINUTE_SECONDS = 60L;

    static String getData(String ip) {
        SYMbolAPIClientV1 client = SYMbolConnection.getOpenConnection(ip);
        String data = ReadLinkStatus.collectData(client);
        SYMbolConnection.closeClient(client);
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
            ObjectBundle bundle = client.getObjectGraph();
            RLSCommand command = new RLSCommand(1);
            RLSCommandDescriptor rlsCommand = new RLSCommandDescriptor();
            rlsCommand.setCommand(command);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(102));
            RLSResults rlsResults = client.getReadLinkStatus(rlsCommand);
            Date now = new Date();
            data.append("RLS Data collected: " + now.toString() + "\n\n");
            data.append("\"Type\",\"Device\",\"Baseline Time\",\"ITW\",\"LF\",\"LOS\",\"LOSG\",\"PSP\",\"ICRC\"\n");
            int x = 1;
            while (x <= 2) {
                data.append("Channel " + x + " data\n\n");
                RLSData[] controllers = rlsResults.getControllers();
                data.append(ReadLinkStatus.getRLSData(controllers, bundle, x));
                RLSData[] drives = rlsResults.getDrives();
                data.append(ReadLinkStatus.getRLSData(drives, bundle, x));
                RLSData[] esms = rlsResults.getEsms();
                data.append(ReadLinkStatus.getRLSData(esms, bundle, x));
                data.append("\n\n");
                ++x;
            }
        }
        catch (Exception e) {
            data.append("\nError accessing RLS data\n" + e.toString());
        }
        return data.toString();
    }

    private static String getRLSData(RLSData[] rlsData, ObjectBundle bundle, int channel) {
        StringBuffer data = new StringBuffer();
        Date now = new Date();
        long timeNow = now.getTime() / 1000L;
        int x = 0;
        while (x < rlsData.length) {
            RLSDevice device = rlsData[x].getDevice();
            int chan = rlsData[x].getChannel();
            if (chan == channel) {
                int type = device.getType().getValue();
                String id = null;
                if (type == 1) {
                    id = Util.createName(bundle, device.getController());
                } else if (type == 2) {
                    id = Util.createShortName(bundle, device.getDrive());
                } else if (type == 3) {
                    id = Util.createIOMName(bundle, device.getEsm());
                }
                data.append(id + ", ");
                data.append(Utility.convertDate(rlsData[x].getBaselineTime()) + ", ");
                RLSCount count = rlsData[x].getRlsCount();
                data.append(count.getInvalidXmitWord() + ", ");
                data.append(count.getLinkFailureCount() + ", ");
                data.append(count.getLossOfSyncCount() + ", ");
                data.append(count.getLossOfSignalCount() + ", ");
                data.append(count.getPrimSeqProtocolErr() + ", ");
                data.append(count.getInvalidCRCCount() + "\n");
            }
            ++x;
        }
        return data.toString();
    }

    private static String timeDelta(long start, long finish) {
        String delta = "Unknown";
        long totalSec = finish - start;
        if (totalSec >= 0L) {
            long seconds;
            long minutes;
            long remainder;
            long hours;
            StringBuffer buf = new StringBuffer();
            long days = totalSec / 86400L;
            if (days > 0L) {
                buf.append(days + " day(s) ");
            }
            if ((hours = (remainder = totalSec % 86400L) / 3600L) > 0L) {
                buf.append(hours + " hour(s) ");
            }
            if ((minutes = (remainder %= 3600L) / 60L) > 0L) {
                buf.append(minutes + " minutes(s) ");
            }
            if ((seconds = remainder % 60L) > 0L) {
                buf.append(seconds + " seconds(s)");
            }
            delta = buf.toString();
        }
        return delta;
    }

    static {
        YEAR_SECONDS = 31536000L;
        DAY_SECONDS = 86400L;
        HOUR_SECONDS = 3600L;
        MINUTE_SECONDS = 60L;
    }
}

