/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.HostPortName;
import devmgr.versioned.symbol.HostPortRef;
import devmgr.versioned.symbol.PersistentRegistration;
import devmgr.versioned.symbol.PersistentRegistrationList;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.RegisteredPorts;
import devmgr.versioned.symbol.Registrant;
import devmgr.versioned.symbol.RegistrantList;
import devmgr.versioned.symbol.ReservedPortID;
import devmgr.versioned.symbol.SYMbolAPIClientV1;

public class PersistentRegistrations {
    static String getData(String ip) {
        String data = "No registration data collected";
        SYMbolAPIClientV1 client = SYMbolConnection.getOpenConnection(ip);
        try {
            data = PersistentRegistrations.collectData(client);
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client);
            client = SYMbolConnection.getOpenConnection(ip);
            try {
                data = PersistentRegistrations.collectData(client);
            }
            catch (Exception e2) {
                data = "Error accessing persistent registrations data\n" + e2.toString();
            }
        }
        SYMbolConnection.closeClient(client);
        return data;
    }

    public static String collectData(SYMbolAPIClientV1 client) throws Exception {
        StringBuffer data = new StringBuffer();
        client.setTimeout(new ProcedureTimeout().getProcTimeout(128));
        PersistentRegistrationList list = client.getPersistentRegistrations();
        PersistentRegistration[] registrations = list.getPersistentRegistration();
        if (registrations.length == 0) {
            data.append("No persistent registrations found.");
        } else {
            int x = 0;
            while (x < registrations.length) {
                data.append("\nVolume: ");
                data.append(Utility.bytesArrayString(registrations[x].getVolumeRef().getRefToken()));
                data.append("\nCluster: ");
                data.append(Utility.bytesArrayString(registrations[x].getClusterRef().getRefToken()));
                data.append("\nHost: ");
                data.append(Utility.bytesArrayString(registrations[x].getHostRef().getRefToken()));
                data.append("\nLUN: ");
                data.append(registrations[x].getLun());
                data.append("\nPTPL active: ");
                data.append(registrations[x].getPtpl_A());
                data.append("\nType: ");
                data.append(Translator.translateReservationTypeID(registrations[x].getReservationTypeID()));
                data.append("\nRegistrant List:\n");
                RegistrantList rlist = registrations[x].getRegistrantList();
                Registrant[] registrants = rlist.getRegistrant();
                int i = 0;
                while (i < registrants.length) {
                    HostPortName portName = registrants[i].getHostPortName();
                    HostPortRef portRef = registrants[i].getHostPortRef();
                    RegisteredPorts regPorts = registrants[i].getRegisteredPorts();
                    ReservedPortID portID = registrants[i].getReservedPort();
                    data.append("\n\tPort name: " + Utility.hexString(portName.getValue()));
                    data.append("\n\tPort Ref :" + Utility.hexString(portRef.getRefToken()));
                    data.append("\n\tPort id  :" + Translator.translateReservedPortID(portID));
                    data.append("\n\tPortA0   :" + regPorts.getPortA0());
                    data.append("\n\tPortA1   :" + regPorts.getPortA1());
                    data.append("\n\tPortB0   :" + regPorts.getPortB0());
                    data.append("\n\tPortB1   :" + regPorts.getPortB1());
                    data.append("\n");
                    ++i;
                }
                data.append("\n");
                ++x;
            }
        }
        return data.toString();
    }
}

