/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerSFP;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ESMInterfaceTypeData;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.EthernetInterface;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.Port;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.RLSCount;
import devmgr.versioned.symbol.RLSData;
import devmgr.versioned.symbol.RLSResults;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SFPParentTypeData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeGroupRef;
import devmgr.versioned.symbol.VolumeRef;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.StringTokenizer;

public class TreefrogReport
implements ReportGenerator {
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    private static final double TB;
    private static final int CONTROLLER = 1;
    private static final int DRIVE = 2;
    private static final int ESM = 3;
    private static final String NO_CONTACT = "No contact";
    private static final String MISSING_DATA = "Missing data";
    private static final String GOOD_CONNECTION = "Connected";
    private static final String DRIVE_NAME = "Drive";
    private static final String DRIVE_TYPE = "drive";
    private static final String SENSOR_NAME = "TempSensor";
    private static final String SENSOR_TYPE = "ts";
    private static final String CONTROLLER_TYPE = "ctrl";
    private static final String ESM_TYPE = "iom";
    private static final String IOM_TYPE = "iom";
    private static final int DEVICE_ID_FORMAT = 1;
    private static final int NAME_FORMAT = 2;
    private static final String VENDOR_PREFIX = "VN";
    private static final String PART_PREFIX = "PN";
    private static final String SERIAL_PREFIX = "SN";
    private static final String TYPE_PREFIX = "FT";
    private static final String SBOD_IOM_TYPE = "SBOD";
    private static final String SATA_IOM_TYPE = "SATA";
    private static final int MAX_RETRIES = 2;

    public ReportClass generateReport(Properties p, String content) {
        SYMbolAPIClientV1 client = null;
        ObjectBundle objectBundle = null;
        ComponentBundle components = null;
        try {
            String connectionStatus = GOOD_CONNECTION;
            int i = 0;
            while (i <= 2) {
                client = SYMbolConnection.getOpenConnection(p);
                if (client != null) {
                    objectBundle = SYMbolConnection.getObjectBundle(client);
                    if (objectBundle == null) {
                        SYMbolConnection.closeClient(client);
                        connectionStatus = MISSING_DATA;
                    } else {
                        components = objectBundle.getComponentBundle();
                        if (components == null) {
                            SYMbolConnection.closeClient(client);
                            connectionStatus = MISSING_DATA;
                        } else {
                            if (this.hasRequiredObjects(objectBundle, components)) break;
                            SYMbolConnection.closeClient(client);
                            connectionStatus = MISSING_DATA;
                        }
                    }
                } else {
                    connectionStatus = NO_CONTACT;
                }
                ++i;
            }
            if (!connectionStatus.equals(GOOD_CONNECTION)) {
                return this.generateErrorReport(p, connectionStatus);
            }
            ReportClass system = this.buildReport(client, objectBundle, components, p);
            return system;
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client);
            return this.generateErrorReport(p, e);
        }
    }

    private ReportClass buildReport(SYMbolAPIClientV1 client, ObjectBundle objectBundle, ComponentBundle components, Properties props) throws Exception {
        ReportClass system = new ReportClass("system");
        this.createSystem(system, objectBundle, props);
        Controller[] controllers = objectBundle.getController();
        int x = 0;
        while (x < controllers.length) {
            this.createController(system, controllers[x], objectBundle, client);
            IOInterfaceTypeData[] hostPorts = controllers[x].getHostInterfaces();
            int port = 0;
            while (port < hostPorts.length) {
                this.createPort(system, hostPorts[port], objectBundle, controllers[x], port);
                ++port;
            }
            ++x;
        }
        SYMbolConnection.closeClient(client);
        Drive[] drives = objectBundle.getDrive();
        int x2 = 0;
        while (x2 < drives.length) {
            this.createDrive(system, drives[x2], objectBundle);
            ++x2;
        }
        VolumeGroup[] groups = objectBundle.getVolumeGroup();
        int x3 = 0;
        while (x3 < groups.length) {
            this.createStoragePool(system, groups[x3], objectBundle);
            ++x3;
        }
        Volume[] volumes = objectBundle.getVolume();
        int x4 = 0;
        while (x4 < volumes.length) {
            this.createVolume(system, volumes[x4], objectBundle);
            ++x4;
        }
        Tray[] trays = objectBundle.getTray();
        int x5 = 0;
        while (x5 < trays.length) {
            this.createMidplane(system, trays[x5], x5, objectBundle);
            ++x5;
        }
        Esm[] esms = components.getEsm();
        int x6 = 0;
        while (x6 < esms.length) {
            this.createESM(system, esms[x6], objectBundle);
            ++x6;
        }
        Sfp[] sfps = components.getSfp();
        int x7 = 0;
        while (x7 < sfps.length) {
            this.createSFP(system, sfps[x7], objectBundle);
            ++x7;
        }
        Fan[] fans = components.getFan();
        int x8 = 0;
        while (x8 < fans.length) {
            this.createFan(system, fans[x8], objectBundle);
            ++x8;
        }
        PowerSupply[] power = components.getPowerSupply();
        int x9 = 0;
        while (x9 < power.length) {
            this.createPowerSupply(system, power[x9], objectBundle);
            ++x9;
        }
        ThermalSensor[] ts = components.getThermalSensor();
        int x10 = 0;
        while (x10 < ts.length) {
            this.createTempSensor(system, ts[x10], objectBundle);
            ++x10;
        }
        return system;
    }

    private ReportClass generateErrorReport(Properties p, String errorID) {
        ReportClass rc = new ReportClass("rc");
        rc.setProperty("error", errorID);
        return rc;
    }

    private ReportClass generateErrorReport(Properties p, Exception e) {
        ReportClass rc = new ReportClass("rc");
        rc.setProperty("error", e.toString());
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        try {
            out.write("Unable to create report due to " + e.toString());
        }
        catch (Exception e2) {
            // empty catch block
        }
        rc.setProperty("trace", sw.toString());
        return rc;
    }

    private boolean hasRequiredObjects(ObjectBundle obundle, ComponentBundle cbundle) {
        boolean rval = true;
        Controller[] controllers = obundle.getController();
        Drive[] drives = obundle.getDrive();
        Tray[] trays = obundle.getTray();
        Fan[] fans = cbundle.getFan();
        PowerSupply[] power = cbundle.getPowerSupply();
        if (controllers.length == 0 || drives.length == 0 || trays.length == 0 || fans.length == 0 || power.length == 0) {
            rval = false;
        }
        return rval;
    }

    private void createSystem(ReportClass system, ObjectBundle bundle, Properties props) {
        try {
            StorageArray stArray = bundle.getSa();
            SAData array = bundle.getSa().getSaData();
            byte[] wwn = array.getSaId().getWorldWideName();
            byte[] firmware = array.getFwVersion();
            String nvsram = array.getNvsramVersion();
            boolean needsAttention = array.getNeedsAttention();
            String arrayName = Utility.userLabelString(array.getStorageArrayLabel());
            system.setKey(Utility.wwnString(wwn));
            system.setStringProperty("_Name", arrayName);
            system.setStringProperty("_Dedicated", "Storage");
            system.setStringProperty("_NameFormat", "Other");
            system.setStringProperty("_PrimaryOwnerName", "");
            system.setStringProperty("_PrimaryOwnerContact", "");
            system.setStringProperty("_Roles", "Unknown");
            system.setStringProperty("_IdentifyingNumber", this.getSerialNumber(bundle));
            system.setStringProperty("_Vendor", "Sun Microsystems");
            system.setStringProperty("_Version", Utility.bytesToDecimalString(firmware));
            system.setStringProperty("_SKUNumber", "");
            system.setStringProperty("_SysBootDelay", "");
            system.setStringProperty("nvsram", nvsram);
            system.setStringProperty("needsAttention", "" + needsAttention);
            Controller[] controllers = bundle.getController();
            NetInterfaceTypeData[] net = controllers[0].getNetInterfaces();
            EthernetInterface enet = net[0].getEthernet();
            int ip = enet.getIp();
            system.setStringProperty("_IPAddress", Utility.convertIpAddr(ip));
            system.setStringProperty("_MacAddress", Utility.bytesToString(enet.getMacAddr()));
            system.setStringProperty("featureEnableId", Utility.bytesArrayString(stArray.getSafeId().getWorldWideName()));
            System.out.println("About to write the extra data in system");
            ComponentBundle components = bundle.getComponentBundle();
            System.out.println("We have the component bundle");
            system.setStringProperty("symbolcontrollercount", "" + bundle.getController().length);
            system.setStringProperty("symboltraycount", "" + bundle.getTray().length);
            system.setStringProperty("symboldrivecount", "" + bundle.getDrive().length);
            system.setStringProperty("symbolpowercount", "" + components.getPowerSupply().length);
            system.setStringProperty("symbolfancount", "" + components.getFan().length);
            system.setStringProperty("symboliomcount", "" + components.getEsm().length);
            system.setStringProperty("symbolsfpcount", "" + components.getSfp().length);
            System.out.println("Done with extra counters");
            String storedName = props.getProperty("name");
            if (arrayName != null && !arrayName.equals("")) {
                if (storedName != null) {
                    if (!arrayName.equals(storedName)) {
                        props.setProperty("name", arrayName);
                    }
                } else {
                    props.setProperty("name", arrayName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            system.setStringProperty("system", "Error creating the system");
        }
    }

    private String getSerialNumber(ObjectBundle bundle) {
        String serialNumber = "";
        try {
            if (bundle != null) {
                Tray[] trays = bundle.getTray();
                int x = 0;
                while (x < trays.length) {
                    if (trays[x].getNumControllerSlots() > 0) break;
                    ++x;
                }
                if (x >= trays.length) {
                    x = 0;
                }
                serialNumber = TreefrogReport.stripHeader(trays[x].getSerialNumber(), SERIAL_PREFIX);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serialNumber.trim();
    }

    private void createController(ReportClass system, Controller controller, ObjectBundle bundle, SYMbolAPIClientV1 client) {
        ReportClass repClass = system.newSubInstance(CONTROLLER_TYPE);
        try {
            IOInterfaceTypeData[] driveSidePorts;
            Location location = controller.getPhysicalLocation();
            String name = TreefrogReport.createName("Controller", bundle, location);
            String deviceID = TreefrogReport.createDeviceID(CONTROLLER_TYPE, bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "RaidController");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("_FirmwareVersion", "" + controller.getAppVersion());
            repClass.setStringProperty("active", "" + controller.getActive());
            repClass.setStringProperty("cacheSize", "" + controller.getCacheMemorySize() + " MB");
            repClass.setStringProperty("cpuMemorySize", "" + controller.getProcessorMemorySize() + " MB");
            repClass.setStringProperty("_Description", "RAID Controller");
            String boardID = controller.getBoardID();
            if (boardID != null) {
                if ((boardID = boardID.trim()).equals("2882")) {
                    repClass.setStringProperty("_Description", "FC RAID Controller");
                } else if (boardID.equals("2822")) {
                    repClass.setStringProperty("_Description", "SATA RAID Controller");
                }
            }
            repClass.setStringProperty("boardID", boardID);
            String status = Translator.translateControllerStatus(controller.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            NetInterfaceTypeData[] net = controller.getNetInterfaces();
            int x = 0;
            while (x < net.length) {
                EthernetInterface enet = net[x].getEthernet();
                repClass.setStringProperty("ethernetAlias", enet.getAlias());
                repClass.setStringProperty("ethernetChannel", "" + enet.getChannel());
                int gwip = enet.getGatewayIp();
                repClass.setStringProperty("ethernetGatewayIp", Utility.convertIpAddr(gwip));
                repClass.setStringProperty("ethernetInterfaceName", enet.getInterfaceName());
                int ip = enet.getIp();
                String ipNum = Utility.convertIpAddr(ip);
                repClass.setStringProperty("ethernetIP", ipNum);
                repClass.setStringProperty("ethernetRloginEnabled", "" + enet.getRloginEnabled());
                repClass.setStringProperty("ethernetSpeed", "" + enet.getSpeed() + "Mbit/sec ");
                repClass.setStringProperty("ethernetSubnetMask", Utility.convertIpAddr(enet.getSubnetMask()));
                repClass.setStringProperty("ethernetBootpUsed", "" + enet.getBootpUsed());
                repClass.setStringProperty("ethernetMACAddress", Utility.bytesToString(enet.getMacAddr()));
                String enetStatus = "Down";
                if (SYMbolConnection.matchController(client, controller.getControllerRef())) {
                    enetStatus = "Up";
                } else if (SYMbolConnection.serverIsResponding(ipNum)) {
                    enetStatus = "Up";
                }
                repClass.setStringProperty("ethernetStatus", enetStatus);
                ++x;
            }
            if (controller.getStatus().getValue() != 3) {
                String key = this.createKey(controller.getManufacturer(), controller.getBoardID(), controller.getSerialNumber().trim());
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Controller");
                fru.setStringProperty("_Model", controller.getProductRevLevel());
                fru.setStringProperty("_Firmware", controller.getBootVersion());
                fru.setStringProperty("_Vendor", controller.getManufacturer());
                fru.setStringProperty("_SerialNumber", controller.getSerialNumber().trim());
                fru.setStringProperty("_FruNumber", controller.getSerialNumber().trim());
                fru.setStringProperty("IdentifyingNumber", controller.getSerialNumber().trim());
                fru.setStringProperty("ManufactureDate", Utility.convertDate(controller.getManufacturerDate()));
                fru.setStringProperty("productID", controller.getProductID().trim());
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
            if ((driveSidePorts = controller.getDriveInterfaces()) != null) {
                this.createControllerDriveSidePorts(repClass, deviceID, name, driveSidePorts);
            }
            ComponentBundle components = bundle.getComponentBundle();
            ControllerRef cref = controller.getControllerRef();
            Battery[] batteries = components.getBattery();
            boolean batteryFound = false;
            int x2 = 0;
            while (x2 < batteries.length) {
                ControllerRef pref = batteries[x2].getBatteryTypeData().getParentController();
                if (Utility.rawCompare(cref.getRefToken(), pref.getRefToken())) {
                    batteryFound = true;
                    this.createBattery(system, batteries[x2], bundle);
                    break;
                }
                ++x2;
            }
            if (!batteryFound) {
                this.createDefaultBattery(system, deviceID, name);
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing controller data");
        }
    }

    private void createControllerDriveSidePorts(ReportClass parent, String parentID, String parentName, IOInterfaceTypeData[] driveSidePorts) {
        try {
            int i = 0;
            while (i < driveSidePorts.length) {
                FibreInterface fibre = driveSidePorts[i].getFibre();
                ReportClass repClass = parent.newSubInstance("fcport");
                int channel = fibre.getChannel();
                String portID = parentID + "lp" + channel;
                String portName = parentName + ".LoopPort." + channel;
                repClass.setKey(portID);
                repClass.setStringProperty("_DeviceID", portID);
                repClass.setStringProperty("_Caption", "FibrePort");
                repClass.setStringProperty("_Description", "Driveside (Internal Loop) Fibre Port");
                repClass.setStringProperty("_ElementName", portName);
                repClass.setStringProperty("_Name", portName);
                repClass.setStringProperty("channel", "" + channel);
                repClass.setStringProperty("wwn", Utility.wwnString(fibre.getPortName()));
                String status = Translator.translateLinkStatus(fibre.getLinkStatus().getValue());
                repClass.setStringProperty("_RawStatus", status);
                repClass.setStringProperty("_Status", this.determineStatus(status));
                repClass.setStringProperty("_EnabledState", this.determineState(status));
                repClass.setStringProperty("_Availability", this.determineAvailability(status));
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void createInternalPort(ReportClass parent, String parentID, String parentName, byte[] ref, RLSResults rlsResults, int type) {
        RLSData[] rlsData = null;
        switch (type) {
            case 1: {
                rlsData = rlsResults.getControllers();
                break;
            }
            case 2: {
                rlsData = rlsResults.getDrives();
                break;
            }
            case 3: {
                rlsData = rlsResults.getEsms();
                break;
            }
            default: {
                return;
            }
        }
        int index = 1;
        int x = 0;
        while (x < rlsData.length) {
            byte[] refToken = null;
            if (type == 1) {
                refToken = rlsData[x].getDevice().getController().getRefToken();
            } else if (type == 3) {
                refToken = rlsData[x].getDevice().getEsm().getRefToken();
            } else if (type == 2) {
                refToken = rlsData[x].getDevice().getDrive().getRefToken();
            }
            if (Utility.rawCompare(ref, refToken)) {
                try {
                    ReportClass repClass = parent.newSubInstance("fcport");
                    String portID = parentID + "lp" + index;
                    String portName = parentName + ".LoopPort." + index;
                    repClass.setKey(portID);
                    repClass.setStringProperty("_DeviceID", portID);
                    repClass.setStringProperty("_Caption", "FibrePort");
                    repClass.setStringProperty("_Description", "Internal Loop Fibre Port");
                    repClass.setStringProperty("_ElementName", portName);
                    repClass.setStringProperty("_Name", portName);
                    int channel = rlsData[x].getChannel();
                    repClass.setStringProperty("channel", "" + channel);
                    RLSCount count = rlsData[x].getRlsCount();
                    repClass.setStringProperty("_CRCErrors", "" + count.getInvalidCRCCount());
                    repClass.setStringProperty("_InvalidTransmissionWords", "" + count.getInvalidXmitWord());
                    repClass.setStringProperty("_LinkFailures", "" + count.getLinkFailureCount());
                    repClass.setStringProperty("_LossOfSignalCounter", "" + count.getLossOfSignalCount());
                    repClass.setStringProperty("_LossOfSyncCounter", "" + count.getLossOfSyncCount());
                    repClass.setStringProperty("_PrimitiveSequenceProtocolErrCount", "" + count.getPrimSeqProtocolErr());
                    ++index;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++x;
        }
    }

    private void createDrive(ReportClass system, Drive drive, ObjectBundle bundle) {
        try {
            Location location = drive.getPhysicalLocation();
            Tray tray = Utility.findTray(bundle, location.getTrayRef());
            if (tray == null) {
                return;
            }
            ReportClass repClass = system.newSubInstance("disk");
            String name = TreefrogReport.createName(DRIVE_NAME, bundle, location);
            String deviceID = TreefrogReport.createDeviceID(DRIVE_TYPE, bundle, location);
            String driveType = Translator.translatePhysicalDriveType(drive.getPhyDriveType());
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "DiskDrive");
            repClass.setStringProperty("_Description", driveType + " Disk Drive");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateDriveStatus(drive.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            repClass.setStringProperty("firmware", drive.getSoftwareVersion());
            repClass.setStringProperty("blockSize", "" + drive.getBlkSize() + " bytes");
            repClass.setStringProperty("driveType", driveType);
            repClass.setStringProperty("statusCause", Translator.translateDriveStatusCause(drive.getCause().getValue()));
            repClass.setStringProperty("available", "" + drive.getAvailable());
            repClass.setStringProperty("offline", "" + drive.getOffline());
            repClass.setStringProperty("pfa", "" + drive.getPfa());
            repClass.setStringProperty("speed", Translator.translateSpeed(drive.getCurrentSpeed().getValue()));
            repClass.setStringProperty("maxSpeed", Translator.translateSpeed(drive.getMaxSpeed().getValue()));
            long rawCapacity = drive.getRawCapacity();
            repClass.setStringProperty("rawCapacity", this.normalizeCapacity(rawCapacity));
            long usableCapacity = drive.getUsableCapacity();
            repClass.setStringProperty("_Capacity", this.normalizeCapacity(usableCapacity));
            repClass.setStringProperty("hasDegradedChannel", "" + drive.getHasDegradedChannel());
            StringBuffer clist = new StringBuffer();
            int[] channels = drive.getDegradedChannels();
            int x = 0;
            while (x < channels.length) {
                if (clist.length() > 0) {
                    clist.append(", ");
                }
                clist.append("\"" + channels[x] + "\"");
                ++x;
            }
            if (clist.length() == 0) {
                clist.append("N/A");
            }
            repClass.setStringProperty("degradedChannels", clist.toString());
            repClass.setStringProperty("hotSpare", "" + drive.getHotSpare());
            repClass.setStringProperty("invalidDriveData", "" + drive.getInvalidDriveData());
            repClass.setStringProperty("nonRedundantAccess", "" + drive.getNonRedundantAccess());
            repClass.setStringProperty("uncertified", "" + drive.getUncertified());
            repClass.setStringProperty("wwn", Utility.wwnString(drive.getWorldWideName()));
            int vdiskIdx = drive.getVolumeGroupIndex();
            if (vdiskIdx > -1) {
                repClass.setStringProperty("vdiskAssignment", this.findPoolName(bundle, drive.getCurrentVolumeGroupRef()));
            } else {
                repClass.setStringProperty("vdiskAssignment", "Unassigned");
            }
            if (drive.getStatus().getValue() != 6 && drive.getStatus().getValue() != 4) {
                StringTokenizer tokens;
                String manufacturer = TreefrogReport.stripHeader(drive.getManufacturer(), VENDOR_PREFIX);
                String model = TreefrogReport.stripHeader(drive.getProductID(), PART_PREFIX);
                String serialNumber = TreefrogReport.stripHeader(drive.getSerialNumber(), SERIAL_PREFIX);
                if (drive.getPhyDriveType().getValue() == 3 && model != null && (tokens = new StringTokenizer(model)).countTokens() == 3) {
                    manufacturer = tokens.nextToken();
                    model = tokens.nextToken();
                }
                String key = this.createKey(manufacturer, model, serialNumber);
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Disk");
                fru.setStringProperty("_Model", model);
                fru.setStringProperty("_Firmware", drive.getSoftwareVersion());
                fru.setStringProperty("_Vendor", manufacturer);
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(drive.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void createMidplane(ReportClass system, Tray tray, int index, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("midplane");
        try {
            String name = "Tray." + tray.getTrayId() + ".Midplane";
            String deviceID = "t" + tray.getTrayId() + "mpn";
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Midplane");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            if (tray.getNumControllerSlots() > 0) {
                repClass.setStringProperty("_Description", "Common RAID Module midplane");
            } else {
                repClass.setStringProperty("_Description", "Common Expansion Module midplane");
            }
            boolean speedMismatch = tray.getDrvMHSpeedMismatch();
            boolean esmMiswire = tray.getEsmMiswire();
            boolean esmMismatch = tray.getEsmVersionMismatch();
            boolean idConflict = tray.getTrayIDConflict();
            boolean idMismatch = tray.getTrayIDMismatch();
            boolean unsupported = tray.getUnsupportedTray();
            String status = "Optimal";
            if (speedMismatch || esmMiswire || esmMismatch || idConflict || idMismatch || unsupported) {
                status = "Failed";
            }
            String partNumber = TreefrogReport.stripHeader(tray.getPartNumber(), PART_PREFIX);
            String serialNumber = TreefrogReport.stripHeader(tray.getSerialNumber(), SERIAL_PREFIX);
            if (partNumber.equals("") && serialNumber.equals("")) {
                status = "Removed";
            }
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            repClass.setStringProperty("driveSpeedMismatch", Utility.convertBoolean(speedMismatch));
            repClass.setStringProperty("iomMiswire", Utility.convertBoolean(esmMiswire));
            repClass.setStringProperty("iomVersionMismatch", Utility.convertBoolean(esmMismatch));
            repClass.setStringProperty("trayIDConflict", Utility.convertBoolean(idConflict));
            repClass.setStringProperty("trayIDMismatch", Utility.convertBoolean(idMismatch));
            repClass.setStringProperty("unsupportedTray", Utility.convertBoolean(unsupported));
            repClass.setStringProperty("maxSpeed", Translator.translateSpeed(tray.getMaxSpeed().getValue()));
            repClass.setStringProperty("numControllerSlots", "" + tray.getNumControllerSlots());
            repClass.setStringProperty("numDriveSlots", "" + tray.getNumDriveSlots());
            boolean redundantAccess = !tray.getNonRedundantAccess();
            repClass.setStringProperty("redundantAccess", "" + redundantAccess);
            if (redundantAccess) {
                repClass.setStringProperty("workingChannel", "N/A (Channels are redundant)");
            } else {
                repClass.setStringProperty("workingChannel", "" + tray.getWorkingChannel());
            }
            String vendor = TreefrogReport.stripHeader(tray.getVendorName(), VENDOR_PREFIX);
            String key = this.createKey(vendor, partNumber, serialNumber) + ".mpn";
            if (!status.equals("Removed")) {
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Midplane");
                fru.setStringProperty("_Model", partNumber);
                fru.setStringProperty("_Firmware", "N/A");
                fru.setStringProperty("_Vendor", vendor);
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("PartNumber", partNumber);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(tray.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "false");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing midplane data");
        }
    }

    private void createESM(ReportClass system, Esm esm, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("iom");
        try {
            Location location = esm.getPhysicalLocation();
            String name = TreefrogReport.createName("IOM", bundle, location);
            String deviceID = TreefrogReport.createDeviceID("iom", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "IOM");
            repClass.setStringProperty("_Description", "I/O Module");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            int currSpeed = esm.getCurrentSpeed().getValue();
            int maxSpeed = esm.getMaxSpeed().getValue();
            String rawType = esm.getFruType();
            String type = "Unspecified";
            if (rawType != null) {
                if (rawType.indexOf(SATA_IOM_TYPE) > -1) {
                    type = SATA_IOM_TYPE;
                } else if (rawType.indexOf(SBOD_IOM_TYPE) > -1) {
                    type = SBOD_IOM_TYPE;
                }
            }
            repClass.setStringProperty("type", type);
            repClass.setStringProperty("currentSpeed", Translator.translateSpeed(currSpeed));
            repClass.setStringProperty("maxSpeed", Translator.translateSpeed(maxSpeed));
            boolean redundantAccess = !esm.getNonRedundantAccess();
            repClass.setStringProperty("redundantAccess", "" + redundantAccess);
            if (redundantAccess) {
                repClass.setStringProperty("workingChannel", "N/A (Channels are redundant)");
            } else {
                repClass.setStringProperty("workingChannel", "" + esm.getWorkingChannel());
            }
            repClass.setStringProperty("softwareVersion", esm.getSoftwareVersion());
            String status = Translator.translateESMStatus(esm.getStatus().getValue());
            String partNumber = TreefrogReport.stripHeader(esm.getPartNumber(), PART_PREFIX);
            String serialNumber = TreefrogReport.stripHeader(esm.getSerialNumber(), SERIAL_PREFIX);
            if (partNumber.equals("") && serialNumber.equals("")) {
                status = "Removed";
            }
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            ESMInterfaceTypeData ifData = esm.getEsmInterfaceData();
            repClass.setStringProperty("interfaceType", Translator.translateEsmIFType(ifData.getIoInterfaceType()));
            Port[] ports = esm.getEsmInterfaceData().getPortList().getPorts();
            int i = 0;
            while (i < ports.length) {
                int bypassStatus = ports[i].getPortStatus().getValue();
                int portType = ports[i].getPortType().getValue();
                repClass.setStringProperty("port" + i + ".status", "" + bypassStatus);
                repClass.setStringProperty("port" + i + ".type", "" + portType);
                ++i;
            }
            if (!status.equals("Removed")) {
                String key = this.createKey("SUN", partNumber, serialNumber);
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "IOM");
                fru.setStringProperty("_Model", TreefrogReport.stripHeader(esm.getPartNumber(), PART_PREFIX));
                fru.setStringProperty("_Firmware", esm.getSoftwareVersion());
                fru.setStringProperty("_Vendor", esm.getManufacturer());
                fru.setStringProperty("_SerialNumber", esm.getSerialNumber().trim());
                fru.setStringProperty("_FruNumber", esm.getSerialNumber().trim());
                fru.setStringProperty("IdentifyingNumber", esm.getSerialNumber().trim());
                fru.setStringProperty("ProductID", this.stripHeader(esm.getProductID()));
                fru.setStringProperty("ManufactureDate", Utility.convertDate(esm.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing esm data");
        }
    }

    private void createSFP(ReportClass system, Sfp sfp, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("sfp");
        try {
            Location location = sfp.getPhysicalLocation();
            repClass.setStringProperty("_Caption", "SFP");
            repClass.setStringProperty("_Description", "Small Form Pluggable");
            String parentID = "unknown";
            String parentName = "unknown";
            String nameExtention = null;
            String idExtention = null;
            SFPParentTypeData parent = sfp.getParentData();
            int ptype = parent.getSfpParentType().getValue();
            if (ptype == 3) {
                repClass.setStringProperty("parentType", "Controller");
                ControllerSFP controller = parent.getControllerSFP();
                parentID = TreefrogReport.findControllerDeviceID(bundle, controller.getParentController());
                parentName = TreefrogReport.findControllerName(bundle, controller.getParentController());
                repClass.setStringProperty("parent", parentID);
                repClass.setStringProperty("channel", "" + controller.getChannel());
                int type = controller.getControllerSFPType().getValue();
                if (type == 2) {
                    repClass.setStringProperty("type", "DriveSide");
                    nameExtention = ".SFP.Expansion";
                    idExtention = "sfp3";
                } else if (type == 1) {
                    repClass.setStringProperty("type", "HostSide");
                    nameExtention = ".SFP.Host" + controller.getChannel();
                    idExtention = "sfp" + controller.getChannel();
                }
            } else if (ptype == 1) {
                parentID = TreefrogReport.findEsmDeviceID(bundle, parent.getParentEsm());
                parentName = TreefrogReport.findEsmName(bundle, parent.getParentEsm());
                repClass.setStringProperty("parentType", "IOM");
                repClass.setStringProperty("parent", parentID);
                nameExtention = ".SFP.Port" + sfp.getSfpPort().getValue();
                idExtention = "sfp" + sfp.getSfpPort().getValue();
            } else if (ptype == 2) {
                parentName = parentID = "minihub:" + Utility.bytesArrayString(parent.getParentMinihub().getRefToken());
                repClass.setStringProperty("parentType", "Minihub");
                repClass.setStringProperty("minihubRef", Utility.bytesArrayString(parent.getParentMinihub().getRefToken()));
            }
            String name = null;
            String deviceID = null;
            if (nameExtention == null) {
                name = TreefrogReport.findSfpName(parentName, sfp.getSfpRef());
                deviceID = TreefrogReport.findSfpDeviceID(parentID, sfp.getSfpRef());
            } else {
                name = parentName + nameExtention;
                deviceID = parentID + idExtention;
            }
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("port", "" + sfp.getSfpPort().getValue());
            repClass.setStringProperty("connectType", Translator.translateSfpConnectType(sfp.getSfpType().getSfpConnectType()));
            repClass.setStringProperty("identType", Translator.translateSfpIdentType(sfp.getSfpType().getSfpIdentType()));
            repClass.setStringProperty("linkType", Translator.translateSfpLinkType(sfp.getSfpType().getSfpLinkLType()));
            repClass.setStringProperty("speed", Translator.translateSfpSpeed(sfp.getSfpType().getSfpSpeed()));
            repClass.setStringProperty("transmissionMedia", Translator.translateSfpXmitMedia(sfp.getSfpType().getSfpTransmissionMedia()));
            repClass.setStringProperty("transmitterType", Translator.translateSfpXmitType(sfp.getSfpType().getSfpTransmitterType()));
            repClass.setStringProperty("OUI", Utility.bytesArrayString(sfp.getSfpType().getVendorOUI()));
            String status = Translator.translateSfpStatus(sfp.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            if (sfp.getStatus().getValue() != 3) {
                String key = this.createKey(sfp.getSfpType().getVendorName(), sfp.getSfpType().getVendorPN(), sfp.getSfpType().getVendorSN());
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "SFP");
                fru.setStringProperty("_Model", sfp.getSfpType().getVendorPN().trim());
                fru.setStringProperty("_Firmware", "N/A");
                fru.setStringProperty("_Vendor", sfp.getSfpType().getVendorName().trim());
                fru.setStringProperty("_SerialNumber", sfp.getSfpType().getVendorSN().trim());
                fru.setStringProperty("_FruNumber", sfp.getSfpType().getVendorSN().trim());
                fru.setStringProperty("IdentifyingNumber", sfp.getSfpType().getVendorSN().trim());
                fru.setStringProperty("PartNumber", sfp.getSfpType().getVendorPN().trim());
                fru.setStringProperty("ManufactureDate", Utility.convertDate(sfp.getSfpType().getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing sfp data");
        }
    }

    private void createFan(ReportClass system, Fan fan, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("fan");
        try {
            Location location = fan.getPhysicalLocation();
            byte[] refToken = fan.getFanRef().getRefToken();
            String name = TreefrogReport.createName("Fan", bundle, location);
            String deviceID = TreefrogReport.createDeviceID("fan", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Fan");
            repClass.setStringProperty("_Description", "Fan");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateFanStatus(fan.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing fan data");
        }
    }

    private void createPowerSupply(ReportClass system, PowerSupply powerSupply, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("pcu");
        try {
            Location location = powerSupply.getPhysicalLocation();
            byte[] refToken = powerSupply.getPowerSupplyRef().getRefToken();
            String name = TreefrogReport.createName("PowerSupply", bundle, location);
            String deviceID = TreefrogReport.createDeviceID("psm", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "PowerSupply");
            repClass.setStringProperty("_Description", "Power Supply Module");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("fruType", powerSupply.getFruType());
            String status = Translator.translatePowerSupplyStatus(powerSupply.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            String partNumber = TreefrogReport.stripHeader(powerSupply.getPartNumber(), PART_PREFIX);
            String serialNumber = TreefrogReport.stripHeader(powerSupply.getSerialNumber(), SERIAL_PREFIX);
            boolean assetDataExists = true;
            if (partNumber.equals("") && serialNumber.equals("")) {
                assetDataExists = false;
            }
            if (powerSupply.getStatus().getValue() != 3 && assetDataExists) {
                String key = this.createKey(powerSupply.getVendorName(), partNumber, serialNumber);
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Power Supply");
                fru.setStringProperty("_Vendor", powerSupply.getVendorName());
                fru.setStringProperty("_Model", partNumber);
                fru.setStringProperty("_Firmware", "N/A");
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("PartNumber", partNumber);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(powerSupply.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing power supply data");
        }
    }

    private void createTempSensor(ReportClass system, ThermalSensor sensor, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("tempsensor");
        try {
            Location location = sensor.getPhysicalLocation();
            byte[] ref = sensor.getThermalSensorRef().getRefToken();
            String name = TreefrogReport.createName(SENSOR_NAME, bundle, location, ref);
            String deviceID = TreefrogReport.createDeviceID(SENSOR_TYPE, bundle, location, ref);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "TemperatureSensor");
            repClass.setStringProperty("_Description", "Temperature Sensor (Non Numeric)");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateTempStatus(sensor.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing temp sensor data");
        }
    }

    private void createBattery(ReportClass system, Battery battery, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("battery");
        try {
            Location location = battery.getPhysicalLocation();
            byte[] ref = battery.getBatteryRef().getRefToken();
            ControllerRef cref = battery.getBatteryTypeData().getParentController();
            String parentID = TreefrogReport.findControllerDeviceID(bundle, battery.getBatteryTypeData().getParentController());
            String parentName = TreefrogReport.findControllerName(bundle, battery.getBatteryTypeData().getParentController());
            String name = parentName + ".Battery";
            String deviceID = parentID + "bat";
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "CacheBattery");
            repClass.setStringProperty("_Description", "Cache Battery");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("batteryAge", "" + battery.getBatteryAge() + " Days");
            repClass.setStringProperty("lifeRemaining", "" + battery.getBatteryLifeRemaining() + " Days");
            repClass.setStringProperty("type", Translator.translateBatteryType(battery.getBatteryTypeData().getBatteryType()));
            repClass.setStringProperty("parentController", parentName);
            String status = Translator.translateBatteryStatus(battery.getStatus());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing battery data");
        }
    }

    private void createDefaultBattery(ReportClass system, String parentID, String parentName) {
        ReportClass repClass = system.newSubInstance("battery");
        try {
            String name = parentName + ".Battery";
            String deviceID = parentID + "bat";
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "CacheBattery");
            repClass.setStringProperty("_Description", "Cache Battery");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("batteryAge", "Data Unavailable");
            repClass.setStringProperty("lifeRemaining", "Data Unavailable");
            repClass.setStringProperty("type", "Data Unavailable");
            repClass.setStringProperty("parentController", parentName);
            String status = "Unknown";
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing battery data");
        }
    }

    private void createStoragePool(ReportClass system, VolumeGroup volumeGroup, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("vdisk");
        try {
            boolean online;
            String deviceID = Utility.wwnString(volumeGroup.getWorldWideName());
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_Caption", "Vdisk");
            repClass.setStringProperty("_Description", "Logical concatenation of disk drives");
            repClass.setStringProperty("_ElementName", "vdisk." + volumeGroup.getSequenceNum());
            repClass.setStringProperty("_Name", "vdisk." + volumeGroup.getSequenceNum());
            repClass.setStringProperty("offline", "" + volumeGroup.getOffline());
            repClass.setStringProperty("WWN", Utility.wwnString(volumeGroup.getWorldWideName()));
            repClass.setStringProperty("_RaidLevel", Translator.translateRaidLevel(volumeGroup.getRaidLevel().getValue()));
            repClass.setStringProperty("_MountState", "mounted");
            repClass.setStringProperty("_Operation", "none");
            repClass.setStringProperty("sequenceNum", "" + volumeGroup.getSequenceNum());
            boolean bl = online = !volumeGroup.getOffline();
            if (online) {
                repClass.setStringProperty("_Status", "OK");
                repClass.setStringProperty("_RawStatus", "Online");
                repClass.setStringProperty("_EnabledState", "2");
                repClass.setStringProperty("_Availability", "Running/Full Power");
            } else {
                repClass.setStringProperty("_Status", "Other");
                repClass.setStringProperty("_RawStatus", "Off Line");
                repClass.setStringProperty("_EnabledState", "3");
                repClass.setStringProperty("_Availability", "Off Line");
                repClass.setStringProperty("_OtherEnabledState", "Disabled");
            }
            StringBuffer diskSet = new StringBuffer();
            StringBuffer basis = new StringBuffer();
            byte[] vgRef = volumeGroup.getVolumeGroupRef().getRefToken();
            Drive[] drives = bundle.getDrive();
            double poolCapacity = 0.0;
            int x = 0;
            while (x < drives.length) {
                byte[] driveVGRef = drives[x].getCurrentVolumeGroupRef().getRefToken();
                if (Utility.rawCompare(vgRef, driveVGRef)) {
                    Location location = drives[x].getPhysicalLocation();
                    Tray tray = Utility.findTray(bundle, location.getTrayRef());
                    String diskKey = "t" + tray.getTrayId() + DRIVE_TYPE + location.getSlot();
                    if (diskSet.length() > 0) {
                        diskSet.append(", ");
                        basis.append(", ");
                    }
                    diskSet.append("\"" + diskKey + "\"");
                    basis.append("\"disk:" + diskKey + "\"");
                    poolCapacity += (double)drives[x].getUsableCapacity();
                }
                ++x;
            }
            repClass.setStringProperty("_BasedOn", basis.toString());
            repClass.setStringProperty("diskSet", diskSet.toString());
            double usablePoolCapacity = 0.0;
            Volume[] volumes = bundle.getVolume();
            int i = 0;
            while (i < volumes.length) {
                byte[] volVgRef = volumes[i].getVolumeGroupRef().getRefToken();
                if (Utility.rawCompare(vgRef, volVgRef)) {
                    usablePoolCapacity += (double)volumes[i].getCapacity();
                }
                ++i;
            }
            FreeExtent[] freeExtent = bundle.getFreeExtent();
            int i2 = 0;
            while (i2 < freeExtent.length) {
                byte[] feVgRef = freeExtent[i2].getVolumeGroupRef().getRefToken();
                if (Utility.rawCompare(vgRef, feVgRef)) {
                    usablePoolCapacity += (double)freeExtent[i2].getRawCapacity();
                }
                ++i2;
            }
            String units = "Bytes";
            if (usablePoolCapacity >= TB) {
                usablePoolCapacity /= TB;
                units = "TB";
            } else if (usablePoolCapacity >= 1.073741824E9) {
                usablePoolCapacity /= 1.073741824E9;
                units = "GB";
            } else if (usablePoolCapacity >= 1048576.0) {
                usablePoolCapacity /= 1048576.0;
                units = "MB";
            }
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMaximumFractionDigits(2);
            String output = formatter.format(usablePoolCapacity);
            repClass.setStringProperty("_Capacity", formatter.format(usablePoolCapacity) + " " + units);
            if (poolCapacity >= TB) {
                poolCapacity /= TB;
                units = "TB";
            } else if (poolCapacity >= 1.073741824E9) {
                poolCapacity /= 1.073741824E9;
                units = "GB";
            } else if (poolCapacity >= 1048576.0) {
                poolCapacity /= 1048576.0;
                units = "MB";
            } else {
                units = "Bytes";
            }
            repClass.setStringProperty("rawCapacity", formatter.format(poolCapacity) + " " + units);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing storage vdisk data");
        }
    }

    private String normalizeCapacity(long capacity) {
        String units = "Bytes";
        if (capacity <= 0L) {
            return "0 " + units;
        }
        if (capacity >= 0x40000000L) {
            capacity /= 0x40000000L;
            units = "GB";
        } else if (capacity >= 0x100000L) {
            capacity /= 0x100000L;
            units = "MB";
        } else {
            units = "Bytes";
        }
        return capacity + " " + units;
    }

    private void createVolume(ReportClass system, Volume volume, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("volume");
        try {
            String deviceID = Utility.wwnString(volume.getWorldWideName());
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_Caption", "Volume");
            repClass.setStringProperty("_Description", "Subset of a Vdisk");
            repClass.setStringProperty("_ElementName", Utility.userLabelString(volume.getLabel()));
            repClass.setStringProperty("_Name", Utility.userLabelString(volume.getLabel()));
            VolumeRef volRef = volume.getVolumeRef();
            repClass.setStringProperty("WWN", Utility.wwnString(volume.getWorldWideName()));
            repClass.setStringProperty("handle", "" + volume.getVolumeHandle());
            repClass.setStringProperty("_BlockSize", "" + volume.getBlkSize() + " bytes");
            repClass.setStringProperty("_NumberOfBlocks", "" + volume.getCapacity() / (long)volume.getBlkSize());
            long capacity = volume.getCapacity();
            repClass.setStringProperty("_Capacity", this.normalizeCapacity(capacity));
            repClass.setStringProperty("_action", Translator.translateVolumeAction(volume.getAction().getValue()));
            String currentManager = TreefrogReport.findControllerName(bundle, volume.getCurrentManager());
            String preferredManager = TreefrogReport.findControllerName(bundle, volume.getPreferredManager());
            repClass.setStringProperty("currentManager", currentManager);
            repClass.setStringProperty("preferredManager", preferredManager);
            String preferred = "false";
            if (currentManager != null && preferredManager != null && currentManager.equals(preferredManager)) {
                preferred = "true";
            }
            repClass.setStringProperty("onPreferredManager", preferred);
            repClass.setStringProperty("extremeProtection", "" + volume.getExtremeProtection());
            repClass.setStringProperty("offline", "" + volume.getOffline());
            repClass.setStringProperty("raidLevel", Translator.translateRaidLevel(volume.getRaidLevel().getValue()));
            repClass.setStringProperty("reconPriority", TreefrogReport.interpretPriority(volume.getReconPriority()));
            repClass.setStringProperty("readable", "" + volume.getPerms().getReadable());
            repClass.setStringProperty("writable", "" + volume.getPerms().getWritable());
            repClass.setStringProperty("copySource", "" + volume.getPerms().getCopySource());
            repClass.setStringProperty("copyTarget", "" + volume.getPerms().getCopyTarget());
            repClass.setStringProperty("format", "" + volume.getPerms().getFormat());
            repClass.setStringProperty("mapToLUN", "" + volume.getPerms().getMapToLUN());
            repClass.setStringProperty("mirrorPrimary", "" + volume.getPerms().getMirrorPrimary());
            repClass.setStringProperty("mirrorSecondary", "" + volume.getPerms().getMirrorSecondary());
            repClass.setStringProperty("reconfigure", "" + volume.getPerms().getReconfigure());
            repClass.setStringProperty("snapshot", "" + volume.getPerms().getSnapShot());
            String status = Translator.translateVolumeStatus(volume.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineStatus(status));
            repClass.setStringProperty("_EnabledState", this.determineState(status));
            repClass.setStringProperty("_Availability", this.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            String parentPool = this.findPoolName(bundle, volume.getVolumeGroupRef());
            repClass.setStringProperty("_SourceVdisk", parentPool);
            repClass.setStringProperty("_VolumeStatus", status);
            repClass.setStringProperty("mediaScan", TreefrogReport.booleanEnabledString(volume.getMediaScan().getEnable()));
            repClass.setStringProperty("parityValidation", TreefrogReport.booleanEnabledString(volume.getMediaScan().getParityValidationEnable()));
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing data");
        }
    }

    public static String booleanEnabledString(boolean value) {
        return value ? "Enabled" : "Disabled";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createPort(ReportClass system, IOInterfaceTypeData port, ObjectBundle bundle, Controller controller, int index) {
        ReportClass repClass = system.newSubInstance("fcport");
        try {
            Location location = controller.getPhysicalLocation();
            String ctlrName = TreefrogReport.createName("Controller", bundle, location);
            int type = port.getInterfaceType().getValue();
            if (type == 2) {
                FibreInterface fc = port.getFibre();
                String deviceID = Utility.wwnString(fc.getPortName()).toLowerCase();
                repClass.setKey(deviceID);
                repClass.setStringProperty("_DeviceID", deviceID);
                repClass.setStringProperty("_Caption", "FibrePort");
                repClass.setStringProperty("_Description", "Fibre Port");
                repClass.setStringProperty("_ElementName", ctlrName + ".FCPort.Host" + fc.getChannel());
                repClass.setStringProperty("_Name", ctlrName + ".FCPort.Host" + fc.getChannel());
                repClass.setStringProperty("channelMiswire", "" + fc.getChanMiswire());
                repClass.setStringProperty("channel", "" + fc.getChannel());
                repClass.setStringProperty("esmMiswire", "" + fc.getEsmMiswire());
                repClass.setStringProperty("hardAddress", "" + fc.getHardAddress());
                repClass.setStringProperty("degraded", "" + fc.getIsDegraded());
                repClass.setStringProperty("loopID", "" + fc.getLoopID());
                repClass.setStringProperty("maxSpeed", "" + fc.getMaxSpeed() + " MB/sec");
                repClass.setStringProperty("part", fc.getPart());
                repClass.setStringProperty("speed", "" + fc.getSpeed() + " MB/sec");
                int sc = fc.getSpeedControl().getValue();
                repClass.setStringProperty("speedControl", Translator.translateSpeedControl(sc));
                repClass.setStringProperty("speedNegError", "" + fc.getSpeedNegError());
                repClass.setStringProperty("Topology", Translator.translateTopologyType(fc.getTopology().getValue()));
                repClass.setStringProperty("part", fc.getPart());
                repClass.setStringProperty("revision", "" + fc.getRevision());
                repClass.setStringProperty("portID", Utility.bytesArrayString(fc.getPortId()));
                repClass.setStringProperty("_WWN", Utility.wwnString(fc.getPortName()).toLowerCase());
                repClass.setStringProperty("NodeWWN", Utility.wwnString(fc.getNodeName()).toLowerCase());
                int temp = fc.getLinkStatus().getValue();
                String status = Translator.translateLinkStatus(temp);
                repClass.setStringProperty("_linkStatus", status);
                repClass.setStringProperty("_RawStatus", status);
                repClass.setStringProperty("_Status", this.determineStatus(status));
                repClass.setStringProperty("_EnabledState", this.determineState(status));
                repClass.setStringProperty("_Availability", this.determineAvailability(status));
                repClass.setStringProperty("_OtherEnabledState", status);
                return;
            }
            if (type != 1) return;
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing port data");
        }
    }

    private String createKey(String vendor, String part, String serialNum) {
        String key = TreefrogReport.stripHeader(vendor, VENDOR_PREFIX) + "." + TreefrogReport.stripHeader(part, PART_PREFIX) + "." + TreefrogReport.stripHeader(serialNum, SERIAL_PREFIX);
        return key.trim();
    }

    private String stripHeader(String data) {
        data = data.trim();
        String value = "";
        int index = data.indexOf(" ");
        value = index >= 0 ? data.substring(index + 1) : data;
        return value.trim();
    }

    private static String stripHeader(String data, String type) {
        data = data.trim();
        String value = "";
        int index = data.indexOf(type + " ");
        value = index >= 0 ? data.substring(index + type.length()) : data;
        return value.trim();
    }

    private String determineStatus(String data) {
        String value = "Unknown";
        if (data.equals("Optimal")) {
            value = "OK";
        } else if (data.equals("Failed")) {
            value = "Error";
        } else if (data.equals("Removed")) {
            value = "Other";
        } else if (data.equals("Charging")) {
            value = "Other";
        } else if (data.equals("Near Expiration")) {
            value = "OK";
        } else if (data.equals("Not in Config")) {
            value = "Other";
        } else if (data.equals("Unknown")) {
            value = "Unknown";
        } else if (data.equals("RPA Parity Error")) {
            value = "Error";
        } else if (data.equals("Bypassed")) {
            value = "Bypassed";
        } else if (data.equals("Replaced")) {
            value = "OK";
        } else if (data.equals("Unresponsive")) {
            value = "No Contact";
        } else if (data.equals("OverMaxTemp")) {
            value = "Error";
        } else if (data.equals("OverTemp")) {
            value = "Stressed";
        } else if (data.equals("Degraded")) {
            value = "Degraded";
        } else if (data.equals("Impaired")) {
            value = "Degraded";
        } else if (data.equals("Up")) {
            value = "OK";
        } else if (data.equals("Down")) {
            value = "Other";
        } else if (data.equals("Service")) {
            value = "Other";
        }
        return value;
    }

    private String determineState(String data) {
        String value = "0";
        if (data.equals("Optimal")) {
            value = "2";
        } else if (data.equals("Failed")) {
            value = "6";
        } else if (data.equals("Removed")) {
            value = "1";
        } else if (data.equals("Charging")) {
            value = "2";
        } else if (data.equals("Near Expiration")) {
            value = "2";
        } else if (data.equals("Not in Config")) {
            value = "1";
        } else if (data.equals("Unknown")) {
            value = "0";
        } else if (data.equals("RPA Parity Error")) {
            value = "6";
        } else if (data.equals("Bypassed")) {
            value = "3";
        } else if (data.equals("Replaced")) {
            value = "2";
        } else if (data.equals("Unresponsive")) {
            value = "1";
        } else if (data.equals("OverMaxTemp")) {
            value = "2";
        } else if (data.equals("OverTemp")) {
            value = "2";
        } else if (data.equals("Degraded")) {
            value = "2";
        } else if (data.equals("Impaired")) {
            value = "2";
        } else if (data.equals("Up")) {
            value = "2";
        } else if (data.equals("Down")) {
            value = "3";
        } else if (data.equals("Service")) {
            value = "3";
        }
        return value;
    }

    private String determineAvailability(String data) {
        String value = "Unknown";
        if (data.equals("Optimal")) {
            value = "Running/Full Power";
        } else if (data.equals("Failed")) {
            value = "Warning";
        } else if (data.equals("Removed")) {
            value = "Not Installed";
        } else if (data.equals("Charging")) {
            value = "Degraded";
        } else if (data.equals("Near Expiration")) {
            value = "Running/Full Power";
        } else if (data.equals("Not in Config")) {
            value = "Other";
        } else if (data.equals("Unknown")) {
            value = "Unknown";
        } else if (data.equals("RPA Parity Error")) {
            value = "Warning";
        } else if (data.equals("Bypassed")) {
            value = "Quiesced";
        } else if (data.equals("Replaced")) {
            value = "Running/Full Power";
        } else if (data.equals("Unresponsive")) {
            value = "Unknown";
        } else if (data.equals("OverMaxTemp")) {
            value = "Warning";
        } else if (data.equals("OverTemp")) {
            value = "Warning";
        } else if (data.equals("Degraded")) {
            value = "Warning";
        } else if (data.equals("Impaired")) {
            value = "Warning";
        } else if (data.equals("Up")) {
            value = "Running/Full Power";
        } else if (data.equals("Down")) {
            value = "Off Line";
        } else if (data.equals("Service")) {
            value = "Off Line";
        }
        return value;
    }

    private static String interpretPriority(int priority) {
        String description;
        switch (priority) {
            case 0: {
                description = "Very high (0 on a scale of 0-4)";
                break;
            }
            case 1: {
                description = "High (1 on a scale of 0-4)";
                break;
            }
            case 2: {
                description = "Medium (2 on a scale of 0-4)";
                break;
            }
            case 3: {
                description = "Low (3 on a scale of 0-4)";
                break;
            }
            case 4: {
                description = "Very low (4 on a scale of 0-4)";
                break;
            }
            default: {
                description = "Not specified";
            }
        }
        return description;
    }

    private static String createDeviceID(String component, ObjectBundle bundle, Location location) {
        String tray = "X";
        String slot = "Y";
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = "X";
                slot = "Y";
            } else if (location == null) {
                slot = "Y";
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = "" + physicalTray.getTrayId();
                slot = "" + location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return "t" + tray + component + slot;
    }

    private static String createDeviceID(String component, ObjectBundle bundle, Location location, byte[] ref) {
        return TreefrogReport.createDeviceID(component, bundle, location, ref, 10);
    }

    private static String createDeviceID(String component, ObjectBundle bundle, Location location, byte[] ref, int idx) {
        String tray = "X";
        String slot = "Y";
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = "X";
                slot = "Y";
            } else if (location == null) {
                slot = "Y";
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = "" + physicalTray.getTrayId();
                slot = "" + location.getSlot() + ":" + ref[idx];
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String id = "t" + tray + component + slot;
        if (SENSOR_TYPE.equals(component)) {
            id = "t" + tray + component + ref[idx];
        }
        return id;
    }

    private static String createName(String component, ObjectBundle bundle, Location location) {
        int tray = -1;
        int slot = -1;
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = -1;
                slot = -1;
            } else if (location == null) {
                slot = -1;
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = physicalTray.getTrayId();
                slot = location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "Tray." + tray + "." + component + "." + Translator.getSlotName(slot);
        if (DRIVE_NAME.equals(component)) {
            name = "Tray." + tray + "." + component + "." + slot;
        }
        return name;
    }

    private static String createName(String component, ObjectBundle bundle, Location location, byte[] ref) {
        return TreefrogReport.createName(component, bundle, location, ref, 10);
    }

    private static String createName(String component, ObjectBundle bundle, Location location, byte[] ref, int idx) {
        int tray = -1;
        int slot = -1;
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = -1;
                slot = -1;
            } else if (location == null) {
                slot = -1;
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = physicalTray.getTrayId();
                slot = location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "Tray." + tray + "." + component + "." + Translator.getSlotName(slot) + ":" + ref[idx];
        if (DRIVE_NAME.equals(component)) {
            name = "Tray." + tray + "." + component + "." + slot + ":" + ref[idx];
        } else if (SENSOR_NAME.equals(component)) {
            name = "Tray." + tray + "." + component + "." + ref[idx];
        }
        return name;
    }

    public static String findControllerName(ObjectBundle bundle, ControllerRef cref) {
        return TreefrogReport.findControllerIdentifier(bundle, cref, 2);
    }

    public static String findControllerDeviceID(ObjectBundle bundle, ControllerRef cref) {
        return TreefrogReport.findControllerIdentifier(bundle, cref, 1);
    }

    private static String findControllerIdentifier(ObjectBundle bundle, ControllerRef cref, int format) {
        byte[] target = cref.getRefToken();
        String name = "cnf";
        try {
            Controller[] controllers = bundle.getController();
            int x = 0;
            while (x < controllers.length) {
                byte[] token = controllers[x].getControllerRef().getRefToken();
                if (Utility.rawCompare(target, token)) {
                    name = format == 1 ? TreefrogReport.createDeviceID(CONTROLLER_TYPE, bundle, controllers[x].getPhysicalLocation()) : TreefrogReport.createName("Controller", bundle, controllers[x].getPhysicalLocation());
                    break;
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findEsmName(ObjectBundle bundle, ComponentRef cref) {
        return TreefrogReport.findEsmIdentifier(bundle, cref, 2);
    }

    public static String findEsmDeviceID(ObjectBundle bundle, ComponentRef cref) {
        return TreefrogReport.findEsmIdentifier(bundle, cref, 1);
    }

    private static String findEsmIdentifier(ObjectBundle bundle, ComponentRef ref, int format) {
        byte[] target = ref.getRefToken();
        String name = "cnf";
        try {
            Esm[] esms = bundle.getComponentBundle().getEsm();
            int x = 0;
            while (x < esms.length) {
                byte[] token = esms[x].getEsmRef().getRefToken();
                if (Utility.rawCompare(target, token)) {
                    name = format == 1 ? TreefrogReport.createDeviceID("iom", bundle, esms[x].getPhysicalLocation()) : TreefrogReport.createName("IOM", bundle, esms[x].getPhysicalLocation());
                    break;
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    private String findPoolName(ObjectBundle bundle, VolumeGroupRef ref) {
        return this.findPoolIdentifier(bundle, ref, 2);
    }

    private String findPoolDeviceID(ObjectBundle bundle, VolumeGroupRef ref) {
        return this.findPoolIdentifier(bundle, ref, 1);
    }

    private String findPoolIdentifier(ObjectBundle bundle, VolumeGroupRef ref, int format) {
        byte[] target = ref.getRefToken();
        String name = "cnf";
        try {
            VolumeGroup[] pools = bundle.getVolumeGroup();
            int x = 0;
            while (x < pools.length) {
                byte[] token = pools[x].getVolumeGroupRef().getRefToken();
                if (Utility.rawCompare(target, token)) {
                    name = format == 1 ? Utility.wwnString(pools[x].getWorldWideName()) : "vdisk." + pools[x].getSequenceNum();
                    break;
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findSfpName(String parentID, ComponentRef ref) {
        return TreefrogReport.findSfpIdentifier(parentID, ref, 2);
    }

    public static String findSfpDeviceID(String parentID, ComponentRef ref) {
        return TreefrogReport.findSfpIdentifier(parentID, ref, 1);
    }

    private static String findSfpIdentifier(String parent, ComponentRef sfpRef, int format) {
        String name = "sfp.unknown";
        try {
            byte[] token = sfpRef.getRefToken();
            name = format == 1 ? parent + ":sfp." + token[10] : parent + ".SFP." + token[10];
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    static {
        MB = 0x100000;
        GB = 0x40000000;
        TB = Math.pow(1024.0, 4.0);
        CONTROLLER = 1;
        DRIVE = 2;
        ESM = 3;
        NO_CONTACT = NO_CONTACT;
        MISSING_DATA = MISSING_DATA;
        GOOD_CONNECTION = GOOD_CONNECTION;
        DRIVE_NAME = DRIVE_NAME;
        DRIVE_TYPE = DRIVE_TYPE;
        SENSOR_NAME = SENSOR_NAME;
        SENSOR_TYPE = SENSOR_TYPE;
        CONTROLLER_TYPE = CONTROLLER_TYPE;
        ESM_TYPE = "iom";
        IOM_TYPE = "iom";
        DEVICE_ID_FORMAT = 1;
        NAME_FORMAT = 2;
        VENDOR_PREFIX = VENDOR_PREFIX;
        PART_PREFIX = PART_PREFIX;
        SERIAL_PREFIX = SERIAL_PREFIX;
        TYPE_PREFIX = TYPE_PREFIX;
        SBOD_IOM_TYPE = SBOD_IOM_TYPE;
        SATA_IOM_TYPE = SATA_IOM_TYPE;
        MAX_RETRIES = 2;
    }
}

