/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.smis;

import com.sun.netstorage.fm.storade.resource.discovery.AbstractProbe;
import com.sun.netstorage.fm.storade.resource.discovery.ProbeResult;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.util.LocalizedString;
import com.sun.netstorage.fm.wbem.client.Discover;
import com.sun.netstorage.fm.wbem.client.SystemProperties;
import java.util.Properties;

public class SMISProbe
extends AbstractProbe {
    public ProbeResult probe(Properties search) {
        String[] ns;
        String cimIP = search.getProperty("ip");
        String cimUser = search.getProperty("login");
        String cimPass = search.getProperty("password");
        if (cimIP == null) {
            return new ProbeResult("#ARG_ERROR", new LocalizedString("ip address missing"));
        }
        Discover disco = new Discover();
        disco.setHost(cimIP);
        disco.setAuthentication(cimUser, cimPass);
        try {
            ns = disco.getNameSpaces();
        }
        catch (Exception e) {
            return new ProbeResult("#ERROR", new LocalizedString(e));
        }
        ProbeResult result = new ProbeResult();
        int i = 0;
        while (i < ns.length) {
            if (!"/interop".equals(ns[i])) {
                SystemProperties[] systems = disco.findSystems(ns[i]);
                int j = 0;
                while (j < systems.length) {
                    SystemProperties sys = systems[j];
                    DeviceProperties p = new DeviceProperties();
                    if ("storage".equals(sys.getType())) {
                        p.setType("smis");
                        p.setKey(sys.getClassName() + "." + sys.getName());
                        p.setWWN(sys.getWwn());
                        p.setIP(sys.getIp());
                        p.setLabel(sys.getUserLabel());
                        p.setClass("storage.smis");
                        p.setName(sys.getName());
                        p.setProperty("cimHost", cimIP);
                        p.setProperty("cimUser", cimUser);
                        p.setProperty("cimPass", cimPass);
                        p.setProperty("cimClass", sys.getClassName());
                        p.setProperty("cimNameSpace", ns[i]);
                        result.addDevice(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }
}

