/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.minnow.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ControllerToken {
    private String descp;
    private String status;
    private String fwrev;
    private String boot_ver;
    private String name;
    private String id;
    private String primary_sn;
    private String secondary_sn;
    private String cache_size;
    private String cpu;
    private static final String sccs_id = "@(#)ControllerToken.java\t";

    public ControllerToken() {
        this.descp = null;
        this.status = null;
        this.fwrev = null;
        this.boot_ver = null;
        this.name = null;
        this.id = null;
        this.primary_sn = null;
        this.secondary_sn = null;
        this.cache_size = null;
        this.cpu = null;
    }

    public ControllerToken(String descp, String status, String fwrev, String boot_ver, String name, String id, String primary_sn, String secondary_sn, String cache_size, String cpu) {
        this.descp = descp;
        this.status = status;
        this.fwrev = fwrev;
        this.boot_ver = boot_ver;
        this.name = name;
        this.id = id;
        this.primary_sn = primary_sn;
        this.secondary_sn = secondary_sn;
        this.cache_size = cache_size;
        this.cpu = cpu;
    }

    public ControllerToken(String input) {
        Vector<String> tempList = new Vector<String>();
        String output = "";
        try {
            StringTokenizer st = new StringTokenizer(input, "\n");
            while (st.hasMoreTokens()) {
                tempList.add(st.nextToken());
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < tempList.size()) {
            String tokenline = (String)tempList.get(i);
            if (tokenline.startsWith("<")) {
                output = output + tokenline + " ";
            }
            ++i;
        }
        this.parseXML(output);
    }

    public void parseXML(String xmlReport) {
        XmlDocument doc = null;
        try {
            doc = XmlDocument.createXmlDocument((InputSource)new InputSource(new StringReader(xmlReport)), (boolean)false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Element baseviewNode = doc.getDocumentElement();
        NamedNodeMap attr = baseviewNode.getAttributes();
        NodeList children = baseviewNode.getChildNodes();
        NodeList children2 = null;
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            if ("raidsystem".equals(cnode.getNodeName())) {
                children2 = cnode.getChildNodes();
            }
            ++j;
        }
        int m = 0;
        while (m < children2.getLength()) {
            Node ccnode = children2.item(m);
            Node ccChildNode = ccnode.getFirstChild();
            String setvalue = null;
            if (ccChildNode != null) {
                setvalue = ccChildNode.getNodeValue();
            }
            if (ccnode.getNodeType() == 3) {
                // empty if block
            }
            if ("name".equals(ccnode.getNodeName())) {
                this.descp = setvalue;
            } else if ("status".equals(ccnode.getNodeName())) {
                this.status = setvalue;
            } else if ("firmware_version".equals(ccnode.getNodeName())) {
                this.fwrev = setvalue;
            } else if ("bootrecord_revision".equals(ccnode.getNodeName())) {
                this.boot_ver = setvalue;
            } else if ("controller_name".equals(ccnode.getNodeName())) {
                this.name = setvalue;
            } else if ("unique_id".equals(ccnode.getNodeName())) {
                this.id = setvalue;
            } else if ("cache_size".equals(ccnode.getNodeName())) {
                this.cache_size = setvalue;
            } else if ("primary_sn".equals(ccnode.getNodeName())) {
                this.primary_sn = setvalue;
            } else if ("secondary_sn".equals(ccnode.getNodeName())) {
                this.secondary_sn = setvalue;
            } else if ("cpu".equals(ccnode.getNodeName())) {
                this.cpu = setvalue;
            }
            ++m;
        }
    }

    public String getDescp() {
        return this.descp;
    }

    public String getStatus() {
        return this.status;
    }

    public String getFwRev() {
        return this.fwrev;
    }

    public String getBootRev() {
        return this.boot_ver;
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getPrimarySN() {
        return this.primary_sn;
    }

    public String getSecondarySN() {
        return this.secondary_sn;
    }

    public String getCache() {
        return this.cache_size;
    }

    public String getCpu() {
        return this.cpu;
    }

    public int getNum() {
        int count = 2;
        if (this.primary_sn.equals("N/A") || this.primary_sn.length() == 0) {
            --count;
        }
        if (this.secondary_sn.equals("N/A") || this.secondary_sn.length() == 0) {
            --count;
        }
        return count;
    }

    static {
        sccs_id = sccs_id;
    }
}

