/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.minnow;

import com.sun.netstorage.fm.storade.device.storage.minnow.io.ChannelToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.ChannelTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.DiskToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.DiskTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.EventChecker;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.FruToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.FruTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.LogicalDiskToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.LogicalDiskTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.MinnowXmlReporter;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PartitionToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PeriDeviceToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PeriDeviceTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PortReporter;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PortTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.SysToken;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class MinnowReportGenerator
implements ReportGenerator {
    private Properties props;
    private String systemName;
    private String hostIPName;
    private String hostIPNum;
    private SysToken sysToken;
    private String systemWWN;
    private PortReporter portWWNReporter;
    private static final String PING = "ping ";
    private EventChecker eventChecker = null;
    private ArrayList ibData;
    private static final String REPORT_OK = "OK";
    private static final String REPORT_FAIL = "FAILURE";
    private static final String FULL_REDUNDANCY = "full";
    private static final String DEGRADED_REDUNDANCY = "degraded";
    private static final String LOST_REDUNDANCY = "lost";
    private static final String PCU_TYPE_NAME = "powerUnit";
    private static final String LOOP_TYPE_NAME = "loopCard";
    private static final String FAN_TYPE_NAME = "fan";
    private static final String DRIVE_TYPE_NAME = "diskDrive";
    private static final String VOLUME_TYPE_NAME = "volume";
    private static final String BATTERY_TYPE_NAME = "battery";
    private static final String CONTROLLER_TYPE_NAME = "controller";
    private static final int CONTROLLER = 1;
    private static final int PCU = 2;
    private static final int LOOP = 3;
    private static final int FAN = 4;
    private static final int DRIVE = 5;
    private static final int TEMPSENSOR = 6;
    private static final int VOLUME = 7;
    private static final int MIDPLANE = 8;
    private static final int FIBREPORT = 9;
    private static final int BATTERY = 10;
    private static final String NOT_AVAILABLE_INBAND = "Data not available";
    private static final String UNAVAILABLE_INTEGER = "0";
    private static final String NO_FABRIC_NAME = "0000000000000000";
    private static final String DATA_OK = "OK";
    private static final String DATA_STALE = "STALE";
    private static final String DATA_MISSING = "MISSING";
    private static final String TAG = "minnow";
    public static final String sccs_id = " ";

    public MinnowReportGenerator(Properties p) {
        this.props = p;
    }

    public ReportClass generateReport(Properties p, String content) {
        int i = 0;
        String ipname = p.getProperty("ip");
        MinnowXmlReporter xmlReporter = new MinnowXmlReporter(ipname);
        ReportClass system = new ReportClass("system");
        this.createSystem(system);
        String seedInfo = xmlReporter.getSeedInfo();
        System.out.println("finish seedInfo catch");
        FruTokenList fruTokenList = xmlReporter.createFruTokenList(seedInfo);
        Vector fruList = fruTokenList.getList();
        i = 0;
        while (i < fruList.size()) {
            FruToken fruToken = (FruToken)fruList.get(i);
            System.out.println("Debug: fru name: " + fruToken.getName());
            String name = fruToken.getName();
            if (name.endsWith("CONTROLLER")) {
                this.createController(system, fruToken);
            } else if (name.endsWith("BATTERY_BOARD")) {
                this.createBattery(system, fruToken);
            } else if (name.endsWith("POWER_SUPPLY")) {
                this.createPowerSupply(system, fruToken);
            } else if (name.endsWith("RAID_IOM") || name.endsWith("RAID_IO_BOARD")) {
                this.createIOM(system, fruToken);
            } else if (name.endsWith("JBOD_IOM")) {
                this.createIOM(system, fruToken);
            } else if (name.endsWith("CHASSIS_BKPLN")) {
                this.createChassis(system, fruToken);
            } else if (name.endsWith("TERMINNATOR_BOARD")) {
                this.createTerminator(system, fruToken);
            } else if (name.endsWith("EMU_BOARD")) {
                this.createEmu(system, fruToken);
            }
            ++i;
        }
        PortTokenList portTokenList = xmlReporter.createPortTokenList(seedInfo);
        ChannelTokenList channelTokenList = xmlReporter.createChannelTokenList(seedInfo);
        Vector chanList = channelTokenList.getList();
        i = 0;
        while (i < chanList.size()) {
            ChannelToken channelToken = (ChannelToken)chanList.get(i);
            this.createPort(system, channelToken, portTokenList);
            ++i;
        }
        DiskTokenList diskTokenList = xmlReporter.createDiskTokenList(seedInfo);
        Vector diskList = diskTokenList.getList();
        i = 0;
        while (i < diskList.size()) {
            DiskToken diskToken = (DiskToken)diskList.get(i);
            this.createDrive(system, diskToken);
            ++i;
        }
        PeriDeviceTokenList periDeviceTokenList = xmlReporter.createPeriDeviceTokenList(seedInfo);
        Vector periList = periDeviceTokenList.getList();
        i = 0;
        while (i < periList.size()) {
            PeriDeviceToken periDeviceToken = (PeriDeviceToken)periList.get(i);
            this.createPeriDevice(system, periDeviceToken);
            ++i;
        }
        LogicalDiskTokenList logicalDiskTokenList = xmlReporter.createLogicalDiskTokenList(seedInfo);
        Vector logicalList = logicalDiskTokenList.getList();
        i = 0;
        while (i < logicalList.size()) {
            LogicalDiskToken logicalDiskToken = (LogicalDiskToken)logicalList.get(i);
            this.createLogicalDisk(system, logicalDiskToken);
            ++i;
        }
        System.out.println(system.toXML());
        return system;
    }

    private void createSystem(ReportClass system) {
        try {
            String key = "2066ffdd";
            String arrayName = "charlie-minnow";
            String serialNumber = "0x002fdd";
            String firmware = "4.11E";
            system.setKey(key);
            system.setStringProperty("_Name", arrayName);
            system.setStringProperty("_Dedicated", "Storage");
            system.setStringProperty("_NameFormat", "Other");
            system.setStringProperty("_PrimaryOwnerName", "");
            system.setStringProperty("_PrimaryOwnerContact", "");
            system.setStringProperty("_IdentifyingNumber", serialNumber);
            system.setStringProperty("_Vendor", "Sun Microsystems");
            system.setStringProperty("_Version", "4.11E");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPeriDevice(ReportClass system, PeriDeviceToken periDeviceToken) {
        try {
            ReportClass repClass = system.newSubInstance("peri_device");
            String name = periDeviceToken.getName();
            String value = periDeviceToken.getValue();
            String status = periDeviceToken.getStatus();
            String deviceID = name;
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Peripheral_device");
            repClass.setStringProperty("_Description", name);
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPort(ReportClass system, ChannelToken channelToken, PortTokenList portTokenList) {
        try {
            ReportClass repClass = system.newSubInstance("channel");
            String idx = channelToken.getIdx();
            String logchl = channelToken.getLogchl();
            String mode = channelToken.getMode();
            String type = channelToken.getType();
            String pid = channelToken.getPid();
            String sid = channelToken.getSid();
            String term = channelToken.getTerm();
            String defclk = channelToken.getDefclk();
            String curclk = channelToken.getCurclk();
            String defwid = channelToken.getDefwid();
            String curwid = channelToken.getCurwid();
            String deviceID = idx;
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Channel");
            repClass.setStringProperty("_Description", "Fibre Port");
            repClass.setStringProperty("_Name", "Channel." + idx);
            repClass.setStringProperty("logchl", logchl);
            repClass.setStringProperty("mode", mode);
            repClass.setStringProperty("type", type);
            repClass.setStringProperty("pid", pid);
            repClass.setStringProperty("sid", sid);
            repClass.setStringProperty("term", term);
            repClass.setStringProperty("defclk", defclk);
            repClass.setStringProperty("curclk", curclk);
            repClass.setStringProperty("defwid", defwid);
            repClass.setStringProperty("curwid", curwid);
            repClass.setStringProperty("pid_wwn", portTokenList.getTargetWWN(idx, pid));
            repClass.setStringProperty("sid_wwn", portTokenList.getTargetWWN(idx, sid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createController(ReportClass system, FruToken fruToken) {
        String field = "ctrl";
        String key = CONTROLLER_TYPE_NAME;
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createBattery(ReportClass system, FruToken fruToken) {
        String field = BATTERY_TYPE_NAME;
        String key = BATTERY_TYPE_NAME;
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createPowerSupply(ReportClass system, FruToken fruToken) {
        String field = "pcu";
        String key = "AC_POWER_SUPPLY";
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createIOM(ReportClass system, FruToken fruToken) {
        String field = "iom";
        String key = "iom";
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createChassis(ReportClass system, FruToken fruToken) {
        String field = "midplane";
        String key = "midplane";
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createTerminator(ReportClass system, FruToken fruToken) {
        String field = "terminator";
        String key = "terminator";
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createEmu(ReportClass system, FruToken fruToken) {
        String field = "emu";
        String key = "emu";
        this.createFruCommon(system, fruToken, field, key);
    }

    private void createFruCommon(ReportClass system, FruToken fruToken, String field, String key) {
        try {
            ReportClass repClass = system.newSubInstance(field);
            String idx = fruToken.getIdx();
            String name = fruToken.getName();
            String serialnum = fruToken.getSerialNum();
            String part_num = fruToken.getPartNum();
            String status = fruToken.getStatus();
            String firmware = fruToken.getRevision();
            String vendor = fruToken.getVendor();
            String manu_date = fruToken.getManuDate();
            String manu_location = fruToken.getManuLocation();
            String model = fruToken.getModel();
            String description = fruToken.getDescription();
            String chassis_serial_number = fruToken.getSerialNum();
            String fru_location = fruToken.getFruLocation();
            if (serialnum.equalsIgnoreCase("N/A")) {
                serialnum = "unknown";
            }
            String deviceID = this.createCtrlKey(key, serialnum);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", key);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("_FirmwareVersion", firmware);
            repClass.setStringProperty("_Description", description);
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", this.determineFruStatus(status));
            String frukey = this.createKey(vendor, model, serialnum);
            repClass.setStringProperty("_Realized", frukey);
            ReportClass fru = system.newSubInstance("fru");
            fru.setKey(frukey);
            fru.setStringProperty("_Name", name);
            fru.setStringProperty("_Type", key);
            fru.setStringProperty("_Model", model);
            fru.setStringProperty("_Firmware", firmware);
            fru.setStringProperty("_Vendor", vendor);
            fru.setStringProperty("_SerialNumber", serialnum);
            fru.setStringProperty("_FruNumber", serialnum);
            fru.setStringProperty("ManufactureDate", manu_date);
            fru.setStringProperty("ManufactureLocation", manu_location);
            fru.setStringProperty("productID", part_num);
            fru.setStringProperty("IdentifyingNumber", serialnum);
            fru.setStringProperty("CanBeFRUed", "true");
            fru.setStringProperty("CustomerReplaceable", "true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createLogicalDisk(ReportClass system, LogicalDiskToken logicalDiskToken) {
        try {
            ReportClass repClass = system.newSubInstance("logical_drive");
            String ld_id = logicalDiskToken.getLid();
            String ld_idx = logicalDiskToken.getIdx();
            String assignment = logicalDiskToken.getAssignemnt();
            String status = logicalDiskToken.getStatus();
            String raid_level = logicalDiskToken.getRaidLevel();
            String write_policy = logicalDiskToken.getPolicy();
            String block_size = logicalDiskToken.getBlockSize();
            String driveNum = logicalDiskToken.getBlockSize();
            String physical_drive = logicalDiskToken.getPhysicalDrive();
            String size = logicalDiskToken.getSize();
            String total_partition = logicalDiskToken.getTotalPartition();
            repClass.setKey(ld_idx);
            repClass.setStringProperty("ld_id", ld_id);
            repClass.setStringProperty("_Name", ld_id);
            repClass.setStringProperty("ld_idx", ld_idx);
            repClass.setStringProperty("assignment", assignment);
            repClass.setStringProperty("status", status);
            repClass.setStringProperty("raid_level", raid_level);
            repClass.setStringProperty("write_policy", write_policy);
            repClass.setStringProperty("block_size", block_size);
            repClass.setStringProperty("driveNum", driveNum);
            repClass.setStringProperty("physical_drive", physical_drive);
            repClass.setStringProperty("size", size);
            repClass.setStringProperty("total_partition", total_partition);
            Vector v = logicalDiskToken.getParList();
            int i = 0;
            while (i < v.size()) {
                PartitionToken pToken = (PartitionToken)v.get(i);
                ReportClass parClass = system.newSubInstance("partition");
                parClass.setStringProperty("partition_idx", pToken.getIdx());
                parClass.setStringProperty("partition_offset", pToken.getOffset());
                parClass.setStringProperty("size", pToken.getSize());
                parClass.setStringProperty("mapping", pToken.getMapping());
                parClass.setStringProperty("_SourceVdisk", ld_id);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createDrive(ReportClass system, DiskToken diskToken) {
        try {
            ReportClass repClass = system.newSubInstance("disk");
            String deviceID = diskToken.getElementID();
            String channel = diskToken.getChannel();
            String target = diskToken.getTagetId();
            String serialNum = diskToken.getSerialNumber();
            String raw_status = diskToken.getStatus();
            String vendor = diskToken.getVendor();
            String model = diskToken.getModel();
            String firmware = diskToken.getRevision();
            String capacity = diskToken.getCapacity();
            String remaining_size = diskToken.getRemainingSize();
            String speed = diskToken.getSpeed();
            String ld_id = diskToken.getlogicalDiskSn();
            String ld_idx = diskToken.getlogicalDiskId();
            repClass.setKey(serialNum);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "DiskDrive");
            repClass.setStringProperty("_RawStatus", raw_status);
            repClass.setStringProperty("_Status", this.determineDiskStatus(raw_status));
            repClass.setStringProperty("_Description", vendor + " Disk Drive");
            repClass.setStringProperty("_Model", model);
            repClass.setStringProperty("firmware", firmware);
            repClass.setStringProperty("capacity", capacity);
            repClass.setStringProperty("remaining_size", remaining_size);
            repClass.setStringProperty("speed", speed);
            repClass.setStringProperty("channel", channel);
            repClass.setStringProperty("target", target);
            repClass.setStringProperty("ld_id", ld_id);
            repClass.setStringProperty("ld_idx", ld_idx);
            String key = this.createKey(vendor, model, serialNum);
            repClass.setStringProperty("_Realized", key);
            ReportClass fru = system.newSubInstance("fru");
            fru.setKey(key);
            fru.setStringProperty("_Name", key);
            fru.setStringProperty("_Type", "Disk");
            fru.setStringProperty("_Model", model);
            fru.setStringProperty("_Firmware", firmware);
            fru.setStringProperty("_Vendor", vendor);
            fru.setStringProperty("_SerialNumber", serialNum);
            fru.setStringProperty("_FruNumber", serialNum);
            fru.setStringProperty("IdentifyingNumber", serialNum);
            fru.setStringProperty("CanBeFRUed", "true");
            fru.setStringProperty("CustomerReplaceable", "true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String determineDiskStatus(String data) {
        String value = "Unknown";
        if (data.equalsIgnoreCase("frmt")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("online")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("new")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("used")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("initing")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("global spare")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("spare")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("bad")) {
            value = "Error";
        } else if (data.equalsIgnoreCase("offline")) {
            value = "Error";
        } else if (data.equalsIgnoreCase("Bypassed")) {
            value = "Bypassed";
        }
        return value;
    }

    private String determineFruStatus(String data) {
        String value = "Unknown";
        if (data.equalsIgnoreCase("OK")) {
            value = "OK";
        } else if (data.equalsIgnoreCase("absent")) {
            value = "Error";
        } else if (data.equalsIgnoreCase("fault")) {
            value = "Error";
        } else if (data.equalsIgnoreCase("dead")) {
            value = "Error";
        } else if (data.equalsIgnoreCase("unknown")) {
            value = "Error";
        }
        return value;
    }

    private String createKey(String vendor, String model, String serialNum) {
        String key = vendor + "." + model + "." + serialNum;
        return key.trim();
    }

    private String createCtrlKey(String ctr, String serialNum) {
        String key = ctr + "." + serialNum;
        return key.trim();
    }

    public static void main(String[] args) throws Exception {
        Properties p = new Properties();
        p.setProperty("ip", args[0]);
        MinnowReportGenerator mrg = new MinnowReportGenerator(p);
        ReportClass report = mrg.generateReport(p, null);
        System.out.println(report.toString());
    }

    static {
        PING = PING;
        REPORT_OK = "OK";
        REPORT_FAIL = REPORT_FAIL;
        FULL_REDUNDANCY = FULL_REDUNDANCY;
        DEGRADED_REDUNDANCY = DEGRADED_REDUNDANCY;
        LOST_REDUNDANCY = LOST_REDUNDANCY;
        PCU_TYPE_NAME = PCU_TYPE_NAME;
        LOOP_TYPE_NAME = LOOP_TYPE_NAME;
        FAN_TYPE_NAME = FAN_TYPE_NAME;
        DRIVE_TYPE_NAME = DRIVE_TYPE_NAME;
        VOLUME_TYPE_NAME = VOLUME_TYPE_NAME;
        BATTERY_TYPE_NAME = BATTERY_TYPE_NAME;
        CONTROLLER_TYPE_NAME = CONTROLLER_TYPE_NAME;
        CONTROLLER = 1;
        PCU = 2;
        LOOP = 3;
        FAN = 4;
        DRIVE = 5;
        TEMPSENSOR = 6;
        VOLUME = 7;
        MIDPLANE = 8;
        FIBREPORT = 9;
        BATTERY = 10;
        NOT_AVAILABLE_INBAND = NOT_AVAILABLE_INBAND;
        UNAVAILABLE_INTEGER = UNAVAILABLE_INTEGER;
        NO_FABRIC_NAME = NO_FABRIC_NAME;
        DATA_OK = "OK";
        DATA_STALE = DATA_STALE;
        DATA_MISSING = DATA_MISSING;
        TAG = TAG;
        sccs_id = sccs_id;
    }
}

