/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.minnow;

import com.sun.netstorage.fm.storade.agent.util.CommandExec;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PortReporter;
import com.sun.netstorage.fm.storade.resource.discovery.AbstractProbe;
import com.sun.netstorage.fm.storade.resource.discovery.ProbeResult;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;

public class MinnowProbe
extends AbstractProbe {
    public static final String ARRAY_TYPE_MINNOW = "MINNOW";
    public static final String CLI_PATH = "sccli_command";
    public static int TIMEOUT;
    public static int RETRY_TIMEOUT;
    public String command;
    Properties load;

    public MinnowProbe(Properties load) {
        this.load = load;
        this.command = load.getProperty(CLI_PATH);
    }

    public ProbeResult probe(Properties inputProperties) {
        ProbeResult result = new ProbeResult();
        ArrayList discoveredArrays = new ArrayList();
        String ip = inputProperties.getProperty("ip");
        if (ip == null) {
            return new ProbeResult("#ARG_ERROR", "ip address is invalid");
        }
        String sn = this.getSerialNum(ip);
        if (sn != null) {
            String wwn = "206000c0ff" + sn;
            if (!discoveredArrays.contains(wwn)) {
                String key = "SUN.MINNOW." + sn;
                String name = "MINNOW-" + sn;
                DeviceProperties p = new DeviceProperties();
                p.setProperty("type", ARRAY_TYPE_MINNOW);
                p.setProperty("class", "storage.MINNOW");
                p.setProperty("key", key);
                p.setProperty("name", name);
                p.setProperty("wwn", wwn.toLowerCase());
                p.setProperty("ipno", this.getIPNum(ip));
                p.setProperty("ip", this.getIPName(ip));
                p.setProperty("wwns", this.getWWNList(ip));
                result.addDevice(p);
            }
            return result;
        }
        return new ProbeResult("#ARG_ERROR", "ip address is invalid, can not get its serial number");
    }

    private String getSerialNum(String path) {
        if (this.command == null) {
            return null;
        }
        String cmd = this.command + " " + path + " inquiry";
        CommandExec cExec = new CommandExec(cmd);
        try {
            cExec.exec();
            int returnCode = cExec.getReturnValue(TIMEOUT);
        }
        catch (InterruptedException ie) {
            try {
                cExec.exec();
                int returnCode = cExec.getReturnValue(TIMEOUT + RETRY_TIMEOUT);
            }
            catch (Exception ex) {
                System.out.println("Probe timeout for ip: " + path);
                return null;
            }
        }
        catch (IllegalStateException ies) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        String output = cExec.getStandardOutput();
        output = output.trim();
        String err = cExec.getErrorOutput();
        err = err.trim();
        String out = output + err;
        String serialNum = this.getSN(out);
        return serialNum;
    }

    private String getSN(String input) {
        String sn = "";
        Pattern patrn = Pattern.compile("\n");
        String[] result = patrn.split(input);
        int i = 0;
        while (i < result.length) {
            String propertyName;
            Pattern patrn1;
            String[] result_colon;
            if (i != 0 && (result_colon = (patrn1 = Pattern.compile(":")).split(result[i])).length == 2 && "Serial Number".equalsIgnoreCase(propertyName = result_colon[0].trim())) {
                sn = result_colon[1].trim();
                break;
            }
            ++i;
        }
        return sn;
    }

    private String getIPNum(String ip) {
        String ipNum;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            ipNum = addr.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            ipNum = ip;
        }
        return ipNum;
    }

    private String getIPName(String ip) {
        String ipName;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            ipName = addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            ipName = ip;
        }
        return ipName;
    }

    private String getWWNList(String path) {
        PortReporter portWWNReporter = new PortReporter(path);
        String wwns = portWWNReporter.getPortWWNS();
        return wwns;
    }

    static {
        ARRAY_TYPE_MINNOW = ARRAY_TYPE_MINNOW;
        CLI_PATH = CLI_PATH;
        TIMEOUT = 5000;
        RETRY_TIMEOUT = 5000;
    }
}

