/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.util;

import com.sun.netstorage.fm.storade.agent.command.ThreadPool;
import com.sun.netstorage.fm.storade.agent.util.CommandOutputListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandExec {
    private int returnCode;
    private String path;
    private StringWriter stdout;
    private StringWriter stderr;
    private Process proc;
    private boolean running;
    private boolean aborted;
    private ReadInputTask stdoutReaderTask;
    private ReadInputTask stderrReaderTask;
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public CommandExec(String path) {
        this.path = path;
    }

    public synchronized void exec() throws IOException {
        this.exec(null);
    }

    public synchronized int run() throws IOException {
        this.exec();
        return this.getReturnValue();
    }

    public synchronized void exec(CommandOutputListener listener) throws IOException {
        this.running = true;
        this.aborted = false;
        Runtime runTime = Runtime.getRuntime();
        this.proc = runTime.exec(this.path);
        this.stdout = new StringSyncWriter();
        this.stderr = new StringSyncWriter();
        this.stdoutReaderTask = new ReadInputTask(this.proc.getInputStream(), this.stdout, listener);
        this.stderrReaderTask = new ReadInputTask(this.proc.getErrorStream(), this.stderr, listener);
        ThreadPool tp = ThreadPool.getThreadPool();
        tp.runJob(this.stdoutReaderTask);
        tp.runJob(this.stderrReaderTask);
        if (listener != null) {
            tp.runJob(new ReturnValueTask(listener));
        }
    }

    public String getStandardOutput() {
        if (this.stdout == null) {
            return null;
        }
        return this.stdout.toString();
    }

    public String getErrorOutput() {
        if (this.stderr == null) {
            return null;
        }
        return this.stderr.toString();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void abort() {
        if (this.proc != null && this.running) {
            this.proc.destroy();
            this.aborted = true;
            this.proc = null;
            this.running = false;
        }
    }

    public synchronized int getReturnValue() throws IllegalStateException {
        boolean interrupted;
        if (!this.running) {
            return this.returnCode;
        }
        do {
            try {
                if (this.proc == null) {
                    throw new IllegalStateException();
                }
                this.returnCode = this.proc.waitFor();
                this.stdoutReaderTask.finish();
                this.stderrReaderTask.finish();
                interrupted = false;
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        } while (interrupted);
        this.proc = null;
        this.running = false;
        return this.returnCode;
    }

    public synchronized int getReturnValue(long timeout) throws IllegalStateException, InterruptedException {
        ThreadPool tp = ThreadPool.getThreadPool();
        TaskMonitor tm = new TaskMonitor(timeout);
        tp.runJob(tm);
        int returnValue = this.getReturnValue();
        tm.stop();
        if (this.aborted) {
            throw new InterruptedException();
        }
        return returnValue;
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }

    public static class TestListener
    implements CommandOutputListener {
        public void stdOutput(String line) {
            System.out.println(line);
        }

        public void errOutput(String line) {
            System.out.println("ERROR:" + line);
        }

        public void finished(int returnCode) {
            System.out.println("EXIT " + returnCode);
        }
    }

    private static class StringSyncWriter
    extends StringWriter {
        private StringSyncWriter() {
        }

        public synchronized String toString() {
            return super.toString();
        }

        public synchronized void write(int c) {
            super.write(c);
        }

        public synchronized StringBuffer getBuffer() {
            return super.getBuffer();
        }
    }

    private class ReadInputTask
    implements Runnable {
        InputStream input;
        StringWriter output;
        boolean finished;
        CommandOutputListener listener;
        StringBuffer line;

        ReadInputTask(InputStream input, StringWriter output, CommandOutputListener listener) {
            this.input = input;
            this.output = output;
            this.listener = listener;
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            block7: {
                if (this.listener != null) {
                    this.line = new StringBuffer();
                }
                try {
                    int c;
                    while (-1 != (c = this.input.read())) {
                        void var1_1;
                        this.output.write((int)var1_1);
                        if (this.line == null || var1_1 == 13) continue;
                        if (var1_1 == 10) {
                            if (this == CommandExec.this.stdoutReaderTask) {
                                this.listener.stdOutput(this.line.toString());
                            } else {
                                this.listener.errOutput(this.line.toString());
                            }
                            this.line.delete(0, this.line.length());
                            continue;
                        }
                        this.line.append((char)var1_1);
                    }
                }
                catch (IOException ioe) {
                    if (CommandExec.this.aborted) break block7;
                    Logger logger = Logger.getLogger("com.sun.netstorage.fm.storade.agent.util");
                    logger.log(Level.SEVERE, CommandExec.this.path, ioe);
                }
            }
            this.setFinished(true);
        }

        public synchronized void setFinished(boolean inFinish) {
            this.finished = inFinish;
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.notify();
        }

        public synchronized void finish() {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class ReturnValueTask
    implements Runnable {
        private CommandOutputListener listener;

        ReturnValueTask(CommandOutputListener listener) {
            this.listener = listener;
        }

        public void run() {
            this.listener.finished(CommandExec.this.getReturnValue());
        }
    }

    private class TaskMonitor
    implements Runnable {
        private long timeout;
        private boolean stopped;

        TaskMonitor(long timeout) {
            this.timeout = timeout;
        }

        public synchronized void stop() {
            boolean stopped = true;
            this.notify();
        }

        public synchronized void run() {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.stopped) {
                return;
            }
            if (CommandExec.this.isRunning()) {
                CommandExec.this.abort();
            }
        }
    }
}

