/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.helper;

import com.sun.netstorage.fm.storade.agent.catalog.Loader;
import com.sun.netstorage.fm.storade.agent.command.xml.SOAPEncoder;
import com.sun.netstorage.fm.storade.agent.command.xml.XMLUtil;
import com.sun.netstorage.fm.storade.resource.discovery.Probe;
import com.sun.netstorage.fm.storade.resource.discovery.ProbeResult;
import com.sun.netstorage.fm.storade.resource.message.LogMessage;
import com.sun.netstorage.fm.storade.resource.message.MessageList;
import com.sun.netstorage.fm.storade.resource.message.MessageProvider;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import com.sun.netstorage.fm.storade.util.StoradeDate;
import com.sun.netstorage.fm.util.PropertyList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DeviceHelper {
    public static final String _SOURCE_REVISION = "$Revision: 1.15 $";

    public static InstReport instrument(Map props) {
        return new InstReport(DeviceHelper.instrumentRC((Properties)new PropertyList(props)));
    }

    public static SOAPEncoder instrumentDevice(Map props) {
        PropertyList device = new PropertyList(props);
        return new InstReportDevice(DeviceHelper.instrumentRC((Properties)device), (Map)device);
    }

    private static ReportClass instrumentRC(Properties device) {
        ReportClass report = null;
        try {
            Loader loader = new Loader(device.getProperty("type"));
            ReportGenerator rgen = (ReportGenerator)loader.getJavaImpl("Report");
            report = rgen.generateReport(device, "FULL");
        }
        catch (Throwable error) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            error.printStackTrace(out);
            report = new ReportClass("error", "ReportGenerator");
            report.setProperty("_Type", "Defect");
            report.setProperty("_MessageID", "0");
            report.setProperty("_Time", new StoradeDate().toString());
            report.setProperty("_Environment", System.getProperty("java.runtime.version"));
            report.setProperty("_Source", "StorADE");
            report.setProperty("_Severity", "NOTICE");
            report.setProperty("_Description", error.toString());
            report.setProperty("_Cause", sw.toString());
        }
        return report;
    }

    public static String getMarker(Map props) {
        PropertyList device = new PropertyList(props);
        Loader loader = new Loader(device.getProperty("type"));
        MessageProvider mp = (MessageProvider)loader.getImpl("Message");
        if (mp == null) {
            return null;
        }
        return mp.getCurrentMarker((Properties)device);
    }

    public static HelperMessageList getMessages(String marker, Map props) {
        PropertyList device = new PropertyList(props);
        Loader loader = new Loader(device.getProperty("type"));
        MessageProvider mp = (MessageProvider)loader.getImpl("Message");
        if (mp == null) {
            return new HelperMessageList(null);
        }
        return new HelperMessageList(mp.getNewMessages(marker, (Properties)device));
    }

    public static DiscoverResult discover(String type, Map props) {
        Loader loader = new Loader(type);
        Probe probe = (Probe)loader.getImpl("Discover");
        PropertyList discoProps = new PropertyList(props);
        return new DiscoverResult(probe.probe((Properties)discoProps));
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }

    public static class DiscoverResult
    implements SOAPEncoder {
        private ProbeResult pr;

        public DiscoverResult(ProbeResult pr) {
            this.pr = pr;
        }

        public void encode(StringBuffer sb) {
            if (this.pr == null) {
                return;
            }
            Properties[] devs = this.pr.getDiscoveredProperties();
            String status = this.pr.getStatus();
            String msg = this.pr.getLocalizedMessage();
            sb.append("<status>" + status + "</status>");
            sb.append("<message>");
            sb.append(msg);
            sb.append("</message>");
            if (devs.length > 0) {
                sb.append("<devices>");
                int i = 0;
                while (i < devs.length) {
                    sb.append("<soap:Item>");
                    Properties map = devs[i];
                    if (map != null) {
                        Set s = map.entrySet();
                        Iterator eiter = s.iterator();
                        while (eiter.hasNext()) {
                            Map.Entry entry = eiter.next();
                            sb.append("<");
                            sb.append((String)entry.getKey());
                            sb.append(">");
                            sb.append(XMLUtil.encodeToXML((String)entry.getValue()));
                            sb.append("</");
                            sb.append((String)entry.getKey());
                            sb.append(">");
                        }
                    }
                    sb.append("</soap:Item>");
                    ++i;
                }
                sb.append("</devices>");
            }
        }
    }

    public static class HelperMessageList
    implements SOAPEncoder {
        private MessageList ml;

        public HelperMessageList(MessageList ml) {
            this.ml = ml;
        }

        public void encode(StringBuffer sb) {
            if (this.ml == null) {
                return;
            }
            sb.append("<marker>" + this.ml.getMarker() + "</marker>\n");
            LogMessage[] msgs = this.ml.getMessages();
            if (msgs != null && msgs.length > 0) {
                sb.append("<messages>\n");
                SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm:ss");
                int i = 0;
                while (i < msgs.length) {
                    LogMessage msg = msgs[i];
                    if (msg != null) {
                        sb.append("<soap:Item>");
                        XMLUtil.encodeXML(sb, "id", msg.getMessageID());
                        XMLUtil.encodeXML(sb, "type", msg.getType());
                        XMLUtil.encodeXML(sb, "severity", Integer.toString(msg.getSeverity()));
                        XMLUtil.encodeXML(sb, "source", msg.getSource());
                        XMLUtil.encodeXML(sb, "component", msg.getComponent());
                        XMLUtil.encodeXML(sb, "time", msg.getMessageTime());
                        XMLUtil.encodeXML(sb, "description", msg.getDescription());
                        XMLUtil.encodeXML(sb, "line", msg.toString());
                        sb.append("</soap:Item>\n");
                    }
                    ++i;
                }
                sb.append("</messages>\n");
            }
        }
    }

    public static class InstReportDevice
    implements SOAPEncoder {
        private ReportClass rc;
        private Map dev;

        public InstReportDevice(ReportClass rc, Map dev) {
            this.rc = rc;
            this.dev = dev;
        }

        public void encode(StringBuffer sb) {
            if (this.rc == null) {
                return;
            }
            sb.append("<report>");
            this.rc.toSOAP(sb);
            sb.append("</report>");
            sb.append("<device>");
            Set s = this.dev.entrySet();
            Iterator eiter = s.iterator();
            if (eiter != null) {
                while (eiter.hasNext()) {
                    Map.Entry entry = eiter.next();
                    if (entry == null) continue;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key == null || val == null) continue;
                    sb.append("<");
                    sb.append(key.toString());
                    sb.append(">");
                    sb.append(XMLUtil.encodeToXML(val.toString()));
                    sb.append("</");
                    sb.append(key.toString());
                    sb.append(">");
                }
            }
            sb.append("</device>\n");
        }
    }

    public static class InstReport
    implements SOAPEncoder {
        private ReportClass rc;

        public InstReport(ReportClass rc) {
            this.rc = rc;
        }

        public void encode(StringBuffer sb) {
            if (this.rc == null) {
                return;
            }
            this.rc.toSOAP(sb);
        }
    }
}

