/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;

public class AgentRegistry {
    public static String getDeviceDirName() {
        String home = System.getProperty("SUNWstade");
        if (home == null) {
            home = "/opt/SUNWstade";
        }
        return home + File.separator + "System" + File.separator + "Catalog" + File.separator + "interface";
    }

    static String getPropertyFileName(String type) {
        return AgentRegistry.getDeviceDirName() + File.separator + type + ".properties";
    }

    public static String[] getRegisteredTypes() {
        ArrayList<String> list = new ArrayList<String>();
        String devDirName = AgentRegistry.getDeviceDirName();
        File devDir = new File(devDirName);
        String[] devs = devDir.list();
        if (devs != null) {
            int i = 0;
            while (i < devs.length) {
                int index = devs[i].indexOf(".properties");
                if (index > 0) {
                    String type = devs[i].substring(0, index);
                    list.add(type);
                }
                ++i;
            }
        }
        String[] types = new String[list.size()];
        list.toArray(types);
        return types;
    }

    public static Properties getDeviceProperties(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        try {
            String pname = AgentRegistry.getPropertyFileName(type);
            if (pname == null) {
                throw new IllegalArgumentException();
            }
            Properties p = new Properties();
            p.load(new FileInputStream(pname));
            return p;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public static String getDeviceProperty(String type, String name) {
        try {
            Properties p = AgentRegistry.getDeviceProperties(type);
            return p.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.setProperty("SUNWstade", "/opt/SUNWstade");
        System.out.println("DeviceDirName=" + AgentRegistry.getDeviceDirName());
        String[] t = AgentRegistry.getRegisteredTypes();
        int i = 0;
        while (i < t.length) {
            System.out.println(t[i]);
            Properties p = AgentRegistry.getDeviceProperties(t[i]);
            p.list(System.out);
            ++i;
        }
    }
}

