/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology;

import com.sun.netstorage.mgmt.fm.storade.schema.topology.CompareSnapshotResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.SnapshotListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.TopologyListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.TopologyResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;

public class Getter {
    private Getter() {
    }

    public static TopologyResultDocument.TopologyResult getTopology(String topoID) {
        TopologyResultDocument.TopologyResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::details";
            s = topoID != null ? s + "&topo=" + URLEncoder.encode(topoID, "UTF-8") : s + "&key=MERGE-MASTER";
            s = s + "&GO2=Client::Control::GetAlarms&format=xml";
            s = s + "&GO3=Client::TO::list";
            s = s + "&GO4=Client::Alarm::summary";
            if (topoID != null) {
                s = s + "&GO5=Client::InstrReport::list&format=xml&host=1&noheader=1";
                s = s + "&GO6=Client::Config::listDevices";
                s = s + "&GO7=Client::Revision::getHosts";
            }
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "topologyResult");
            TopologyResultDocument resultDoc = TopologyResultDocument.Factory.parse((String)data);
            result = resultDoc.getTopologyResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAppletParameters(String topoID) {
        String result = null;
        try {
            int ch;
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::applet";
            if (topoID != null) {
                s = s + "&topo=" + URLEncoder.encode(topoID, "UTF-8");
                s = s + "&HIST=true";
                s = s + "&FILTER=*";
            } else {
                topoID = "MERGE-MASTER";
                s = s + "&topo=" + URLEncoder.encode(topoID, "UTF-8");
                s = s + "&FILTER=*";
            }
            InputStream is = Connection.getInputStream(s);
            Debug.println("REQUEST: " + s);
            StringBuffer buffer = new StringBuffer();
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                void var7_8;
                buffer.append((char)var7_8);
            }
            ((Reader)in).close();
            result = buffer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static TopologyListResultDocument.TopologyListResult getTopologyList() {
        TopologyListResultDocument.TopologyListResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::list";
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "TopologyListResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            TopologyListResultDocument resultDoc = TopologyListResultDocument.Factory.parse((String)data);
            result = resultDoc.getTopologyListResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SnapshotListResultDocument.SnapshotListResult getSnapshotList() {
        SnapshotListResultDocument.SnapshotListResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::listSnapshot";
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SnapshotListResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SnapshotListResultDocument resultDoc = SnapshotListResultDocument.Factory.parse((String)data);
            result = resultDoc.getSnapshotListResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static CompareSnapshotResultDocument.CompareSnapshotResult getCompareSnapshot(String topo1, String topo2) {
        CompareSnapshotResultDocument.CompareSnapshotResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::compareSnapshot&topo1=" + URLEncoder.encode(topo1, "UTF-8") + "&topo2=" + URLEncoder.encode(topo2, "UTF-8");
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "CompareSnapshotResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            CompareSnapshotResultDocument resultDoc = CompareSnapshotResultDocument.Factory.parse((String)data);
            result = resultDoc.getCompareSnapshotResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

