/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetComponent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetValue;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Component;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import java.util.Locale;

public class AssetUtil {
    private static final String VALUE_STATE = "state";
    private static final String VALUE_STATUS = "status";

    private AssetUtil() {
    }

    private static String getValue(String devId, String fruId, String value, Locale locale, boolean live) {
        if (devId == null || fruId == null) {
            return null;
        }
        String rString = null;
        try {
            AssetComponent fru;
            AssetResultDocument.AssetResult result = live ? Getter.getFruList(devId, null) : Getter.getSimpleReportDetails(devId);
            if (result == null || result.getReport() == null) {
                return null;
            }
            AssetContent content = result.getReport().getContent();
            if (content != null && (fru = content.getFRU()) != null) {
                Component[] components = fru.getCOMPONENTArray();
                int j = 0;
                while (j < components.length) {
                    AssetValue[] values;
                    String s = components[j].getID();
                    if (fruId.equals(s) && (values = components[j].getValueArray()) != null) {
                        int k = 0;
                        while (k < values.length) {
                            String s2 = values[k].getID();
                            if (value.equals(s2)) {
                                rString = values[k].getStringValue();
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rString;
    }

    public static String getState(String devId, String fruId, Locale locale, boolean live) {
        String v = AssetUtil.getValue(devId, fruId, VALUE_STATE, locale, live);
        if ((v = StateUtil.getState(v)) != null) {
            v = LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources", v, locale);
        }
        return v;
    }

    public static String getStatus(String devId, String fruId, Locale locale, boolean live) {
        String v = AssetUtil.getValue(devId, fruId, VALUE_STATUS, locale, live);
        if (v != null) {
            v = LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources", v, locale);
        }
        return v;
    }

    static {
        VALUE_STATE = VALUE_STATE;
        VALUE_STATUS = VALUE_STATUS;
    }
}

