/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HiddenField;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.AssetsDataHelper;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TestSetupViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "TestSetup";
    static final String PAGE_TITLE = "page.title.testSetup1";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/diagnostics/TestSetup.jsp";
    public static final String CHILD_RUN_BUTTON = "RunButton";
    public static final String CHILD_CANCEL_BUTTON = "CancelButton";
    public static final String CHILD_RESET_BUTTON = "ResetButton";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    public static final String CHILD_ASSETID = "assetID";
    public static final String CHILD_TESTNAME = "diag.testName";
    public static final String CHILD_TESTID = "diag.testID";
    public static final String CHILD_AGENT = "diag.agent";
    public static final String CHILD_PROPERTYSHEET = "TestSetupPropertySheet";
    private CCPropertySheetModel model;
    private CCPageTitleModel pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/xml/pagetitle/TestSetupPageTitle.xml");
    private DiagResultDocument.DiagResult result;
    private CCI18N cci18n;
    private String agent;
    private String assetID;
    private String testName;
    private String displayName;
    private static final String ERROR_HEADER = "#ERROR";
    private static final String ERROR_MSG = "Validation Error: : ";
    static /* synthetic */ Class class$com$sun$web$ui$view$propertysheet$CCPropertySheet;
    static /* synthetic */ Class class$com$sun$web$ui$view$pagetitle$CCPageTitle;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$HiddenField;

    public TestSetupViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    private void initModel() {
        this.pageTitleModel.setValue(CHILD_RUN_BUTTON, (Object)"button.run");
        this.pageTitleModel.setValue(CHILD_RESET_BUTTON, (Object)"button.reset");
        this.pageTitleModel.setValue(CHILD_CANCEL_BUTTON, (Object)"button.cancel");
    }

    public void beginDisplay(DisplayEvent event) {
        String warningMessage;
        this.checkUserPrivilege();
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        this.cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
        this.testName = request.getParameter("testID");
        this.assetID = request.getParameter(CHILD_ASSETID);
        this.displayName = request.getParameter("displayName");
        this.setPageSessionAttribute("displayName", (Serializable)((Object)this.displayName));
        this.agent = AssetsDataHelper.getMonitoringAgent(this.assetID);
        String testID = DiagnosticsDataHelper.getSectionName(this.result, this.testName);
        String preWarningMessage = DiagnosticsDataHelper.getPreWarningMessage(this.result, this.testName, locale);
        if (preWarningMessage != null && !"".equals(preWarningMessage)) {
            this.setInlineAlert("warning", preWarningMessage, null, null, null);
        }
        if ((warningMessage = DiagnosticsDataHelper.getWarningMessage(this.result, this.testName, locale)) == null) {
            warningMessage = this.cci18n.getMessage("asset.testsetup.defaultwarning", null);
        }
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("warningMessage", (Object)warningMessage);
        Debug.println("Test Setup - Test Name: " + this.testName);
        Debug.println("Test Setup - Asset ID: " + this.assetID);
        this.setDisplayFieldValue(CHILD_ASSETID, this.assetID);
        this.setDisplayFieldValue(CHILD_TESTNAME, this.testName);
        if (testID != null) {
            this.setDisplayFieldValue(CHILD_TESTID, testID);
        }
        if (this.agent != null) {
            this.setDisplayFieldValue(CHILD_AGENT, this.agent);
        }
        super.beginDisplay(event);
    }

    private DiagResultDocument.DiagResult getResult() {
        if (this.result == null) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            Locale locale = request.getLocale();
            this.assetID = request.getParameter(CHILD_ASSETID);
            this.testName = request.getParameter("testID");
            if (this.assetID != null && this.testName != null) {
                try {
                    this.result = Getter.getDiag(this.assetID, locale);
                    this.setAlarmSummary(this.result.getAlarmSummary());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.result;
    }

    private String getAssetID() {
        if (this.assetID == null) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            this.assetID = request.getParameter(CHILD_ASSETID);
        }
        return this.assetID;
    }

    private String getDisplayName() {
        if (this.displayName == null) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            this.displayName = request.getParameter("displayName");
        }
        return this.displayName;
    }

    private String getTestName() {
        if (this.testName == null) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            this.testName = request.getParameter("testID");
        }
        return this.testName;
    }

    private CCPropertySheetModel getPropSheetModel() {
        if (this.model == null) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            Locale locale = request.getLocale();
            String assetID = request.getParameter(CHILD_ASSETID);
            String testName = request.getParameter("testID");
            this.agent = AssetsDataHelper.getMonitoringAgent(assetID);
            DiagResultDocument.DiagResult result = this.getResult();
            String propSheet = result != null ? DiagnosticsDataHelper.createPropertySheetTemplate(result, assetID, testName, this.agent, locale) : DiagnosticsDataHelper.createEmptyPropertySheetTemplate();
            try {
                ByteArrayInputStream io = new ByteArrayInputStream(propSheet.getBytes("UTF-16"));
                this.model = new CCPropertySheetModel((InputStream)io);
            }
            catch (Exception ex) {
                this.model = null;
                ex.printStackTrace();
            }
        }
        return this.model;
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PROPERTYSHEET, class$com$sun$web$ui$view$propertysheet$CCPropertySheet == null ? (class$com$sun$web$ui$view$propertysheet$CCPropertySheet = TestSetupViewBean.class$("com.sun.web.ui.view.propertysheet.CCPropertySheet")) : class$com$sun$web$ui$view$propertysheet$CCPropertySheet);
        this.getPropSheetModel().registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_PAGE_TITLE, class$com$sun$web$ui$view$pagetitle$CCPageTitle == null ? (class$com$sun$web$ui$view$pagetitle$CCPageTitle = TestSetupViewBean.class$("com.sun.web.ui.view.pagetitle.CCPageTitle")) : class$com$sun$web$ui$view$pagetitle$CCPageTitle);
        this.registerChild(CHILD_ASSETID, class$com$iplanet$jato$view$html$HiddenField == null ? (class$com$iplanet$jato$view$html$HiddenField = TestSetupViewBean.class$("com.iplanet.jato.view.html.HiddenField")) : class$com$iplanet$jato$view$html$HiddenField);
        this.registerChild(CHILD_TESTNAME, class$com$iplanet$jato$view$html$HiddenField == null ? (class$com$iplanet$jato$view$html$HiddenField = TestSetupViewBean.class$("com.iplanet.jato.view.html.HiddenField")) : class$com$iplanet$jato$view$html$HiddenField);
        this.registerChild(CHILD_TESTID, class$com$iplanet$jato$view$html$HiddenField == null ? (class$com$iplanet$jato$view$html$HiddenField = TestSetupViewBean.class$("com.iplanet.jato.view.html.HiddenField")) : class$com$iplanet$jato$view$html$HiddenField);
        this.registerChild(CHILD_AGENT, class$com$iplanet$jato$view$html$HiddenField == null ? (class$com$iplanet$jato$view$html$HiddenField = TestSetupViewBean.class$("com.iplanet.jato.view.html.HiddenField")) : class$com$iplanet$jato$view$html$HiddenField);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PROPERTYSHEET)) {
            CCPropertySheet child = new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.getPropSheetModel(), name);
            return child;
        }
        if (name.equals(CHILD_PAGE_TITLE)) {
            String displayName = this.getDisplayName();
            if (displayName != null) {
                Object[] params = new String[]{displayName};
                if (this.cci18n == null) {
                    this.cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
                }
                String value = this.cci18n.getMessage(PAGE_TITLE, params);
                if (this.pageTitleModel != null) {
                    this.pageTitleModel.setPageTitleText(value);
                }
            }
            CCPageTitle child = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
            return child;
        }
        if (name.equals(CHILD_ASSETID)) {
            HiddenField child = new HiddenField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_TESTNAME)) {
            HiddenField child = new HiddenField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_TESTID)) {
            HiddenField child = new HiddenField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_AGENT)) {
            HiddenField child = new HiddenField((ContainerView)this, name, null);
            return child;
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        if (this.getPropSheetModel().isChildSupported(name)) {
            View v = this.getPropSheetModel().createChild((View)this, name);
            if (v instanceof CCDropDownMenu || v instanceof CCCheckBox || v instanceof CCRadioButton) {
                String testName;
                String assetID;
                String df;
                String opt = name;
                DiagResultDocument.DiagResult result = this.getResult();
                if (result != null && (df = DiagnosticsDataHelper.getDefaultValueFor(result, assetID = this.getAssetID(), testName = this.getTestName(), opt)) != null) {
                    if (v instanceof CCDropDownMenu) {
                        CCDropDownMenu dropDown = (CCDropDownMenu)v;
                        dropDown.setValue((Object)df);
                    } else if (v instanceof CCCheckBox) {
                        CCCheckBox checkbox = (CCCheckBox)v;
                        if (df.equals("1")) {
                            checkbox.setValue((Object)"true");
                        } else {
                            checkbox.setValue((Object)"false");
                        }
                    } else if (v instanceof CCRadioButton) {
                        CCRadioButton radioButton = (CCRadioButton)v;
                        radioButton.setValue((Object)df);
                    }
                }
            }
            return v;
        }
        return null;
    }

    public void handleRunButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        String displayName = (String)this.getPageSessionAttribute("displayName");
        String assetID = request.getParameter("TestSetup.assetID");
        String testName = request.getParameter("TestSetup.diag.testName");
        String testID = request.getParameter("TestSetup.diag.testID");
        String agent = request.getParameter("TestSetup.diag.agent");
        Debug.println("display name: " + displayName);
        Debug.println("handle Submit request - assetID  : " + assetID);
        Debug.println("handle Submit request - testName : " + testName);
        Debug.println("handle Submit request - testID   : " + testID);
        Debug.println("handle Submit request - agent    : " + agent);
        DiagResultDocument.DiagResult result = null;
        String pid = "";
        try {
            result = Getter.getDiag(assetID, locale);
            String[] opt = DiagnosticsDataHelper.getOpt(result, assetID, testID);
            String[] values = new String[opt.length];
            int i = 0;
            while (i < opt.length) {
                String option = "TestSetup." + opt[i];
                values[i] = request.getParameter(option);
                if (opt[i].equals("-v")) {
                    values[i] = "true".equals(values[i]) ? "1" : "0";
                }
                Debug.println("Test Param: " + opt[i] + " " + values[i]);
                ++i;
            }
            pid = DiagnosticsDataHelper.runDiag(assetID, testID, opt, values, agent);
            Debug.println("Test pid: " + pid);
            int index = pid.indexOf("OK");
            if (index != -1) {
                pid = pid.substring(index + 2);
                pid = pid.trim();
            } else if (pid.startsWith(ERROR_HEADER)) {
                index = pid.indexOf("\t");
                if (index != -1) {
                    String errorMsg = pid.substring(index + 1);
                    if ((index = errorMsg.indexOf("\t")) != -1) {
                        errorMsg = errorMsg.substring(index + 1);
                    }
                    String[] param = new String[]{errorMsg};
                    this.setInlineAlert("error", "asset.test.testresult.start.error1", param, null, null);
                } else {
                    index = pid.indexOf(ERROR_MSG);
                    if (index != -1) {
                        String errorMsg = pid.substring(index + ERROR_MSG.length());
                        String[] param = new String[]{errorMsg};
                        this.setInlineAlert("error", "asset.test.testresult.start.error1", param, null, null);
                    } else {
                        this.setInlineAlert("error", "asset.test.testresult.start.error", null, null, null);
                    }
                }
            }
            Debug.println("Test pid: " + pid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String id = agent + ":ST:" + pid;
        String url = "/" + Connection.getAppName() + "/diagnostics/TestResult";
        url = url + "?" + "id=" + this.urlencode(id);
        if (displayName != null) {
            url = url + "&" + "displayName=" + this.urlencode(displayName);
        }
        requestContext.getResponse().sendRedirect(url);
    }

    public void handleResetButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        RequestContext requestContext = event.getRequestContext();
        String assetID = (String)this.getDisplayFieldValue(CHILD_ASSETID);
        String testName = (String)this.getDisplayFieldValue(CHILD_TESTNAME);
        String url = "/storade/diagnostics/TestSetup";
        url = url + "?" + "assetID=" + this.urlencode(assetID);
        url = url + "&testID=" + this.urlencode(testName);
        requestContext.getResponse().sendRedirect(url);
    }

    public void handleCancelButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        RequestContext requestContext = event.getRequestContext();
        String assetID = (String)this.getDisplayFieldValue(CHILD_ASSETID);
        String url = "/storade/reports/AssetDetails";
        url = url + "?" + "assetID=" + this.urlencode(assetID);
        requestContext.getResponse().sendRedirect(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PAGE_NAME = PAGE_NAME;
        PAGE_TITLE = PAGE_TITLE;
        DEFAULT_DISPLAY_URL = DEFAULT_DISPLAY_URL;
        CHILD_RUN_BUTTON = CHILD_RUN_BUTTON;
        CHILD_CANCEL_BUTTON = CHILD_CANCEL_BUTTON;
        CHILD_RESET_BUTTON = CHILD_RESET_BUTTON;
        CHILD_PAGE_TITLE = CHILD_PAGE_TITLE;
        CHILD_ASSETID = CHILD_ASSETID;
        CHILD_TESTNAME = CHILD_TESTNAME;
        CHILD_TESTID = CHILD_TESTID;
        CHILD_AGENT = CHILD_AGENT;
        CHILD_PROPERTYSHEET = CHILD_PROPERTYSHEET;
        ERROR_HEADER = ERROR_HEADER;
        ERROR_MSG = ERROR_MSG;
    }
}

