/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class DiagnosticField
implements Comparable {
    public static final String TEXT_FIELD = "text";
    public static final String STATIC_FIELD = "const";
    public static final String SELECT_FIELD = "select";
    public static final String PASSWD_FIELD = "password";
    public static final String CHECKBOX = "checkbox";
    public static final String RADIO = "radio";
    private int index;
    private String name;
    private String sectionName;
    private String defaultValue;
    private String option;
    private String type;
    private String description;
    private String size;
    private String[] values;
    private String[] localizedValues;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getValues() {
        return this.values;
    }

    public String[] getLocalizedValues() {
        if (this.localizedValues == null) {
            return this.values;
        }
        return this.localizedValues;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setValues(String value) {
        StringTokenizer st = new StringTokenizer(value, "|");
        ArrayList<String> valueList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            valueList.add(s);
        }
        this.values = new String[valueList.size()];
        valueList.toArray(this.values);
    }

    public void setLocalizedValues(String value) {
        StringTokenizer st = new StringTokenizer(value, "|");
        ArrayList<String> valueList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            valueList.add(s);
        }
        this.localizedValues = new String[valueList.size()];
        valueList.toArray(this.localizedValues);
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String toString() {
        int i;
        String s = "Name: " + this.name + "\n" + "Default: " + this.defaultValue + "\n" + "Opt: " + this.option + "\n" + "Description: " + this.description + "\n" + "Type: " + this.type + "\n" + "Size: " + this.size + "\n";
        if (this.values != null) {
            s = s + "Values: ";
            i = 0;
            while (i < this.values.length) {
                s = s + this.values[i] + " ";
                ++i;
            }
            s = s + "\n";
        }
        if (this.localizedValues != null) {
            s = s + "Localized Values: ";
            i = 0;
            while (i < this.localizedValues.length) {
                s = s + this.localizedValues[i] + " ";
                ++i;
            }
            s = s + "\n";
        }
        return s;
    }

    public int compareTo(Object o) {
        if (!(o instanceof DiagnosticField)) {
            throw new IllegalArgumentException();
        }
        DiagnosticField df = (DiagnosticField)o;
        int sign = this.index < df.index ? -1 : (this.index == df.index ? 0 : 1);
        return sign;
    }

    static String getValue(String s) {
        String value = s;
        int index = s.indexOf(61);
        if (index != -1) {
            value = s.substring(0, index);
        }
        return value;
    }

    static String getText(String s) {
        String text = s;
        int index = s.indexOf(61);
        if (index != -1) {
            text = s.substring(index + 1);
        }
        return text;
    }

    static {
        TEXT_FIELD = TEXT_FIELD;
        STATIC_FIELD = STATIC_FIELD;
        SELECT_FIELD = SELECT_FIELD;
        PASSWD_FIELD = PASSWD_FIELD;
        CHECKBOX = CHECKBOX;
        RADIO = RADIO;
    }
}

