/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AckAlarmResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.DeleteAlarmResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTableInterface;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.AlarmsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.AlarmsTableTiledView;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.Setter;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AlarmsViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "Alarms";
    public static final String ASSETID_KEY = "assetID";
    public static final String SEVERITY_KEY = "severity";
    public static final String DISPLAYNAME_KEY = "displayName";
    public static final String STATE_KEY = "state";
    public static final String ALARMPROP_KEY = "storade.alarmProp";
    public static final String FRUTYPE_KEY = "element";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/alarms/Alarms.jsp";
    public static final String CHILD_ALARMS_TABLE = "AlarmsTable";
    public static final String CHILD_ALARMSTABLE_TILEDVIEW = "AlarmsTableTiledView";
    public static final String CHILD_FILTERMENU = "FilterMenu";
    public static final String CHILD_FILTERMENU_HREF = "FilterMenuHref";
    public static final String CHILD_ACKCOMMAND = "AckCommand";
    public static final String CHILD_IDLIST = "IdList";
    private ActionTableModel alarmsModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/AlarmsTable.xml");
    private String idList = "";
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$fm$storade$ui$view$ActionTable;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$fm$storade$ui$viewbeans$alarms$AlarmsTableTiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$HREF;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public AlarmsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_ALARMS_TABLE, class$com$sun$netstorage$mgmt$fm$storade$ui$view$ActionTable == null ? (class$com$sun$netstorage$mgmt$fm$storade$ui$view$ActionTable = AlarmsViewBean.class$("com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable")) : class$com$sun$netstorage$mgmt$fm$storade$ui$view$ActionTable);
        this.registerChild(CHILD_ALARMSTABLE_TILEDVIEW, class$com$sun$netstorage$mgmt$fm$storade$ui$viewbeans$alarms$AlarmsTableTiledView == null ? (class$com$sun$netstorage$mgmt$fm$storade$ui$viewbeans$alarms$AlarmsTableTiledView = AlarmsViewBean.class$("com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.AlarmsTableTiledView")) : class$com$sun$netstorage$mgmt$fm$storade$ui$viewbeans$alarms$AlarmsTableTiledView);
        this.registerChild(CHILD_FILTERMENU_HREF, class$com$iplanet$jato$view$html$HREF == null ? (class$com$iplanet$jato$view$html$HREF = AlarmsViewBean.class$("com.iplanet.jato.view.html.HREF")) : class$com$iplanet$jato$view$html$HREF);
        this.registerChild(CHILD_ACKCOMMAND, class$com$iplanet$jato$view$html$HREF == null ? (class$com$iplanet$jato$view$html$HREF = AlarmsViewBean.class$("com.iplanet.jato.view.html.HREF")) : class$com$iplanet$jato$view$html$HREF);
        this.registerChild(CHILD_IDLIST, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AlarmsViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.alarmsModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_ALARMSTABLE_TILEDVIEW)) {
            AlarmsTableTiledView child = new AlarmsTableTiledView((View)this, this.alarmsModel, name);
            return child;
        }
        if (name.equals(CHILD_IDLIST)) {
            CCHiddenField child = new CCHiddenField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_ALARMS_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.alarmsModel, name);
            child.setTiledView((ContainerView)this.getChild(CHILD_ALARMSTABLE_TILEDVIEW));
            return child;
        }
        if (name.equals(CHILD_FILTERMENU_HREF) || name.equals(CHILD_ACKCOMMAND)) {
            HREF child = new HREF((ContainerView)this, name, null);
            return child;
        }
        if (this.alarmsModel.isChildSupported(name)) {
            View view = this.alarmsModel.createChild((View)this, name);
            this.disableButtonIfNotPrivilege(view);
            return view;
        }
        return null;
    }

    private void initModel() {
        this.alarmsModel.setActionValue("severityCol", "table.header.severity");
        this.alarmsModel.setActionValue("timeCol", "table.header.time");
        this.alarmsModel.setActionValue("elementNameCol", "table.header.element");
        this.alarmsModel.setActionValue("parentNameCol", "table.header.parent");
        this.alarmsModel.setActionValue("topicCol", "table.header.topic");
        this.alarmsModel.setActionValue("alarmIDCol", "table.header.alarmID");
        this.alarmsModel.setActionValue("stateCol", "table.header.state");
        this.alarmsModel.setActionValue("actionCol", "table.header.alarmDetails");
        this.alarmsModel.setActionValue("deleteButton", "button.delete");
        this.alarmsModel.setActionValue("ackButton", "button.acknowledge");
        this.alarmsModel.setActionValue("unackButton", "button.unacknowledge");
        this.alarmsModel.setPrimarySortName("Alarm0");
        this.alarmsModel.setPrimarySortOrder("descending");
        this.alarmsModel.setSecondarySortName("timeStr");
        this.alarmsModel.setSecondarySortOrder("descending");
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        String childName;
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("timeStr".equals(childName = event.getChildName())) {
            CCStaticTextField textField = (CCStaticTextField)this.getChild(childName);
            String formatMask = DateUtil.getMediumFormatMask(locale);
            textField.setFormatMask(formatMask);
        }
        return true;
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("storade.privilegedRole", (Object)new Boolean(UserUtil.isPrivilegedRole(request)).toString());
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            Properties alarmProp = this.getAlarmProperties();
            AlarmListResultDocument.AlarmListResult result = Getter.getAlarmListResultDocument(alarmProp).getAlarmListResult();
            this.setAlarmSummary(result.getAlarmSummary());
            AlarmsDataHelper.populateAlarmsTableModel(result, this.alarmsModel, alarmProp, locale);
            this.idList = "|";
            String[] keys = this.alarmsModel.getKeys();
            if (keys != null) {
                int i = 0;
                while (i < keys.length) {
                    if (keys[i].startsWith("A-")) {
                        this.idList = this.idList + i + "|";
                    }
                    ++i;
                }
            }
            this.setDisplayFieldValue(CHILD_IDLIST, this.idList);
            String state = alarmProp.getProperty(STATE_KEY);
            if (state != null && !"".equals(state)) {
                this.setDisplayFieldValue(CHILD_FILTERMENU, state);
            }
            this.saveAlarmProperties(alarmProp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleFilterMenuHrefRequest(RequestInvocationEvent event) {
        String value = this.getDisplayFieldValue(CHILD_FILTERMENU) != null ? (String)this.getDisplayFieldValue(CHILD_FILTERMENU) : "";
        this.forwardTo(this.getRequestContext());
    }

    public void handleDeleteButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_ALARMS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        String localizeHeader = "deleteAlarm";
        int numOK = 0;
        int numWrong = 0;
        int i = 0;
        while (i < selectedKeys.size()) {
            String key = (String)selectedKeys.get(i);
            DeleteAlarmResultDocument.DeleteAlarmResult result = Setter.deleteAlarm(key = key.substring(2));
            if (result == null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error." + localizeHeader + ".internal", locale) + "<br>";
                hasFail = true;
                ++numWrong;
            } else if (result.getERROR() != null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error." + localizeHeader + "." + result.getERROR().getNo(), locale) + "<br>";
                hasFail = true;
                ++numWrong;
            } else {
                ++numOK;
            }
            ++i;
        }
        if (hasFail) {
            this.setInlineAlert("error", "summary." + localizeHeader, null, "error.alarms." + localizeHeader, new String[]{"" + numOK, "" + numWrong, display});
        } else {
            this.setInlineAlert("info", "summary." + localizeHeader, null, "info.alarms." + localizeHeader, new String[]{"" + numOK});
        }
        String url = "/" + Connection.getAppName() + "/alarms/Alarms?" + this.getAlarmPropertiesQuery();
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void setPageInfo() {
        Properties p = this.getAlarmProperties();
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String assetID = p.getProperty(ASSETID_KEY);
        String severity = p.getProperty(SEVERITY_KEY);
        String displayName = p.getProperty(DISPLAYNAME_KEY);
        String fruType = p.getProperty(FRUTYPE_KEY);
        if (displayName == null) {
            displayName = assetID;
        }
        String localizedSeverityStr = "";
        if (severity != null) {
            int severityInt = new Integer(severity);
            localizedSeverityStr = LocalizeUtil.getLocalizedString(AlarmConstants.getSeverityString(severityInt), locale);
        }
        String localizedFruTypeStr = "";
        if (fruType != null) {
            localizedFruTypeStr = LocalizeUtil.getLocalizedString(fruType, locale);
        }
        if (assetID != null && severity != null && fruType != null) {
            this.setPageTitle("page.title.subAlarmsForWithSeverityFruType", new String[]{displayName, localizedSeverityStr, localizedFruTypeStr});
            this.setPageName("SubAlarms");
        } else if (assetID != null && fruType != null) {
            this.setPageTitle("page.title.subAlarmsForWithFruType", new String[]{displayName, localizedFruTypeStr});
            this.setPageName("SubAlarms");
        } else if (assetID != null && severity != null) {
            this.setPageTitle("page.title.subAlarmsForWithSeverity", new String[]{displayName, localizedSeverityStr});
            this.setPageName("SubAlarms");
        } else if (assetID != null) {
            this.setPageTitle("page.title.subAlarmsFor", new String[]{displayName});
            this.setPageName("SubAlarms");
        } else if (severity != null) {
            this.setPageTitle("page.title.subAlarmsWithSeverity", new String[]{localizedSeverityStr});
            this.setPageName("SubAlarms");
        }
    }

    public void handleAckCommandRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        String ackedBy = request.getParameter("ackedBy");
        String action = request.getParameter("action");
        Locale locale = request.getLocale();
        request.getSession().setAttribute("storade.ack.user", (Object)ackedBy);
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_ALARMS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        String localizeHeader = "ack".equals(action) ? "ackAlarm" : "unackAlarm";
        int numOK = 0;
        int numWrong = 0;
        int i = 0;
        while (i < selectedKeys.size()) {
            String key = (String)selectedKeys.get(i);
            key = key.substring(2);
            AckAlarmResultDocument.AckAlarmResult result = "ack".equals(action) ? Setter.ackAlarm(key, ackedBy, true) : Setter.ackAlarm(key, ackedBy, false);
            if (result == null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error." + localizeHeader + ".internal", locale) + "<br>";
                hasFail = true;
                ++numWrong;
            } else if (result.getERROR() != null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error." + localizeHeader + "." + result.getERROR().getNo(), locale) + "<br>";
                hasFail = true;
                ++numWrong;
            } else {
                ++numOK;
            }
            ++i;
        }
        if (hasFail) {
            this.setInlineAlert("error", "summary." + localizeHeader, null, "error.alarms." + localizeHeader, new String[]{"" + numOK, "" + numWrong, display});
        } else {
            this.setInlineAlert("info", "summary." + localizeHeader, null, "info.alarms." + localizeHeader, new String[]{"" + numOK});
        }
        String url = "/" + Connection.getAppName() + "/alarms/Alarms?" + this.getAlarmPropertiesQuery();
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String getAlarmPropertiesQuery() {
        Properties p = this.getAlarmProperties();
        String assetID = p.getProperty(ASSETID_KEY);
        String severity = p.getProperty(SEVERITY_KEY);
        String fruType = p.getProperty(FRUTYPE_KEY);
        String displayName = p.getProperty(DISPLAYNAME_KEY);
        String state = p.getProperty(STATE_KEY);
        String query = "";
        if (assetID != null) {
            query = query + ASSETID_KEY + "=" + this.urlencode(assetID) + "&";
        }
        if (severity != null) {
            query = query + SEVERITY_KEY + "=" + this.urlencode(severity) + "&";
        }
        if (fruType != null) {
            query = query + FRUTYPE_KEY + "=" + this.urlencode(fruType) + "&";
        }
        if (displayName != null) {
            query = query + DISPLAYNAME_KEY + "=" + this.urlencode(displayName) + "&";
        }
        if (state != null && !"".equals(state)) {
            query = query + STATE_KEY + "=" + this.urlencode(state) + "&";
        }
        return query;
    }

    private Properties getAlarmProperties() {
        Properties p = (Properties)this.getPageSessionAttribute(ALARMPROP_KEY);
        if (p == null) {
            p = new Properties();
        }
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String assetID = request.getParameter(ASSETID_KEY);
        String severity = request.getParameter(SEVERITY_KEY);
        String fruType = request.getParameter(FRUTYPE_KEY);
        String displayName = request.getParameter(DISPLAYNAME_KEY);
        String state = (String)this.getDisplayFieldValue(CHILD_FILTERMENU);
        if (state == null) {
            state = request.getParameter(STATE_KEY);
        }
        if (assetID != null) {
            p.setProperty(ASSETID_KEY, assetID);
        }
        if (severity != null) {
            p.setProperty(SEVERITY_KEY, severity);
        }
        if (fruType != null) {
            p.setProperty(FRUTYPE_KEY, fruType);
        }
        if (displayName != null) {
            p.setProperty(DISPLAYNAME_KEY, displayName);
        }
        if (state != null && !"".equals(state)) {
            p.setProperty(STATE_KEY, state);
        }
        return p;
    }

    private void saveAlarmProperties(Properties p) {
        this.setPageSessionAttribute(ALARMPROP_KEY, p);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PAGE_NAME = PAGE_NAME;
        ASSETID_KEY = ASSETID_KEY;
        SEVERITY_KEY = SEVERITY_KEY;
        DISPLAYNAME_KEY = DISPLAYNAME_KEY;
        STATE_KEY = STATE_KEY;
        ALARMPROP_KEY = ALARMPROP_KEY;
        FRUTYPE_KEY = FRUTYPE_KEY;
        DEFAULT_DISPLAY_URL = DEFAULT_DISPLAY_URL;
        CHILD_ALARMS_TABLE = CHILD_ALARMS_TABLE;
        CHILD_ALARMSTABLE_TILEDVIEW = CHILD_ALARMSTABLE_TILEDVIEW;
        CHILD_FILTERMENU = CHILD_FILTERMENU;
        CHILD_FILTERMENU_HREF = CHILD_FILTERMENU_HREF;
        CHILD_ACKCOMMAND = CHILD_ACKCOMMAND;
        CHILD_IDLIST = CHILD_IDLIST;
        sccs_id = sccs_id;
    }
}

