/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms;

import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmDetails;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.Event;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class AlarmsDataHelper {
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public static void populateAlarmsTableModel(AlarmListResultDocument.AlarmListResult result, ActionTableModel alarmsModel, Properties p, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || alarmsModel == null || p == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Event[] events = new Event[]{};
        String severityFilter = p.getProperty("severity");
        String fruTypeFilter = p.getProperty("element");
        String stateFilter = p.getProperty("state");
        if ("allItemsOption".equals(stateFilter)) {
            stateFilter = null;
        }
        try {
            events = result.getALARMS().getEventArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int size = events.length;
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            Event alarmSummary = events[i];
            if ((severityFilter == null || severityFilter.equals(alarmSummary.getSeverity())) && (fruTypeFilter == null || alarmSummary.getTopic() != null && alarmSummary.getTopic().startsWith(fruTypeFilter)) && (stateFilter == null || alarmSummary.getAck() != null && alarmSummary.getAck().equals(stateFilter))) {
                if (i != 0) {
                    alarmsModel.appendRow();
                }
                int severityInt = new Integer(alarmSummary.getSeverity());
                CCAlarmObject alarm = new CCAlarmObject(4);
                switch (severityInt) {
                    case 1: {
                        alarm = new CCAlarmObject(3);
                        break;
                    }
                    case 2: {
                        alarm = new CCAlarmObject(2);
                        break;
                    }
                    case 3: {
                        alarm = new CCAlarmObject(1);
                    }
                }
                String alarmID = alarmSummary.getType() + ":" + alarmSummary.getKey() + ":" + alarmSummary.getTopic();
                String desc = alarmSummary.getDesc();
                String time = desc.substring(0, 19);
                String trueDesc = desc.substring(19);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date timeObj = new Date();
                try {
                    timeObj = formatter.parse(time);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                alarmsModel.setValue("Alarm0", alarm);
                alarmsModel.setValue("severity", alarmSummary.getSeverity());
                alarmsModel.setValue("timeStr", timeObj);
                alarmsModel.setValue("elementNameStr", alarmSummary.getFullTopic());
                alarmsModel.setValue("parentNameStr", AlarmsDataHelper.removeHostHeader(alarmSummary.getDeviceName()) + " (" + AbbreviationUtil.getAbbreviation(alarmSummary.getType(), 1, locale) + ")");
                alarmsModel.setValue("topicStr", AlarmsDataHelper.getLocalizedEventType(alarmSummary.getEventType(), locale));
                alarmsModel.setValue("AlarmDetailsStoradeHREF", NavUtil.compose(new String[]{alarmID, AlarmsDataHelper.removeHostHeader(alarmSummary.getDeviceName()), alarmSummary.getFullTopic(), alarmSummary.getTopic(), alarmSummary.getAggregate()}));
                if (alarmSummary.getAggregate() == null || "".equals(alarmSummary.getAggregate())) {
                    alarmsModel.setValue("viewDetailsStr", "action.viewDetails");
                } else {
                    alarmsModel.setValue("viewDetailsStr", LocalizeUtil.getLocalizedString("alarm.detailsWithNumberAggregated", new String[]{alarmSummary.getAggregate()}, locale));
                }
                alarmsModel.setValue("alarmIDStr", alarmID);
                if ("Y".equals(alarmSummary.getAck())) {
                    alarmsModel.setValue("stateStr", "state.acknowledged");
                } else {
                    alarmsModel.setValue("stateStr", "state.open");
                }
                alarmsModel.setValue("topicToolTipStr", trueDesc);
                alarmsModel.setValue("ParentStoradeHREF", NavUtil.compose(new String[]{alarmSummary.getType() + ":" + alarmSummary.getKey()}));
                if ("Y".equals(alarmSummary.getAck())) {
                    keys.add("A-" + alarmID);
                } else {
                    keys.add("U-" + alarmID);
                }
            }
            ++i;
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        alarmsModel.setKeys(keysArr);
    }

    public static void populateAlarmDetailsModel(AlarmDetailsResultDocument.AlarmDetailsResult result, CCActionTableModel alarmDetailsModel, Properties p, Locale locale) throws IllegalArgumentException {
        if (locale == null || alarmDetailsModel == null || result == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        AlarmDetails alarmDetails = null;
        try {
            alarmDetails = result.getALARM();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String desc = alarmDetails.getDESC();
        String disclaimer = alarmDetails.getDISCLAIMER();
        String time = desc.substring(0, 19);
        String trueDesc = desc.substring(19);
        String alarmID = p.getProperty("alarmID");
        String displayName = p.getProperty("displayName");
        String fullTopic = p.getProperty("fullTopic");
        String aggregate = p.getProperty("aggregate");
        if (aggregate == null || "".equals(aggregate)) {
            aggregate = "0";
        }
        String deviceKey = "";
        String elementName = "";
        if (alarmID != null) {
            StringTokenizer st = new StringTokenizer(alarmID, ":");
            if (st.countTokens() == 3) {
                deviceKey = st.nextToken() + ":" + st.nextToken();
                elementName = st.nextToken();
            } else if (st.countTokens() == 2) {
                deviceKey = st.nextToken() + ":" + st.nextToken();
            }
        }
        alarmDetailsModel.setValue("propertyValue2", null);
        alarmDetailsModel.setValue("ParentStoradeHREF", null);
        String severityStr = "";
        int severityInt = new Integer(alarmDetails.getSEVERITY());
        severityStr = AlarmConstants.getSeverityString(severityInt);
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.severity");
        alarmDetailsModel.setValue("propertyValue1", (Object)severityStr);
        String localizedTime = time;
        try {
            localizedTime = DateUtil.toString1(DateUtil.toDate1(time), locale);
        }
        catch (Exception ex) {
            // empty catch block
        }
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.time");
        alarmDetailsModel.setValue("propertyValue1", (Object)localizedTime);
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.state");
        if ("Y".equals(alarmDetails.getACK())) {
            alarmDetailsModel.setValue("propertyValue1", (Object)"state.acknowledged");
        } else {
            alarmDetailsModel.setValue("propertyValue1", (Object)"state.open");
        }
        alarmDetailsModel.appendRow();
        if ("Y".equals(alarmDetails.getACK()) || alarmDetails.getACKLOGIN() == null || "".equals(alarmDetails.getACKLOGIN())) {
            alarmDetailsModel.setValue("propertyName", (Object)"prop.header.ackedBy");
        } else {
            alarmDetailsModel.setValue("propertyName", (Object)"prop.header.unackedBy");
        }
        alarmDetailsModel.setValue("propertyValue1", (Object)alarmDetails.getACKLOGIN());
        if (disclaimer != null && !"".equals(disclaimer)) {
            alarmDetailsModel.appendRow();
            alarmDetailsModel.setValue("propertyName", (Object)"prop.header.disclaimer");
            alarmDetailsModel.setValue("propertyValue1", (Object)disclaimer);
        }
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.description");
        alarmDetailsModel.setValue("propertyValue1", (Object)AlarmsDataHelper.breakLine(trueDesc, 100));
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.info");
        alarmDetailsModel.setValue("propertyValue1", (Object)AlarmsDataHelper.breakLine(alarmDetails.getINFO(), 100));
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.component");
        alarmDetailsModel.setValue("propertyValue1", null);
        alarmDetailsModel.setValue("propertyValue2", (Object)displayName);
        alarmDetailsModel.setValue("ParentStoradeHREF", (Object)NavUtil.compose(new String[]{deviceKey}));
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyValue2", null);
        alarmDetailsModel.setValue("ParentStoradeHREF", null);
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.element");
        alarmDetailsModel.setValue("propertyValue1", (Object)fullTopic);
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyValue2", null);
        alarmDetailsModel.setValue("ParentStoradeHREF", null);
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.gridCode");
        alarmDetailsModel.setValue("propertyValue1", (Object)alarmDetails.getCODE());
        alarmDetailsModel.appendRow();
        alarmDetailsModel.setValue("propertyValue2", null);
        alarmDetailsModel.setValue("ParentStoradeHREF", null);
        alarmDetailsModel.setValue("propertyName", (Object)"prop.header.aggregatedCount");
        alarmDetailsModel.setValue("propertyValue1", (Object)aggregate);
    }

    private static String removeHostHeader(String in) {
        String key = "host:";
        if (in == null) {
            return null;
        }
        if (in.startsWith(key)) {
            return in.substring(key.length());
        }
        return in;
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String breakLine(String in, int numCh) {
        if (in == null || numCh < 1) {
            return in;
        }
        StringTokenizer st = new StringTokenizer(in, " ");
        String ret = "";
        String app = " ";
        int count = 0;
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if ((count = count + next.length() + 1) > numCh) {
                app = "<br> ";
                count = 0;
            } else {
                app = " ";
            }
            ret = ret + next + app;
        }
        if (ret.endsWith(app)) {
            ret = ret.substring(0, ret.length() - app.length());
        }
        return ret;
    }

    private static String getLocalizedEventType(String in, Locale locale) {
        if (in == null) {
            return null;
        }
        int pos1 = in.indexOf(".");
        if (pos1 == -1) {
            return in;
        }
        String toBeLocalized = in;
        int pos2 = in.indexOf(".", pos1 + 1);
        toBeLocalized = pos2 == -1 ? in.substring(pos1 + 1) : in.substring(pos1 + 1, pos2);
        return LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.Events", toBeLocalized, locale);
    }

    static {
        sccs_id = sccs_id;
    }
}

