/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtil {
    public static final String COMMA = ",";
    public static final String BLANK_CHARACTER = "-";

    public static final String toCsv(String[] s) {
        StringBuffer sb = null;
        try {
            int length = s.length;
            sb = new StringBuffer("");
            sb.append(s[0]);
            int i = 1;
            while (i < length) {
                sb.append(COMMA).append(s[i]);
                ++i;
            }
            String result = sb.toString();
            return result;
        }
        catch (NullPointerException npe) {
            return "";
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return sb.toString();
        }
    }

    public static final String[] toArray(String csv) {
        try {
            if (csv.indexOf("',") != -1) {
                return StringUtil.toArray(csv, "'");
            }
            if (csv.startsWith("'") && csv.endsWith("'")) {
                csv = csv.substring(1, csv.length());
                return StringUtil.toArray(csv, "'");
            }
            return StringUtil.toArray(csv, COMMA);
        }
        catch (NullPointerException npe) {
            if (csv != null) {
                throw new NullPointerException("Unexpected null: " + npe);
            }
            return new String[0];
        }
    }

    public static final String[] toArray(String list, String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter argument must be non-null");
        }
        StringTokenizer st = null;
        ArrayList<String> saList = null;
        try {
            st = new StringTokenizer(list, delimiter);
            int numTokens = st.countTokens();
            saList = new ArrayList<String>();
            String[] sa = null;
            int token = 0;
            while (token < numTokens) {
                String thisElement = st.nextToken().trim();
                if (!COMMA.equals(thisElement)) {
                    saList.add(thisElement);
                }
                ++token;
            }
            sa = new String[saList.size()];
            saList.toArray(sa);
            return sa;
        }
        catch (NullPointerException npe) {
            if (list != null) {
                throw npe;
            }
            return new String[0];
        }
    }

    public static final StringBuffer replaceString(StringBuffer target, String replaceMe, String replaceWith) {
        StringBuffer newTemplate = new StringBuffer(target.toString());
        int start = target.toString().indexOf(replaceMe);
        int end = start + replaceMe.length();
        try {
            newTemplate.replace(start, end, replaceWith);
        }
        catch (NullPointerException e) {
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            // empty catch block
        }
        return newTemplate;
    }

    public static final String replaceString(String target, String replaceMe, String replaceWith) {
        StringBuffer newTemplate = new StringBuffer(target);
        int start = target.indexOf(replaceMe);
        int end = start + replaceMe.length();
        try {
            newTemplate.replace(start, end, replaceWith);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            // empty catch block
        }
        String s = newTemplate.toString();
        newTemplate = null;
        return s;
    }

    public static final String replaceAllStrings(String target, String replaceme, String replacewith, boolean excludeTagContent) {
        try {
            if (target.indexOf(replaceme) == -1) {
                return target;
            }
        }
        catch (NullPointerException npe) {
            return target;
        }
        return StringUtil.replaceAllStrings(target, replaceme, replacewith, 0, excludeTagContent);
    }

    public static final String replaceAllStrings(String target, String replaceme, String replacewith) {
        try {
            if (target.indexOf(replaceme) == -1) {
                return target;
            }
        }
        catch (NullPointerException npe) {
            return target;
        }
        return StringUtil.replaceAllStrings(target, replaceme, replacewith, 0, true);
    }

    private static final String replaceAllStrings(String target, String replaceme, String replacewith, int start) {
        return StringUtil.replaceAllStrings(target, replaceme, replacewith, start, true);
    }

    private static final String replaceAllStrings(String target, String replaceme, String replacewith, int start, boolean excludeTagContent) {
        if (target == null || replaceme == null || replacewith == null) {
            return target;
        }
        if (excludeTagContent && StringUtil.isWithinTag(replaceme)) {
            return target;
        }
        int nextstart = 0;
        if ((start = target.indexOf(replaceme, start)) == -1) {
            return target;
        }
        int replacelength = replaceme.length();
        int end = start + replacelength;
        boolean notAnElement = true;
        if (excludeTagContent) {
            boolean bl = notAnElement = !StringUtil.isWithinTag(target.substring(start));
            if (!notAnElement) {
                nextstart = end;
            }
        }
        if (notAnElement) {
            StringBuffer sb = new StringBuffer(target);
            sb.replace(start, end, replacewith);
            target = sb.toString();
            sb = null;
            nextstart = start + replacewith.length();
        }
        target = StringUtil.replaceAllStrings(target, replaceme, replacewith, nextstart, excludeTagContent);
        return target;
    }

    public static final boolean isWithinTag(String s) {
        int startBracketPosn;
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.charAt(0) == '<') {
            return true;
        }
        int endBracketPosn = s.indexOf(">");
        boolean isWithinElement = false;
        if (endBracketPosn != -1 && ((startBracketPosn = s.indexOf("<")) == -1 || startBracketPosn > endBracketPosn)) {
            isWithinElement = true;
        }
        return isWithinElement;
    }

    public static String toPropFormat(String s) {
        if (s == null) {
            return s;
        }
        String prop = s;
        if (!prop.endsWith(":")) {
            prop = prop + ":";
        }
        return prop;
    }

    public static String toBlank(String s) {
        if (s == null || "".equals(s)) {
            return BLANK_CHARACTER;
        }
        return s;
    }

    static {
        COMMA = COMMA;
        BLANK_CHARACTER = BLANK_CHARACTER;
    }
}

