/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Page;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PagesParser {
    private static String PAGE = "page";
    private static String PAGEID = "pageID";
    private static String PARENT_PAGEID = "parentPageID";
    private static String SCOPE = "scope";
    private static String TITLE = "title";
    private static String HELP = "help";
    private static String ROLE = "role";
    private static String TABNAME = "tabName";
    private static String SUB_TABNAME = "subTabName";
    private static String THIRD_TABNAME = "thirdTabName";
    private static String AMP = "amp";
    private static String LT = "lt";
    private static String GT = "gt";
    private static String QUOT = "\"";
    public static final String sccs_id = "@(#)PagesParser.java\t1.3 04/21/03 SMI";

    private String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String text = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node cnode = nodeList.item(i);
            switch (cnode.getNodeType()) {
                case 1: {
                    break;
                }
                case 3: {
                    if (text == null) {
                        text = cnode.getNodeValue().trim();
                        break;
                    }
                    text = text + cnode.getNodeValue().trim();
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    if (AMP.equals(cnode.getNodeName())) {
                        text = text + '&';
                        break;
                    }
                    if (LT.equals(cnode.getNodeName())) {
                        text = text + '<';
                        break;
                    }
                    if (GT.equals(cnode.getNodeName())) {
                        text = text + '>';
                        break;
                    }
                    if (!QUOT.equals(cnode.getNodeName())) break;
                    text = text + '\"';
                }
            }
            ++i;
        }
        return text;
    }

    private Page parsePage(Node node) {
        Page page = new Page();
        ArrayList<String> scopes = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName();
                    if (PAGEID.equalsIgnoreCase(n)) {
                        page.pageID = this.getText(cnode);
                        break;
                    }
                    if (PARENT_PAGEID.equalsIgnoreCase(n)) {
                        page.parentPageID = this.getText(cnode);
                        break;
                    }
                    if (HELP.equalsIgnoreCase(n)) {
                        page.help = this.getText(cnode);
                        break;
                    }
                    if (TITLE.equalsIgnoreCase(n)) {
                        page.title = this.getText(cnode);
                        break;
                    }
                    if (TABNAME.equalsIgnoreCase(n)) {
                        page.tabName = this.getText(cnode);
                        break;
                    }
                    if (SUB_TABNAME.equalsIgnoreCase(n)) {
                        page.subTabName = this.getText(cnode);
                        break;
                    }
                    if (ROLE.equalsIgnoreCase(n)) {
                        roles.add(this.getText(cnode));
                        break;
                    }
                    if (SCOPE.equalsIgnoreCase(n)) {
                        scopes.add(this.getText(cnode));
                        break;
                    }
                    if (!THIRD_TABNAME.equalsIgnoreCase(n)) break;
                    page.thirdTabName = this.getText(cnode);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++j;
        }
        String[] _scopes = new String[scopes.size()];
        scopes.toArray(_scopes);
        page.scopes = _scopes;
        String[] _roles = new String[roles.size()];
        roles.toArray(_roles);
        page.roles = _roles;
        return page;
    }

    public HashMap parse(String fileName) throws Exception {
        HashMap<String, Page> pagesMap = new HashMap<String, Page>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new FileReader(fileName)));
        Element node = doc.getDocumentElement();
        if ("pages".equalsIgnoreCase(node.getNodeName())) {
            NodeList children = node.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                if (PAGE.equalsIgnoreCase(cnode.getNodeName())) {
                    Page page = this.parsePage(cnode);
                    pagesMap.put(page.pageID, page);
                }
                ++j;
            }
        }
        return pagesMap;
    }

    static {
        sccs_id = sccs_id;
    }
}

