/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.jade.util.locale.Localizer;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocalizeUtil {
    private static String resource = "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources";
    private static Localizer localizer = new Localizer(resource);
    public static final Locale[] UTF8Locales = new Locale[]{Locale.JAPANESE, Locale.CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
    private static HashMap localMap = new HashMap();
    public static final String UTF_8_ENC = "UTF-8";
    public static final String ISO_8859_ENC = "ISO-8859-1";
    public static final String EUC_JP_ENC = "EUC-JP";
    public static final String SHIFT_JIS_ENC = "SHIFT-JIS";
    public static final String GB2312_ENC = "GB2312";
    static final String sccs_id = "@(#)LocalizeUtil.java 1.9     03/10/07 SMI";

    public static String getLocalizedBoolean(Boolean in, Locale locale) {
        locale = LocalizeUtil.resolveLocale(locale);
        localizer.setLocale(locale);
        if (in == null) {
            return localizer.getString("boolean.unknown");
        }
        if (in.booleanValue()) {
            return localizer.getString("boolean.true");
        }
        return localizer.getString("boolean.false");
    }

    public static String getLocalizedBoolean(boolean in, Locale locale) {
        locale = LocalizeUtil.resolveLocale(locale);
        localizer.setLocale(locale);
        if (in) {
            return localizer.getString("boolean.true");
        }
        return localizer.getString("boolean.false");
    }

    public static String getLocalizedBoolean(int in, Locale locale) {
        locale = LocalizeUtil.resolveLocale(locale);
        localizer.setLocale(locale);
        if (in > 0) {
            return localizer.getString("boolean.true");
        }
        return localizer.getString("boolean.false");
    }

    public static String getLocalizedString(String key, Locale locale) {
        locale = LocalizeUtil.resolveLocale(locale);
        localizer.setLocale(locale);
        return localizer.getString(key);
    }

    public static String getLocalizedString(String key, String[] args, Locale locale) {
        locale = LocalizeUtil.resolveLocale(locale);
        localizer.setLocale(locale);
        String s = localizer.getString(key);
        int i = 0;
        while (i < args.length) {
            s = LocalizeUtil.replace(s, "{" + i + "}", args[i]);
            ++i;
        }
        return s;
    }

    public static String getLocalizedString(String resource, String key, Locale locale) {
        Localizer customLocalizer = new Localizer(resource);
        locale = LocalizeUtil.resolveLocale(locale);
        customLocalizer.setLocale(locale);
        return customLocalizer.getString(key);
    }

    public static String getLocalizedString(String resource, String key, String[] args, Locale locale) {
        locale = LocalizeUtil.resolveLocale(locale);
        Localizer customLocalizer = new Localizer(resource);
        customLocalizer.setLocale(locale);
        String s = customLocalizer.getString(key);
        int i = 0;
        while (i < args.length) {
            s = LocalizeUtil.replace(s, "{" + i + "}", args[i]);
            ++i;
        }
        return s;
    }

    public static String getCharSet(Locale locale) {
        if (locale == null) {
            return ISO_8859_ENC;
        }
        if (locale.equals(Locale.CHINESE) || locale.equals(Locale.SIMPLIFIED_CHINESE)) {
            return GB2312_ENC;
        }
        if (locale.equals(Locale.JAPANESE)) {
            return SHIFT_JIS_ENC;
        }
        return ISO_8859_ENC;
    }

    public static String convert(String str, String from, String to) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return new String(str.getBytes(from), to);
    }

    public static void intValueOf(String s) {
        Debug.println("Integer values of " + s);
        if (s == null) {
            return;
        }
        String delim = "";
        int i = 0;
        while (i < s.length()) {
            System.out.print(delim);
            System.out.print((int)s.charAt(i));
            delim = " ";
            ++i;
        }
        System.out.println();
    }

    public static void testChars(String s) {
        if (s == null || "".equals(s)) {
            return;
        }
        String[] charset = new String[]{UTF_8_ENC, ISO_8859_ENC, EUC_JP_ENC, SHIFT_JIS_ENC, GB2312_ENC};
        Debug.println("Tests " + s + " with system default charset");
        try {
            String str;
            int i = 0;
            while (i < charset.length) {
                str = new String(s.getBytes(charset[i]));
                Debug.println("getBytes with " + charset[i] + ":" + str);
                LocalizeUtil.intValueOf(str);
                ++i;
            }
            int i2 = 0;
            while (i2 < charset.length) {
                str = new String(s.getBytes(), charset[i2]);
                Debug.println("set charset to " + charset[i2] + ":" + str);
                LocalizeUtil.intValueOf(str);
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized Locale resolveLocale(Locale inLocale) {
        Locale fallbackLocale = new Locale("en", "", "");
        if (inLocale == null) {
            return fallbackLocale;
        }
        Locale resolvedLocale = (Locale)localMap.get(inLocale.toString());
        if (resolvedLocale == null) {
            ResourceBundle rb = ResourceBundle.getBundle(resource, inLocale);
            Locale testLocale = rb.getLocale();
            if (testLocale.getLanguage().equals(inLocale.getLanguage())) {
                if (inLocale.getCountry() == null || inLocale.getCountry().trim() == "" || testLocale.getCountry() == null || testLocale.getCountry().trim() == "") {
                    resolvedLocale = testLocale;
                } else if (inLocale.getCountry().equals(testLocale.getCountry())) {
                    resolvedLocale = testLocale;
                } else {
                    Debug.println("resolve locale: cannot find the rb for " + inLocale.toString() + " because the country cannot match. will use the fallback one.");
                    resolvedLocale = fallbackLocale;
                }
            } else {
                Debug.println("resolve locale: cannot find the rb for " + inLocale.toString() + " because the language cannot match. will use the fallback one.");
                resolvedLocale = fallbackLocale;
            }
            localMap.put(inLocale.toString(), resolvedLocale);
        }
        return resolvedLocale;
    }

    private static String replace(String in, String beReplaced, String toReplace) {
        if (in == null || beReplaced == null || toReplace == null) {
            return in;
        }
        int pos = in.indexOf(beReplaced);
        while (pos != -1) {
            in = in.substring(0, pos) + toReplace + in.substring(pos + beReplaced.length());
            pos = in.indexOf(beReplaced);
        }
        return in;
    }

    static {
        UTF_8_ENC = UTF_8_ENC;
        ISO_8859_ENC = ISO_8859_ENC;
        EUC_JP_ENC = EUC_JP_ENC;
        SHIFT_JIS_ENC = SHIFT_JIS_ENC;
        GB2312_ENC = GB2312_ENC;
        sccs_id = sccs_id;
    }
}

