/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public class DateUtil {
    private static SimpleDateFormat formatter1;
    private static SimpleDateFormat formatter2;
    private static SimpleDateFormat formatter3;
    private static SimpleDateFormat formatter4;
    private static final String ENGLISH_FULL_TZ_FORMAT_MASK = "EEEE, MMMM d, yyyy h:mm:ss a z";
    private static final String ENGLISH_FULL_FORMAT_MASK = "EEEE, MMMM d, yyyy h:mm:ss a";
    private static final String ENGLISH_MEDIUM_FORMAT_MASK = "MM/dd/yyyy HH:mm:ss";
    private static final String ENGLISH_SHORT_FORMAT_MASK = "MM/dd/yyyy";
    private static final String ENGLISH_NO_YEAR_FORMAT_MASK = "MM/dd HH:mm:ss";

    private DateUtil() {
    }

    public static Date toDate1(String s) {
        DateUtil.init1();
        Date date = null;
        try {
            date = formatter1.parse(s);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static String toString1(Date date, Locale locale) {
        String result = date.toString();
        try {
            String pattern = DateUtil.getMediumFormatMask(locale);
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            result = formatter.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void init1() {
        if (formatter1 == null) {
            formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    }

    public static Date toDate2(String s) {
        DateUtil.init2();
        Date date = null;
        try {
            date = formatter2.parse(s);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static String toString2(Date date, Locale locale) {
        String result = date.toString();
        try {
            String pattern = DateUtil.getFullTzFormatMask(locale);
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
            result = formatter.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void init2() {
        if (formatter2 == null) {
            formatter2 = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        }
    }

    public static Date toDate3(String s) {
        DateUtil.init3();
        Date date = null;
        try {
            date = formatter3.parse(s);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static Date toDate4(String s) {
        DateUtil.init4();
        Date date = null;
        try {
            date = formatter4.parse(s);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return date;
    }

    private static void init4() {
        if (formatter4 == null) {
            formatter4 = new SimpleDateFormat(ENGLISH_MEDIUM_FORMAT_MASK);
        }
    }

    public static String toString3(Date date, Locale locale) {
        String result = date.toString();
        try {
            String pattern = DateUtil.getFullFormatMask(locale);
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
            result = formatter.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void init3() {
        if (formatter3 == null) {
            formatter3 = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
        }
    }

    public static String getMediumFormatMask(Locale locale) {
        String pattern = ENGLISH_MEDIUM_FORMAT_MASK;
        try {
            ResourceBundle r = LocaleData.getLocaleElements((Locale)locale);
            String[] dateTimePatterns = r.getStringArray("DateTimePatterns");
            pattern = dateTimePatterns[7];
            if (pattern.indexOf("yyyy") == -1) {
                pattern = pattern.replaceFirst("yy", "yyyy");
            }
            if (pattern.indexOf("MM") == -1) {
                pattern = pattern.replaceFirst("M", "MM");
            }
            if (pattern.indexOf("dd") == -1) {
                pattern = pattern.replaceFirst("d", "dd");
            }
            pattern = pattern + " " + dateTimePatterns[2];
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                pattern = pattern.replaceFirst("h:mm:ss a", "HH:mm:ss");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pattern;
    }

    public static String getShortFormatMask(Locale locale) {
        String pattern = ENGLISH_SHORT_FORMAT_MASK;
        try {
            ResourceBundle r = LocaleData.getLocaleElements((Locale)locale);
            String[] dateTimePatterns = r.getStringArray("DateTimePatterns");
            pattern = dateTimePatterns[7];
            if (pattern.indexOf("yyyy") == -1) {
                pattern = pattern.replaceFirst("yy", "yyyy");
            }
            if (pattern.indexOf("MM") == -1) {
                pattern = pattern.replaceFirst("M", "MM");
            }
            if (pattern.indexOf("dd") == -1) {
                pattern = pattern.replaceFirst("d", "dd");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pattern;
    }

    public static String getVeryShortFormatMask(Locale locale) {
        String pattern = DateUtil.getShortFormatMask(locale);
        pattern = pattern.replaceFirst("dd", "");
        if ((pattern = pattern.replaceFirst("//", "/")).startsWith("/")) {
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("/") || pattern.endsWith("-")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return pattern;
    }

    public static String getNoYearFormatMask(Locale locale) {
        String pattern = DateUtil.getMediumFormatMask(locale);
        pattern = pattern.replaceFirst("yyyy", "");
        if ((pattern = pattern.replaceFirst("/ ", " ")).startsWith("/")) {
            pattern = pattern.substring(1);
        }
        return pattern;
    }

    public static String getFullFormatMask_Internal(Locale locale, String p) {
        String pattern = p;
        try {
            ResourceBundle r = LocaleData.getLocaleElements((Locale)locale);
            String[] dateTimePatterns = r.getStringArray("DateTimePatterns");
            pattern = dateTimePatterns[4];
            pattern = pattern + " " + dateTimePatterns[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pattern;
    }

    public static String getFullTzFormatMask(Locale locale) {
        return DateUtil.getFullFormatMask_Internal(locale, ENGLISH_FULL_TZ_FORMAT_MASK);
    }

    public static String getFullFormatMask(Locale locale) {
        return DateUtil.getFullFormatMask_Internal(locale, ENGLISH_FULL_FORMAT_MASK);
    }

    static {
        ENGLISH_FULL_TZ_FORMAT_MASK = ENGLISH_FULL_TZ_FORMAT_MASK;
        ENGLISH_FULL_FORMAT_MASK = ENGLISH_FULL_FORMAT_MASK;
        ENGLISH_MEDIUM_FORMAT_MASK = ENGLISH_MEDIUM_FORMAT_MASK;
        ENGLISH_SHORT_FORMAT_MASK = ENGLISH_SHORT_FORMAT_MASK;
        ENGLISH_NO_YEAR_FORMAT_MASK = ENGLISH_NO_YEAR_FORMAT_MASK;
    }
}

