/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.common;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.sun.netstorage.mgmt.fm.storade.ui.common.InstallerServlet;
import com.sun.netstorage.mgmt.fm.storade.ui.util.App;
import com.sun.netstorage.mgmt.fm.storade.ui.util.ApplicationsParser;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LinkModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SubTask;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.TabContext;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Task;
import com.sun.web.common.ConsoleServletBase;
import java.io.IOException;
import java.io.Reader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppServletBase
extends ConsoleServletBase {
    private static ArrayList applications;
    public static final String SITEINFO_NOT_READY_KEY = "siteInfoNotReady";

    protected void addResponseHeaders(RequestContext requestContext) {
        super.addResponseHeaders(requestContext);
        HttpServletResponse response = requestContext.getResponse();
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
    }

    protected void processRequest(String pageName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            if (!"true".equals(this.getServletContext().getAttribute("storade.isBaseInitialized"))) {
                InstallerServlet.initBaseProperties(this.getServletContext());
            }
            String isSiteInfoReady = (String)this.getServletContext().getAttribute("storade.isSiteInfoReady");
            String SiteInfoURI = "/" + Connection.getAppName() + "/admin/SiteInfo";
            String UpdateSystemPropertiesURI = "/" + Connection.getAppName() + "/admin/UpdateSystemProperties";
            if (!("true".equals(isSiteInfoReady) || SiteInfoURI.equals(request.getRequestURI()) || UpdateSystemPropertiesURI.equals(request.getRequestURI()))) {
                boolean isDead = AppServletBase.isDead();
                if (!AppServletBase.isDead()) {
                    try {
                        if (InstallerServlet.isRequiredSiteInfoIn(null)) {
                            this.getServletContext().setAttribute("storade.isSiteInfoReady", (Object)"true");
                            break block16;
                        }
                        String url = SiteInfoURI + "?" + SITEINFO_NOT_READY_KEY + "=true";
                        Debug.println("SITE INFO NOT READY, GO TO SITE INFO PAGE");
                        response.sendRedirect(url);
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        Enumeration names = request.getParameterNames();
        String name = "";
        boolean foundHREF = false;
        boolean foundTab = false;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (name.endsWith("StoradeHREF")) {
                foundHREF = true;
                break;
            }
            if (!name.endsWith("LocalTabs.TabHref")) continue;
            foundTab = true;
            break;
        }
        if (foundHREF) {
            String value = request.getParameter(name);
            String key = name.substring(name.lastIndexOf(".") + 1);
            String url = NavUtil.getURL(key, value);
            Debug.println("FOUND AND USE OWN URL FOR STORADEHREF: " + url);
            try {
                response.sendRedirect(url);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (foundTab) {
            String node = request.getParameter(name);
            TabContext tabContext = (TabContext)request.getSession().getAttribute("esm.roadking.tabcontext.session");
            try {
                String url = this.getNodeURL(new Integer(node), tabContext);
                Debug.println("FOUND AND USE OWN URL FOR TAB NODE: " + url);
                response.sendRedirect(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            super.processRequest(pageName, request, response);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initTabs(config.getServletContext());
    }

    public void onSessionTimeout(RequestContext requestContext) {
        try {
            requestContext.getResponse().sendRedirect("/" + Connection.getAppName() + "/index.html");
        }
        catch (IOException ex) {
            System.err.println("forward exception (IO):" + ex.getMessage());
        }
        catch (IllegalStateException ex) {
            System.err.println("forward exception (state):" + ex.getMessage());
        }
        throw new CompleteRequestException();
    }

    protected void onRequestHandlerNotSpecified(RequestContext requestContext) throws ServletException {
        System.err.println("Request Handler not specified");
        this.onSessionTimeout(requestContext);
    }

    protected void onRequestHandlerNotFound(RequestContext requestContext, String handlerName) throws ServletException {
        System.err.println("Request Handler not found");
        this.onSessionTimeout(requestContext);
    }

    private void initTabs(ServletContext sc) {
        if (applications == null) {
            String fullPath = SystemUtil.getAppFileName();
            String value = sc.getRealPath(fullPath);
            if (value != null) {
                fullPath = value;
            }
            try {
                ApplicationsParser ap = new ApplicationsParser();
                applications = ap.parse(fullPath);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Problem occurs when reading applications.xml file at " + fullPath + "/n");
            }
        }
    }

    private String getNodeURL(int id, TabContext tabContext) {
        int tabIndex = 0;
        int subTabIndex = 0;
        int thirdTabIndex = 0;
        String url = null;
        int MAX_TAB_NUMBER = 100;
        String FIRST_CLICKING = "FirstClicking";
        String CLICKING = "Clicking";
        if (id < MAX_TAB_NUMBER) {
            LinkModel[] links;
            tabIndex = id - 1;
            App app = (App)applications.get(tabIndex);
            if (tabContext != null && (links = tabContext.getLinks(app.name)) != null && links.length > 0) {
                url = links[links.length - 1].getLinkValue();
            }
            Debug.println("get url from session " + url + " " + app.name);
            if (url == null) {
                url = app.navMap.defaultTarget;
                tabContext.setLastTabName(FIRST_CLICKING + app.name);
            } else {
                tabContext.setLastTabName(CLICKING + app.name);
            }
        } else if (id < MAX_TAB_NUMBER * MAX_TAB_NUMBER) {
            tabIndex = id / MAX_TAB_NUMBER - 1;
            subTabIndex = id % MAX_TAB_NUMBER - 1;
            App app = (App)applications.get(tabIndex);
            Task task = (Task)app.tasks.get(subTabIndex);
            url = task.navMap.defaultTarget;
            tabContext.setLastSubTabName(CLICKING + task.name);
        } else {
            tabIndex = id / (MAX_TAB_NUMBER * MAX_TAB_NUMBER) - 1;
            subTabIndex = id % (MAX_TAB_NUMBER * MAX_TAB_NUMBER) / MAX_TAB_NUMBER - 1;
            thirdTabIndex = id % (MAX_TAB_NUMBER * MAX_TAB_NUMBER) % MAX_TAB_NUMBER - 1;
            App app = (App)applications.get(tabIndex);
            Task task = (Task)app.tasks.get(subTabIndex);
            SubTask subTask = (SubTask)task.subTasks.get(thirdTabIndex);
            url = subTask.navMap.defaultTarget;
            tabContext.setLastThirdTabName(CLICKING + subTask.name);
        }
        return url;
    }

    private static boolean isDead() {
        boolean dead = false;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary&format=xml";
            Reader reader = Connection.getReader(s);
        }
        catch (ConnectException ex) {
            dead = true;
            Debug.println("Connection exception - Storade middle tier probably dead");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            dead = true;
            Debug.println("Exception - problem accessing middle tier, possibly a HTTP 500 error Apache in a weird state");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            Debug.println("Exception - possible problem accessing middle tier");
            ex.printStackTrace();
        }
        return dead;
    }

    static {
        SITEINFO_NOT_READY_KEY = SITEINFO_NOT_READY_KEY;
    }
}

