/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.symbol;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import devmgr.v0912api01.symbol.ControllerRef;
import devmgr.v0912api01.symbol.DriveChannelDegradeReason;
import devmgr.v0912api01.symbol.DriveChannelState;
import devmgr.v0912api01.symbol.DriveChannelStatistics;
import devmgr.v0912api01.symbol.SYMbolAPIConstants;

public class DriveChannel
implements XDRType,
SYMbolAPIConstants {
    private int channel;
    private DriveChannelState state = new DriveChannelState();
    private DriveChannelDegradeReason reason = new DriveChannelDegradeReason();
    private ControllerRef degradingController = new ControllerRef();
    private DriveChannelStatistics statsControllerA = new DriveChannelStatistics();
    private DriveChannelStatistics statsControllerB = new DriveChannelStatistics();

    public DriveChannel() {
    }

    public DriveChannel(DriveChannel driveChannel) {
        this.channel = driveChannel.channel;
        this.state = driveChannel.state;
        this.reason = driveChannel.reason;
        this.degradingController = driveChannel.degradingController;
        this.statsControllerA = driveChannel.statsControllerA;
        this.statsControllerB = driveChannel.statsControllerB;
    }

    public int getChannel() {
        return this.channel;
    }

    public ControllerRef getDegradingController() {
        return this.degradingController;
    }

    public DriveChannelDegradeReason getReason() {
        return this.reason;
    }

    public DriveChannelState getState() {
        return this.state;
    }

    public DriveChannelStatistics getStatsControllerA() {
        return this.statsControllerA;
    }

    public DriveChannelStatistics getStatsControllerB() {
        return this.statsControllerB;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setDegradingController(ControllerRef controllerRef) {
        this.degradingController = controllerRef;
    }

    public void setReason(DriveChannelDegradeReason driveChannelDegradeReason) {
        this.reason = driveChannelDegradeReason;
    }

    public void setState(DriveChannelState driveChannelState) {
        this.state = driveChannelState;
    }

    public void setStatsControllerA(DriveChannelStatistics driveChannelStatistics) {
        this.statsControllerA = driveChannelStatistics;
    }

    public void setStatsControllerB(DriveChannelStatistics driveChannelStatistics) {
        this.statsControllerB = driveChannelStatistics;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.state.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reason.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.degradingController.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.statsControllerA.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.statsControllerB.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.channel);
        this.state.xdrEncode(xDROutputStream);
        this.reason.xdrEncode(xDROutputStream);
        this.degradingController.xdrEncode(xDROutputStream);
        this.statsControllerA.xdrEncode(xDROutputStream);
        this.statsControllerB.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }
}

