/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.jrpc;

import devmgr.trace.Trace;
import devmgr.v0912api01.jrpc.RPCAcceptedReply;
import devmgr.v0912api01.jrpc.RPCAcceptedStatus;
import devmgr.v0912api01.jrpc.RPCDebug;
import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.RPCMsg;
import devmgr.v0912api01.jrpc.RPCRequestDetails;
import devmgr.v0912api01.jrpc.TCPChannel;
import devmgr.v0912api01.jrpc.UDPChannel;
import devmgr.v0912api01.jrpc.UDPMessageBundle;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDRMessageIOV;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public abstract class RPCServer {
    private int m_Program = 0;
    private int m_Version = 0;
    private int m_TcpTimeout = 0;
    private boolean m_UdpStarted = false;
    private boolean m_TcpStarted = false;
    private Thread m_UdpThread = null;
    private Thread m_TcpListenerThread = null;
    private ThreadGroup m_ThreadGroup = null;
    private boolean m_ThreadGroupStopped = false;
    private boolean m_RunAsDaemon = false;
    private Hashtable m_ReqDetailsTable = new Hashtable();

    public RPCServer(int n, int n2) {
        this.m_Program = n;
        this.m_Version = n2;
        this.m_ThreadGroup = new ThreadGroup(this.toString());
    }

    public boolean allowConnection(InetAddress inetAddress) {
        return true;
    }

    protected void exceptionHandler(Exception exception) {
        Trace.println(79, "Exception in RPC server: " + exception.toString());
        Trace.printStackTrace(79, exception);
    }

    public RPCRequestDetails getRequestDetails() {
        return (RPCRequestDetails)this.m_ReqDetailsTable.get(Thread.currentThread());
    }

    public synchronized int getTcpTimeout() {
        return this.m_TcpTimeout;
    }

    public synchronized void halt() {
        try {
            this.m_ThreadGroup = null;
            this.m_ThreadGroupStopped = true;
        }
        catch (Exception exception) {
            Trace.printStackTrace(79, exception);
        }
    }

    public void nullHandler() throws RPCError {
    }

    public abstract XDRType processCall(int var1, XDRInputStream var2) throws RPCError;

    public void setDaemon(boolean bl) {
        this.m_RunAsDaemon = bl;
    }

    public synchronized void setTcpTimeout(int n) {
        this.m_TcpTimeout = n;
    }

    public synchronized int startTCP(int n) throws RPCError, IOException {
        int n2 = n;
        if (this.m_TcpStarted) {
            throw new RPCError("TCP_SERVER_ACTIVE");
        }
        ServerSocket serverSocket = new ServerSocket(n2);
        n2 = serverSocket.getLocalPort();
        this.m_TcpListenerThread = new Thread(this.m_ThreadGroup, new TCPListenerThread(serverSocket));
        this.m_TcpListenerThread.setDaemon(this.m_RunAsDaemon);
        this.m_TcpListenerThread.start();
        this.m_TcpStarted = true;
        return n2;
    }

    private synchronized void startTcpHandler(Socket socket) throws IOException {
        if (!this.allowConnection(socket.getInetAddress())) {
            socket.close();
        } else {
            Thread thread = new Thread(this.m_ThreadGroup, new TCPConnectionThread(socket));
            thread.setDaemon(this.m_RunAsDaemon);
            thread.start();
        }
    }

    public synchronized int startUDP(int n) throws RPCError, IOException {
        DatagramSocket datagramSocket;
        int n2 = n;
        if (this.m_UdpStarted) {
            throw new RPCError("UDP_SERVER_ACTIVE");
        }
        if (n != 0) {
            datagramSocket = new DatagramSocket(n2);
        } else {
            datagramSocket = new DatagramSocket();
            n2 = datagramSocket.getLocalPort();
        }
        this.m_UdpThread = new Thread(this.m_ThreadGroup, new UDPThread(datagramSocket));
        this.m_UdpThread.setDaemon(this.m_RunAsDaemon);
        this.m_UdpThread.start();
        this.m_UdpStarted = true;
        return n2;
    }

    private XDRMessageIOV transact(XDRMessageIOV xDRMessageIOV, boolean bl, InetAddress inetAddress, int n) throws RPCError {
        XDRMessageIOV xDRMessageIOV2;
        block14: {
            boolean bl2;
            XDRType xDRType;
            RPCMsg rPCMsg;
            XDROutputStream xDROutputStream;
            block16: {
                RPCAcceptedStatus rPCAcceptedStatus;
                Thread thread;
                boolean bl3;
                RPCMsg rPCMsg2;
                XDRInputStream xDRInputStream;
                block17: {
                    RPCAcceptedReply rPCAcceptedReply;
                    block15: {
                        xDRMessageIOV2 = null;
                        xDRInputStream = new XDRInputStream(xDRMessageIOV);
                        xDROutputStream = null;
                        rPCMsg = new RPCMsg();
                        rPCMsg2 = new RPCMsg();
                        xDRType = null;
                        bl3 = false;
                        bl2 = false;
                        thread = Thread.currentThread();
                        rPCAcceptedReply = rPCMsg.getBody().getReplyMsg().getAcceptedReply();
                        rPCAcceptedStatus = rPCAcceptedReply.getBody().getStatus();
                        Trace.println(4, "Received call from " + inetAddress);
                        if (Trace.isTracing(5)) {
                            RPCDebug.dumpIOV(5, xDRMessageIOV);
                        }
                        rPCMsg2.xdrDecode(xDRInputStream);
                        if (rPCMsg2.getBody().getMsgType().getValue() != 0 || rPCMsg2.getBody().getCallMsg().getRpcVersion() != 2) break block14;
                        rPCMsg.setXid(rPCMsg2.getXid());
                        rPCMsg.getBody().getMsgType().setValue(1);
                        rPCAcceptedStatus.setValue(0);
                        rPCAcceptedReply.setVerifier(rPCMsg2.getBody().getCallMsg().getVerifier());
                        if (rPCMsg2.getBody().getCallMsg().getProgramNo() == this.m_Program) break block15;
                        rPCAcceptedStatus.setValue(1);
                        break block16;
                    }
                    if (rPCMsg2.getBody().getCallMsg().getVersionNo() == this.m_Version) break block17;
                    rPCAcceptedStatus.setValue(2);
                    rPCAcceptedReply.getBody().getVersions().setLow(this.m_Version);
                    rPCAcceptedReply.getBody().getVersions().setHigh(this.m_Version);
                    break block16;
                }
                RPCRequestDetails rPCRequestDetails = new RPCRequestDetails(rPCMsg2, inetAddress, n, bl);
                this.m_ReqDetailsTable.put(thread, rPCRequestDetails);
                try {
                    try {
                        bl3 = false;
                        bl2 = false;
                        xDRType = this.processCall(rPCMsg2.getBody().getCallMsg().getProcedure(), xDRInputStream);
                    }
                    catch (RPCError rPCError) {
                        Trace.printStackTrace(79, rPCError);
                        if (rPCError.getMessage().equals("SUPPRESS_REPLY")) {
                            bl2 = true;
                        }
                        bl3 = true;
                    }
                    Object var18_18 = null;
                    this.m_ReqDetailsTable.remove(thread);
                }
                catch (Throwable throwable) {
                    Object var18_19 = null;
                    this.m_ReqDetailsTable.remove(thread);
                    throw throwable;
                }
                if (!bl2) {
                    if (bl3) {
                        rPCAcceptedStatus.setValue(4);
                    } else if (xDRType == null) {
                        rPCAcceptedStatus.setValue(3);
                    } else {
                        rPCAcceptedStatus.setValue(0);
                    }
                }
            }
            if (!bl2) {
                xDROutputStream = new XDROutputStream();
                rPCMsg.xdrEncode(xDROutputStream);
                if (xDRType != null) {
                    xDRType.xdrEncode(xDROutputStream);
                }
                xDRMessageIOV2 = xDROutputStream.getMessage();
                Trace.println(4, "Sending reply to " + inetAddress);
                if (Trace.isTracing(6)) {
                    RPCDebug.dumpIOV(6, xDRMessageIOV2);
                }
            }
        }
        return xDRMessageIOV2;
    }

    class TCPConnectionThread
    implements Runnable {
        private TCPChannel m_Channel = null;
        private InetAddress m_RemoteAddress = null;
        private int m_RemotePort;

        TCPConnectionThread(Socket socket) throws IOException {
            this.m_RemoteAddress = socket.getInetAddress();
            this.m_RemotePort = socket.getPort();
            this.m_Channel = new TCPChannel(socket);
            this.m_Channel.setTimeout(RPCServer.this.getTcpTimeout());
        }

        protected void finalize() throws Throwable {
            if (this.m_Channel != null) {
                this.m_Channel.close();
            }
        }

        public void run() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[" + this.m_RemoteAddress.toString() + ":" + this.m_RemotePort + "]");
            Thread.currentThread().setName(stringBuffer.toString());
            Trace.println(4, "Server TCP thread started");
            while (!bl && !RPCServer.this.m_ThreadGroupStopped) {
                try {
                    XDRMessageIOV xDRMessageIOV = this.m_Channel.receiveMsg();
                    XDRMessageIOV xDRMessageIOV2 = RPCServer.this.transact(xDRMessageIOV, true, this.m_RemoteAddress, this.m_RemotePort);
                    if (xDRMessageIOV2 == null) continue;
                    this.m_Channel.sendMsg(xDRMessageIOV2);
                    xDRMessageIOV2 = null;
                }
                catch (Exception exception) {
                    RPCServer.this.exceptionHandler(exception);
                    bl = true;
                }
            }
            Trace.println(4, "Server TCP thread exiting");
            try {
                this.m_Channel.close();
                this.m_Channel = null;
            }
            catch (Exception exception) {
                Trace.printStackTrace(79, exception);
            }
        }
    }

    class TCPListenerThread
    implements Runnable {
        private ServerSocket m_Sock;

        TCPListenerThread(ServerSocket serverSocket) {
            this.m_Sock = serverSocket;
        }

        protected void finalize() throws Throwable {
        }

        public void run() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.m_Sock.getLocalPort();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[" + n + "]");
            Thread.currentThread().setName(stringBuffer.toString());
            Trace.printf(4, "Server TCP listener running on port %d", new Integer(n));
            while (!bl && !RPCServer.this.m_ThreadGroupStopped) {
                try {
                    Socket socket = this.m_Sock.accept();
                    RPCServer.this.startTcpHandler(socket);
                }
                catch (IOException iOException) {
                    RPCServer.this.exceptionHandler(iOException);
                    bl = true;
                }
            }
            try {
                this.m_Sock.close();
            }
            catch (IOException iOException) {
                Trace.printStackTrace(79, iOException);
            }
        }
    }

    class UDPThread
    implements Runnable {
        private UDPChannel m_Channel = null;
        private int m_Port;

        UDPThread(DatagramSocket datagramSocket) {
            this.m_Channel = new UDPChannel(datagramSocket);
            this.m_Port = datagramSocket.getLocalPort();
        }

        protected void finalize() throws Throwable {
            if (this.m_Channel != null) {
                this.m_Channel.close();
            }
        }

        public void run() {
            XDRMessageIOV xDRMessageIOV = null;
            XDRMessageIOV xDRMessageIOV2 = null;
            UDPMessageBundle uDPMessageBundle = null;
            UDPMessageBundle uDPMessageBundle2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[" + this.m_Port + "]");
            Thread.currentThread().setName(stringBuffer.toString());
            Trace.printf(4, "Server UDP thread running on port %d", new Integer(this.m_Port));
            while (!RPCServer.this.m_ThreadGroupStopped) {
                try {
                    uDPMessageBundle2 = this.m_Channel.receiveMsg();
                    xDRMessageIOV = uDPMessageBundle2.getMsg();
                    xDRMessageIOV2 = RPCServer.this.transact(xDRMessageIOV, false, uDPMessageBundle2.getAddress(), uDPMessageBundle2.getPort());
                    if (xDRMessageIOV2 == null) continue;
                    uDPMessageBundle = new UDPMessageBundle(xDRMessageIOV2, uDPMessageBundle2.getAddress(), uDPMessageBundle2.getPort());
                    this.m_Channel.sendMsg(uDPMessageBundle);
                    uDPMessageBundle = null;
                }
                catch (Exception exception) {
                    RPCServer.this.exceptionHandler(exception);
                }
            }
        }
    }
}

