package Trap::5310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name: bld61_002 $ 
#  $Id: 5310.pm,v 1.3 2005/03/17 20:57:59 kdesai Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Policies;
use Trap;
use Labels;



sub REGISTER {
   #return ['enterprises.42.2.28.13.3.14.1'];
   return ['.1.3.6.1.4.1.42.2.28.13.3.12.1','.1.3.6.1.4.1.42.2.28.13.3.13.1']; # Note 12 means 5310 and 13 means 5310 C
}

sub RUN {
  my($trap_agent, $lines, $errors) = @_;

  my $LB = Labels->read("Trap::5310");

  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my(%DEV, $x);
  my $policies = Policies->new("5210_policies");

  my $devs = $Config->devices();
  foreach my $d (@$devs) {
     $DEV{$d->{ipno}} = $d;
  }

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = Trap->last_snmp($lines->[$x], 3);
     #my $fulltrapID = $line->{'snmpTrap.snmpTrapOID.0'};

     my $h = $lines->[$x];
     my $trapID = 0;
     foreach my $e (keys %$h) {
       if ($e =~ /Enterprise Specific Trap \((\d+)\)/) {
         $trapID = $1;
       }
     }

#     my $fulltrapID = $line->{'4.1.0'};
#     my $ix = rindex($fulltrapID,".");
#     my $trapID = substr($fulltrapID,$ix+1);

     my $severity = "severity_".$trapID;
     my $topicAttributeName = "topicAttributeName_".$trapID;
     my $description = "descr_".$trapID;
     my $sev  = $LB->{"$severity"};
     my $alltopic= $LB->{"$topicAttributeName"};
     my $traptype = "trapType_".$trapID;
     my $trptype= $LB->{"$traptype"};

     my(@ary_topics) = split(/\,/, $alltopic);
     my $topic = $ary_topics[0]; 

     my $id   = $line->{IP};
#     my $desc = $LB->{"$description"};
     my $ip   = $line->{IP};
     my $dev_name=$DEV{$ip}{name};
     my $key  = $DEV{$ip}{key};
  
     my $i = 0;
     my @data;
     my $numberofdatalines = 0;
     $numberofdatalines = $#ary_topics;
     my $dataline = Trap->last_snmp($lines->[$x], 50); # 50 is useless
     my ($key1, $value);
     my %dataline1 = %$dataline;

     foreach $key1 (sort keys(%dataline1)) {

        if ( ($i <= $numberofdatalines) && 
	     (($key1 =~ /.1.3.6.1.4.1.42.2.28.13.3.13.1/) ||
	      ($key1 =~ /.1.3.6.1.4.1.42.2.28.13.3.12.1/)) && 
	     (!($key1 =~ /Enterprise Specific Trap \((\d+)\)/)) ) { 
          #$data .= "$ary_topics[$i] = $value"; 

	  $value = $dataline1{$key1};	  
	  $data[$i] = $value;
	  $i++;
	}
     }

     my $desc = $LB->expand("$description", @data);

     my $loglines = ["$line->{DATE} $line->{TIME} $line->{DEVICE} $ip Sev:$sev Type:$topic TrapType:$trptype SystemID:$id Description: $desc"];
     my $y = 0;
     my $key = "5310:$key:$topic";
     my $key0= "5310:$key";

     $policies->run($errors, 
                    $loglines, \$y, 
                    $topic,
                    $dev_name, 
                    $key, 
                    $ip,
                    $key0, 
                    1);
  }
}

1;
