package Tests::QlogicSwitch;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2002, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base "Tests";
use Tests::General;
use PDM::ConfigFile;
#
# switch2test
# preform executes right before the form is displayed, 
# used to set field values.
#
sub Qlogic_SwitchTest_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my($err, $t);
  my $config = PDM::ConfigFile->read();
  
  my $key = $node->key();
  my $dev = $config->deviceByKey($key);
  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  my $pass = $class->getPassword($dev, \$err, 'switch');

  my(%DATA) = ('#PASSWD' =>  $pass);

  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);

  $err .= $gen_err if ($gen_err);
  return ($err, \%DATA);
}

#
# runs after the used submit the test form
# used to validate the test, refuse to run it etc..
#
sub Qlogic_SwitchTest_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($t, $err);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();

  if (($t = $class->testRunning("*", $key))) {
     return "A test on $key already exists";
  }


  if ($q->{"opt_passwd"} eq "#PASSWD" ) {
     $err .= "Must enter a valid password to run this test.";
  }
  return $err;
}



1;
