package Tests::QLC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base "Tests";
use Tests::General;
use PDM::ConfigFile;

#
# preform executes right before the form is displayed, 
# used to set field values.
#
sub qlctest_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my ($err, $collisions);

  if (($collisions = $class->rulesOfTodd($command, $to, $node)) ) {
     return $collisions;
  }
}

#
# runs after the used submit the test form
# used to validate the test, refuse to run it etc..
#
sub qlctest_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($err, $t, $collisions);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();


  
  if (($collisions = $class->rulesOfTodd($command, $to, $node)) ) {
     return $collisions;
  }
  if (($t = $class->testRunning("*", $key))) {
     return "Test cannot start: A test is already running on $key.";
  }
  if ($q->{"opt_run_connect"} eq "No") 
  {
     # only do this check if an internal type operation was selected
     if(($q->{"opt_selftest"} eq "Enable") ||
	($q->{"opt_ilb_10"}   eq "Enable") ||
	($q->{"opt_ilb"}      eq "Enable") ||
	($q->{"opt_checksum"} eq "Enable") )
      {

     
        my $links = $node->port();
        if ($q->{register} =~ /[ALL]/) {
          my $x;
          for ($x=0; $x <= $#$links; $x++) {
           if ($links->[$x]) {          
             $err = "Port $x is/was connected to $links->[$x] as seen by the topology, to run this test, you must".
                   " check the 'Allow Internal Tests to Run if Connected to Storage' checkbox";
             last;    
           }
          }
        } else {
          my @regs = split(/\t/, $q->{register});
          foreach my $reg (@regs) {
             my($pno, $path) = split(/\:/, $reg, 2);
             if ($links->[$pno]) {
                $err = "Port $pno is/was connected to $links->[$pno] as seen by the topology, to run this test, you must".
                   " check the 'Allow Internal Tests to Run if Connected to Storage' checkbox";
                last;    
             }
          }
        }
     }
  }
  return $err;
}
1;
