package Tests;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Scheduler;
use strict;
use Tests::General;
use Resource;
use base 'Resource';

sub base      { 'Tests' }
sub extension { "" }
sub exclude   { ",values,default,devType,fruType,node,defaults,opt,type," }
sub mark      { ",name," }   #

# $class->testExist("*", "wwn");
# $class->testExist("*", "wwn", "port1");

sub getPassword {
  my($class, $dev, $err, $type) = @_;
  my $pass;
  $type = "array" if (!$type);

  if ($dev->{telnet}) {
     $pass = Util->decode($dev->{telnet});
  } else {
     $pass = System->getPassword($type);
     if (!$pass) {
       $$err .= "No password defined for this device. ($dev->{key})";
     }
  }
  return $pass;
}

sub testRunning {
  my($class,  $host, $key, $port) = @_;

  my $list = Scheduler->processList("ST", $host, 'O');  # open only
  my @P = split(/\t/, $port);
  foreach my $l (@$list) {
      my $i = $l->info();
      if ($i->{key} eq $key) {
        if (!$port) {
           return $l;
        } else {
           foreach my $p0 (@P) {
              if (index("\t$i->{ports}\t", "\t$p0\t") >= 0) {
                return $l;
              }
           }
        }
      }
  }
  return undef;
}

#####################
# Rules of Todd
#####################
# 
# 1- a5kses/dakses test can't run when qlc or socal test running.
# 2- switch test can't run when qlc running.
# 3- tapetest can't run with qlc running.
# 4- qlctest can't run when switch, disks, ses's, tape are running.
# 5- Interactive test must run on their own.
# 6- if a switch is being tested, that switch cannot be used to test a cascaded switch
#    only allow one switch test to run at a time.

#10- You shall not steal tests.


sub rulesOfTodd {
  my($class, $comm, $to, $node) = @_;
  my($err);
  my $list = Scheduler->processList("ST", "*", 'O');  # open only
  my $command = $comm->{info}{sectionName};

  if (($command =~ /expert/ || $command =~ /linktest/) && $#$list >= 0) {
     return "Interactive test must run on their own.";
  }

  foreach my $l (@$list) {
      my $i = $l->info();

      if ($l->{command} =~ /linktest/) {
         return "Linktest already running, must run alone.";
      }

      if ($l->{interactive}) {
          $err = "Interactive test must run on their own.";
          last;
      }

      if (($command =~ /ve_diag/ ) &&
           ($l->{command} =~ /ve_diag/)) {
          $err = "$command test can't run when another $command test is running. ";
          last;
      }

      if (($command =~ /a5kses/ || $command =~ /dakses/) &&
           ($l->{command} =~ /qlc/ || $l->{command} =~ /socal/)) {
          $err = "$command test can't run when $l->{command} test running. ";
          last;
      }


      if ( ($command =~ /socal/) &&
           ($l->{command} =~ /a5kses/ )
	 ) {
          $err = "$command test can't run when $l->{command} test running. ";
          last;
      }

      # block most tests from running if qlc selected
      if (($command =~ /t3test/ || 
           $command =~ /a5ktest/ ||
	   $command =~ /a3500fctest/ ||
	   $command =~ /brocade/ ||
	   $command =~ /35/ ||
	   $command =~ /61/ ||
	   $command =~ /fcdisktest/ ||
	   $command =~ /daktest/ ||
	   $command =~ /switch/ ||
	   $command =~ /tape/
      
          ) &&
          ($l->{command} =~ /qlc/ ||$l->{command} =~ /jni/  )) {
          $err = "$command test can't run when $l->{command} test is running. ";
          last;
      }

      # block qlc test from running if disk tests selected
      if (($command =~ /qlc/ || $command =~ /jni/) && 
         ($l->{command} =~ /switch/ || 
	  $l->{command} =~ /t3test/ ||
	  $l->{command} =~ /a5ktest/ ||
          $l->{command} =~ /a3500fctest/ ||
	  $l->{command} =~ /brocade/ ||
          $l->{command} =~ /35/ ||
	  $l->{command} =~ /61/ ||
          $l->{command} =~ /fcdisktest/ ||
	  $l->{command} =~ /daktest/ ||
	  $l->{command} =~ /ses/ ||
          $l->{command} =~ /tape/)
	  ) 
	  
	  {
          $err = "$command can't run when $l->{command} test is running.";
          last;
      }

      if (($command =~ /switch/ ) &&
          ($l->{command} =~ /switch/ )) {
          $err = "There is already a switch test running.";
          last;
      }

  }
  return $err;

}







# 'task_type' => 'ST',
#   'status' => 'O',
#   'opts' => '-P diags  ',
#   'email' => undef,
#   'start_tick' => '1001446348',
#   'opts2' => 'diag213',
#   'start_date' => '2001-09-25 13:32:28',
#   'info' => {
#     'dev_type' => 't3',
#     'ports' => 't3',
#     'key' => 'slr-mi.370-3990-01-e-f0.027582',
#     'node' => '',
#     'comp' => 'e'
#   },
#   'pid' => 22067,
#   'host' => 'ccadieux.central.sun.com',
#   'passes' => 1,
#   'command' => 't3ondg'
# };
# 
# 
#   
# 
1;
