package TO::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use TO::STORAGE;
use base 'TO::STORAGE';
use strict;

# portLabel expect port=0/1

sub leaf { 1 }
sub diskTotal {9}
sub type {'t3'}

sub isKnownDevice {
  my($class, $dev) = @_;
  if ($dev->{ProductID} =~ /T300/ || $dev->{ProductID} eq "T4") {
     return 1;
  }
  return 0;
}

sub portLabel {
  my($class, $port) = @_;
  return "ctrl-" . ($port+1);
}

sub getPortCIMId {
  my($node , $port) = @_;    #  0 / 1
  my $pi = $node->portInfo();
  return $pi->[$port]{PortWWN};
}

#
# returns the port name , as entered in Reports and State.
#
sub getPortId {
  my($class, $port) = @_;    #  0 / 1
  if ($port == 0) {
     return 'controller.u1ctr';
  } else {
     return 'controller.u2ctr';
  }
}

sub disk_map {
}

sub newFromDev {
  my($class, $to, $dev, $arg) = @_;

  my $renv = System->get_renv();
  my $host = $renv->{hostname};
  my $k = $dev->{type} . ":" . $dev->{key};
  my $exist = $to->nodeByName($k);

  my $storages  =  $to->[2];
  my $key = $dev->{key};
  my $t3 = $class->type();
  my $obj = {};
  if ($arg->{report}) {
    my $rep = $arg->{report};
    $dev->{wwn}  = lc($rep->{"rc.portWWN"});
    $dev->{wwn2} = lc($rep->{"rc.port2WWN"});
  }

  if ($exist) {
     $obj = $exist;  
     $obj->{info}{units} = $dev->{units} ? $dev->{units} : ($dev->{wwn2} ? 2:1);
     $obj->disk_map();
     #return $obj;
  } 

  $obj->{info}{type}    = $t3;
  $obj->{info}{class}   = "storage.$t3";
  $obj->{info}{name}    = "$t3:$key";
  $obj->{info}{BoxName} = $dev->{name} || $dev->{ipno};

  TO->host_array2($obj->{info}, {host => $host, host_type => "oob"});

  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{Model}   = $dev->{type};
  $obj->{info}{LGroup}  = "StorEdge-" . uc($t3) . "-00";

  my($node_wwn, $port_wwn, $port_wwn2);
  $node_wwn = $port_wwn = lc($dev->{wwn});
  $port_wwn2            = lc($dev->{wwn2});

  $obj->{info}{PortWWN} = $port_wwn;
  substr($node_wwn,7,1) = "0";
  $obj->{info}{NodeWWN} = $node_wwn;

  $obj->{info}{ipAddr}  = $dev->{ipno};
  $obj->{info}{units}   = $dev->{units} ? $dev->{units} : ($dev->{wwn2} ? 2:1);
  $obj->{info}{userLabel}  = $dev->{userLabel};
  $obj->{info}{mgmtLevel}  = $dev->{mgmtLevel} || "D";
  $obj->{info}{PG}      = 0;
  $obj->{port}          = [];

  $to->addSyn($dev->{wwn}, "$t3:$key:0");

  if (!$obj->{portInfo}[0]) {
    $obj->{portInfo}[0]   = {
        PortWWN   => $port_wwn,
   LocalPortWWN   => $port_wwn,
        PortLabel => $class->portLabel(0), 
        };
  }

  if ($port_wwn2) {
     $obj->{info}{PG}  = 1;
     my $index = $dev->{units} > 2 ? ($dev->{units}/2) : 1;

     if (!$obj->{portInfo}[$index]) {
         $obj->{portInfo}[$index]   = {
            PortWWN => $port_wwn2,
       LocalPortWWN => $port_wwn2,
          PortLabel => $class->portLabel($index),
        };
     }
     $to->addSyn($dev->{wwn2}, "$t3:$key:$index");
  }
  
  bless($obj, "TO::" . uc($t3));
  $obj->disk_map();
  $to->addSyn($key,  "$t3:$key");
  $storages->{"$t3:$key"} = $obj;
  return $obj;
}


sub diagramApplet {
  my($class, $name, $Comp, $to) = @_;

  my $Config = PDM::ConfigFile->read();
  my $renv = $Config->renv();
  my $dev = $Config->deviceByKey($name);
  my $width = 305;
  my $height = 232;
  my $gif = "t3_open";
  my $hi = $renv->{gui_bandwidth} || "L";
  if ($dev->{wwn2}) {
    $gif = "t3pg_open";
    $width = 303; $height = 437
  }

  open(O, System->get_home() . "/System/Products/$gif.htm");
  my (%M, $l);
  while ($l = <O>) {
     $l =~ s/"//g;
     if ($l =~ /coords = (\d+),(\d+),(\d+),(\d+)\s+HREF=([^>]+)/) {
        $M{$5} = "$1,$2,$3,$4";
     }
  }
  close(O);
  my $applet =<<EOF;
 <applet code="IMap.class" width=$width height=$height>
 <param name="mapimage" value="/gif/$gif$hi.gif">
 <param name="fgcolor" value="#FFFFFF">
 <param name="bgcolor" value="#666699">
 <param name="alarmFlag" value=1>
 <param name="border" value="1,#FFFFFF">
 <param name="boxSize" value=10>
 <param name="font" value="arial,normal,10">
 <param name="margins" value="5,5">
 <param name="outline" value="#FF0000">
EOF
  my $cnt = 1; my $y;
  foreach my $el (keys %M) {
    my $c = $Comp->{$el};
    $applet .= "<param name=shape-$cnt value=\"rect,$M{$el}\">\n";

    if ($c && defined($c->[0])) {
      my $status = int($c->[0] + 0.5);
      my $text = $c->[1];
      $applet .= "<param name=\"status-$cnt\" value=$status>\n";
      my $len = 0;
      my $cnt2 = 1;
      my @w = split(/\s+/, $text);
      my $curr = "";
      for ($y=0; $y <= $#w; $y++) {
        my $w1 = $w[$y];
        $curr .= "$w1 ";
        if (length($curr . $w[$y+1]) > 42) {
          $applet .= "<param name=\"text-$cnt-$cnt2\" value=\"$curr\">\n";
          $cnt2++;
          $curr= "";
        }
      }
      if ($curr) {
          $applet .= "<param name=\"text-$cnt-$cnt2\" value=\"$curr\">\n";
      }
    } else {
      $el = ($el eq "e") ? "Comm-OOBand" : ($el eq "ib"? "Comm-InBand": $el);
      $applet .= "<param name=\"text-$cnt-1\" value=\"$el\">\n";
    }
      
    $cnt++;
  }
  $applet .= "</applet>";
  return $applet;
}

sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components($name);
  my $i       = $Comp->value("e");
  my $iIB     = $Comp->value("ib");
  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);
  my $units   = $node->{info}{units} || ( $node->{info}{PG} ? 2 : 1 );

  my $C2   =  int($units/2)  + 1;
  my $P2   =  $C2 - 1;

  my($port, $portInfo) = TO->valArray(
          [$Comp->value("controller.u1ctr"), $Comp->value("port.0")],
          [$Comp->value("controller.u${C2}ctr"), $Comp->value("port.$P2")],
           );
       
  my($disk, $diskInfo, $otherInfo, $other, $u, $d);
  my($l1, $l2, $l3, $l4, $p1, $p2, $p3, $p4, $v1, $v2, $v3, $v4);
  my $disk_map = $node->info("disk_map");
  $diskInfo = ",";

  for ($u=1; $u <= $units; $u++) {
     for ($d=1; $d <= $class->diskTotal(); $d++) {
         my $i1 = $Comp->value("disk.u${u}d$d*",0);
         if ($i1 >= 1) {
            $disk     .= "$i1,";
            $diskInfo .= $Comp->value("disk.u${u}d$d*",1) . ",";
         } elsif (index($disk_map, ",$u-$d,") >= 0) {
            $disk     .= "-1,";
         } else {
            $disk     .= ",";
            $diskInfo .= ",";
         }
     }
  }

  $Comp->other([], \$other, \$otherInfo);

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
    
}



sub ipAddr {
  my($class) = @_;
  return $class->{info}{ipAddr};
}


sub getDiskList {
  my($node) = @_;
  my (@L, $x);
  my $ports = $node->{portInfo};
  for ($x=1; $x <= $node->diskTotal(); $x++) {
     push(@L, "disk.u1d$x");
  }
  if ($ports->[1]) {
    for ($x=1; $x <= $node->diskTotal(); $x++) {
      push(@L, "disk.u2d$x");
    }
  }
  return \@L;
}

sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);
  my $dt = $obj->diskTotal();
  my $t3 = uc($obj->type());
  my $t3l = $obj->type() || "t3";

  my $units = $obj->{info}{units};
  $units = 2 if (!$units && $obj->{info}{PG});

  if ($units > 1) {
     my ($dd, $x);
     my $ext = $units > 2 ? "x4" : "pg";
     for ($x=1; $x <= $units; $x++) {
        $dd .= "${x}d/";
     }
     chop($dd);
     $cat = "a,$t3,2/12,-$dt,$dd,_,,D0D0F0/${t3l}$ext.gif";
     $ses = 2;
  } else {
     $cat = "a,$t3,1/1,-$dt,1d,_,,D0D0F0/$t3l.gif";
     $ses = 1;
  }
  $label2 = $obj->{info}{userLabel} || lc($t3);
  $ses    = 1;
  return ($cat, $label2, $ses);
}

sub getLogicalPaths{
  my($self) = @_;
  my $volinfo =$self->volInfo();
  my @paths;
  foreach my $path (keys %$volinfo){
    push(@paths, $path);
  }
  return @paths;
}

1;
