package TO::STORAGE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';

sub leaf { 0 }

sub getPortId {
  my($class, $port) = @_;    #  0 / 1

  return "port.$port";
}

sub toString {
  my($s) = @_;
  my($disks, $ports, $x, $portI, $volI);

  my($name) = $s->name();
  my($type) = $s->type();
  my($info) = $s->{info};
  my($utype) = sprintf("%-6.6s", uc($type));

  my($out) = "$utype: '$name', BoxName=$info->{BoxName}, LogicalPath=$info->{LogicalPath} \n";

  $ports = $s->port();
  $portI = $s->portInfo();

  for ($x=0; $x <= $#$portI; $x++) {
     my($p) = $portI->[$x];
     $out .= "      PORT-$x: NodeWWN=$p->{NodeWWN}, \n" .
             "              LogicalPath=$p->{LogicalPath}, \n".
             "               LINK_TO-> $ports->[$x]\n";
  }

  $disks = $s->diskInfo();
  foreach my $disk (sort keys %$disks) {
     my($di) = sprintf("%3.3s", $disk);
     my($d) = $disks->{$disk};
     $out .= "     DISK-$di : NodeWWN=$d->{NodeWWN},  RegisterName=$d->{RegisterName}, $d->{SerialNo} \n";
  }
  my($vols) = $s->volInfo();
  if ($vols) {
    foreach my $v1 (keys %$vols) {
       print "     VOL-$v1\n";
    }
  }
  return $out;
}

sub type {
  my($obj) = @_;
  return $obj->{info}{type};
}


sub boxName {
  my($obj) = @_;
  return  $obj->{info}{BoxName} || $obj->{info}{NodeWWN};
}

sub id {
  my($obj) = @_;
  my($id) = $obj->{info}{type} . " '" ;
  $id .= $obj->{info}{BoxName} || $obj->{info}{NodeWWN};
  $id .= "'";
  return $id;
}


sub getDiskList {
  my($obj) = @_;
  return [];

}

sub getLogicalPaths{
  my($self) = @_;
  my @paths;
  my $diskInfo = $self->diskInfo();
  foreach my $disk (keys %$diskInfo) {
    my $Disk = $diskInfo->{$disk};
    push(@paths, split(/\|/,$Disk->{LogicalPath}));
  }
  return @paths;
}

1;


