package Revision::D2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::D2;

use PDM::ConfigFile;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class       {"ib.d2"}
sub description {"Sun StorEdge D2"}
sub type        {"d2"}


sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my( $l, @R, $out);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  foreach my $dev (@$devs) {
      next if ($dev->{type} ne "d2");
      next if (!Util->isMineToMonitor($dev));

      my $r1 = $class->REVISION( $Matrix, $InstalledPatches, $dev);
      push(@R, @$r1);
  }
  if ($#R < 0) {
      push(@R,["D2",'N/A','ERR',undef, undef,undef,undef, "No device present, please check system"]);
  }
  return \@R;
}

sub REVISION {
  my($class, $Matrix, $InstalledPatches, $dev) = @_;
  my( $l, @R, %VERSION, $out);
  my $TO = 20;
  my $mat = $Matrix->{D2};
  my $el = $mat->{firm};
  my $disk_el = $mat->{disk};
  my $MaxDisk = 12 ;    # max disk number in D2 enclosure  
  my $report = {};
  Agent::D2->read_device_slot_status($report, $dev);
  Agent::D2->read_disk_inquiry($report, $dev);
  my $disk;
  my @arr;
  if ($dev->{wwn} =~ /ses/){
     @arr[0]=0; 
  }
  if ($dev->{wwn2} =~ /ses/) {
     @arr[1]=1;
  } 
  my $ref = \@arr;
  foreach my $esm (@$ref) {
    my $rev1 = $report->{"esm.$esm.revision"};
    next if (!$rev1);
    push(@R, $class->devCompare("D2", "esm$esm", $rev1, $dev, $mat, "firm"));
    for ($disk=0; $disk <= $MaxDisk; $disk++) {
       my $disk_rev = $report->{"slot.$esm.$disk.revision"};
       my $info = $report->{"slot.$esm.$disk.vendor"} . " " . $report->{"slot.$esm.$disk.model"};
       next if (!$disk_rev);
       my $tem_model = $report->{"slot.$esm.$disk.model"};
       $tem_model =~ s/\s+//g;
       my $d2_disk_key = $report->{"slot.$esm.$disk.vendor"}.":".$tem_model.":"."D2";
       push(@R, $class->check_d2_disk_fw($Matrix, $InstalledPatches, $d2_disk_key, "esm$esm.disk$disk", $disk_rev, $info));
    }
  }

  return \@R;
}

sub check_d2_disk_fw {
    my($class, $Matrix, $InstalledP, $key, $dev, $curr_fw, $info) = @_;
    my $d2_disk_fw = $Matrix->{D2_DISK_FW};
    my $category = "Sun D2 Disk FW";
    if ( $d2_disk_fw->{$key} ){ 
                     my $d = $d2_disk_fw->{$key};
                     my $req_fw = $d->[0];
                     my $req_patch = $d->[2];
                     my $comp = $class->compareDiskFwLevels($curr_fw, $req_fw);
                     if ( $comp==0) {
                               return [$category, $dev,'PASS',$curr_fw, $req_fw,undef,undef,$info];
                     } elsif ($comp>0) {
                               return [$category, $dev,'UPREV',$curr_fw, $req_fw,undef,undef,$info];
                     } elsif ($comp<0){
                              return [$category, $dev,'DOWNREV',$curr_fw, $req_fw,undef,$req_patch,$info];
                     }

    } else {
         # print "err\n";
         return [$category, $dev,"INFO",undef, undef,undef,undef,'No information about the device, please contact your sun representative']; 
    }
}



1;
