package Revision::6120;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::6120;
use PDM::ConfigFile;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class {"oob.6120"}
sub description {"Sun StorEdge 6120  array firmware/disk/loop/pcu"}
sub type {"6120"}

#;u1d1,fruRevision,EA29;
#;u1l2,fruRevision, 5.01 Flash;
#;u1ctr,fruRevision,0210;
#;u1pcu1,fruRevision,refer to label;
#;u1mpn,fruRevision,;


sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my(@R);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  foreach my $dev (@$devs) {
      next if ($dev->{type} ne "6120");
      next if (!Util->isMineToMonitor($dev));
      my $report = Agent::6120->INSTRUMENTATION($dev);
      my $err = $report->{"rc.error"};
      if ($err) {    
        push(@R,['6120', $dev->{name}, 'ERR', undef, undef,undef,undef,"Can not instrument the 6120 device"]);
      } else {
         my $r1 = $class->REVISION($Matrix,  $InstalledPatches, $dev, $report);
         push(@R, @$r1);
      }

  }
  if ($#R < 0) {
      push(@R,['6120', 'N/A', 'ERR', undef, undef,undef,undef,"No 6120 device, please check system setup"]);
  }
  return \@R;
  
}

# runs on only one device, dev is from the configFile
#
sub REVISION {
  my( $class, $Matrix, $InstalledPatches, $dev, $rep) = @_;
 my ( $elemprop0,  $elemprop1, $mat, @R , @R1, @R2, @R3, @R4);
  my $mat = $Matrix->{6120};    # used for stand alone t3
  my ($vendor, $model, $tem1, $tem2, $firm_rev);
  my $se_version = System::get_se_version();
  my $dev_type ="6120";

  $firm_rev = $rep->{'system.sysRevision'};

  push(@R, $class->devCompare("6120_SYSTEM_FW",undef, $firm_rev, $dev, $mat, "firmrev"));
 
  foreach my $el (keys %$rep) {
      if ($el =~ /fruLoopVersion/) {
         my $ix = rindex($el, ".");
         my $pre = substr($el, 0, $ix);
         my $vendor = $rep->{"$pre.fruVendor"};
         my $tem_model  = $rep->{"$pre.fruModel"};
         my ($model, $tem) = split(/\s+/, $tem_model);
         my $val    = $rep->{$el};
         my $ix0    = index($el, ".");
         my $elem   = substr($el, $ix0+1);
         my $ix0    = index($elem, ".");
         $elem      = substr($elem, 0, $ix0) if ($ix0 > 0);
         
         if ($el =~ /loopcard/) {
            push(@R2, $class->devCompare("6120",$elem, $val, $dev, $mat, "loop"));

         }
     }

     if ($el =~ /fruRevision/) {
         my $ix = rindex($el, ".");
         my $pre = substr($el, 0, $ix);
         my $vendor = $rep->{"$pre.fruVendor"};
         my $model  = $rep->{"$pre.fruModel"};
         my $val    = $rep->{$el};
         my $ix0    = index($el, ".");
         my $elem   = substr($el, $ix0+1);
         my $ix0    = index($elem, ".");
         $elem      = substr($elem, 0, $ix0) if ($ix0 > 0);

         if ($el =~ /disk/) {
            if ($model) {  #  $model = '' means dummy disk, skip it
            push(@R1,$class->checkDiskFirmware_6120($Matrix, $InstalledPatches, $vendor, $model, $val,$dev,$elem,
	             "disk",$dev_type));
            }
         } elsif ($el =~ /power/) {
            push(@R3, $class->devCompare("6120",$elem, $val, $dev, $mat, "pcu"));

         } elsif ($el =~ /midplane/) {
            push(@R4, $class->devCompare("6120",$elem, $val, $dev, $mat, "mpn"));
         }
       }

  }

 my @SR1 = sort {$a->[1] cmp $b->[1]} @R1 ;
 my @SR2 = sort {$a->[1] cmp $b->[1]} @R2;
 my @SR3 = sort {$a->[1] cmp $b->[1]} @R3;
 my @SR4 = sort {$a->[1] cmp $b->[1]} @R4;
 push (@R, @SR1,@SR2,@SR3,@SR4);
  return \@R;
}

sub checkDiskFirmware_6120 {
     my($class,$Matrix, $InstalledP,$vendor, $model, $val, $dev,$elem,
         $type,$dev_type) = @_;
     my $disk_fw;
     $disk_fw = $Matrix->{DISK_FW};

     my $category = "6120_DISK_FW";      

     my $key = "$vendor:$model:$dev_type";    # default set up

     my $curr_fw = $val;
     my $cp = ($dev->{name} || $dev->{ip});

     if ($disk_fw->{$key}) {
            my $d = $disk_fw->{$key};
            my $req_fw = $d->[0];
            my $req_patch = $d->[2];
            my $desc =  "$vendor:$model";
            my $info =  " No patch available, please contact your SUN representative ";
            my($req_base, $req_rev) = $class->baseRev($req_patch);
            if ($curr_fw < 0){
            return [$category, "$cp.$type.$elem", 'ERR', undef, $req_fw, undef, $req_patch, "Unable to get the device firmware level, please contact you SUN representative"];
            }
            my $comp = $class->compareDiskFwLevels($curr_fw, $req_fw);
            if ($comp == 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                      return [$category, "$cp.$type.$elem", 'PASS', $curr_fw, $req_fw, undef, undef, $info];
               } else {
                      return [$category, "$cp.$type.$elem", 'PASS', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            } elsif ($comp > 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                     return [$category,"$cp.$type.$elem", 'UPREV', $curr_fw, $req_fw, undef, undef, $desc];
               } else {
                     return [$category, "$cp.$type.$elem", 'UPREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            } elsif ($comp < 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                    return [$category, "$cp.$type.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, "N/A", $info];
               } else {
                    return [$category, "$cp.$type.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            }
            else {
              return [$category, "$cp.$type.$elem", 'ERR', $curr_fw, $req_fw, undef, $req_patch, "Unable to check $vendor device,please contact your SUN representative and update the device firmware"];
            }
    } else {
           return [$category, "$cp.$type.$elem", 'INFO', undef, undef, undef, undef, "Unable to check the $vendor device, please see sunsolve online for potential patch information or contact your SUN representative"];
    }

}



1;
