package Revision::5310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use Revision::5210;
use base 'Revision::5210';
use System;
use Util;
use Agent::5310;
use PDM::ConfigFile;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class {"oob.5310"}
sub description {"Sun StorEdge 5310"}
sub type {"5310"}


sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my(@R);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;
  foreach my $dev (@$devs) {
      next if ($dev->{type} ne "5310");
      next if (!Util->isMineToMonitor($dev));
      my ($wwn, $err, $report) = Agent::5310->INSTRUMENTATION($dev);
      if ($err eq "BUSY") {
         my $info = "The 5310 device is busy, please run revision check later";
         push(@R,['5310', $dev->{name}, 'ERR', undef, undef,undef,undef, $info]);
      } elsif ($err =~ /not accessible/){
         my $info = "The 5310 device is not accessible, please check system setup ";
         push(@R,['5310', $dev->{name}, 'ERR', undef, undef,undef,undef, $info]); 
      } else {
         my $r1 = $class->REVISION($Matrix, $InstalledPatches, $dev, $report);
         push(@R, @$r1);
      }					      
  }
  if ($#R < 0) {
      push(@R,['5310', 'N/A', 'ERR', undef, undef,undef,undef,"No 5310 device, please check system setup"]);
  }
  return \@R;
  
}

# runs on only one device, dev is from the configFile
#
sub REVISION {
  my( $class, $Matrix, $InstalledPatches, $dev, $rep) = @_;
  my ( $mat, @R , @R1);
  my $mat = $Matrix->{5310};    # used for stand alone 3310 
  my ($vendor, $model, $tem2, $firm_rev);
  # my $se_version = System::get_se_version();

  my $dev_type = "5310";

  my $firm_rev = $rep->{'controller.1.RaidCtlrFirmwareVersion'};
  my $firm_rev2 = $rep->{'controller.2.RaidCtlrFirmwareVersion'};

  if ($firm_rev) {
    my $firmware_info = $firm_rev;
    push(@R, $class->check_firmware("5310_Controller_FW",undef, $firmware_info, $dev, $mat, "controller.1.firmrev"));

  } 
  
  # For 2nd Controller
  if ($firm_rev2) {
    my $firmware_info = $firm_rev2;
    push(@R, $class->check_firmware("5310_Controller_FW",undef, $firmware_info, $dev, $mat, "controller.2.firmrev"));

  } 

  my $os_rev = $rep->{'info.OsVersion'} || $rep->{'info.System.11'};
  if ($os_rev) {
    push(@R, $class->check_firmware("5310_OS_VERISON",undef, $os_rev, $dev, $mat, "osversion")); 
  }
 
  foreach my $el (keys %$rep) {
      if (($el =~ /physicaldrive/) && ($el =~ /RaidPhysicalDriveType/)) {
         my $ix = rindex($el, ".");
         my $pre = substr($el, 0, $ix);
         my $vendor = $rep->{"$pre.RaidPhysicalDriveVendor"};
         my $model  = $rep->{"$pre.RaidPhysicalDriveModel"};
         my $val    = $rep->{"$pre.RaidPhysDriveFwRevision"};
	 
	 # For 5310
         $vendor =~ s/\s+$//;
	 
	 if ($model) {  #  $model= '' means dummy disk, skip it
            push(@R1,$class->checkDiskFirmware_5310($Matrix, $InstalledPatches, $vendor, $model, $val,$dev,$pre,$dev_type));
         }

     }
  }

  my @SR1 = sort { $a->[1] cmp $b->[1] } @R1 ;
 
  push (@R, @SR1);
  return \@R;
}

sub checkDiskFirmware_5310 {
     my($class,$Matrix, $InstalledP,$vendor, $model, $val, $dev,$elem ,$dev_type) = @_;
     my $disk_fw;
     $disk_fw = $Matrix->{DISK_FW};

     my $category = "5310_DISK_FW";      
     if (!$vendor){
        if($model =~ /^HITACHI/){
	  my ($ven, $mod, $other) = split(/\s/, $model);
	  # Temporary fix for 6299559 
	  $model = $mod;
	  $vendor = $ven;
	}
     }
     my $key = "$vendor:$model:$dev_type";    # default set up

     my $curr_fw = $val;
     my $cp = ($dev->{name} || $dev->{ip});

     if ($disk_fw->{$key}) {
            my $d = $disk_fw->{$key};
            my $req_fw = $d->[0];
            my $req_patch = $d->[2];
            my $desc =  "$vendor:$model";
            my $info =  " No patch available, please contact your SUN representative ";
            my($req_base, $req_rev) = $class->baseRev($req_patch);
            if ($curr_fw < 0){
            return [$category, "$cp.$elem", 'ERR', undef, $req_fw, undef, $req_patch, "Unable to get the device firmware level, please contact you SUN representative"];
            }
            my $comp = $class->compFwLevels($curr_fw, $req_fw);
            if ($comp == 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                      return [$category, "$cp.$elem", 'PASS', $curr_fw, $req_fw, undef, undef, undef];
               } else {
                      return [$category, "$cp.$elem", 'PASS', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            } elsif ($comp > 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                     return [$category,"$cp.$elem", 'UPREV', $curr_fw, $req_fw, undef, undef, $desc];
               } else {
                     return [$category, "$cp.$elem", 'UPREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            } elsif ($comp < 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                    return [$category, "$cp.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, "N/A", $info];
               } else {
                    return [$category, "$cp.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            }
            else {
              return [$category, "$cp.$elem", 'ERR', $curr_fw, $req_fw, undef, $req_patch, "Unable to check $vendor device,please contact your SUN representative and update the device firmware"];
            }
    } else {
           return [$category, "$cp.$elem", 'INFO', undef, undef, undef, undef, "Unable to check the $vendor device, please see sunsolve online for potential patch information or contact your SUN representative"];
    }

}

1;

