package Logic::3310;

use Util;
use strict;
use Agent::3310;
use Logic;

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $ipno, $active, $x);
   $active = "Y";
   my @nodes;

   while (1) {
     if (!$q->{ip}) {
        $err = Error->error(103);
        last;
     } else {

        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my $rc = Agent::3310->getFastWWN($q->{ip}, $q->{host});
        if (!$rc->{key} || $rc->{error} ) {
           $err = Error->error(no_device => "$q->{ip}</b> $rc->{error}");
           last;
        }
        my $key = $rc->{key};

        my %THERE;
        foreach $x (@$devs) {
          if (index("3310,3320,3510,3511", $x->{type}) >= 0) {
             $THERE{$x->{key}} = 1;
          }
        }
        if (!$THERE{$key}) {
           $x = $#$devs + 1;

           my $nd = {
              type     => $rc->{type},
              class    => "storage." . $rc->{type},
              key      => $key,
              wwn      => $rc->{wwn},
              wwns     => $rc->{wwns},
              name     => $q->{name} || $q->{ip},
              active   => $active,
              userLabel=> $rc->{userLabel} || $q->{userLabel},
              ip       => $q->{ip},
              ipno     => $rc->{ipno} || $q->{ip},
               telnet   => Util->encodeAll($q->{telnet}),
              host     => $q->{host},
           };
           if (index($rc->{wwn2},",") >= 0 || index($rc->{wwn2},"|") >= 0) {  # wwn_list
             $nd->{wwns} = $rc->{wwn2};
             $nd->{wwn2} = "";
           }

           PDM::ConfigFile->addDevice($devs, $nd);
 
           Logic->clearSlave($q->{host}, $hosts);
           push(@nodes, $devs->[$x]);

           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
             $err = Error->error(101);
           }
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}



1;

