package Linktest::SWITCH2;
use strict;
use Linktest::Node;
use base 'Linktest::Node';


sub needPassword {1}

sub password {
  my($node) = @_;
  my $dev = $node->config();
  return (System->getDevicePassword($dev, "switch"));
}
sub portTest {
 my($switch, $nodeB) = @_;

  if ($nodeB->class =~ /storage.t3/ && $switch->portType() eq "F_Port") {
     return 0;
  }
  return 1;
}

sub prompt_info {
  my($node) = @_;
  return ($node->{WWN}, $node->{port});
}

sub class {'switch.switch2'}

sub type2 {"SW"}

sub start_diagnostic {
  my($node, $mode) = @_;
  my ($test, $options, $sparcv9);
  my $estimated_time = 0;

  my($verbose, $wb_patterns, $option_user_pattern, $option_pattern_type) = $node->diag_defaults();

  my $user_password = $node->password();

  $test = "switch2test";

  $options = "$verbose -q -i1 -f -o " . '"' . "dev=$node->{port}:$node->{ip}:$node->{fcaddr}|passwd=$user_password|selectpattern=$wb_patterns" . $option_user_pattern . '"';

  if ($option_pattern_type eq "user") {
    $estimated_time = 1;
  } elsif ($option_pattern_type eq "critical") {
    $estimated_time = 7;
  } else {
    $estimated_time = 70;
  }

  return $node->run_diagnostic($test, $sparcv9, $options, $estimated_time);

}




1;
