package Health::Server;
use strict;

use Health;
use base 'Health';


sub free_space {
  my($hm, $report, $orep) = @_;

  my $id  = $report->deviceName();
  my $rep = $report->content();

  # Check free space for our data files
  foreach my $v (keys %$rep) {
      next if ($v !~ /freeSpace/);
      if ($v =~ /var\/opt\/SUNWstade/ || $v =~ /\|\/$/ || $v =~ /\|\/tmp$/) {
         my $v1 = substr($v, 10);
         my $percent = $rep->{$v};
         my $opercent = $orep->{$v};
         $percent =~ s/%//;
         $opercent =~ s/%//;

         if ($percent >= 98 && $opercent < 98) {
             my($desc0) = "Detected file system '$v1' at ${percent}% capacity";
             my $wwn = $id;
             Grid->setCode("host.AlarmEvent.disk_capacity");
             $hm->valueChangeEvent("freeSpace", "", $report, $wwn, $desc0, 2, "disk_capacity");

         } elsif ($percent < 98 && $opercent >= 98) {
             my($desc0) = "Detected file system '$v1' back to ${percent}% capacity";
             my $wwn = $id;
             Grid->setCode("host.AlarmEvent.disk_capacity_okay");
             $hm->valueChangeEvent("freeSpace", "", $report, $wwn, $desc0,
                             0, "disk_capacity_okay");
         }
      }
  }
}

1;


